/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.framework.tests.core;

import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ser.FilterProvider;
import com.fasterxml.jackson.databind.ser.impl.SimpleBeanPropertyFilter;
import com.fasterxml.jackson.databind.ser.impl.SimpleFilterProvider;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.alfresco.rest.api.model.Comment;
import org.alfresco.rest.framework.core.exceptions.InvalidArgumentException;
import org.alfresco.rest.framework.jacksonextensions.JacksonHelper;
import org.alfresco.rest.framework.jacksonextensions.RestJsonModule;
import org.alfresco.rest.framework.tests.api.mocks.Farmer;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class JsonJacksonTests {
    static JacksonHelper jsonHelper = null;
    public static final String FARMER_JSON = "{\"name\":\"Giles\",\"created\":\"2012-03-23T15:56:18.552+0000\",\"age\":54,\"id\":\"1234A3\",\"farm\":\"LARGE\"}";
    public static final String GRASS_JSON = "{\"id\":\"grass\",\"color\":\"green\"}";
    public static final String COLLECTION_START = "[ ";
    public static final String COLLECTION_END = " ]";
    public static final String FARMERS_COLLECTION_JSON = "[ {\"name\":\"Giles\",\"created\":\"2012-03-23T15:56:18.552+0000\",\"age\":54,\"id\":\"1234A3\",\"farm\":\"LARGE\"},{\"name\":\"Giles\",\"created\":\"2012-03-23T15:56:18.552+0000\",\"age\":54,\"id\":\"1234A3\",\"farm\":\"LARGE\"},{\"name\":\"Giles\",\"created\":\"2012-03-23T15:56:18.552+0000\",\"age\":54,\"id\":\"1234A3\",\"farm\":\"LARGE\"} ]";

    @BeforeClass
    public static void setupTests() throws Exception {
        jsonHelper = new JacksonHelper();
        RestJsonModule module = new RestJsonModule();
        jsonHelper.setModule((Module)module);
        jsonHelper.afterPropertiesSet();
    }

    @Test
    public void testDeserializeFarmer() throws IOException {
        Farmer aFarmer = (Farmer)jsonHelper.construct((Reader)new StringReader(FARMER_JSON), Farmer.class);
        Assert.assertEquals(Farmer.class, aFarmer.getClass());
        Assert.assertEquals((Object)"Giles", (Object)aFarmer.getName());
        Assert.assertEquals((long)54L, (long)aFarmer.getAge());
        Assert.assertEquals((Object)((Object)Farmer.size.LARGE), (Object)((Object)aFarmer.getFarm()));
        try {
            aFarmer = (Farmer)jsonHelper.construct((Reader)new StringReader(""), Farmer.class);
            Assert.fail((String)"Should not get here.");
        }
        catch (InvalidArgumentException iae) {
            Assert.assertNotNull((Object)((Object)iae));
        }
    }

    @Test
    public void testDeserializeFarmersAsList() throws IOException {
        List aFarmer = jsonHelper.constructList((Reader)new StringReader("[ {\"name\":\"Giles\",\"created\":\"2012-03-23T15:56:18.552+0000\",\"age\":54,\"id\":\"1234A3\",\"farm\":\"LARGE\"} ]"), Farmer.class);
        Assert.assertTrue((boolean)Collection.class.isAssignableFrom(aFarmer.getClass()));
        Assert.assertEquals((long)1L, (long)aFarmer.size());
        aFarmer = jsonHelper.constructList((Reader)new StringReader(FARMERS_COLLECTION_JSON), Farmer.class);
        Assert.assertTrue((boolean)Collection.class.isAssignableFrom(aFarmer.getClass()));
        Assert.assertEquals((long)3L, (long)aFarmer.size());
        aFarmer = jsonHelper.constructList((Reader)new StringReader(FARMER_JSON), Farmer.class);
        Assert.assertTrue((boolean)Collection.class.isAssignableFrom(aFarmer.getClass()));
        Assert.assertEquals((long)1L, (long)aFarmer.size());
        try {
            aFarmer = jsonHelper.constructList((Reader)new StringReader(""), Farmer.class);
            Assert.fail((String)"Should not get here.");
        }
        catch (InvalidArgumentException iae) {
            Assert.assertNotNull((Object)((Object)iae));
        }
        try {
            aFarmer = jsonHelper.constructList((Reader)new StringReader("rubbish"), Farmer.class);
            Assert.fail((String)"Should not get here.");
        }
        catch (InvalidArgumentException iae) {
            Assert.assertNotNull((Object)((Object)iae));
        }
        try {
            aFarmer = jsonHelper.constructList((Reader)new StringReader("[]"), Farmer.class);
            Assert.fail((String)"Should not get here.");
        }
        catch (InvalidArgumentException iae) {
            Assert.assertNotNull((Object)((Object)iae));
        }
    }

    @Test
    public void testDeserializeComment() throws IOException {
        String json = "{\"title\":\"fred\", \"content\":\"lots of noise\"}";
        Comment aComment = (Comment)jsonHelper.construct((Reader)new StringReader(json), Comment.class);
        Assert.assertEquals(Comment.class, aComment.getClass());
        Assert.assertEquals((Object)"fred", (Object)aComment.getTitle());
        Assert.assertEquals((Object)"lots of noise", (Object)aComment.getContent());
    }

    @Test
    public void testSerializeComment() throws IOException {
        final Comment aComment = new Comment();
        aComment.setContent("<b>There it is</b>");
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        jsonHelper.withWriter((OutputStream)out, new JacksonHelper.Writer(){

            public void writeContents(JsonGenerator generator, ObjectMapper objectMapper) throws JsonGenerationException, JsonMappingException, IOException {
                SimpleFilterProvider fp = new SimpleFilterProvider().addFilter("defaultFilterName", (SimpleBeanPropertyFilter)new JacksonHelper.ReturnAllBeanProperties());
                objectMapper.writer((FilterProvider)fp).writeValue(generator, (Object)aComment);
            }
        });
        Assert.assertTrue((boolean)out.toString().contains("{\"content\":\"<b>There it is</b>\""));
    }

    @Test
    public void testSerializeMultipleObjects() throws IOException {
        final ArrayList<Comment> allComments = new ArrayList<Comment>();
        Comment aComment = new Comment();
        aComment.setContent("<b>There it is</b>");
        allComments.add(aComment);
        aComment = new Comment();
        aComment.setContent("<p>I agree with the author</p>");
        allComments.add(aComment);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        jsonHelper.withWriter((OutputStream)out, new JacksonHelper.Writer(){

            public void writeContents(JsonGenerator generator, ObjectMapper objectMapper) throws JsonGenerationException, JsonMappingException, IOException {
                SimpleFilterProvider fp = new SimpleFilterProvider().addFilter("defaultFilterName", (SimpleBeanPropertyFilter)new JacksonHelper.ReturnAllBeanProperties());
                objectMapper.writer((FilterProvider)fp).writeValue(generator, (Object)allComments);
            }
        });
        Assert.assertTrue((boolean)out.toString().contains("content\":\"<b>There it is</b>"));
        Assert.assertTrue((boolean)out.toString().contains("content\":\"<p>I agree with the author</p>"));
    }

    @Test
    public void testNullInComment() throws IOException {
        final Comment aComment = new Comment();
        aComment.setContent(null);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        jsonHelper.withWriter((OutputStream)out, new JacksonHelper.Writer(){

            public void writeContents(JsonGenerator generator, ObjectMapper objectMapper) throws JsonGenerationException, JsonMappingException, IOException {
                SimpleFilterProvider fp = new SimpleFilterProvider().addFilter("defaultFilterName", (SimpleBeanPropertyFilter)new JacksonHelper.ReturnAllBeanProperties());
                objectMapper.writer((FilterProvider)fp).writeValue(generator, (Object)aComment);
            }
        });
        Assert.assertEquals((String)"Null values should not be output.", (Object)"{\"canEdit\":false,\"canDelete\":false}", (Object)out.toString());
    }
}

