/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.web.scripts.solr;

import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.repo.web.filter.beans.DependencyInjectedFilter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.InitializingBean;

public class SOLRAuthenticationFilter
implements DependencyInjectedFilter,
InitializingBean {
    private static Log logger = LogFactory.getLog(SOLRAuthenticationFilter.class);
    private SecureCommsType secureComms = SecureCommsType.HTTPS;
    private String sharedSecret;
    private String sharedSecretHeader = "X-Alfresco-Search-Secret";

    public void setSecureComms(String type) {
        try {
            this.secureComms = SecureCommsType.getType(type);
        }
        catch (IllegalArgumentException e) {
            throw new AlfrescoRuntimeException("", (Throwable)e);
        }
    }

    public void setSharedSecret(String sharedSecret) {
        this.sharedSecret = sharedSecret;
    }

    public void setSharedSecretHeader(String sharedSecretHeader) {
        this.sharedSecretHeader = sharedSecretHeader;
    }

    public void afterPropertiesSet() throws Exception {
        if (this.secureComms == SecureCommsType.SECRET) {
            if (this.sharedSecret == null || this.sharedSecret.length() == 0) {
                logger.fatal((Object)"Missing value for solr.sharedSecret configuration property. If solr.secureComms is set to \"secret\", a value for solr.sharedSecret is required. See https://docs.alfresco.com/search-services/latest/install/options/");
                throw new AlfrescoRuntimeException("Missing value for solr.sharedSecret configuration property");
            }
            if (this.sharedSecretHeader == null || this.sharedSecretHeader.length() == 0) {
                throw new AlfrescoRuntimeException("Missing value for sharedSecretHeader");
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void doFilter(ServletContext context, ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        HttpServletResponse httpResponse = (HttpServletResponse)response;
        if (this.secureComms == SecureCommsType.SECRET) {
            if (this.sharedSecret.equals(httpRequest.getHeader(this.sharedSecretHeader))) {
                chain.doFilter(request, response);
                return;
            } else {
                httpResponse.sendError(403, "Authentication failure");
            }
            return;
        } else if (this.secureComms == SecureCommsType.HTTPS) {
            if (!httpRequest.isSecure()) throw new AlfrescoRuntimeException("Expected a https request");
            chain.doFilter(request, response);
            return;
        } else {
            chain.doFilter(request, response);
        }
    }

    public static enum SecureCommsType {
        HTTPS,
        SECRET,
        NONE;


        public static SecureCommsType getType(String type) {
            if (type.equalsIgnoreCase("https")) {
                return HTTPS;
            }
            if (type.equalsIgnoreCase("secret")) {
                return SECRET;
            }
            if (type.equalsIgnoreCase("none")) {
                return NONE;
            }
            throw new IllegalArgumentException("Invalid communications type");
        }
    }
}

