/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.webdav.auth;

import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.FilterConfig;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import java.io.IOException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;

public class HTTPRequestAuthenticationFilterTestFilter
implements Filter {
    private String httpServletRequestAuthHeaderName;
    private String userName;

    public void init(FilterConfig config) throws ServletException {
        this.httpServletRequestAuthHeaderName = config.getInitParameter("httpServletRequestAuthHeaderName");
        if (this.httpServletRequestAuthHeaderName == null) {
            this.httpServletRequestAuthHeaderName = "x-user";
        }
        this.userName = config.getInitParameter("userName");
        if (this.userName == null) {
            this.userName = "guest";
        }
    }

    public void doFilter(ServletRequest req, ServletResponse resp, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest httpReq = (HttpServletRequest)req;
        chain.doFilter((ServletRequest)this.getProxy(httpReq), resp);
    }

    public void destroy() {
    }

    private HttpServletRequest getProxy(HttpServletRequest req) {
        HttpServletRequest proxy = (HttpServletRequest)Proxy.newProxyInstance(HttpServletRequest.class.getClassLoader(), new Class[]{HttpServletRequest.class}, (InvocationHandler)new Handler(req));
        return proxy;
    }

    class Handler
    implements InvocationHandler {
        HttpServletRequest httpReq;

        Handler(HttpServletRequest httpReq) {
            this.httpReq = httpReq;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            String headerName;
            Object arg0;
            if (method.getName().equals("getHeader") && (arg0 = args[0]) != null && arg0 instanceof String && (headerName = (String)arg0).equals(HTTPRequestAuthenticationFilterTestFilter.this.httpServletRequestAuthHeaderName)) {
                return HTTPRequestAuthenticationFilterTestFilter.this.userName;
            }
            return method.invoke((Object)this.httpReq, args);
        }
    }
}

