/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.api.impl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.transfer.PathHelper;
import org.alfresco.rest.api.Nodes;
import org.alfresco.rest.api.impl.CategoriesImpl;
import org.alfresco.rest.api.model.Category;
import org.alfresco.rest.api.model.Node;
import org.alfresco.rest.framework.core.exceptions.EntityNotFoundException;
import org.alfresco.rest.framework.core.exceptions.InvalidArgumentException;
import org.alfresco.rest.framework.core.exceptions.InvalidNodeTypeException;
import org.alfresco.rest.framework.core.exceptions.PermissionDeniedException;
import org.alfresco.rest.framework.resource.parameters.Parameters;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.Path;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.search.CategoryService;
import org.alfresco.service.cmr.security.AccessStatus;
import org.alfresco.service.cmr.security.AuthorityService;
import org.alfresco.service.cmr.security.PermissionService;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.namespace.RegexQNamePattern;
import org.alfresco.util.Pair;
import org.alfresco.util.TypeConstraint;
import org.assertj.core.api.AbstractObjectAssert;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.assertj.core.api.ObjectAssert;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentMatchers;
import org.mockito.BDDMockito;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class CategoriesImplTest {
    private static final String CATEGORY_ID = "category-node-id";
    private static final String CATEGORY_NAME = "categoryName";
    private static final String PARENT_ID = "parent-node-id";
    private static final String CAT_ROOT_NODE_ID = "cat-root-node-id";
    private static final NodeRef CATEGORY_NODE_REF = CategoriesImplTest.createNodeRefWithId("category-node-id");
    private static final Category CATEGORY = CategoriesImplTest.createDefaultCategory();
    private static final String CONTENT_NODE_ID = "content-node-id";
    private static final NodeRef CONTENT_NODE_REF = CategoriesImplTest.createNodeRefWithId("content-node-id");
    private static final String MOCK_ROOT_LEVEL = "/{mockRootLevel}";
    private static final String MOCK_CHILD_LEVEL = "/{mockChild}";
    private static final String MOCK_CATEGORY_PATH = "///{mockRootLevel}///{mockChild}";
    @Mock
    private Nodes nodesMock;
    @Mock
    private NodeService nodeServiceMock;
    @Mock
    private AuthorityService authorityServiceMock;
    @Mock
    private CategoryService categoryServiceMock;
    @Mock
    private ChildAssociationRef dummyChildAssociationRefMock;
    @Mock
    private ChildAssociationRef categoryChildAssociationRefMock;
    @Mock
    private PermissionService permissionServiceMock;
    @Mock
    private TypeConstraint typeConstraint;
    @Mock
    private Parameters parametersMock;
    @InjectMocks
    private CategoriesImpl objectUnderTest;

    @Before
    public void setUp() throws Exception {
        BDDMockito.given((Object)this.authorityServiceMock.hasAdminAuthority()).willReturn((Object)true);
        BDDMockito.given((Object)this.nodesMock.validateNode(CATEGORY_ID)).willReturn((Object)CATEGORY_NODE_REF);
        BDDMockito.given((Object)this.nodesMock.validateOrLookupNode(CONTENT_NODE_ID)).willReturn((Object)CONTENT_NODE_REF);
        BDDMockito.given((Object)this.nodesMock.isSubClass((NodeRef)ArgumentMatchers.any(), (QName)ArgumentMatchers.any(), ArgumentMatchers.anyBoolean())).willReturn((Object)true);
        BDDMockito.given((Object)this.typeConstraint.matches((NodeRef)ArgumentMatchers.any())).willReturn((Object)true);
        BDDMockito.given((Object)this.permissionServiceMock.hasReadPermission((NodeRef)ArgumentMatchers.any())).willReturn((Object)AccessStatus.ALLOWED);
        BDDMockito.given((Object)this.permissionServiceMock.hasPermission((NodeRef)ArgumentMatchers.any(), (String)ArgumentMatchers.any())).willReturn((Object)AccessStatus.ALLOWED);
    }

    @Test
    public void shouldNotGetRootCategoryById() {
        NodeRef categoryRootNodeRef = CategoriesImplTest.createNodeRefWithId(CAT_ROOT_NODE_ID);
        BDDMockito.given((Object)this.nodesMock.validateNode(CAT_ROOT_NODE_ID)).willReturn((Object)categoryRootNodeRef);
        BDDMockito.given((Object)this.categoryChildAssociationRefMock.getQName()).willReturn((Object)ContentModel.ASPECT_GEN_CLASSIFIABLE);
        BDDMockito.given((Object)this.nodeServiceMock.getParentAssocs(categoryRootNodeRef)).willReturn(List.of(this.categoryChildAssociationRefMock));
        Assert.assertThrows(InvalidArgumentException.class, () -> this.objectUnderTest.getCategoryById(CAT_ROOT_NODE_ID, this.parametersMock));
        ((Nodes)BDDMockito.then((Object)this.nodesMock).should()).validateNode(CAT_ROOT_NODE_ID);
        ((Nodes)BDDMockito.then((Object)this.nodesMock).should()).isSubClass(categoryRootNodeRef, ContentModel.TYPE_CATEGORY, false);
        BDDMockito.then((Object)this.nodesMock).shouldHaveNoMoreInteractions();
        ((NodeService)BDDMockito.then((Object)this.nodeServiceMock).should()).getParentAssocs(categoryRootNodeRef);
        BDDMockito.then((Object)this.nodeServiceMock).shouldHaveNoMoreInteractions();
        BDDMockito.then((Object)this.categoryServiceMock).shouldHaveNoInteractions();
        BDDMockito.then((Object)this.authorityServiceMock).shouldHaveNoInteractions();
    }

    @Test
    public void testGetCategoryById_withChildren() {
        NodeRef parentNodeRef = CategoriesImplTest.createNodeRefWithId(PARENT_ID);
        Node categoryNode = CategoriesImplTest.createNode(CATEGORY_NAME, CATEGORY_ID, parentNodeRef);
        BDDMockito.given((Object)this.nodesMock.getNode(CATEGORY_ID)).willReturn((Object)categoryNode);
        ChildAssociationRef parentAssoc = new ChildAssociationRef(null, parentNodeRef, null, CATEGORY_NODE_REF);
        BDDMockito.given((Object)this.nodeServiceMock.getPrimaryParent(CATEGORY_NODE_REF)).willReturn((Object)parentAssoc);
        List<ChildAssociationRef> dummyChildren = List.of(this.dummyChildAssociationRefMock);
        BDDMockito.given((Object)this.nodeServiceMock.getChildAssocs(CATEGORY_NODE_REF, RegexQNamePattern.MATCH_ALL, RegexQNamePattern.MATCH_ALL, false)).willReturn(dummyChildren);
        Category category = this.objectUnderTest.getCategoryById(CATEGORY_ID, this.parametersMock);
        ((Nodes)BDDMockito.then((Object)this.nodesMock).should()).validateNode(CATEGORY_ID);
        ((Nodes)BDDMockito.then((Object)this.nodesMock).should()).isSubClass(CATEGORY_NODE_REF, ContentModel.TYPE_CATEGORY, false);
        ((Nodes)BDDMockito.then((Object)this.nodesMock).should()).getNode(CATEGORY_ID);
        BDDMockito.then((Object)this.nodesMock).shouldHaveNoMoreInteractions();
        ((NodeService)BDDMockito.then((Object)this.nodeServiceMock).should()).getPrimaryParent(CATEGORY_NODE_REF);
        ((NodeService)BDDMockito.then((Object)this.nodeServiceMock).should()).getParentAssocs(parentNodeRef);
        ((NodeService)BDDMockito.then((Object)this.nodeServiceMock).should()).getParentAssocs(CATEGORY_NODE_REF);
        ((NodeService)BDDMockito.then((Object)this.nodeServiceMock).should()).getChildAssocs(CATEGORY_NODE_REF, RegexQNamePattern.MATCH_ALL, RegexQNamePattern.MATCH_ALL, false);
        BDDMockito.then((Object)this.nodeServiceMock).shouldHaveNoMoreInteractions();
        BDDMockito.then((Object)this.categoryServiceMock).shouldHaveNoInteractions();
        BDDMockito.then((Object)this.authorityServiceMock).shouldHaveNoInteractions();
        Category expectedCategory = Category.builder().id(CATEGORY_ID).name(categoryNode.getName()).hasChildren(true).parentId(PARENT_ID).create();
        Assert.assertEquals((Object)expectedCategory, (Object)category);
    }

    @Test
    public void testGetCategoryById_withoutChildren() {
        NodeRef parentNodeRef = CategoriesImplTest.createNodeRefWithId(PARENT_ID);
        Node categoryNode = CategoriesImplTest.createNode(CATEGORY_NAME, CATEGORY_ID, parentNodeRef);
        BDDMockito.given((Object)this.nodesMock.getNode(CATEGORY_ID)).willReturn((Object)categoryNode);
        ChildAssociationRef parentAssoc = new ChildAssociationRef(null, parentNodeRef, null, CATEGORY_NODE_REF);
        BDDMockito.given((Object)this.nodeServiceMock.getPrimaryParent(CATEGORY_NODE_REF)).willReturn((Object)parentAssoc);
        BDDMockito.given((Object)this.nodeServiceMock.getChildAssocs(CATEGORY_NODE_REF, RegexQNamePattern.MATCH_ALL, RegexQNamePattern.MATCH_ALL, false)).willReturn(Collections.emptyList());
        Category category = this.objectUnderTest.getCategoryById(CATEGORY_ID, this.parametersMock);
        ((Nodes)BDDMockito.then((Object)this.nodesMock).should()).validateNode(CATEGORY_ID);
        ((Nodes)BDDMockito.then((Object)this.nodesMock).should()).isSubClass(CATEGORY_NODE_REF, ContentModel.TYPE_CATEGORY, false);
        ((Nodes)BDDMockito.then((Object)this.nodesMock).should()).getNode(CATEGORY_ID);
        BDDMockito.then((Object)this.nodesMock).shouldHaveNoMoreInteractions();
        ((NodeService)BDDMockito.then((Object)this.nodeServiceMock).should()).getPrimaryParent(CATEGORY_NODE_REF);
        ((NodeService)BDDMockito.then((Object)this.nodeServiceMock).should()).getParentAssocs(parentNodeRef);
        ((NodeService)BDDMockito.then((Object)this.nodeServiceMock).should()).getParentAssocs(CATEGORY_NODE_REF);
        ((NodeService)BDDMockito.then((Object)this.nodeServiceMock).should()).getChildAssocs(CATEGORY_NODE_REF, RegexQNamePattern.MATCH_ALL, RegexQNamePattern.MATCH_ALL, false);
        BDDMockito.then((Object)this.nodeServiceMock).shouldHaveNoMoreInteractions();
        BDDMockito.then((Object)this.categoryServiceMock).shouldHaveNoInteractions();
        BDDMockito.then((Object)this.authorityServiceMock).shouldHaveNoInteractions();
        Category expectedCategory = Category.builder().id(CATEGORY_ID).name(categoryNode.getName()).hasChildren(false).parentId(PARENT_ID).create();
        Assert.assertEquals((Object)expectedCategory, (Object)category);
    }

    @Test
    public void testGetCategoryById_includeCount() {
        QName categoryQName = CategoriesImplTest.createCmQNameOf(CATEGORY_NAME);
        NodeRef parentCategoryNodeRef = CategoriesImplTest.createNodeRefWithId(PARENT_ID);
        ChildAssociationRef parentAssociation = CategoriesImplTest.createAssociationOf(parentCategoryNodeRef, CATEGORY_NODE_REF, categoryQName);
        BDDMockito.given((Object)this.nodesMock.getNode((String)ArgumentMatchers.any())).willReturn((Object)CategoriesImplTest.createNode());
        BDDMockito.given((Object)this.nodeServiceMock.getPrimaryParent((NodeRef)ArgumentMatchers.any())).willReturn((Object)parentAssociation);
        BDDMockito.given((Object)this.parametersMock.getInclude()).willReturn(List.of("count"));
        BDDMockito.given((Object)this.categoryServiceMock.getTopCategories((StoreRef)ArgumentMatchers.any(), (QName)ArgumentMatchers.any(), ArgumentMatchers.anyInt())).willReturn(List.of(new Pair((Object)CATEGORY_NODE_REF, (Object)1)));
        Category actualCategory = this.objectUnderTest.getCategoryById(CATEGORY_ID, this.parametersMock);
        ((CategoryService)BDDMockito.then((Object)this.categoryServiceMock).should()).getTopCategories(StoreRef.STORE_REF_WORKSPACE_SPACESSTORE, ContentModel.ASPECT_GEN_CLASSIFIABLE, Integer.MAX_VALUE);
        BDDMockito.then((Object)this.categoryServiceMock).shouldHaveNoMoreInteractions();
        ((AbstractObjectAssert)((ObjectAssert)Assertions.assertThat((Object)actualCategory).isNotNull()).extracting(Category::getCount).isNotNull()).isEqualTo((Object)1);
    }

    @Test
    public void testGetCategoryById_includePath() {
        QName categoryQName = CategoriesImplTest.createCmQNameOf(CATEGORY_NAME);
        NodeRef parentCategoryNodeRef = CategoriesImplTest.createNodeRefWithId(PARENT_ID);
        ChildAssociationRef parentAssociation = CategoriesImplTest.createAssociationOf(parentCategoryNodeRef, CATEGORY_NODE_REF, categoryQName);
        BDDMockito.given((Object)this.nodesMock.getNode((String)ArgumentMatchers.any())).willReturn((Object)CategoriesImplTest.createNode());
        BDDMockito.given((Object)this.nodeServiceMock.getPrimaryParent((NodeRef)ArgumentMatchers.any())).willReturn((Object)parentAssociation);
        BDDMockito.given((Object)this.parametersMock.getInclude()).willReturn(List.of("path"));
        BDDMockito.given((Object)this.nodeServiceMock.getPath((NodeRef)ArgumentMatchers.any())).willReturn((Object)this.mockCategoryPath());
        Category actualCategory = this.objectUnderTest.getCategoryById(CATEGORY_ID, this.parametersMock);
        ((AbstractObjectAssert)((ObjectAssert)Assertions.assertThat((Object)actualCategory).isNotNull()).extracting(Category::getPath).isNotNull()).isEqualTo((Object)MOCK_CATEGORY_PATH);
    }

    @Test
    public void testGetCategoryById_notACategory() {
        NodeRef categoryNodeRef = new NodeRef(StoreRef.STORE_REF_WORKSPACE_SPACESSTORE, CATEGORY_ID);
        BDDMockito.given((Object)this.nodesMock.validateNode(CATEGORY_ID)).willReturn((Object)categoryNodeRef);
        BDDMockito.given((Object)this.nodesMock.isSubClass(categoryNodeRef, ContentModel.TYPE_CATEGORY, false)).willReturn((Object)false);
        Assert.assertThrows(InvalidArgumentException.class, () -> this.objectUnderTest.getCategoryById(CATEGORY_ID, this.parametersMock));
        ((Nodes)BDDMockito.then((Object)this.nodesMock).should()).validateNode(CATEGORY_ID);
        ((Nodes)BDDMockito.then((Object)this.nodesMock).should()).isSubClass(categoryNodeRef, ContentModel.TYPE_CATEGORY, false);
        BDDMockito.then((Object)this.nodesMock).shouldHaveNoMoreInteractions();
        BDDMockito.then((Object)this.nodeServiceMock).shouldHaveNoInteractions();
        BDDMockito.then((Object)this.categoryServiceMock).shouldHaveNoInteractions();
        BDDMockito.then((Object)this.authorityServiceMock).shouldHaveNoInteractions();
    }

    @Test
    public void testGetCategoryById_nodeNotExists() {
        BDDMockito.given((Object)this.nodesMock.validateNode(CATEGORY_ID)).willThrow(EntityNotFoundException.class);
        Assert.assertThrows(EntityNotFoundException.class, () -> this.objectUnderTest.getCategoryById(CATEGORY_ID, this.parametersMock));
        ((Nodes)BDDMockito.then((Object)this.nodesMock).should()).validateNode(CATEGORY_ID);
        BDDMockito.then((Object)this.nodesMock).shouldHaveNoMoreInteractions();
        BDDMockito.then((Object)this.nodeServiceMock).shouldHaveNoInteractions();
        BDDMockito.then((Object)this.categoryServiceMock).shouldHaveNoInteractions();
        BDDMockito.then((Object)this.authorityServiceMock).shouldHaveNoInteractions();
    }

    @Test
    public void testDeleteCategoryById_asAdmin() {
        BDDMockito.given((Object)this.authorityServiceMock.hasAdminAuthority()).willReturn((Object)true);
        NodeRef categoryNodeRef = CategoriesImplTest.createNodeRefWithId(CATEGORY_ID);
        BDDMockito.given((Object)this.nodesMock.validateNode(CATEGORY_ID)).willReturn((Object)categoryNodeRef);
        BDDMockito.given((Object)this.nodesMock.isSubClass(categoryNodeRef, ContentModel.TYPE_CATEGORY, false)).willReturn((Object)true);
        this.objectUnderTest.deleteCategoryById(CATEGORY_ID, this.parametersMock);
        ((AuthorityService)BDDMockito.then((Object)this.authorityServiceMock).should()).hasAdminAuthority();
        BDDMockito.then((Object)this.authorityServiceMock).shouldHaveNoMoreInteractions();
        ((Nodes)BDDMockito.then((Object)this.nodesMock).should()).validateNode(CATEGORY_ID);
        ((Nodes)BDDMockito.then((Object)this.nodesMock).should()).isSubClass(categoryNodeRef, ContentModel.TYPE_CATEGORY, false);
        BDDMockito.then((Object)this.nodesMock).shouldHaveNoMoreInteractions();
        ((NodeService)BDDMockito.then((Object)this.nodeServiceMock).should()).getParentAssocs(categoryNodeRef);
        ((NodeService)BDDMockito.then((Object)this.nodeServiceMock).should()).deleteNode(categoryNodeRef);
        BDDMockito.then((Object)this.nodeServiceMock).shouldHaveNoMoreInteractions();
    }

    @Test
    public void testDeleteCategoryById_asNonAdminUser() {
        BDDMockito.given((Object)this.authorityServiceMock.hasAdminAuthority()).willReturn((Object)false);
        Assert.assertThrows(PermissionDeniedException.class, () -> this.objectUnderTest.deleteCategoryById(CATEGORY_ID, this.parametersMock));
        ((AuthorityService)BDDMockito.then((Object)this.authorityServiceMock).should()).hasAdminAuthority();
        BDDMockito.then((Object)this.authorityServiceMock).shouldHaveNoMoreInteractions();
        BDDMockito.then((Object)this.nodesMock).shouldHaveNoInteractions();
        BDDMockito.then((Object)this.nodeServiceMock).shouldHaveNoInteractions();
    }

    @Test
    public void testDeleteCategoryById_nonCategoryId() {
        BDDMockito.given((Object)this.authorityServiceMock.hasAdminAuthority()).willReturn((Object)true);
        NodeRef categoryNodeRef = CategoriesImplTest.createNodeRefWithId(CATEGORY_ID);
        BDDMockito.given((Object)this.nodesMock.validateNode(CATEGORY_ID)).willReturn((Object)categoryNodeRef);
        BDDMockito.given((Object)this.nodesMock.isSubClass(categoryNodeRef, ContentModel.TYPE_CATEGORY, false)).willReturn((Object)false);
        Assert.assertThrows(InvalidArgumentException.class, () -> this.objectUnderTest.deleteCategoryById(CATEGORY_ID, this.parametersMock));
        ((AuthorityService)BDDMockito.then((Object)this.authorityServiceMock).should()).hasAdminAuthority();
        BDDMockito.then((Object)this.authorityServiceMock).shouldHaveNoMoreInteractions();
        ((Nodes)BDDMockito.then((Object)this.nodesMock).should()).validateNode(CATEGORY_ID);
        ((Nodes)BDDMockito.then((Object)this.nodesMock).should()).isSubClass(categoryNodeRef, ContentModel.TYPE_CATEGORY, false);
        BDDMockito.then((Object)this.nodesMock).shouldHaveNoMoreInteractions();
    }

    @Test
    public void testDeleteCategoryById_rootCategory() {
        BDDMockito.given((Object)this.authorityServiceMock.hasAdminAuthority()).willReturn((Object)true);
        NodeRef categoryRootNodeRef = CategoriesImplTest.createNodeRefWithId(CAT_ROOT_NODE_ID);
        BDDMockito.given((Object)this.nodesMock.validateNode(CAT_ROOT_NODE_ID)).willReturn((Object)categoryRootNodeRef);
        BDDMockito.given((Object)this.nodesMock.isSubClass(categoryRootNodeRef, ContentModel.TYPE_CATEGORY, false)).willReturn((Object)true);
        BDDMockito.given((Object)this.categoryChildAssociationRefMock.getQName()).willReturn((Object)ContentModel.ASPECT_GEN_CLASSIFIABLE);
        BDDMockito.given((Object)this.nodeServiceMock.getParentAssocs(categoryRootNodeRef)).willReturn(List.of(this.categoryChildAssociationRefMock));
        Assert.assertThrows(InvalidArgumentException.class, () -> this.objectUnderTest.deleteCategoryById(CAT_ROOT_NODE_ID, this.parametersMock));
        ((AuthorityService)BDDMockito.then((Object)this.authorityServiceMock).should()).hasAdminAuthority();
        BDDMockito.then((Object)this.authorityServiceMock).shouldHaveNoMoreInteractions();
        ((Nodes)BDDMockito.then((Object)this.nodesMock).should()).validateNode(CAT_ROOT_NODE_ID);
        ((Nodes)BDDMockito.then((Object)this.nodesMock).should()).isSubClass(categoryRootNodeRef, ContentModel.TYPE_CATEGORY, false);
        BDDMockito.then((Object)this.nodesMock).shouldHaveNoMoreInteractions();
        ((NodeService)BDDMockito.then((Object)this.nodeServiceMock).should()).getParentAssocs(categoryRootNodeRef);
        BDDMockito.then((Object)this.nodeServiceMock).shouldHaveNoMoreInteractions();
    }

    @Test
    public void testCreateCategoryUnderRoot() {
        NodeRef parentCategoryNodeRef = CategoriesImplTest.createNodeRefWithId("-root-");
        BDDMockito.given((Object)this.categoryServiceMock.getRootCategoryNodeRef(StoreRef.STORE_REF_WORKSPACE_SPACESSTORE)).willReturn(Optional.of(parentCategoryNodeRef));
        NodeRef categoryNodeRef = CategoriesImplTest.createNodeRefWithId(CATEGORY_ID);
        BDDMockito.given((Object)this.categoryServiceMock.createCategory(parentCategoryNodeRef, CATEGORY_NAME)).willReturn((Object)categoryNodeRef);
        BDDMockito.given((Object)this.nodesMock.getNode(CATEGORY_ID)).willReturn((Object)CategoriesImplTest.createNode());
        ChildAssociationRef parentAssoc = CategoriesImplTest.createAssociationOf(parentCategoryNodeRef, categoryNodeRef);
        BDDMockito.given((Object)this.nodeServiceMock.getPrimaryParent(categoryNodeRef)).willReturn((Object)parentAssoc);
        BDDMockito.given((Object)this.nodeServiceMock.getParentAssocs(parentCategoryNodeRef)).willReturn(List.of(parentAssoc));
        BDDMockito.given((Object)this.nodeServiceMock.getChildAssocs(categoryNodeRef, RegexQNamePattern.MATCH_ALL, RegexQNamePattern.MATCH_ALL, false)).willReturn(Collections.emptyList());
        List createdCategories = this.objectUnderTest.createSubcategories("-root-", this.prepareCategories(), this.parametersMock);
        ((AuthorityService)BDDMockito.then((Object)this.authorityServiceMock).should()).hasAdminAuthority();
        BDDMockito.then((Object)this.authorityServiceMock).shouldHaveNoMoreInteractions();
        ((Nodes)BDDMockito.then((Object)this.nodesMock).should()).getNode(CATEGORY_ID);
        BDDMockito.then((Object)this.nodesMock).shouldHaveNoMoreInteractions();
        ((NodeService)BDDMockito.then((Object)this.nodeServiceMock).should()).getPrimaryParent(categoryNodeRef);
        ((NodeService)BDDMockito.then((Object)this.nodeServiceMock).should()).getParentAssocs(parentCategoryNodeRef);
        ((NodeService)BDDMockito.then((Object)this.nodeServiceMock).should()).getChildAssocs(categoryNodeRef, RegexQNamePattern.MATCH_ALL, RegexQNamePattern.MATCH_ALL, false);
        BDDMockito.then((Object)this.nodeServiceMock).shouldHaveNoMoreInteractions();
        ((CategoryService)BDDMockito.then((Object)this.categoryServiceMock).should()).getRootCategoryNodeRef(StoreRef.STORE_REF_WORKSPACE_SPACESSTORE);
        ((CategoryService)BDDMockito.then((Object)this.categoryServiceMock).should()).createCategory(parentCategoryNodeRef, CATEGORY_NAME);
        BDDMockito.then((Object)this.categoryServiceMock).shouldHaveNoMoreInteractions();
        Assert.assertEquals((long)1L, (long)createdCategories.size());
        Category expectedCategory = Category.builder().id(CATEGORY_ID).name(CATEGORY_NAME).hasChildren(false).parentId("-root-").create();
        Category createdCategory = (Category)createdCategories.iterator().next();
        Assert.assertEquals((Object)expectedCategory, (Object)createdCategory);
    }

    @Test
    public void testCreateCategory() {
        NodeRef parentCategoryNodeRef = CategoriesImplTest.createNodeRefWithId(PARENT_ID);
        BDDMockito.given((Object)this.nodesMock.validateNode(PARENT_ID)).willReturn((Object)parentCategoryNodeRef);
        NodeRef categoryNodeRef = CategoriesImplTest.createNodeRefWithId(CATEGORY_ID);
        BDDMockito.given((Object)this.categoryServiceMock.createCategory(parentCategoryNodeRef, CATEGORY_NAME)).willReturn((Object)categoryNodeRef);
        BDDMockito.given((Object)this.nodesMock.getNode(CATEGORY_ID)).willReturn((Object)CategoriesImplTest.createNode());
        ChildAssociationRef parentAssoc = CategoriesImplTest.createAssociationOf(parentCategoryNodeRef, categoryNodeRef);
        BDDMockito.given((Object)this.nodeServiceMock.getPrimaryParent(categoryNodeRef)).willReturn((Object)parentAssoc);
        BDDMockito.given((Object)this.nodeServiceMock.getParentAssocs(parentCategoryNodeRef)).willReturn(List.of(parentAssoc));
        BDDMockito.given((Object)this.nodeServiceMock.getChildAssocs(categoryNodeRef, RegexQNamePattern.MATCH_ALL, RegexQNamePattern.MATCH_ALL, false)).willReturn(Collections.emptyList());
        List createdCategories = this.objectUnderTest.createSubcategories(PARENT_ID, this.prepareCategories(), this.parametersMock);
        ((AuthorityService)BDDMockito.then((Object)this.authorityServiceMock).should()).hasAdminAuthority();
        BDDMockito.then((Object)this.authorityServiceMock).shouldHaveNoMoreInteractions();
        ((Nodes)BDDMockito.then((Object)this.nodesMock).should()).validateNode(PARENT_ID);
        ((Nodes)BDDMockito.then((Object)this.nodesMock).should()).isSubClass(parentCategoryNodeRef, ContentModel.TYPE_CATEGORY, false);
        ((Nodes)BDDMockito.then((Object)this.nodesMock).should()).getNode(CATEGORY_ID);
        BDDMockito.then((Object)this.nodesMock).shouldHaveNoMoreInteractions();
        ((NodeService)BDDMockito.then((Object)this.nodeServiceMock).should()).getPrimaryParent(categoryNodeRef);
        ((NodeService)BDDMockito.then((Object)this.nodeServiceMock).should()).getParentAssocs(parentCategoryNodeRef);
        ((NodeService)BDDMockito.then((Object)this.nodeServiceMock).should()).getChildAssocs(categoryNodeRef, RegexQNamePattern.MATCH_ALL, RegexQNamePattern.MATCH_ALL, false);
        BDDMockito.then((Object)this.nodeServiceMock).shouldHaveNoMoreInteractions();
        ((CategoryService)BDDMockito.then((Object)this.categoryServiceMock).should()).createCategory(parentCategoryNodeRef, CATEGORY_NAME);
        BDDMockito.then((Object)this.categoryServiceMock).shouldHaveNoMoreInteractions();
        Assert.assertEquals((long)1L, (long)createdCategories.size());
        Category expectedCategory = Category.builder().id(CATEGORY_ID).name(CATEGORY_NAME).hasChildren(false).parentId(PARENT_ID).create();
        Category createdCategory = (Category)createdCategories.iterator().next();
        Assert.assertEquals((Object)expectedCategory, (Object)createdCategory);
    }

    @Test
    public void testCreateCategory_includeCount() {
        QName categoryQName = CategoriesImplTest.createCmQNameOf(CATEGORY_NAME);
        NodeRef categoryNodeRef = CategoriesImplTest.createNodeRefWithId(CATEGORY_ID);
        NodeRef parentCategoryNodeRef = CategoriesImplTest.createNodeRefWithId(PARENT_ID);
        ChildAssociationRef parentAssociation = CategoriesImplTest.createAssociationOf(parentCategoryNodeRef, CATEGORY_NODE_REF, categoryQName);
        BDDMockito.given((Object)this.nodesMock.validateNode(PARENT_ID)).willReturn((Object)parentCategoryNodeRef);
        BDDMockito.given((Object)this.categoryServiceMock.createCategory(parentCategoryNodeRef, CATEGORY_NAME)).willReturn((Object)categoryNodeRef);
        BDDMockito.given((Object)this.nodesMock.getNode((String)ArgumentMatchers.any())).willReturn((Object)CategoriesImplTest.createNode());
        BDDMockito.given((Object)this.nodeServiceMock.getPrimaryParent((NodeRef)ArgumentMatchers.any())).willReturn((Object)parentAssociation);
        BDDMockito.given((Object)this.parametersMock.getInclude()).willReturn(List.of("count"));
        List categoryModels = this.prepareCategories().stream().peek(category -> category.setCount(Integer.valueOf(1))).collect(Collectors.toList());
        List actualCreatedCategories = this.objectUnderTest.createSubcategories(PARENT_ID, categoryModels, this.parametersMock);
        ((CategoryService)BDDMockito.then((Object)this.categoryServiceMock).should()).createCategory((NodeRef)ArgumentMatchers.any(), (String)ArgumentMatchers.any());
        BDDMockito.then((Object)this.categoryServiceMock).shouldHaveNoMoreInteractions();
        ((AbstractObjectAssert)((ObjectAssert)((ListAssert)((ListAssert)Assertions.assertThat((List)actualCreatedCategories).isNotNull()).hasSize(1)).element(0)).extracting(Category::getCount).isNotNull()).isEqualTo((Object)0);
    }

    @Test
    public void testCreateCategory_includePath() {
        QName categoryQName = CategoriesImplTest.createCmQNameOf(CATEGORY_NAME);
        NodeRef categoryNodeRef = CategoriesImplTest.createNodeRefWithId(CATEGORY_ID);
        NodeRef parentCategoryNodeRef = CategoriesImplTest.createNodeRefWithId(PARENT_ID);
        ChildAssociationRef parentAssociation = CategoriesImplTest.createAssociationOf(parentCategoryNodeRef, CATEGORY_NODE_REF, categoryQName);
        BDDMockito.given((Object)this.nodesMock.validateNode(PARENT_ID)).willReturn((Object)parentCategoryNodeRef);
        BDDMockito.given((Object)this.categoryServiceMock.createCategory(parentCategoryNodeRef, CATEGORY_NAME)).willReturn((Object)categoryNodeRef);
        BDDMockito.given((Object)this.nodesMock.getNode((String)ArgumentMatchers.any())).willReturn((Object)CategoriesImplTest.createNode());
        BDDMockito.given((Object)this.nodeServiceMock.getPrimaryParent((NodeRef)ArgumentMatchers.any())).willReturn((Object)parentAssociation);
        BDDMockito.given((Object)this.parametersMock.getInclude()).willReturn(List.of("path"));
        BDDMockito.given((Object)this.nodeServiceMock.getPath((NodeRef)ArgumentMatchers.any())).willReturn((Object)this.mockCategoryPath());
        ArrayList<Category> categoryModels = new ArrayList<Category>(this.prepareCategories());
        List actualCreatedCategories = this.objectUnderTest.createSubcategories(PARENT_ID, categoryModels, this.parametersMock);
        ((CategoryService)BDDMockito.then((Object)this.categoryServiceMock).should()).createCategory((NodeRef)ArgumentMatchers.any(), (String)ArgumentMatchers.any());
        BDDMockito.then((Object)this.categoryServiceMock).shouldHaveNoMoreInteractions();
        ((AbstractObjectAssert)((ObjectAssert)((ListAssert)((ListAssert)Assertions.assertThat((List)actualCreatedCategories).isNotNull()).hasSize(1)).element(0)).extracting(Category::getPath).isNotNull()).isEqualTo((Object)MOCK_CATEGORY_PATH);
    }

    @Test
    public void testCreateCategories_noPermissions() {
        BDDMockito.given((Object)this.authorityServiceMock.hasAdminAuthority()).willReturn((Object)false);
        Assert.assertThrows(PermissionDeniedException.class, () -> this.objectUnderTest.createSubcategories(PARENT_ID, this.prepareCategories(), this.parametersMock));
        ((AuthorityService)BDDMockito.then((Object)this.authorityServiceMock).should()).hasAdminAuthority();
        BDDMockito.then((Object)this.authorityServiceMock).shouldHaveNoMoreInteractions();
        BDDMockito.then((Object)this.nodesMock).shouldHaveNoInteractions();
        BDDMockito.then((Object)this.nodeServiceMock).shouldHaveNoInteractions();
        BDDMockito.then((Object)this.categoryServiceMock).shouldHaveNoInteractions();
    }

    @Test
    public void testCreateCategories_wrongParentNodeType() {
        NodeRef parentCategoryNodeRef = new NodeRef(StoreRef.STORE_REF_WORKSPACE_SPACESSTORE, PARENT_ID);
        BDDMockito.given((Object)this.nodesMock.validateNode(PARENT_ID)).willReturn((Object)parentCategoryNodeRef);
        BDDMockito.given((Object)this.nodesMock.isSubClass(parentCategoryNodeRef, ContentModel.TYPE_CATEGORY, false)).willReturn((Object)false);
        Assert.assertThrows(InvalidArgumentException.class, () -> this.objectUnderTest.createSubcategories(PARENT_ID, this.prepareCategories(), this.parametersMock));
        ((AuthorityService)BDDMockito.then((Object)this.authorityServiceMock).should()).hasAdminAuthority();
        BDDMockito.then((Object)this.authorityServiceMock).shouldHaveNoMoreInteractions();
        ((Nodes)BDDMockito.then((Object)this.nodesMock).should()).validateNode(PARENT_ID);
        ((Nodes)BDDMockito.then((Object)this.nodesMock).should()).isSubClass(parentCategoryNodeRef, ContentModel.TYPE_CATEGORY, false);
        BDDMockito.then((Object)this.nodesMock).shouldHaveNoMoreInteractions();
        BDDMockito.then((Object)this.nodeServiceMock).shouldHaveNoInteractions();
        BDDMockito.then((Object)this.categoryServiceMock).shouldHaveNoInteractions();
    }

    @Test
    public void testCreateCategories_nonExistingParentNode() {
        BDDMockito.given((Object)this.nodesMock.validateNode(PARENT_ID)).willThrow(EntityNotFoundException.class);
        Assert.assertThrows(EntityNotFoundException.class, () -> this.objectUnderTest.createSubcategories(PARENT_ID, this.prepareCategories(), this.parametersMock));
        ((AuthorityService)BDDMockito.then((Object)this.authorityServiceMock).should()).hasAdminAuthority();
        BDDMockito.then((Object)this.authorityServiceMock).shouldHaveNoMoreInteractions();
        ((Nodes)BDDMockito.then((Object)this.nodesMock).should()).validateNode(PARENT_ID);
        BDDMockito.then((Object)this.nodesMock).shouldHaveNoMoreInteractions();
        BDDMockito.then((Object)this.nodeServiceMock).shouldHaveNoInteractions();
        BDDMockito.then((Object)this.categoryServiceMock).shouldHaveNoInteractions();
    }

    @Test
    public void testGetRootCategoryChildren() {
        NodeRef parentCategoryNodeRef = CategoriesImplTest.createNodeRefWithId("-root-");
        BDDMockito.given((Object)this.categoryServiceMock.getRootCategoryNodeRef(StoreRef.STORE_REF_WORKSPACE_SPACESSTORE)).willReturn(Optional.of(parentCategoryNodeRef));
        int childrenCount = 3;
        List<ChildAssociationRef> childAssociationRefMocks = this.prepareChildAssocMocks(3, parentCategoryNodeRef);
        BDDMockito.given((Object)this.nodeServiceMock.getChildAssocs(parentCategoryNodeRef)).willReturn(childAssociationRefMocks);
        childAssociationRefMocks.forEach(this::prepareCategoryNodeMocks);
        List categoryChildren = this.objectUnderTest.getCategoryChildren("-root-", this.parametersMock);
        ((CategoryService)BDDMockito.then((Object)this.categoryServiceMock).should()).getRootCategoryNodeRef(StoreRef.STORE_REF_WORKSPACE_SPACESSTORE);
        BDDMockito.then((Object)this.categoryServiceMock).shouldHaveNoMoreInteractions();
        ((NodeService)BDDMockito.then((Object)this.nodeServiceMock).should()).getChildAssocs(parentCategoryNodeRef);
        childAssociationRefMocks.forEach(ca -> {
            ((Nodes)BDDMockito.then((Object)this.nodesMock).should()).getNode(ca.getChildRef().getId());
            ((NodeService)BDDMockito.then((Object)this.nodeServiceMock).should()).getChildAssocs(ca.getChildRef(), RegexQNamePattern.MATCH_ALL, RegexQNamePattern.MATCH_ALL, false);
            ((NodeService)BDDMockito.then((Object)this.nodeServiceMock).should()).getPrimaryParent(ca.getChildRef());
        });
        ((NodeService)BDDMockito.then((Object)this.nodeServiceMock).should(Mockito.times((int)3))).getParentAssocs(parentCategoryNodeRef);
        BDDMockito.then((Object)this.nodesMock).shouldHaveNoMoreInteractions();
        BDDMockito.then((Object)this.nodeServiceMock).shouldHaveNoMoreInteractions();
        BDDMockito.then((Object)this.authorityServiceMock).shouldHaveNoInteractions();
        Assert.assertEquals((long)childAssociationRefMocks.size(), (long)categoryChildren.size());
        IntStream.range(0, 3).forEach(i -> this.doCategoryAssertions((Category)categoryChildren.get(i), i, "-root-"));
    }

    @Test
    public void testGetCategoryChildren() {
        NodeRef parentCategoryNodeRef = CategoriesImplTest.createNodeRefWithId(PARENT_ID);
        BDDMockito.given((Object)this.nodesMock.validateNode(PARENT_ID)).willReturn((Object)parentCategoryNodeRef);
        BDDMockito.given((Object)this.nodesMock.isSubClass(parentCategoryNodeRef, ContentModel.TYPE_CATEGORY, false)).willReturn((Object)true);
        int childrenCount = 3;
        List<ChildAssociationRef> childAssociationRefMocks = this.prepareChildAssocMocks(3, parentCategoryNodeRef);
        BDDMockito.given((Object)this.nodeServiceMock.getChildAssocs(parentCategoryNodeRef)).willReturn(childAssociationRefMocks);
        childAssociationRefMocks.forEach(this::prepareCategoryNodeMocks);
        List categoryChildren = this.objectUnderTest.getCategoryChildren(PARENT_ID, this.parametersMock);
        ((Nodes)BDDMockito.then((Object)this.nodesMock).should()).validateNode(PARENT_ID);
        ((Nodes)BDDMockito.then((Object)this.nodesMock).should()).isSubClass(parentCategoryNodeRef, ContentModel.TYPE_CATEGORY, false);
        ((NodeService)BDDMockito.then((Object)this.nodeServiceMock).should()).getChildAssocs(parentCategoryNodeRef);
        childAssociationRefMocks.forEach(ca -> {
            ((Nodes)BDDMockito.then((Object)this.nodesMock).should()).getNode(ca.getChildRef().getId());
            ((NodeService)BDDMockito.then((Object)this.nodeServiceMock).should()).getChildAssocs(ca.getChildRef(), RegexQNamePattern.MATCH_ALL, RegexQNamePattern.MATCH_ALL, false);
            ((NodeService)BDDMockito.then((Object)this.nodeServiceMock).should()).getPrimaryParent(ca.getChildRef());
        });
        ((NodeService)BDDMockito.then((Object)this.nodeServiceMock).should(Mockito.times((int)3))).getParentAssocs(parentCategoryNodeRef);
        BDDMockito.then((Object)this.nodesMock).shouldHaveNoMoreInteractions();
        BDDMockito.then((Object)this.nodeServiceMock).shouldHaveNoMoreInteractions();
        BDDMockito.then((Object)this.authorityServiceMock).shouldHaveNoInteractions();
        BDDMockito.then((Object)this.categoryServiceMock).shouldHaveNoInteractions();
        Assert.assertEquals((long)childAssociationRefMocks.size(), (long)categoryChildren.size());
        IntStream.range(0, 3).forEach(i -> this.doCategoryAssertions((Category)categoryChildren.get(i), i, PARENT_ID));
    }

    @Test
    public void testGetCategoryChildren_includeCount() {
        NodeRef parentCategoryNodeRef = CategoriesImplTest.createNodeRefWithId(PARENT_ID);
        BDDMockito.given((Object)this.nodesMock.validateNode(PARENT_ID)).willReturn((Object)parentCategoryNodeRef);
        BDDMockito.given((Object)this.nodesMock.isSubClass(parentCategoryNodeRef, ContentModel.TYPE_CATEGORY, false)).willReturn((Object)true);
        int childrenCount = 3;
        List<ChildAssociationRef> childAssociationRefMocks = this.prepareChildAssocMocks(3, parentCategoryNodeRef);
        BDDMockito.given((Object)this.nodeServiceMock.getChildAssocs(parentCategoryNodeRef)).willReturn(childAssociationRefMocks);
        childAssociationRefMocks.forEach(this::prepareCategoryNodeMocks);
        BDDMockito.given((Object)this.parametersMock.getInclude()).willReturn(List.of("count"));
        BDDMockito.given((Object)this.categoryServiceMock.getTopCategories((StoreRef)ArgumentMatchers.any(), (QName)ArgumentMatchers.any(), ArgumentMatchers.anyInt())).willReturn(List.of(new Pair((Object)CategoriesImplTest.createNodeRefWithId(CATEGORY_ID.concat("-1")), (Object)2)));
        List actualCategoryChildren = this.objectUnderTest.getCategoryChildren(PARENT_ID, this.parametersMock);
        ((CategoryService)BDDMockito.then((Object)this.categoryServiceMock).should()).getTopCategories(StoreRef.STORE_REF_WORKSPACE_SPACESSTORE, ContentModel.ASPECT_GEN_CLASSIFIABLE, Integer.MAX_VALUE);
        BDDMockito.then((Object)this.categoryServiceMock).shouldHaveNoMoreInteractions();
        ((ListAssert)((ListAssert)Assertions.assertThat((List)actualCategoryChildren).isNotNull()).hasSize(3)).extracting(Category::getCount).isNotNull().isEqualTo(List.of(Integer.valueOf(0), Integer.valueOf(2), Integer.valueOf(0)));
    }

    @Test
    public void testGetCategoryChildren_includePath() {
        NodeRef parentCategoryNodeRef = CategoriesImplTest.createNodeRefWithId(PARENT_ID);
        BDDMockito.given((Object)this.nodesMock.validateNode(PARENT_ID)).willReturn((Object)parentCategoryNodeRef);
        BDDMockito.given((Object)this.nodesMock.isSubClass(parentCategoryNodeRef, ContentModel.TYPE_CATEGORY, false)).willReturn((Object)true);
        int childrenCount = 3;
        List<ChildAssociationRef> childAssociationRefMocks = this.prepareChildAssocMocks(3, parentCategoryNodeRef);
        BDDMockito.given((Object)this.nodeServiceMock.getChildAssocs(parentCategoryNodeRef)).willReturn(childAssociationRefMocks);
        childAssociationRefMocks.forEach(this::prepareCategoryNodeMocks);
        BDDMockito.given((Object)this.parametersMock.getInclude()).willReturn(List.of("path"));
        BDDMockito.given((Object)this.nodeServiceMock.getPath((NodeRef)ArgumentMatchers.any())).willReturn((Object)this.mockCategoryPath());
        List actualCategoryChildren = this.objectUnderTest.getCategoryChildren(PARENT_ID, this.parametersMock);
        ((ListAssert)((ListAssert)Assertions.assertThat((List)actualCategoryChildren).isNotNull()).hasSize(3)).extracting(Category::getPath).isNotNull().isEqualTo(List.of(MOCK_CATEGORY_PATH, MOCK_CATEGORY_PATH, MOCK_CATEGORY_PATH));
    }

    @Test
    public void testGetCategoryChildren_noChildren() {
        NodeRef parentCategoryNodeRef = CategoriesImplTest.createNodeRefWithId(PARENT_ID);
        BDDMockito.given((Object)this.nodesMock.validateNode(PARENT_ID)).willReturn((Object)parentCategoryNodeRef);
        BDDMockito.given((Object)this.nodesMock.isSubClass(parentCategoryNodeRef, ContentModel.TYPE_CATEGORY, false)).willReturn((Object)true);
        BDDMockito.given((Object)this.nodeServiceMock.getChildAssocs(parentCategoryNodeRef)).willReturn(Collections.emptyList());
        List categoryChildren = this.objectUnderTest.getCategoryChildren(PARENT_ID, this.parametersMock);
        ((Nodes)BDDMockito.then((Object)this.nodesMock).should()).validateNode(PARENT_ID);
        ((Nodes)BDDMockito.then((Object)this.nodesMock).should()).isSubClass(parentCategoryNodeRef, ContentModel.TYPE_CATEGORY, false);
        BDDMockito.then((Object)this.nodesMock).shouldHaveNoMoreInteractions();
        ((NodeService)BDDMockito.then((Object)this.nodeServiceMock).should()).getChildAssocs(parentCategoryNodeRef);
        BDDMockito.then((Object)this.nodeServiceMock).shouldHaveNoMoreInteractions();
        BDDMockito.then((Object)this.authorityServiceMock).shouldHaveNoInteractions();
        BDDMockito.then((Object)this.categoryServiceMock).shouldHaveNoInteractions();
        Assert.assertEquals((long)0L, (long)categoryChildren.size());
    }

    @Test
    public void testGetCategoryChildren_wrongParentNodeType() {
        NodeRef parentCategoryNodeRef = CategoriesImplTest.createNodeRefWithId(PARENT_ID);
        BDDMockito.given((Object)this.nodesMock.validateNode(PARENT_ID)).willReturn((Object)parentCategoryNodeRef);
        BDDMockito.given((Object)this.nodesMock.isSubClass(parentCategoryNodeRef, ContentModel.TYPE_CATEGORY, false)).willReturn((Object)false);
        Assert.assertThrows(InvalidArgumentException.class, () -> this.objectUnderTest.getCategoryChildren(PARENT_ID, this.parametersMock));
        ((Nodes)BDDMockito.then((Object)this.nodesMock).should()).validateNode(PARENT_ID);
        ((Nodes)BDDMockito.then((Object)this.nodesMock).should()).isSubClass(parentCategoryNodeRef, ContentModel.TYPE_CATEGORY, false);
        BDDMockito.then((Object)this.nodesMock).shouldHaveNoMoreInteractions();
        BDDMockito.then((Object)this.nodeServiceMock).shouldHaveNoInteractions();
        BDDMockito.then((Object)this.categoryServiceMock).shouldHaveNoInteractions();
        BDDMockito.then((Object)this.authorityServiceMock).shouldHaveNoInteractions();
    }

    @Test
    public void testGetCategoryChildren_nonExistingParentNode() {
        BDDMockito.given((Object)this.nodesMock.validateNode(PARENT_ID)).willThrow(EntityNotFoundException.class);
        Assert.assertThrows(EntityNotFoundException.class, () -> this.objectUnderTest.getCategoryChildren(PARENT_ID, this.parametersMock));
        ((Nodes)BDDMockito.then((Object)this.nodesMock).should()).validateNode(PARENT_ID);
        BDDMockito.then((Object)this.nodesMock).shouldHaveNoMoreInteractions();
        BDDMockito.then((Object)this.nodeServiceMock).shouldHaveNoInteractions();
        BDDMockito.then((Object)this.categoryServiceMock).shouldHaveNoInteractions();
        BDDMockito.then((Object)this.authorityServiceMock).shouldHaveNoInteractions();
    }

    @Test
    public void testUpdateCategoryById() {
        String categoryNewName = "categoryNewName";
        Category fixedCategory = CategoriesImplTest.createCategoryOnlyWithName("categoryNewName");
        QName categoryQName = CategoriesImplTest.createCmQNameOf(CATEGORY_NAME);
        NodeRef parentCategoryNodeRef = CategoriesImplTest.createNodeRefWithId(PARENT_ID);
        ChildAssociationRef parentAssociation = CategoriesImplTest.createAssociationOf(parentCategoryNodeRef, CATEGORY_NODE_REF, categoryQName);
        BDDMockito.given((Object)this.nodesMock.getNode((String)ArgumentMatchers.any())).willReturn((Object)CategoriesImplTest.createNode("categoryNewName"));
        BDDMockito.given((Object)this.nodeServiceMock.getPrimaryParent((NodeRef)ArgumentMatchers.any())).willReturn((Object)parentAssociation);
        BDDMockito.given((Object)this.nodeServiceMock.moveNode((NodeRef)ArgumentMatchers.any(), (NodeRef)ArgumentMatchers.any(), (QName)ArgumentMatchers.any(), (QName)ArgumentMatchers.any())).willReturn((Object)CategoriesImplTest.createAssociationOf(parentCategoryNodeRef, CATEGORY_NODE_REF, CategoriesImplTest.createCmQNameOf("categoryNewName")));
        Category actualCategory = this.objectUnderTest.updateCategoryById(CATEGORY_ID, fixedCategory, this.parametersMock);
        ((AuthorityService)BDDMockito.then((Object)this.authorityServiceMock).should()).hasAdminAuthority();
        BDDMockito.then((Object)this.authorityServiceMock).shouldHaveNoMoreInteractions();
        ((Nodes)BDDMockito.then((Object)this.nodesMock).should()).validateNode(CATEGORY_ID);
        ((Nodes)BDDMockito.then((Object)this.nodesMock).should()).isSubClass(CATEGORY_NODE_REF, ContentModel.TYPE_CATEGORY, false);
        ((Nodes)BDDMockito.then((Object)this.nodesMock).should()).getNode(CATEGORY_ID);
        BDDMockito.then((Object)this.nodesMock).shouldHaveNoMoreInteractions();
        ((NodeService)BDDMockito.then((Object)this.nodeServiceMock).should()).getParentAssocs(CATEGORY_NODE_REF);
        ((NodeService)BDDMockito.then((Object)this.nodeServiceMock).should()).getChildAssocs(CATEGORY_NODE_REF, RegexQNamePattern.MATCH_ALL, RegexQNamePattern.MATCH_ALL, false);
        ((NodeService)BDDMockito.then((Object)this.nodeServiceMock).should()).setProperty(CATEGORY_NODE_REF, ContentModel.PROP_NAME, (Serializable)((Object)"categoryNewName"));
        ((NodeService)BDDMockito.then((Object)this.nodeServiceMock).should(Mockito.times((int)2))).getPrimaryParent(CATEGORY_NODE_REF);
        QName expectedNewQName = CategoriesImplTest.createCmQNameOf("categoryNewName");
        ((NodeService)BDDMockito.then((Object)this.nodeServiceMock).should()).moveNode(CATEGORY_NODE_REF, parentCategoryNodeRef, ContentModel.ASSOC_SUBCATEGORIES, expectedNewQName);
        ((NodeService)BDDMockito.then((Object)this.nodeServiceMock).should()).getParentAssocs(parentCategoryNodeRef);
        BDDMockito.then((Object)this.nodeServiceMock).shouldHaveNoMoreInteractions();
        BDDMockito.then((Object)this.categoryServiceMock).shouldHaveNoInteractions();
        Category expectedCategory = CategoriesImplTest.createDefaultCategoryWithName("categoryNewName");
        ((ObjectAssert)Assertions.assertThat((Object)actualCategory).isNotNull()).usingRecursiveComparison().isEqualTo((Object)expectedCategory);
    }

    @Test
    public void testUpdateCategoryById_includeCount() {
        String categoryNewName = "categoryNewName";
        Category fixedCategory = CategoriesImplTest.createCategoryOnlyWithName("categoryNewName");
        fixedCategory.setCount(Integer.valueOf(9));
        QName categoryQName = CategoriesImplTest.createCmQNameOf(CATEGORY_NAME);
        NodeRef parentCategoryNodeRef = CategoriesImplTest.createNodeRefWithId(PARENT_ID);
        ChildAssociationRef parentAssociation = CategoriesImplTest.createAssociationOf(parentCategoryNodeRef, CATEGORY_NODE_REF, categoryQName);
        BDDMockito.given((Object)this.nodesMock.getNode((String)ArgumentMatchers.any())).willReturn((Object)CategoriesImplTest.createNode("categoryNewName"));
        BDDMockito.given((Object)this.nodeServiceMock.getPrimaryParent((NodeRef)ArgumentMatchers.any())).willReturn((Object)parentAssociation);
        BDDMockito.given((Object)this.nodeServiceMock.moveNode((NodeRef)ArgumentMatchers.any(), (NodeRef)ArgumentMatchers.any(), (QName)ArgumentMatchers.any(), (QName)ArgumentMatchers.any())).willReturn((Object)CategoriesImplTest.createAssociationOf(parentCategoryNodeRef, CATEGORY_NODE_REF, CategoriesImplTest.createCmQNameOf("categoryNewName")));
        BDDMockito.given((Object)this.parametersMock.getInclude()).willReturn(List.of("count"));
        BDDMockito.given((Object)this.categoryServiceMock.getTopCategories((StoreRef)ArgumentMatchers.any(), (QName)ArgumentMatchers.any(), ArgumentMatchers.anyInt())).willReturn(List.of(new Pair((Object)CATEGORY_NODE_REF, (Object)1)));
        Category actualCategory = this.objectUnderTest.updateCategoryById(CATEGORY_ID, fixedCategory, this.parametersMock);
        ((CategoryService)BDDMockito.then((Object)this.categoryServiceMock).should()).getTopCategories(StoreRef.STORE_REF_WORKSPACE_SPACESSTORE, ContentModel.ASPECT_GEN_CLASSIFIABLE, Integer.MAX_VALUE);
        BDDMockito.then((Object)this.categoryServiceMock).shouldHaveNoMoreInteractions();
        ((AbstractObjectAssert)((ObjectAssert)Assertions.assertThat((Object)actualCategory).isNotNull()).extracting(Category::getCount).isNotNull()).isEqualTo((Object)1);
    }

    @Test
    public void testUpdateCategoryById_includePath() {
        String categoryNewName = "categoryNewName";
        Category fixedCategory = CategoriesImplTest.createCategoryOnlyWithName("categoryNewName");
        fixedCategory.setPath("/test/TestCat");
        QName categoryQName = CategoriesImplTest.createCmQNameOf(CATEGORY_NAME);
        NodeRef parentCategoryNodeRef = CategoriesImplTest.createNodeRefWithId(PARENT_ID);
        ChildAssociationRef parentAssociation = CategoriesImplTest.createAssociationOf(parentCategoryNodeRef, CATEGORY_NODE_REF, categoryQName);
        BDDMockito.given((Object)this.nodesMock.getNode((String)ArgumentMatchers.any())).willReturn((Object)CategoriesImplTest.createNode("categoryNewName"));
        BDDMockito.given((Object)this.nodeServiceMock.getPrimaryParent((NodeRef)ArgumentMatchers.any())).willReturn((Object)parentAssociation);
        BDDMockito.given((Object)this.nodeServiceMock.moveNode((NodeRef)ArgumentMatchers.any(), (NodeRef)ArgumentMatchers.any(), (QName)ArgumentMatchers.any(), (QName)ArgumentMatchers.any())).willReturn((Object)CategoriesImplTest.createAssociationOf(parentCategoryNodeRef, CATEGORY_NODE_REF, CategoriesImplTest.createCmQNameOf("categoryNewName")));
        BDDMockito.given((Object)this.parametersMock.getInclude()).willReturn(List.of("path"));
        BDDMockito.given((Object)this.nodeServiceMock.getPath((NodeRef)ArgumentMatchers.any())).willReturn((Object)this.mockCategoryPath());
        Category actualCategory = this.objectUnderTest.updateCategoryById(CATEGORY_ID, fixedCategory, this.parametersMock);
        ((AbstractObjectAssert)((ObjectAssert)Assertions.assertThat((Object)actualCategory).isNotNull()).extracting(Category::getPath).isNotNull()).isEqualTo((Object)MOCK_CATEGORY_PATH);
    }

    @Test
    public void testUpdateCategoryById_noPermission() {
        BDDMockito.given((Object)this.authorityServiceMock.hasAdminAuthority()).willReturn((Object)false);
        Assertions.assertThatExceptionOfType(PermissionDeniedException.class).isThrownBy(() -> this.objectUnderTest.updateCategoryById(CATEGORY_ID, CATEGORY, this.parametersMock));
        BDDMockito.then((Object)this.nodesMock).shouldHaveNoInteractions();
        BDDMockito.then((Object)this.nodeServiceMock).shouldHaveNoInteractions();
    }

    @Test
    public void testUpdateCategoryById_categoryNodeNotFound() {
        BDDMockito.given((Object)this.nodesMock.validateNode((String)ArgumentMatchers.any(String.class))).willThrow(EntityNotFoundException.class);
        Assertions.assertThatExceptionOfType(EntityNotFoundException.class).isThrownBy(() -> this.objectUnderTest.updateCategoryById(CATEGORY_ID, CATEGORY, this.parametersMock));
        BDDMockito.then((Object)this.nodeServiceMock).shouldHaveNoInteractions();
    }

    @Test
    public void testUpdateCategoryById_notACategory() {
        BDDMockito.given((Object)this.nodesMock.isSubClass((NodeRef)ArgumentMatchers.any(), (QName)ArgumentMatchers.any(), ArgumentMatchers.eq((boolean)false))).willReturn((Object)false);
        Assertions.assertThatExceptionOfType(InvalidArgumentException.class).isThrownBy(() -> this.objectUnderTest.updateCategoryById(CATEGORY_ID, CATEGORY, this.parametersMock)).withMessageContaining("Node id does not refer to a valid category");
        BDDMockito.then((Object)this.nodeServiceMock).shouldHaveNoInteractions();
    }

    @Test
    public void testUpdateCategoryById_isRootCategory() {
        BDDMockito.given((Object)this.categoryServiceMock.getRootCategoryNodeRef((StoreRef)ArgumentMatchers.any())).willReturn(Optional.of(CategoriesImplTest.createNodeRefWithId("-root-")));
        BDDMockito.given((Object)this.nodeServiceMock.getParentAssocs((NodeRef)ArgumentMatchers.any())).willReturn(List.of(this.categoryChildAssociationRefMock));
        BDDMockito.given((Object)this.categoryChildAssociationRefMock.getQName()).willReturn((Object)ContentModel.ASPECT_GEN_CLASSIFIABLE);
        Assertions.assertThatExceptionOfType(InvalidArgumentException.class).isThrownBy(() -> this.objectUnderTest.updateCategoryById("-root-", CATEGORY, this.parametersMock)).withMessageContaining("Node id does not refer to a valid category");
        ((CategoryService)BDDMockito.then((Object)this.categoryServiceMock).should()).getRootCategoryNodeRef(StoreRef.STORE_REF_WORKSPACE_SPACESSTORE);
        BDDMockito.then((Object)this.categoryServiceMock).shouldHaveNoMoreInteractions();
    }

    private List<String> getInvalidCategoryNames() {
        ArrayList<String> invalidNames = new ArrayList<String>();
        invalidNames.add(null);
        invalidNames.add("");
        return invalidNames;
    }

    @Test
    public void testUpdateCategoryById_emptyName() {
        for (String invalidName : this.getInvalidCategoryNames()) {
            Category categoryWithoutName = CategoriesImplTest.createCategoryOnlyWithName(invalidName);
            Assertions.assertThatExceptionOfType(InvalidArgumentException.class).isThrownBy(() -> this.objectUnderTest.updateCategoryById(CATEGORY_ID, categoryWithoutName, this.parametersMock)).withMessageContaining("Category name must not be null or empty");
        }
    }

    @Test
    public void testUpdateCategoryById_notMatchingIdField() {
        String categoryNewName = "categoryNewName";
        Category categoryWithInvalidId = CategoriesImplTest.createCategoryOnlyWithName("categoryNewName");
        categoryWithInvalidId.setId("different-category-node-id");
        QName categoryQName = CategoriesImplTest.createCmQNameOf(CATEGORY_NAME);
        NodeRef parentCategoryNodeRef = CategoriesImplTest.createNodeRefWithId(PARENT_ID);
        ChildAssociationRef parentAssociation = CategoriesImplTest.createAssociationOf(parentCategoryNodeRef, CATEGORY_NODE_REF, categoryQName);
        BDDMockito.given((Object)this.nodesMock.getNode((String)ArgumentMatchers.any())).willReturn((Object)CategoriesImplTest.createNode("categoryNewName"));
        BDDMockito.given((Object)this.nodeServiceMock.getPrimaryParent((NodeRef)ArgumentMatchers.any())).willReturn((Object)parentAssociation);
        BDDMockito.given((Object)this.nodeServiceMock.moveNode((NodeRef)ArgumentMatchers.any(), (NodeRef)ArgumentMatchers.any(), (QName)ArgumentMatchers.any(), (QName)ArgumentMatchers.any())).willReturn((Object)CategoriesImplTest.createAssociationOf(parentCategoryNodeRef, CATEGORY_NODE_REF, CategoriesImplTest.createCmQNameOf("categoryNewName")));
        Category actualCategory = this.objectUnderTest.updateCategoryById(CATEGORY_ID, categoryWithInvalidId, this.parametersMock);
        Category expectedCategory = CategoriesImplTest.createDefaultCategoryWithName("categoryNewName");
        ((ObjectAssert)Assertions.assertThat((Object)actualCategory).isNotNull()).usingRecursiveComparison().isEqualTo((Object)expectedCategory);
    }

    @Test
    public void testUpdateCategoryById_notMatchingParentIdField() {
        String categoryNewName = "categoryNewName";
        Category categoryWithInvalidParentId = CategoriesImplTest.createCategoryOnlyWithName("categoryNewName");
        categoryWithInvalidParentId.setParentId("different-parent-node-id");
        QName categoryQName = CategoriesImplTest.createCmQNameOf(CATEGORY_NAME);
        NodeRef parentCategoryNodeRef = CategoriesImplTest.createNodeRefWithId(PARENT_ID);
        ChildAssociationRef parentAssociation = CategoriesImplTest.createAssociationOf(parentCategoryNodeRef, CATEGORY_NODE_REF, categoryQName);
        BDDMockito.given((Object)this.nodesMock.getNode((String)ArgumentMatchers.any())).willReturn((Object)CategoriesImplTest.createNode("categoryNewName"));
        BDDMockito.given((Object)this.nodeServiceMock.getPrimaryParent((NodeRef)ArgumentMatchers.any())).willReturn((Object)parentAssociation);
        BDDMockito.given((Object)this.nodeServiceMock.moveNode((NodeRef)ArgumentMatchers.any(), (NodeRef)ArgumentMatchers.any(), (QName)ArgumentMatchers.any(), (QName)ArgumentMatchers.any())).willReturn((Object)CategoriesImplTest.createAssociationOf(parentCategoryNodeRef, CATEGORY_NODE_REF, CategoriesImplTest.createCmQNameOf("categoryNewName")));
        Category actualCategory = this.objectUnderTest.updateCategoryById(CATEGORY_ID, categoryWithInvalidParentId, this.parametersMock);
        Category expectedCategory = CategoriesImplTest.createDefaultCategoryWithName("categoryNewName");
        ((ObjectAssert)Assertions.assertThat((Object)actualCategory).isNotNull()).usingRecursiveComparison().isEqualTo((Object)expectedCategory);
    }

    @Test
    public void testUpdateCategoryById_notMatchingHasChildrenField() {
        String categoryNewName = "categoryNewName";
        Category categoryWithInvalidHasChildren = CategoriesImplTest.createCategoryOnlyWithName("categoryNewName");
        categoryWithInvalidHasChildren.setHasChildren(true);
        QName categoryQName = CategoriesImplTest.createCmQNameOf(CATEGORY_NAME);
        NodeRef parentCategoryNodeRef = CategoriesImplTest.createNodeRefWithId(PARENT_ID);
        ChildAssociationRef parentAssociation = CategoriesImplTest.createAssociationOf(parentCategoryNodeRef, CATEGORY_NODE_REF, categoryQName);
        BDDMockito.given((Object)this.nodesMock.getNode((String)ArgumentMatchers.any())).willReturn((Object)CategoriesImplTest.createNode("categoryNewName"));
        BDDMockito.given((Object)this.nodeServiceMock.getPrimaryParent((NodeRef)ArgumentMatchers.any())).willReturn((Object)parentAssociation);
        BDDMockito.given((Object)this.nodeServiceMock.moveNode((NodeRef)ArgumentMatchers.any(), (NodeRef)ArgumentMatchers.any(), (QName)ArgumentMatchers.any(), (QName)ArgumentMatchers.any())).willReturn((Object)CategoriesImplTest.createAssociationOf(parentCategoryNodeRef, CATEGORY_NODE_REF, CategoriesImplTest.createCmQNameOf("categoryNewName")));
        Category actualCategory = this.objectUnderTest.updateCategoryById(CATEGORY_ID, categoryWithInvalidHasChildren, this.parametersMock);
        Category expectedCategory = CategoriesImplTest.createDefaultCategoryWithName("categoryNewName");
        ((ObjectAssert)Assertions.assertThat((Object)actualCategory).isNotNull()).usingRecursiveComparison().isEqualTo((Object)expectedCategory);
    }

    @Test
    public void testLinkNodeToCategories_withoutCategoryAspect() {
        List<Category> categoryLinks = List.of(CATEGORY);
        NodeRef categoryParentNodeRef = CategoriesImplTest.createNodeRefWithId(PARENT_ID);
        ChildAssociationRef parentAssociation = CategoriesImplTest.createAssociationOf(categoryParentNodeRef, CATEGORY_NODE_REF);
        BDDMockito.given((Object)this.nodesMock.getNode((String)ArgumentMatchers.any())).willReturn((Object)CategoriesImplTest.createNode());
        BDDMockito.given((Object)this.nodeServiceMock.getPrimaryParent((NodeRef)ArgumentMatchers.any())).willReturn((Object)parentAssociation);
        List actualLinkedCategories = this.objectUnderTest.linkNodeToCategories(CONTENT_NODE_ID, categoryLinks, this.parametersMock);
        ((Nodes)BDDMockito.then((Object)this.nodesMock).should()).validateOrLookupNode(CONTENT_NODE_ID);
        ((PermissionService)BDDMockito.then((Object)this.permissionServiceMock).should()).hasPermission(CONTENT_NODE_REF, "ChangePermissions");
        BDDMockito.then((Object)this.permissionServiceMock).shouldHaveNoMoreInteractions();
        ((TypeConstraint)BDDMockito.then((Object)this.typeConstraint).should()).matches(CONTENT_NODE_REF);
        BDDMockito.then((Object)this.typeConstraint).shouldHaveNoMoreInteractions();
        ((Nodes)BDDMockito.then((Object)this.nodesMock).should()).validateNode(CATEGORY_ID);
        ((Nodes)BDDMockito.then((Object)this.nodesMock).should()).getNode(CATEGORY_ID);
        ((Nodes)BDDMockito.then((Object)this.nodesMock).should()).isSubClass(CATEGORY_NODE_REF, ContentModel.TYPE_CATEGORY, false);
        BDDMockito.then((Object)this.nodesMock).shouldHaveNoMoreInteractions();
        ((NodeService)BDDMockito.then((Object)this.nodeServiceMock).should()).getChildAssocs(CATEGORY_NODE_REF, RegexQNamePattern.MATCH_ALL, RegexQNamePattern.MATCH_ALL, false);
        ((NodeService)BDDMockito.then((Object)this.nodeServiceMock).should()).getPrimaryParent(CATEGORY_NODE_REF);
        ((NodeService)BDDMockito.then((Object)this.nodeServiceMock).should()).getParentAssocs(CATEGORY_NODE_REF);
        ((NodeService)BDDMockito.then((Object)this.nodeServiceMock).should()).hasAspect(CONTENT_NODE_REF, ContentModel.ASPECT_GEN_CLASSIFIABLE);
        Map<QName, Serializable> expectedProperties = Map.of(ContentModel.PROP_CATEGORIES, (Serializable)((Object)List.of(CATEGORY_NODE_REF)));
        ((NodeService)BDDMockito.then((Object)this.nodeServiceMock).should()).addAspect(CONTENT_NODE_REF, ContentModel.ASPECT_GEN_CLASSIFIABLE, expectedProperties);
        ((NodeService)BDDMockito.then((Object)this.nodeServiceMock).should()).getParentAssocs(categoryParentNodeRef);
        BDDMockito.then((Object)this.nodeServiceMock).shouldHaveNoMoreInteractions();
        List<Category> expectedLinkedCategories = List.of(CATEGORY);
        expectedLinkedCategories.get(0).setPath(null);
        ((ListAssert)Assertions.assertThat((List)actualLinkedCategories).isNotNull()).usingRecursiveComparison().isEqualTo(expectedLinkedCategories);
    }

    @Test
    public void testLinkNodeToCategories_withPresentCategoryAspect() {
        NodeRef categoryParentNodeRef = CategoriesImplTest.createNodeRefWithId(PARENT_ID);
        ChildAssociationRef parentAssociation = CategoriesImplTest.createAssociationOf(categoryParentNodeRef, CATEGORY_NODE_REF);
        BDDMockito.given((Object)this.nodesMock.getNode((String)ArgumentMatchers.any())).willReturn((Object)CategoriesImplTest.createNode());
        BDDMockito.given((Object)this.nodeServiceMock.getPrimaryParent((NodeRef)ArgumentMatchers.any())).willReturn((Object)parentAssociation);
        BDDMockito.given((Object)this.nodeServiceMock.hasAspect((NodeRef)ArgumentMatchers.any(), (QName)ArgumentMatchers.any())).willReturn((Object)true);
        List actualLinkedCategories = this.objectUnderTest.linkNodeToCategories(CONTENT_NODE_ID, List.of(CATEGORY), this.parametersMock);
        ((Nodes)BDDMockito.then((Object)this.nodesMock).should()).getNode(CATEGORY_ID);
        ((NodeService)BDDMockito.then((Object)this.nodeServiceMock).should()).getChildAssocs(CATEGORY_NODE_REF, RegexQNamePattern.MATCH_ALL, RegexQNamePattern.MATCH_ALL, false);
        ((NodeService)BDDMockito.then((Object)this.nodeServiceMock).should()).getPrimaryParent(CATEGORY_NODE_REF);
        ((NodeService)BDDMockito.then((Object)this.nodeServiceMock).should()).getParentAssocs(CATEGORY_NODE_REF);
        ((NodeService)BDDMockito.then((Object)this.nodeServiceMock).should()).hasAspect(CONTENT_NODE_REF, ContentModel.ASPECT_GEN_CLASSIFIABLE);
        ((NodeService)BDDMockito.then((Object)this.nodeServiceMock).should()).getProperty(CONTENT_NODE_REF, ContentModel.PROP_CATEGORIES);
        Serializable expectedCategories = (Serializable)((Object)List.of(CATEGORY_NODE_REF));
        ((NodeService)BDDMockito.then((Object)this.nodeServiceMock).should()).setProperty(CONTENT_NODE_REF, ContentModel.PROP_CATEGORIES, expectedCategories);
        ((NodeService)BDDMockito.then((Object)this.nodeServiceMock).should()).getParentAssocs(categoryParentNodeRef);
        BDDMockito.then((Object)this.nodeServiceMock).shouldHaveNoMoreInteractions();
        List<Category> expectedLinkedCategories = List.of(CATEGORY);
        ((ListAssert)Assertions.assertThat((List)actualLinkedCategories).isNotNull()).usingRecursiveComparison().isEqualTo(expectedLinkedCategories);
    }

    @Test
    public void testLinkNodeToCategories_withMultipleCategoryIds() {
        String secondCategoryId = "second-category-id";
        String secondCategoryName = "secondCategoryName";
        NodeRef secondCategoryNodeRef = CategoriesImplTest.createNodeRefWithId("second-category-id");
        Category secondCategoryLink = Category.builder().id("second-category-id").create();
        List<Category> categoryLinks = List.of(CATEGORY, secondCategoryLink);
        NodeRef categoryParentNodeRef = CategoriesImplTest.createNodeRefWithId(PARENT_ID);
        ChildAssociationRef categoryParentAssociation = CategoriesImplTest.createAssociationOf(categoryParentNodeRef, CATEGORY_NODE_REF);
        ChildAssociationRef secondCategoryParentAssociation = CategoriesImplTest.createAssociationOf(categoryParentNodeRef, secondCategoryNodeRef);
        BDDMockito.given((Object)this.nodesMock.validateNode("second-category-id")).willReturn((Object)secondCategoryNodeRef);
        BDDMockito.given((Object)this.nodesMock.getNode((String)ArgumentMatchers.any())).willReturn((Object)CategoriesImplTest.createNode(), (Object[])new Node[]{CategoriesImplTest.createNode("secondCategoryName")});
        BDDMockito.given((Object)this.nodeServiceMock.getPrimaryParent((NodeRef)ArgumentMatchers.any())).willReturn((Object)categoryParentAssociation, (Object[])new ChildAssociationRef[]{secondCategoryParentAssociation});
        List actualLinkedCategories = this.objectUnderTest.linkNodeToCategories(CONTENT_NODE_ID, categoryLinks, this.parametersMock);
        ((Nodes)BDDMockito.then((Object)this.nodesMock).should()).validateNode(CATEGORY_ID);
        ((Nodes)BDDMockito.then((Object)this.nodesMock).should()).validateNode("second-category-id");
        ((Nodes)BDDMockito.then((Object)this.nodesMock).should()).isSubClass(CATEGORY_NODE_REF, ContentModel.TYPE_CATEGORY, false);
        ((Nodes)BDDMockito.then((Object)this.nodesMock).should()).isSubClass(secondCategoryNodeRef, ContentModel.TYPE_CATEGORY, false);
        Map<QName, Serializable> expectedProperties = Map.of(ContentModel.PROP_CATEGORIES, (Serializable)((Object)List.of(CATEGORY_NODE_REF, secondCategoryNodeRef)));
        ((NodeService)BDDMockito.then((Object)this.nodeServiceMock).should()).addAspect(CONTENT_NODE_REF, ContentModel.ASPECT_GEN_CLASSIFIABLE, expectedProperties);
        List<Category> expectedLinkedCategories = List.of(CATEGORY, Category.builder().id("second-category-id").name("secondCategoryName").parentId(PARENT_ID).create());
        ((ListAssert)Assertions.assertThat((List)actualLinkedCategories).isNotNull()).usingRecursiveComparison().isEqualTo(expectedLinkedCategories);
    }

    @Test
    public void testLinkNodeToCategories_includePath() {
        NodeRef categoryParentNodeRef = CategoriesImplTest.createNodeRefWithId(PARENT_ID);
        ChildAssociationRef parentAssociation = CategoriesImplTest.createAssociationOf(categoryParentNodeRef, CATEGORY_NODE_REF);
        BDDMockito.given((Object)this.nodesMock.getNode((String)ArgumentMatchers.any())).willReturn((Object)CategoriesImplTest.createNode());
        BDDMockito.given((Object)this.nodeServiceMock.getPrimaryParent((NodeRef)ArgumentMatchers.any())).willReturn((Object)parentAssociation);
        BDDMockito.given((Object)this.nodeServiceMock.hasAspect((NodeRef)ArgumentMatchers.any(), (QName)ArgumentMatchers.any())).willReturn((Object)true);
        BDDMockito.given((Object)this.parametersMock.getInclude()).willReturn(List.of("path"));
        BDDMockito.given((Object)this.nodeServiceMock.getPath((NodeRef)ArgumentMatchers.any())).willReturn((Object)this.mockCategoryPath());
        List actualLinkedCategories = this.objectUnderTest.linkNodeToCategories(CONTENT_NODE_ID, List.of(CATEGORY), this.parametersMock);
        ((Nodes)BDDMockito.then((Object)this.nodesMock).should(Mockito.times((int)2))).getNode(CATEGORY_ID);
        ((NodeService)BDDMockito.then((Object)this.nodeServiceMock).should()).getChildAssocs(CATEGORY_NODE_REF, RegexQNamePattern.MATCH_ALL, RegexQNamePattern.MATCH_ALL, false);
        ((NodeService)BDDMockito.then((Object)this.nodeServiceMock).should()).getPrimaryParent(CATEGORY_NODE_REF);
        ((NodeService)BDDMockito.then((Object)this.nodeServiceMock).should()).getParentAssocs(CATEGORY_NODE_REF);
        ((NodeService)BDDMockito.then((Object)this.nodeServiceMock).should()).hasAspect(CONTENT_NODE_REF, ContentModel.ASPECT_GEN_CLASSIFIABLE);
        ((NodeService)BDDMockito.then((Object)this.nodeServiceMock).should()).getProperty(CONTENT_NODE_REF, ContentModel.PROP_CATEGORIES);
        Serializable expectedCategories = (Serializable)((Object)List.of(CATEGORY_NODE_REF));
        ((NodeService)BDDMockito.then((Object)this.nodeServiceMock).should()).setProperty(CONTENT_NODE_REF, ContentModel.PROP_CATEGORIES, expectedCategories);
        ((NodeService)BDDMockito.then((Object)this.nodeServiceMock).should()).getParentAssocs(categoryParentNodeRef);
        List<Category> expectedLinkedCategories = List.of(CATEGORY);
        expectedLinkedCategories.get(0).setPath(MOCK_CATEGORY_PATH);
        ((ListAssert)Assertions.assertThat((List)actualLinkedCategories).isNotNull()).usingRecursiveComparison().isEqualTo(expectedLinkedCategories);
    }

    @Test
    public void testLinkNodeToCategories_withPreviouslyLinkedCategories() {
        String otherCategoryId = "other-category-id";
        NodeRef otherCategoryNodeRef = CategoriesImplTest.createNodeRefWithId("other-category-id");
        Serializable previousCategories = (Serializable)((Object)List.of(otherCategoryNodeRef));
        NodeRef categoryParentNodeRef = CategoriesImplTest.createNodeRefWithId(PARENT_ID);
        ChildAssociationRef parentAssociation = CategoriesImplTest.createAssociationOf(categoryParentNodeRef, CATEGORY_NODE_REF);
        BDDMockito.given((Object)this.nodesMock.getNode((String)ArgumentMatchers.any())).willReturn((Object)CategoriesImplTest.createNode());
        BDDMockito.given((Object)this.nodeServiceMock.getPrimaryParent((NodeRef)ArgumentMatchers.any())).willReturn((Object)parentAssociation);
        BDDMockito.given((Object)this.nodeServiceMock.hasAspect((NodeRef)ArgumentMatchers.any(), (QName)ArgumentMatchers.any())).willReturn((Object)true);
        BDDMockito.given((Object)this.nodeServiceMock.getProperty((NodeRef)ArgumentMatchers.any(), (QName)ArgumentMatchers.eq((Object)ContentModel.PROP_CATEGORIES))).willReturn((Object)previousCategories);
        List actualLinkedCategories = this.objectUnderTest.linkNodeToCategories(CONTENT_NODE_ID, List.of(CATEGORY), this.parametersMock);
        Serializable expectedCategories = (Serializable)((Object)Set.of(otherCategoryNodeRef, CATEGORY_NODE_REF));
        ((NodeService)BDDMockito.then((Object)this.nodeServiceMock).should()).setProperty(CONTENT_NODE_REF, ContentModel.PROP_CATEGORIES, expectedCategories);
        List<Category> expectedLinkedCategories = List.of(CATEGORY);
        ((ListAssert)Assertions.assertThat((List)actualLinkedCategories).isNotNull()).usingRecursiveComparison().isEqualTo(expectedLinkedCategories);
    }

    @Test
    public void testLinkNodeToCategories_withInvalidNodeId() {
        BDDMockito.given((Object)this.nodesMock.validateOrLookupNode(CONTENT_NODE_ID)).willThrow(EntityNotFoundException.class);
        Throwable actualException = Assertions.catchThrowable(() -> this.objectUnderTest.linkNodeToCategories(CONTENT_NODE_ID, List.of(CATEGORY), this.parametersMock));
        ((Nodes)BDDMockito.then((Object)this.nodesMock).should()).validateOrLookupNode(CONTENT_NODE_ID);
        BDDMockito.then((Object)this.permissionServiceMock).shouldHaveNoInteractions();
        BDDMockito.then((Object)this.nodeServiceMock).shouldHaveNoInteractions();
        Assertions.assertThat((Throwable)actualException).isInstanceOf(EntityNotFoundException.class);
    }

    @Test
    public void testLinkNodeToCategories_withoutPermission() {
        BDDMockito.given((Object)this.permissionServiceMock.hasPermission((NodeRef)ArgumentMatchers.any(), (String)ArgumentMatchers.any())).willReturn((Object)AccessStatus.DENIED);
        Throwable actualException = Assertions.catchThrowable(() -> this.objectUnderTest.linkNodeToCategories(CONTENT_NODE_ID, List.of(CATEGORY), this.parametersMock));
        ((Nodes)BDDMockito.then((Object)this.nodesMock).should()).validateOrLookupNode(CONTENT_NODE_ID);
        ((PermissionService)BDDMockito.then((Object)this.permissionServiceMock).should()).hasPermission(CONTENT_NODE_REF, "ChangePermissions");
        BDDMockito.then((Object)this.nodeServiceMock).shouldHaveNoInteractions();
        ((AbstractThrowableAssert)Assertions.assertThat((Throwable)actualException).isInstanceOf(PermissionDeniedException.class)).hasMessageContaining("Current user does not have change permission to content");
    }

    @Test
    public void testLinkContentNodeToCategories_withInvalidNodeType() {
        BDDMockito.given((Object)this.typeConstraint.matches((NodeRef)ArgumentMatchers.any())).willReturn((Object)false);
        Throwable actualException = Assertions.catchThrowable(() -> this.objectUnderTest.linkNodeToCategories(CONTENT_NODE_ID, List.of(CATEGORY), this.parametersMock));
        ((TypeConstraint)BDDMockito.then((Object)this.typeConstraint).should()).matches(CONTENT_NODE_REF);
        BDDMockito.then((Object)this.nodeServiceMock).shouldHaveNoInteractions();
        ((AbstractThrowableAssert)Assertions.assertThat((Throwable)actualException).isInstanceOf(InvalidNodeTypeException.class)).hasMessageContaining("Cannot categorize this type of node");
    }

    @Test
    public void testLinkNodeToCategories_withEmptyLinks() {
        List categoryLinks = Collections.emptyList();
        Throwable actualException = Assertions.catchThrowable(() -> this.objectUnderTest.linkNodeToCategories(CONTENT_NODE_ID, categoryLinks, this.parametersMock));
        BDDMockito.then((Object)this.nodesMock).shouldHaveNoInteractions();
        BDDMockito.then((Object)this.permissionServiceMock).shouldHaveNoInteractions();
        BDDMockito.then((Object)this.nodeServiceMock).shouldHaveNoInteractions();
        ((AbstractThrowableAssert)Assertions.assertThat((Throwable)actualException).isInstanceOf(InvalidArgumentException.class)).hasMessageContaining("Node id does not refer to a valid category");
    }

    @Test
    public void testLinkNodeToCategories_withInvalidCategoryIds() {
        Category categoryLinkWithNullId = Category.builder().id(null).create();
        Category categoryLinkWithEmptyId = Category.builder().id("").create();
        ArrayList<Category> categoryLinks = new ArrayList<Category>();
        categoryLinks.add(categoryLinkWithNullId);
        categoryLinks.add(null);
        categoryLinks.add(categoryLinkWithEmptyId);
        Throwable actualException = Assertions.catchThrowable(() -> this.objectUnderTest.linkNodeToCategories(CONTENT_NODE_ID, categoryLinks, this.parametersMock));
        BDDMockito.then((Object)this.nodeServiceMock).shouldHaveNoInteractions();
        ((AbstractThrowableAssert)Assertions.assertThat((Throwable)actualException).isInstanceOf(InvalidArgumentException.class)).hasMessageContaining("Node id does not refer to a valid category");
    }

    @Test
    public void testLinkNodeToCategories_withTwoIdenticalCategories() {
        List<Category> categoryLinks = List.of(CATEGORY, CATEGORY);
        NodeRef categoryParentNodeRef = CategoriesImplTest.createNodeRefWithId(PARENT_ID);
        ChildAssociationRef parentAssociation = CategoriesImplTest.createAssociationOf(categoryParentNodeRef, CATEGORY_NODE_REF);
        BDDMockito.given((Object)this.nodesMock.getNode((String)ArgumentMatchers.any())).willReturn((Object)CategoriesImplTest.createNode());
        BDDMockito.given((Object)this.nodeServiceMock.getPrimaryParent((NodeRef)ArgumentMatchers.any())).willReturn((Object)parentAssociation);
        List actualLinkedCategories = this.objectUnderTest.linkNodeToCategories(CONTENT_NODE_ID, categoryLinks, this.parametersMock);
        Map<QName, Serializable> expectedProperties = Map.of(ContentModel.PROP_CATEGORIES, (Serializable)((Object)List.of(CATEGORY_NODE_REF)));
        ((NodeService)BDDMockito.then((Object)this.nodeServiceMock).should()).addAspect(CONTENT_NODE_REF, ContentModel.ASPECT_GEN_CLASSIFIABLE, expectedProperties);
        List<Category> expectedLinkedCategories = List.of(CATEGORY);
        ((ListAssert)Assertions.assertThat((List)actualLinkedCategories).isNotNull()).usingRecursiveComparison().isEqualTo(expectedLinkedCategories);
    }

    @Test
    public void testUnlinkNodeFromCategory() {
        BDDMockito.given((Object)this.nodeServiceMock.hasAspect(CONTENT_NODE_REF, ContentModel.ASPECT_GEN_CLASSIFIABLE)).willReturn((Object)true);
        this.objectUnderTest.unlinkNodeFromCategory(CONTENT_NODE_ID, CATEGORY_ID, this.parametersMock);
        ((Nodes)BDDMockito.then((Object)this.nodesMock).should()).validateNode(CATEGORY_ID);
        ((Nodes)BDDMockito.then((Object)this.nodesMock).should()).validateOrLookupNode(CONTENT_NODE_ID);
        ((PermissionService)BDDMockito.then((Object)this.permissionServiceMock).should()).hasPermission(CONTENT_NODE_REF, "ChangePermissions");
        BDDMockito.then((Object)this.permissionServiceMock).shouldHaveNoMoreInteractions();
        ((TypeConstraint)BDDMockito.then((Object)this.typeConstraint).should()).matches(CONTENT_NODE_REF);
        BDDMockito.then((Object)this.typeConstraint).shouldHaveNoMoreInteractions();
        ((NodeService)BDDMockito.then((Object)this.nodeServiceMock).should()).hasAspect(CONTENT_NODE_REF, ContentModel.ASPECT_GEN_CLASSIFIABLE);
        ((NodeService)BDDMockito.then((Object)this.nodeServiceMock).should()).getProperty(CONTENT_NODE_REF, ContentModel.PROP_CATEGORIES);
        ((NodeService)BDDMockito.then((Object)this.nodeServiceMock).should()).setProperty((NodeRef)ArgumentMatchers.eq((Object)CONTENT_NODE_REF), (QName)ArgumentMatchers.eq((Object)ContentModel.PROP_CATEGORIES), (Serializable)ArgumentMatchers.any());
    }

    @Test
    public void testUnlinkNodeFromCategory_missingCategoryAspect() {
        BDDMockito.given((Object)this.nodeServiceMock.hasAspect(CONTENT_NODE_REF, ContentModel.ASPECT_GEN_CLASSIFIABLE)).willReturn((Object)false);
        Throwable actualException = Assertions.catchThrowable(() -> this.objectUnderTest.unlinkNodeFromCategory(CONTENT_NODE_ID, CATEGORY_ID, this.parametersMock));
        ((NodeService)BDDMockito.then((Object)this.nodeServiceMock).should()).hasAspect(CONTENT_NODE_REF, ContentModel.ASPECT_GEN_CLASSIFIABLE);
        BDDMockito.then((Object)this.nodeServiceMock).shouldHaveNoMoreInteractions();
        ((AbstractThrowableAssert)Assertions.assertThat((Throwable)actualException).isInstanceOf(InvalidArgumentException.class)).hasMessageContaining("does not belong to a category");
    }

    @Test
    public void testListCategoriesForNode() {
        NodeRef categoryParentNodeRef = CategoriesImplTest.createNodeRefWithId(PARENT_ID);
        ChildAssociationRef parentAssociation = CategoriesImplTest.createAssociationOf(categoryParentNodeRef, CATEGORY_NODE_REF);
        BDDMockito.given((Object)this.nodeServiceMock.getProperty((NodeRef)ArgumentMatchers.any(), (QName)ArgumentMatchers.eq((Object)ContentModel.PROP_CATEGORIES))).willReturn((Object)((Serializable)((Object)List.of(CATEGORY_NODE_REF))));
        BDDMockito.given((Object)this.nodesMock.getNode((String)ArgumentMatchers.any())).willReturn((Object)CategoriesImplTest.createNode());
        BDDMockito.given((Object)this.nodeServiceMock.getPrimaryParent((NodeRef)ArgumentMatchers.any())).willReturn((Object)parentAssociation);
        List actualCategories = this.objectUnderTest.listCategoriesForNode(CONTENT_NODE_ID, this.parametersMock);
        ((Nodes)BDDMockito.then((Object)this.nodesMock).should()).validateOrLookupNode(CONTENT_NODE_ID);
        ((PermissionService)BDDMockito.then((Object)this.permissionServiceMock).should()).hasReadPermission(CONTENT_NODE_REF);
        BDDMockito.then((Object)this.permissionServiceMock).shouldHaveNoMoreInteractions();
        ((TypeConstraint)BDDMockito.then((Object)this.typeConstraint).should()).matches(CONTENT_NODE_REF);
        BDDMockito.then((Object)this.typeConstraint).shouldHaveNoMoreInteractions();
        ((Nodes)BDDMockito.then((Object)this.nodesMock).should()).getNode(CATEGORY_ID);
        BDDMockito.then((Object)this.nodesMock).shouldHaveNoMoreInteractions();
        ((NodeService)BDDMockito.then((Object)this.nodeServiceMock).should()).getProperty(CONTENT_NODE_REF, ContentModel.PROP_CATEGORIES);
        ((NodeService)BDDMockito.then((Object)this.nodeServiceMock).should()).getChildAssocs(CATEGORY_NODE_REF, RegexQNamePattern.MATCH_ALL, RegexQNamePattern.MATCH_ALL, false);
        ((NodeService)BDDMockito.then((Object)this.nodeServiceMock).should()).getPrimaryParent(CATEGORY_NODE_REF);
        ((NodeService)BDDMockito.then((Object)this.nodeServiceMock).should()).getParentAssocs(categoryParentNodeRef);
        BDDMockito.then((Object)this.nodeServiceMock).shouldHaveNoMoreInteractions();
        List<Category> expectedCategories = List.of(CATEGORY);
        expectedCategories.get(0).setPath(null);
        ((ListAssert)Assertions.assertThat((List)actualCategories).isNotNull()).usingRecursiveComparison().isEqualTo(expectedCategories);
    }

    @Test
    public void testListCategoriesForNode_includePath() {
        NodeRef categoryParentNodeRef = CategoriesImplTest.createNodeRefWithId(PARENT_ID);
        ChildAssociationRef parentAssociation = CategoriesImplTest.createAssociationOf(categoryParentNodeRef, CATEGORY_NODE_REF);
        BDDMockito.given((Object)this.nodeServiceMock.getProperty((NodeRef)ArgumentMatchers.any(), (QName)ArgumentMatchers.eq((Object)ContentModel.PROP_CATEGORIES))).willReturn((Object)((Serializable)((Object)List.of(CATEGORY_NODE_REF))));
        BDDMockito.given((Object)this.nodesMock.getNode((String)ArgumentMatchers.any())).willReturn((Object)CategoriesImplTest.createNode());
        BDDMockito.given((Object)this.nodeServiceMock.getPrimaryParent((NodeRef)ArgumentMatchers.any())).willReturn((Object)parentAssociation);
        BDDMockito.given((Object)this.parametersMock.getInclude()).willReturn(List.of("path"));
        BDDMockito.given((Object)this.nodeServiceMock.getPath((NodeRef)ArgumentMatchers.any())).willReturn((Object)this.mockCategoryPath());
        List actualCategories = this.objectUnderTest.listCategoriesForNode(CONTENT_NODE_ID, this.parametersMock);
        ((Nodes)BDDMockito.then((Object)this.nodesMock).should()).validateOrLookupNode(CONTENT_NODE_ID);
        ((PermissionService)BDDMockito.then((Object)this.permissionServiceMock).should()).hasReadPermission(CONTENT_NODE_REF);
        BDDMockito.then((Object)this.permissionServiceMock).shouldHaveNoMoreInteractions();
        ((TypeConstraint)BDDMockito.then((Object)this.typeConstraint).should()).matches(CONTENT_NODE_REF);
        BDDMockito.then((Object)this.typeConstraint).shouldHaveNoMoreInteractions();
        ((Nodes)BDDMockito.then((Object)this.nodesMock).should(Mockito.times((int)2))).getNode(CATEGORY_ID);
        BDDMockito.then((Object)this.nodesMock).shouldHaveNoMoreInteractions();
        ((NodeService)BDDMockito.then((Object)this.nodeServiceMock).should()).getProperty(CONTENT_NODE_REF, ContentModel.PROP_CATEGORIES);
        ((NodeService)BDDMockito.then((Object)this.nodeServiceMock).should()).getChildAssocs(CATEGORY_NODE_REF, RegexQNamePattern.MATCH_ALL, RegexQNamePattern.MATCH_ALL, false);
        ((NodeService)BDDMockito.then((Object)this.nodeServiceMock).should()).getPrimaryParent(CATEGORY_NODE_REF);
        ((NodeService)BDDMockito.then((Object)this.nodeServiceMock).should()).getParentAssocs(categoryParentNodeRef);
        ((NodeService)BDDMockito.then((Object)this.nodeServiceMock).should()).getPath((NodeRef)ArgumentMatchers.any());
        BDDMockito.then((Object)this.nodeServiceMock).shouldHaveNoMoreInteractions();
        List<Category> expectedCategories = List.of(CATEGORY);
        expectedCategories.get(0).setPath(MOCK_CATEGORY_PATH);
        ((ListAssert)Assertions.assertThat((List)actualCategories).isNotNull()).usingRecursiveComparison().isEqualTo(expectedCategories);
    }

    @Test
    public void testListCategoriesForNode_withInvalidNodeId() {
        BDDMockito.given((Object)this.nodesMock.validateOrLookupNode(CONTENT_NODE_ID)).willThrow(EntityNotFoundException.class);
        Throwable actualException = Assertions.catchThrowable(() -> this.objectUnderTest.listCategoriesForNode(CONTENT_NODE_ID, this.parametersMock));
        ((Nodes)BDDMockito.then((Object)this.nodesMock).should()).validateOrLookupNode(CONTENT_NODE_ID);
        BDDMockito.then((Object)this.nodeServiceMock).shouldHaveNoInteractions();
        Assertions.assertThat((Throwable)actualException).isInstanceOf(EntityNotFoundException.class);
    }

    @Test
    public void testListCategoriesForNode_withoutPermission() {
        BDDMockito.given((Object)this.permissionServiceMock.hasReadPermission((NodeRef)ArgumentMatchers.any())).willReturn((Object)AccessStatus.DENIED);
        Throwable actualException = Assertions.catchThrowable(() -> this.objectUnderTest.listCategoriesForNode(CONTENT_NODE_ID, this.parametersMock));
        ((Nodes)BDDMockito.then((Object)this.nodesMock).should()).validateOrLookupNode(CONTENT_NODE_ID);
        ((PermissionService)BDDMockito.then((Object)this.permissionServiceMock).should()).hasReadPermission(CONTENT_NODE_REF);
        BDDMockito.then((Object)this.nodeServiceMock).shouldHaveNoInteractions();
        ((AbstractThrowableAssert)Assertions.assertThat((Throwable)actualException).isInstanceOf(PermissionDeniedException.class)).hasMessageContaining("Current user does not have read permission to content");
    }

    @Test
    public void testListCategoriesForNode_withInvalidNodeType() {
        BDDMockito.given((Object)this.typeConstraint.matches((NodeRef)ArgumentMatchers.any())).willReturn((Object)false);
        Throwable actualException = Assertions.catchThrowable(() -> this.objectUnderTest.listCategoriesForNode(CONTENT_NODE_ID, this.parametersMock));
        ((TypeConstraint)BDDMockito.then((Object)this.typeConstraint).should()).matches(CONTENT_NODE_REF);
        BDDMockito.then((Object)this.nodeServiceMock).shouldHaveNoInteractions();
        ((AbstractThrowableAssert)Assertions.assertThat((Throwable)actualException).isInstanceOf(InvalidNodeTypeException.class)).hasMessageContaining("Cannot categorize this type of node");
    }

    @Test
    public void testListCategoriesForNode_withoutLinkedCategories() {
        Stream.of(null, Collections.emptyList()).forEach(nullOrEmptyList -> {
            BDDMockito.given((Object)this.nodeServiceMock.getProperty((NodeRef)ArgumentMatchers.any(), (QName)ArgumentMatchers.eq((Object)ContentModel.PROP_CATEGORIES))).willReturn((Object)((Serializable)((Object)nullOrEmptyList)));
            List actualCategories = this.objectUnderTest.listCategoriesForNode(CONTENT_NODE_ID, this.parametersMock);
            ((ListAssert)Assertions.assertThat((List)actualCategories).isNotNull()).isEmpty();
        });
    }

    private List<ChildAssociationRef> prepareChildAssocMocks(int count, NodeRef parentCategoryNodeRef) {
        return IntStream.range(0, count).mapToObj(i -> {
            ChildAssociationRef dummyChildAssocMock = (ChildAssociationRef)Mockito.mock(ChildAssociationRef.class);
            BDDMockito.given((Object)dummyChildAssocMock.getTypeQName()).willReturn((Object)ContentModel.ASSOC_SUBCATEGORIES);
            BDDMockito.given((Object)dummyChildAssocMock.getChildRef()).willReturn((Object)CategoriesImplTest.createNodeRefWithId("category-node-id-" + i));
            BDDMockito.given((Object)dummyChildAssocMock.getParentRef()).willReturn((Object)parentCategoryNodeRef);
            return dummyChildAssocMock;
        }).collect(Collectors.toList());
    }

    private void prepareCategoryNodeMocks(ChildAssociationRef childAssociationRef) {
        NodeRef childRef = childAssociationRef.getChildRef();
        String id = childRef.getId();
        String name = id.replace(CATEGORY_ID, CATEGORY_NAME);
        NodeRef parentRef = childAssociationRef.getParentRef();
        BDDMockito.given((Object)this.nodesMock.getNode(id)).willReturn((Object)CategoriesImplTest.createNode(name, id, parentRef));
        ChildAssociationRef parentAssoc = CategoriesImplTest.createAssociationOf(parentRef, childRef);
        BDDMockito.given((Object)this.nodeServiceMock.getPrimaryParent(childRef)).willReturn((Object)parentAssoc);
        BDDMockito.given((Object)this.nodeServiceMock.getParentAssocs(parentRef)).willReturn(List.of(parentAssoc));
    }

    private void doCategoryAssertions(Category category, int index, String parentId) {
        Category expectedCategory = Category.builder().id("category-node-id-" + index).name("categoryName-" + index).parentId(parentId).hasChildren(false).create();
        Assert.assertEquals((Object)expectedCategory, (Object)category);
    }

    private List<Category> prepareCategories() {
        return List.of(CategoriesImplTest.createCategoryOnlyWithName(CATEGORY_NAME));
    }

    private static Node createNode(String name, String id, NodeRef parentNodeRef) {
        Node categoryNode = new Node();
        categoryNode.setName(name);
        categoryNode.setNodeId(id);
        categoryNode.setParentId(parentNodeRef);
        return categoryNode;
    }

    private static Node createNode(String name) {
        return CategoriesImplTest.createNode(name, CATEGORY_ID, CategoriesImplTest.createNodeRefWithId(PARENT_ID));
    }

    private static Node createNode() {
        return CategoriesImplTest.createNode(CATEGORY_NAME);
    }

    private static NodeRef createNodeRefWithId(String id) {
        return new NodeRef(StoreRef.STORE_REF_WORKSPACE_SPACESSTORE, id);
    }

    private static Category createCategoryOnlyWithName(String name) {
        return Category.builder().name(name).create();
    }

    private static Category createDefaultCategory() {
        return CategoriesImplTest.createDefaultCategoryWithName(CATEGORY_NAME);
    }

    private static Category createDefaultCategoryWithName(String name) {
        return Category.builder().id(CATEGORY_ID).name(name).parentId(PARENT_ID).hasChildren(false).create();
    }

    private static QName createCmQNameOf(String name) {
        return QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)QName.createValidLocalName((String)name));
    }

    private static ChildAssociationRef createAssociationOf(NodeRef parentNode, NodeRef childNode) {
        return CategoriesImplTest.createAssociationOf(parentNode, childNode, null);
    }

    private static ChildAssociationRef createAssociationOf(NodeRef parentNode, NodeRef childNode, QName childNodeName) {
        return new ChildAssociationRef(ContentModel.ASSOC_SUBCATEGORIES, parentNode, childNodeName, childNode);
    }

    private Path mockCategoryPath() {
        Path mockPath = new Path();
        mockPath.append(PathHelper.stringToPath((String)MOCK_ROOT_LEVEL));
        mockPath.append(PathHelper.stringToPath((String)MOCK_CHILD_LEVEL));
        mockPath.append(PathHelper.stringToPath((String)"/"));
        return mockPath;
    }
}

