/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.heatbeat;

import java.util.Date;
import java.util.List;
import java.util.Map;
import org.alfresco.heartbeat.RenditionsDataCollector;
import org.alfresco.heartbeat.datasender.HBData;
import org.alfresco.heartbeat.jobs.HeartBeatJobScheduler;
import org.alfresco.repo.descriptor.DescriptorDAO;
import org.alfresco.repo.thumbnail.ThumbnailDefinition;
import org.alfresco.service.cmr.repository.HBDataCollectorService;
import org.alfresco.service.cmr.repository.TransformationOptions;
import org.alfresco.service.descriptor.Descriptor;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;

public class RenditionsDataCollectorTest {
    private RenditionsDataCollector renditionsDataCollector;
    private HBDataCollectorService mockCollectorService;
    private DescriptorDAO mockDescriptorDAO;
    private List<HBData> collectedData;
    private HeartBeatJobScheduler mockScheduler;
    private TransformationOptions options = new TransformationOptions();
    private ThumbnailDefinition doclib = new ThumbnailDefinition("png", this.options, "doclib");
    private ThumbnailDefinition preview = new ThumbnailDefinition("pdf", this.options, "preview");

    @Before
    public void setUp() {
        this.mockDescriptorDAO = (DescriptorDAO)Mockito.mock(DescriptorDAO.class);
        this.mockCollectorService = (HBDataCollectorService)Mockito.mock(HBDataCollectorService.class);
        this.mockScheduler = (HeartBeatJobScheduler)Mockito.mock(HeartBeatJobScheduler.class);
        Descriptor mockDescriptor = (Descriptor)Mockito.mock(Descriptor.class);
        Mockito.when((Object)mockDescriptor.getId()).thenReturn((Object)"mock_id");
        Mockito.when((Object)this.mockDescriptorDAO.getDescriptor()).thenReturn((Object)mockDescriptor);
        this.renditionsDataCollector = new RenditionsDataCollector("acs.repository.renditions", "1.0", "0 0 0 ? * *", this.mockScheduler);
        this.renditionsDataCollector.setHbDataCollectorService(this.mockCollectorService);
        this.renditionsDataCollector.setCurrentRepoDescriptorDAO(this.mockDescriptorDAO);
    }

    @Test
    public void testHBDataFields() {
        this.renditionsDataCollector.recordRenditionRequest(this.preview, "docx");
        this.renditionsDataCollector.recordRenditionRequest(this.doclib, "docx");
        this.collectedData = this.renditionsDataCollector.collectData();
        for (HBData data : this.collectedData) {
            Assert.assertNotNull((Object)data.getCollectorId());
            Assert.assertNotNull((Object)data.getCollectorVersion());
            Assert.assertNotNull((Object)data.getSchemaVersion());
            Assert.assertNotNull((Object)data.getSystemId());
            Assert.assertNotNull((Object)data.getTimestamp());
        }
    }

    @Test
    public void testCollectedDataInDetail() {
        this.renditionsDataCollector.recordRenditionRequest(this.doclib, "xls");
        this.renditionsDataCollector.recordRenditionRequest(this.doclib, "xls");
        this.renditionsDataCollector.recordRenditionRequest(this.preview, "docx");
        this.renditionsDataCollector.recordRenditionRequest(this.doclib, "docx");
        this.collectedData = this.renditionsDataCollector.collectData();
        Assert.assertEquals((String)"There should have been 3 data elements", (long)3L, (long)this.collectedData.size());
        Date firstTimestamp = null;
        for (HBData data : this.collectedData) {
            if (firstTimestamp == null) {
                firstTimestamp = data.getTimestamp();
            } else {
                Assert.assertEquals((String)"All data in a batch should have the same timestamp", (Object)firstTimestamp, (Object)data.getTimestamp());
            }
            Map values = data.getData();
            Assert.assertEquals((String)"There should have been 4 mapped values", (long)4L, (long)values.size());
            String rendition = (String)values.get("rendition");
            String sourceMimetype = (String)values.get("sourceMimetype");
            String targetMimetype = (String)values.get("targetMimetype");
            Integer count = (Integer)values.get("count");
            Assert.assertNotNull((Object)rendition);
            Assert.assertNotNull((Object)sourceMimetype);
            Assert.assertNotNull((Object)targetMimetype);
            Assert.assertNotNull((Object)count);
        }
        this.assertHBDataContains("doclib", "xls", "png", 2);
        this.assertHBDataContains("doclib", "docx", "png", 1);
        this.assertHBDataContains("preview", "docx", "pdf", 1);
    }

    @Test
    public void testMultipleCollections() throws InterruptedException {
        this.collectedData = this.renditionsDataCollector.collectData();
        Assert.assertEquals((String)"There should have been 0 data elements", (long)0L, (long)this.collectedData.size());
        this.renditionsDataCollector.recordRenditionRequest(this.doclib, "xls");
        this.renditionsDataCollector.recordRenditionRequest(this.doclib, "xls");
        this.renditionsDataCollector.recordRenditionRequest(this.preview, "docx");
        this.renditionsDataCollector.recordRenditionRequest(this.doclib, "docx");
        this.collectedData = this.renditionsDataCollector.collectData();
        Assert.assertEquals((String)"There should have been 3 data elements", (long)3L, (long)this.collectedData.size());
        this.assertHBDataContains("doclib", "xls", "png", 2);
        this.assertHBDataContains("doclib", "docx", "png", 1);
        this.assertHBDataContains("preview", "docx", "pdf", 1);
        Date prevTimestamp = this.collectedData.get(0).getTimestamp();
        Thread.sleep(10L);
        this.renditionsDataCollector.recordRenditionRequest(this.doclib, "jpg");
        this.renditionsDataCollector.recordRenditionRequest(this.doclib, "jpg");
        this.renditionsDataCollector.recordRenditionRequest(this.doclib, "jpg");
        this.collectedData = this.renditionsDataCollector.collectData();
        Assert.assertEquals((String)"There should have been 1 data element", (long)1L, (long)this.collectedData.size());
        this.assertHBDataContains("doclib", "jpg", "png", 3);
        Assert.assertNotEquals((String)"The timestamp should have changed", (Object)prevTimestamp, (Object)this.collectedData.get(0).getTimestamp());
        this.collectedData = this.renditionsDataCollector.collectData();
        Assert.assertEquals((String)"There should have been 0 data elements", (long)0L, (long)this.collectedData.size());
        this.renditionsDataCollector.recordRenditionRequest(this.doclib, "xls");
        this.collectedData = this.renditionsDataCollector.collectData();
        Assert.assertEquals((String)"There should have been 1 data element", (long)1L, (long)this.collectedData.size());
        this.assertHBDataContains("doclib", "xls", "png", 1);
    }

    private boolean assertHBDataContains(String rendition, String sourceMimetype, String targetMimetype, int count) {
        boolean found = false;
        for (HBData data : this.collectedData) {
            Map values = data.getData();
            if (!rendition.equals(values.get("rendition")) || !sourceMimetype.equals(values.get("sourceMimetype")) || !targetMimetype.equals(values.get("targetMimetype")) || count != (Integer)values.get("count")) continue;
            found = true;
            break;
        }
        return found;
    }
}

