/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.api.impl.rules;

import java.util.Collections;
import java.util.List;
import junit.framework.TestCase;
import org.alfresco.repo.rule.RuleModel;
import org.alfresco.repo.rule.RuntimeRuleService;
import org.alfresco.repo.security.permissions.AccessDeniedException;
import org.alfresco.rest.api.impl.rules.NodeValidator;
import org.alfresco.rest.api.impl.rules.RuleSetLoader;
import org.alfresco.rest.api.impl.rules.RuleSetsImpl;
import org.alfresco.rest.api.model.rules.RuleSet;
import org.alfresco.rest.framework.core.exceptions.InvalidArgumentException;
import org.alfresco.rest.framework.resource.parameters.CollectionWithPagingInfo;
import org.alfresco.rest.framework.resource.parameters.Paging;
import org.alfresco.service.Experimental;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.rule.RuleService;
import org.assertj.core.api.Assertions;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentMatchers;
import org.mockito.BDDMockito;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mockito.junit.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
@Experimental
public class RuleSetsImplTest
extends TestCase {
    private static final String FOLDER_ID = "dummy-folder-id";
    private static final String LINK_TO_NODE_ID = "dummy-link-to-node-id";
    private static final String RULE_SET_ID = "dummy-rule-set-id";
    private static final NodeRef FOLDER_NODE = new NodeRef(StoreRef.STORE_REF_WORKSPACE_SPACESSTORE, "dummy-folder-id");
    private static final NodeRef LINK_TO_NODE = new NodeRef(StoreRef.STORE_REF_WORKSPACE_SPACESSTORE, "dummy-link-to-node-id");
    private static final NodeRef RULE_SET_NODE = new NodeRef(StoreRef.STORE_REF_WORKSPACE_SPACESSTORE, "dummy-rule-set-id");
    private static final Paging PAGING = Paging.DEFAULT;
    private static final List<String> INCLUDES = List.of("dummy-includes");
    @InjectMocks
    private RuleSetsImpl ruleSets;
    @Mock
    private RuleSetLoader ruleSetLoaderMock;
    @Mock
    private NodeValidator nodeValidatorMock;
    @Mock
    private NodeService nodeServiceMock;
    @Mock
    private RuleService ruleServiceMock;
    @Mock
    private RuntimeRuleService runtimeRuleServiceMock;
    @Mock
    private RuleSet ruleSetMock;
    @Mock
    private ChildAssociationRef assocRef;

    @Before
    public void setUp() {
        MockitoAnnotations.openMocks((Object)((Object)this));
        BDDMockito.given((Object)this.nodeValidatorMock.validateFolderNode((String)ArgumentMatchers.eq((Object)LINK_TO_NODE_ID), ArgumentMatchers.anyBoolean())).willReturn((Object)LINK_TO_NODE);
        BDDMockito.given((Object)this.nodeValidatorMock.validateRuleSetNode(LINK_TO_NODE_ID, false)).willReturn((Object)LINK_TO_NODE);
        BDDMockito.given((Object)this.nodeValidatorMock.validateFolderNode((String)ArgumentMatchers.eq((Object)FOLDER_ID), ArgumentMatchers.anyBoolean())).willReturn((Object)FOLDER_NODE);
        BDDMockito.given((Object)this.nodeValidatorMock.validateRuleSetNode(RULE_SET_ID, FOLDER_NODE)).willReturn((Object)RULE_SET_NODE);
        BDDMockito.given((Object)this.ruleServiceMock.getRuleSetNode(FOLDER_NODE)).willReturn((Object)RULE_SET_NODE);
        BDDMockito.given((Object)this.ruleServiceMock.getNodesSupplyingRuleSets(FOLDER_NODE)).willReturn(List.of(FOLDER_NODE));
        BDDMockito.given((Object)this.ruleSetLoaderMock.loadRuleSet(RULE_SET_NODE, FOLDER_NODE, INCLUDES)).willReturn((Object)this.ruleSetMock);
    }

    @Test
    public void testGetRuleSets() {
        CollectionWithPagingInfo actual = this.ruleSets.getRuleSets(FOLDER_ID, INCLUDES, PAGING);
        ((NodeValidator)BDDMockito.then((Object)this.nodeValidatorMock).should()).validateFolderNode(FOLDER_ID, false);
        BDDMockito.then((Object)this.nodeValidatorMock).shouldHaveNoMoreInteractions();
        ((RuleService)BDDMockito.then((Object)this.ruleServiceMock).should()).getNodesSupplyingRuleSets(FOLDER_NODE);
        ((RuleService)BDDMockito.then((Object)this.ruleServiceMock).should()).getRuleSetNode(FOLDER_NODE);
        BDDMockito.then((Object)this.ruleServiceMock).shouldHaveNoMoreInteractions();
        List<RuleSet> expected = List.of(this.ruleSetMock);
        RuleSetsImplTest.assertEquals(expected, (Object)actual.getCollection());
        RuleSetsImplTest.assertEquals((Object)PAGING, (Object)actual.getPaging());
    }

    @Test
    public void testGetZeroRuleSets() {
        BDDMockito.given((Object)this.ruleServiceMock.getRuleSetNode(FOLDER_NODE)).willReturn(null);
        CollectionWithPagingInfo actual = this.ruleSets.getRuleSets(FOLDER_ID, INCLUDES, PAGING);
        ((NodeValidator)BDDMockito.then((Object)this.nodeValidatorMock).should()).validateFolderNode(FOLDER_ID, false);
        BDDMockito.then((Object)this.nodeValidatorMock).shouldHaveNoMoreInteractions();
        ((RuleService)BDDMockito.then((Object)this.ruleServiceMock).should()).getNodesSupplyingRuleSets(FOLDER_NODE);
        ((RuleService)BDDMockito.then((Object)this.ruleServiceMock).should()).getRuleSetNode(FOLDER_NODE);
        BDDMockito.then((Object)this.ruleServiceMock).shouldHaveNoMoreInteractions();
        RuleSetsImplTest.assertEquals(Collections.emptyList(), (Object)actual.getCollection());
        RuleSetsImplTest.assertEquals((Object)PAGING, (Object)actual.getPaging());
    }

    @Test
    public void testOnlyGetPermittedRuleSets() {
        NodeRef privateFolder = new NodeRef("private://folder/");
        NodeRef privateRuleSetNode = new NodeRef("private://rule/set/node/");
        BDDMockito.given((Object)this.ruleServiceMock.getRuleSetNode(privateFolder)).willReturn((Object)privateRuleSetNode);
        BDDMockito.given((Object)this.ruleServiceMock.getNodesSupplyingRuleSets(FOLDER_NODE)).willReturn(List.of(FOLDER_NODE, privateFolder));
        BDDMockito.given((Object)this.ruleSetLoaderMock.loadRuleSet((NodeRef)ArgumentMatchers.eq((Object)privateRuleSetNode), (NodeRef)ArgumentMatchers.any(NodeRef.class), (List)ArgumentMatchers.any(List.class))).willThrow(new Throwable[]{new AccessDeniedException("Cannot access private rule set.")});
        CollectionWithPagingInfo actual = this.ruleSets.getRuleSets(FOLDER_ID, INCLUDES, PAGING);
        ((NodeValidator)BDDMockito.then((Object)this.nodeValidatorMock).should()).validateFolderNode(FOLDER_ID, false);
        BDDMockito.then((Object)this.nodeValidatorMock).shouldHaveNoMoreInteractions();
        ((RuleService)BDDMockito.then((Object)this.ruleServiceMock).should()).getNodesSupplyingRuleSets(FOLDER_NODE);
        ((RuleService)BDDMockito.then((Object)this.ruleServiceMock).should()).getRuleSetNode(FOLDER_NODE);
        ((RuleService)BDDMockito.then((Object)this.ruleServiceMock).should()).getRuleSetNode(privateFolder);
        BDDMockito.then((Object)this.ruleServiceMock).shouldHaveNoMoreInteractions();
        List<RuleSet> expected = List.of(this.ruleSetMock);
        RuleSetsImplTest.assertEquals(expected, (Object)actual.getCollection());
        RuleSetsImplTest.assertEquals((Object)PAGING, (Object)actual.getPaging());
    }

    @Test
    public void testGetInheritedRuleSets() {
        NodeRef parentNode = new NodeRef("parent://node/");
        NodeRef grandparentNode = new NodeRef("grandparent://node/");
        RuleSet grandparentRuleSet = (RuleSet)Mockito.mock(RuleSet.class);
        NodeRef grandparentRuleSetNode = new NodeRef("grandparent://rule-set/");
        BDDMockito.given((Object)this.ruleServiceMock.getRuleSetNode(grandparentNode)).willReturn((Object)grandparentRuleSetNode);
        BDDMockito.given((Object)this.ruleSetLoaderMock.loadRuleSet(grandparentRuleSetNode, FOLDER_NODE, INCLUDES)).willReturn((Object)grandparentRuleSet);
        BDDMockito.given((Object)this.ruleServiceMock.getNodesSupplyingRuleSets(FOLDER_NODE)).willReturn(List.of(grandparentNode, parentNode, FOLDER_NODE));
        CollectionWithPagingInfo actual = this.ruleSets.getRuleSets(FOLDER_ID, INCLUDES, PAGING);
        ((NodeValidator)BDDMockito.then((Object)this.nodeValidatorMock).should()).validateFolderNode(FOLDER_ID, false);
        BDDMockito.then((Object)this.nodeValidatorMock).shouldHaveNoMoreInteractions();
        ((RuleService)BDDMockito.then((Object)this.ruleServiceMock).should()).getNodesSupplyingRuleSets(FOLDER_NODE);
        ((RuleService)BDDMockito.then((Object)this.ruleServiceMock).should()).getRuleSetNode(grandparentNode);
        ((RuleService)BDDMockito.then((Object)this.ruleServiceMock).should()).getRuleSetNode(parentNode);
        ((RuleService)BDDMockito.then((Object)this.ruleServiceMock).should()).getRuleSetNode(FOLDER_NODE);
        BDDMockito.then((Object)this.ruleServiceMock).shouldHaveNoMoreInteractions();
        List<RuleSet> expected = List.of(grandparentRuleSet, this.ruleSetMock);
        RuleSetsImplTest.assertEquals(expected, (Object)actual.getCollection());
        RuleSetsImplTest.assertEquals((Object)PAGING, (Object)actual.getPaging());
    }

    @Test
    public void testGetDuplicateRuleSets() {
        NodeRef grandparentNode = new NodeRef("grandparent://node/");
        BDDMockito.given((Object)this.ruleServiceMock.getRuleSetNode(grandparentNode)).willReturn((Object)RULE_SET_NODE);
        NodeRef parentNode = new NodeRef("parent://node/");
        RuleSet parentRuleSet = (RuleSet)Mockito.mock(RuleSet.class);
        NodeRef parentRuleSetNode = new NodeRef("parent://rule-set/");
        BDDMockito.given((Object)this.ruleServiceMock.getRuleSetNode(parentNode)).willReturn((Object)parentRuleSetNode);
        BDDMockito.given((Object)this.ruleSetLoaderMock.loadRuleSet(parentRuleSetNode, FOLDER_NODE, INCLUDES)).willReturn((Object)parentRuleSet);
        BDDMockito.given((Object)this.ruleServiceMock.getNodesSupplyingRuleSets(FOLDER_NODE)).willReturn(List.of(grandparentNode, parentNode, FOLDER_NODE));
        CollectionWithPagingInfo actual = this.ruleSets.getRuleSets(FOLDER_ID, INCLUDES, PAGING);
        List<RuleSet> expected = List.of(this.ruleSetMock, parentRuleSet);
        RuleSetsImplTest.assertEquals(expected, (Object)actual.getCollection());
        RuleSetsImplTest.assertEquals((Object)PAGING, (Object)actual.getPaging());
    }

    @Test
    public void testGetRuleSetById() {
        RuleSet actual = this.ruleSets.getRuleSetById(FOLDER_ID, RULE_SET_ID, INCLUDES);
        ((NodeValidator)BDDMockito.then((Object)this.nodeValidatorMock).should()).validateFolderNode(FOLDER_ID, false);
        ((NodeValidator)BDDMockito.then((Object)this.nodeValidatorMock).should()).validateRuleSetNode(RULE_SET_ID, FOLDER_NODE);
        BDDMockito.then((Object)this.nodeValidatorMock).shouldHaveNoMoreInteractions();
        RuleSetsImplTest.assertEquals((Object)this.ruleSetMock, (Object)actual);
    }

    @Test
    public void testLinkToFolderRuleSet() {
        NodeRef childNodeRef = new NodeRef(StoreRef.STORE_REF_WORKSPACE_SPACESSTORE, "dummy-child-id");
        BDDMockito.given((Object)this.ruleServiceMock.hasRules((NodeRef)ArgumentMatchers.any(NodeRef.class))).willReturn((Object)true, (Object[])new Boolean[]{false});
        BDDMockito.given((Object)this.runtimeRuleServiceMock.getSavedRuleFolderAssoc((NodeRef)ArgumentMatchers.any(NodeRef.class))).willReturn((Object)this.assocRef);
        BDDMockito.given((Object)this.assocRef.getChildRef()).willReturn((Object)childNodeRef);
        String actual = this.ruleSets.linkToRuleSet(FOLDER_ID, LINK_TO_NODE_ID).getId();
        ((RuleService)BDDMockito.then((Object)this.ruleServiceMock).should()).hasRules(LINK_TO_NODE);
        ((RuleService)BDDMockito.then((Object)this.ruleServiceMock).should()).hasNonInheritedRules(FOLDER_NODE);
        ((RuntimeRuleService)BDDMockito.then((Object)this.runtimeRuleServiceMock).should()).getSavedRuleFolderAssoc(LINK_TO_NODE);
        BDDMockito.then((Object)this.runtimeRuleServiceMock).shouldHaveNoMoreInteractions();
        ((NodeService)BDDMockito.then((Object)this.nodeServiceMock).should()).addChild(FOLDER_NODE, childNodeRef, RuleModel.ASSOC_RULE_FOLDER, RuleModel.ASSOC_RULE_FOLDER);
        BDDMockito.then((Object)this.nodeServiceMock).shouldHaveNoMoreInteractions();
        RuleSetsImplTest.assertEquals((String)childNodeRef.getId(), (String)actual);
    }

    @Test
    public void testLinkToRuleSet() {
        NodeRef childNodeRef = new NodeRef(StoreRef.STORE_REF_WORKSPACE_SPACESSTORE, "dummy-child-id");
        BDDMockito.given((Object)this.nodeValidatorMock.isRuleSetNode((String)ArgumentMatchers.any())).willReturn((Object)true);
        BDDMockito.given((Object)this.ruleServiceMock.hasRules((NodeRef)ArgumentMatchers.any(NodeRef.class))).willReturn((Object)true, (Object[])new Boolean[]{false});
        BDDMockito.given((Object)this.runtimeRuleServiceMock.getSavedRuleFolderAssoc((NodeRef)ArgumentMatchers.any(NodeRef.class))).willReturn((Object)this.assocRef);
        BDDMockito.given((Object)this.assocRef.getChildRef()).willReturn((Object)childNodeRef);
        String actual = this.ruleSets.linkToRuleSet(FOLDER_ID, LINK_TO_NODE_ID).getId();
        ((NodeValidator)BDDMockito.then((Object)this.nodeValidatorMock).should()).validateFolderNode(FOLDER_ID, true);
        ((NodeValidator)BDDMockito.then((Object)this.nodeValidatorMock).should()).isRuleSetNode(LINK_TO_NODE_ID);
        ((NodeValidator)BDDMockito.then((Object)this.nodeValidatorMock).should()).validateRuleSetNode(LINK_TO_NODE_ID, false);
        BDDMockito.then((Object)this.nodeValidatorMock).shouldHaveNoMoreInteractions();
        ((RuleService)BDDMockito.then((Object)this.ruleServiceMock).should()).hasRules(LINK_TO_NODE);
        ((RuleService)BDDMockito.then((Object)this.ruleServiceMock).should()).hasNonInheritedRules(FOLDER_NODE);
        ((RuntimeRuleService)BDDMockito.then((Object)this.runtimeRuleServiceMock).should()).getSavedRuleFolderAssoc(LINK_TO_NODE);
        BDDMockito.then((Object)this.runtimeRuleServiceMock).shouldHaveNoMoreInteractions();
        ((NodeService)BDDMockito.then((Object)this.nodeServiceMock).should()).addChild(FOLDER_NODE, childNodeRef, RuleModel.ASSOC_RULE_FOLDER, RuleModel.ASSOC_RULE_FOLDER);
        BDDMockito.then((Object)this.nodeServiceMock).shouldHaveNoMoreInteractions();
        RuleSetsImplTest.assertEquals((String)childNodeRef.getId(), (String)actual);
    }

    @Test
    public void testLinkToRuleSet_targetFolderHasNoRules() {
        BDDMockito.given((Object)this.ruleServiceMock.hasRules(LINK_TO_NODE)).willReturn((Object)false);
        Assertions.assertThatExceptionOfType(InvalidArgumentException.class).isThrownBy(() -> this.ruleSets.linkToRuleSet(FOLDER_ID, LINK_TO_NODE_ID));
        BDDMockito.then((Object)this.nodeServiceMock).shouldHaveNoMoreInteractions();
        ((RuleService)BDDMockito.then((Object)this.ruleServiceMock).should()).hasRules(LINK_TO_NODE);
        BDDMockito.then((Object)this.ruleServiceMock).shouldHaveNoMoreInteractions();
        BDDMockito.then((Object)this.runtimeRuleServiceMock).shouldHaveNoInteractions();
    }

    @Test
    public void testLinkToRuleSet_folderShouldntHavePreExistingRules() {
        BDDMockito.given((Object)this.ruleServiceMock.hasRules((NodeRef)ArgumentMatchers.any(NodeRef.class))).willReturn((Object)true);
        BDDMockito.given((Object)this.ruleServiceMock.hasNonInheritedRules((NodeRef)ArgumentMatchers.any(NodeRef.class))).willReturn((Object)true);
        Assertions.assertThatExceptionOfType(InvalidArgumentException.class).isThrownBy(() -> this.ruleSets.linkToRuleSet(FOLDER_ID, LINK_TO_NODE_ID));
        BDDMockito.then((Object)this.nodeServiceMock).shouldHaveNoMoreInteractions();
        ((RuleService)BDDMockito.then((Object)this.ruleServiceMock).should()).hasRules(LINK_TO_NODE);
        ((RuleService)BDDMockito.then((Object)this.ruleServiceMock).should()).hasNonInheritedRules(FOLDER_NODE);
        BDDMockito.then((Object)this.ruleServiceMock).shouldHaveNoMoreInteractions();
        BDDMockito.then((Object)this.runtimeRuleServiceMock).shouldHaveNoInteractions();
    }

    @Test
    public void testUnlinkRuleSet() {
        BDDMockito.given((Object)this.ruleServiceMock.isLinkedToRuleNode(FOLDER_NODE)).willReturn((Object)true);
        this.ruleSets.unlinkRuleSet(FOLDER_ID, RULE_SET_ID);
        ((NodeValidator)BDDMockito.then((Object)this.nodeValidatorMock).should()).validateFolderNode(FOLDER_ID, true);
        ((NodeValidator)BDDMockito.then((Object)this.nodeValidatorMock).should()).validateRuleSetNode(RULE_SET_ID, FOLDER_NODE);
        BDDMockito.then((Object)this.nodeValidatorMock).shouldHaveNoMoreInteractions();
        ((RuleService)BDDMockito.then((Object)this.ruleServiceMock).should()).isLinkedToRuleNode(FOLDER_NODE);
        BDDMockito.then((Object)this.ruleServiceMock).shouldHaveNoMoreInteractions();
        ((NodeService)BDDMockito.then((Object)this.nodeServiceMock).should()).removeAspect(FOLDER_NODE, RuleModel.ASPECT_RULES);
        BDDMockito.then((Object)this.nodeServiceMock).shouldHaveNoMoreInteractions();
    }

    @Test
    public void testUnlinkRuleSet_folderIsNotLinkedToRuleSet() {
        BDDMockito.given((Object)this.ruleServiceMock.isLinkedToRuleNode(FOLDER_NODE)).willReturn((Object)false);
        Assertions.assertThatExceptionOfType(InvalidArgumentException.class).isThrownBy(() -> this.ruleSets.unlinkRuleSet(FOLDER_ID, RULE_SET_ID));
        ((NodeValidator)BDDMockito.then((Object)this.nodeValidatorMock).should()).validateFolderNode(FOLDER_ID, true);
        ((NodeValidator)BDDMockito.then((Object)this.nodeValidatorMock).should()).validateRuleSetNode(RULE_SET_ID, FOLDER_NODE);
        BDDMockito.then((Object)this.nodeValidatorMock).shouldHaveNoMoreInteractions();
        ((RuleService)BDDMockito.then((Object)this.ruleServiceMock).should()).isLinkedToRuleNode(FOLDER_NODE);
        BDDMockito.then((Object)this.ruleServiceMock).shouldHaveNoMoreInteractions();
        BDDMockito.then((Object)this.nodeServiceMock).shouldHaveNoInteractions();
    }

    @Test
    public void testUpdateRuleSet() {
        BDDMockito.given((Object)this.ruleSetMock.getId()).willReturn((Object)RULE_SET_ID);
        BDDMockito.given((Object)this.nodeValidatorMock.validateFolderNode(FOLDER_ID, false)).willReturn((Object)FOLDER_NODE);
        BDDMockito.given((Object)this.nodeValidatorMock.validateRuleSetNode(RULE_SET_ID, FOLDER_NODE)).willReturn((Object)RULE_SET_NODE);
        RuleSet ruleSetResponse = (RuleSet)Mockito.mock(RuleSet.class);
        BDDMockito.given((Object)this.ruleSetLoaderMock.loadRuleSet(RULE_SET_NODE, FOLDER_NODE, Collections.emptyList())).willReturn((Object)ruleSetResponse);
        RuleSet ruleSet = this.ruleSets.updateRuleSet(FOLDER_ID, this.ruleSetMock, Collections.emptyList());
        RuleSetsImplTest.assertEquals((String)"Unexpected rule set returned.", (Object)ruleSetResponse, (Object)ruleSet);
        ((NodeValidator)BDDMockito.then((Object)this.nodeValidatorMock).should()).validateFolderNode(FOLDER_ID, false);
        ((NodeValidator)BDDMockito.then((Object)this.nodeValidatorMock).should()).validateRuleSetNode(RULE_SET_ID, FOLDER_NODE);
        ((RuleSetLoader)BDDMockito.then((Object)this.ruleSetLoaderMock).should()).loadRuleSet(RULE_SET_NODE, FOLDER_NODE, Collections.emptyList());
    }

    @Test
    public void testUpdateRuleSet_reorderRules() {
        List<String> dbOrder = List.of("RuleA", "RuleB");
        List<String> newOrder = List.of("RuleB", "RuleA");
        List<String> includes = List.of("ruleIds");
        RuleSet dbRuleSet = (RuleSet)Mockito.mock(RuleSet.class);
        RuleSet requestRuleSet = (RuleSet)Mockito.mock(RuleSet.class);
        BDDMockito.given((Object)requestRuleSet.getId()).willReturn((Object)RULE_SET_ID);
        BDDMockito.given((Object)requestRuleSet.getRuleIds()).willReturn(newOrder);
        BDDMockito.given((Object)this.ruleSetLoaderMock.loadRuleSet(RULE_SET_NODE, FOLDER_NODE, includes)).willReturn((Object)dbRuleSet);
        BDDMockito.given((Object)this.ruleSetLoaderMock.loadRuleIds(FOLDER_NODE)).willReturn(dbOrder);
        BDDMockito.given((Object)this.nodeValidatorMock.validateFolderNode(FOLDER_ID, false)).willReturn((Object)FOLDER_NODE);
        BDDMockito.given((Object)this.nodeValidatorMock.validateRuleSetNode(RULE_SET_ID, FOLDER_NODE)).willReturn((Object)RULE_SET_NODE);
        RuleSet ruleSet = this.ruleSets.updateRuleSet(FOLDER_ID, requestRuleSet, includes);
        RuleSetsImplTest.assertEquals((String)"Unexpected rule set returned.", (Object)dbRuleSet, (Object)ruleSet);
        ((NodeValidator)BDDMockito.then((Object)this.nodeValidatorMock).should()).validateFolderNode(FOLDER_ID, false);
        ((NodeValidator)BDDMockito.then((Object)this.nodeValidatorMock).should()).validateRuleSetNode(RULE_SET_ID, FOLDER_NODE);
        ((RuleSetLoader)BDDMockito.then((Object)this.ruleSetLoaderMock).should()).loadRuleSet(RULE_SET_NODE, FOLDER_NODE, includes);
        ((RuleSet)BDDMockito.then((Object)dbRuleSet).should()).setRuleIds(newOrder);
    }

    @Test
    public void testUpdateRuleSet_tryToChangeSetOfRuleIds() {
        List<String> dbOrder = List.of("RuleA", "RuleB");
        List<String> newOrder = List.of("RuleA");
        List<String> includes = List.of("ruleIds");
        RuleSet dbRuleSet = (RuleSet)Mockito.mock(RuleSet.class);
        RuleSet requestRuleSet = (RuleSet)Mockito.mock(RuleSet.class);
        BDDMockito.given((Object)requestRuleSet.getId()).willReturn((Object)RULE_SET_ID);
        BDDMockito.given((Object)requestRuleSet.getRuleIds()).willReturn(newOrder);
        BDDMockito.given((Object)this.ruleSetLoaderMock.loadRuleSet(RULE_SET_NODE, FOLDER_NODE, includes)).willReturn((Object)dbRuleSet);
        BDDMockito.given((Object)this.ruleSetLoaderMock.loadRuleIds(FOLDER_NODE)).willReturn(dbOrder);
        BDDMockito.given((Object)this.nodeValidatorMock.validateFolderNode(FOLDER_ID, false)).willReturn((Object)FOLDER_NODE);
        BDDMockito.given((Object)this.nodeValidatorMock.validateRuleSetNode(RULE_SET_ID, FOLDER_NODE)).willReturn((Object)RULE_SET_NODE);
        Assertions.assertThatExceptionOfType(InvalidArgumentException.class).isThrownBy(() -> this.ruleSets.updateRuleSet(FOLDER_ID, requestRuleSet, includes));
    }

    @Test
    public void testUpdateRuleSet_DuplicateRuleId() {
        List<String> dbOrder = List.of("RuleA", "RuleB");
        List<String> newOrder = List.of("RuleA", "RuleB", "RuleA");
        List<String> includes = List.of("ruleIds");
        RuleSet dbRuleSet = (RuleSet)Mockito.mock(RuleSet.class);
        RuleSet requestRuleSet = (RuleSet)Mockito.mock(RuleSet.class);
        BDDMockito.given((Object)requestRuleSet.getId()).willReturn((Object)RULE_SET_ID);
        BDDMockito.given((Object)requestRuleSet.getRuleIds()).willReturn(newOrder);
        BDDMockito.given((Object)this.ruleSetLoaderMock.loadRuleSet(RULE_SET_NODE, FOLDER_NODE, includes)).willReturn((Object)dbRuleSet);
        BDDMockito.given((Object)this.ruleSetLoaderMock.loadRuleIds(FOLDER_NODE)).willReturn(dbOrder);
        BDDMockito.given((Object)this.nodeValidatorMock.validateFolderNode(FOLDER_ID, false)).willReturn((Object)FOLDER_NODE);
        BDDMockito.given((Object)this.nodeValidatorMock.validateRuleSetNode(RULE_SET_ID, FOLDER_NODE)).willReturn((Object)RULE_SET_NODE);
        Assertions.assertThatExceptionOfType(InvalidArgumentException.class).isThrownBy(() -> this.ruleSets.updateRuleSet(FOLDER_ID, requestRuleSet, includes));
    }

    @Test
    public void testUpdateRuleSet_dontIncludeRuleIds() {
        List<String> dbOrder = List.of("RuleA", "RuleB");
        List<String> newOrder = List.of("RuleB", "RuleA");
        List includes = Collections.emptyList();
        RuleSet dbRuleSet = (RuleSet)Mockito.mock(RuleSet.class);
        RuleSet requestRuleSet = (RuleSet)Mockito.mock(RuleSet.class);
        BDDMockito.given((Object)requestRuleSet.getId()).willReturn((Object)RULE_SET_ID);
        BDDMockito.given((Object)requestRuleSet.getRuleIds()).willReturn(newOrder);
        BDDMockito.given((Object)this.ruleSetLoaderMock.loadRuleSet(RULE_SET_NODE, FOLDER_NODE, includes)).willReturn((Object)dbRuleSet);
        BDDMockito.given((Object)this.ruleSetLoaderMock.loadRuleIds(FOLDER_NODE)).willReturn(dbOrder);
        BDDMockito.given((Object)this.nodeValidatorMock.validateFolderNode(FOLDER_ID, false)).willReturn((Object)FOLDER_NODE);
        BDDMockito.given((Object)this.nodeValidatorMock.validateRuleSetNode(RULE_SET_ID, FOLDER_NODE)).willReturn((Object)RULE_SET_NODE);
        RuleSet ruleSet = this.ruleSets.updateRuleSet(FOLDER_ID, requestRuleSet, includes);
        RuleSetsImplTest.assertEquals((String)"Unexpected rule set returned.", (Object)dbRuleSet, (Object)ruleSet);
        BDDMockito.then((Object)dbRuleSet).shouldHaveNoInteractions();
    }
}

