/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.web.scripts.invite;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import junit.framework.TestCase;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.action.executer.MailActionExecuter;
import org.alfresco.repo.invitation.InvitationServiceImpl;
import org.alfresco.repo.invitation.script.ScriptInvitationService;
import org.alfresco.repo.management.subsystems.ChildApplicationContextFactory;
import org.alfresco.repo.node.archive.NodeArchiveService;
import org.alfresco.repo.security.authentication.AuthenticationComponent;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.security.authentication.MutableAuthenticationDao;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.repo.web.scripts.BaseWebScriptTest;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.datatype.DefaultTypeConverter;
import org.alfresco.service.cmr.security.MutableAuthenticationService;
import org.alfresco.service.cmr.security.PersonService;
import org.alfresco.service.cmr.site.SiteInfo;
import org.alfresco.service.cmr.site.SiteService;
import org.alfresco.service.cmr.site.SiteVisibility;
import org.alfresco.service.cmr.workflow.WorkflowDefinition;
import org.alfresco.service.cmr.workflow.WorkflowInstance;
import org.alfresco.service.cmr.workflow.WorkflowService;
import org.alfresco.service.transaction.TransactionService;
import org.alfresco.util.GUID;
import org.alfresco.util.PropertyMap;
import org.alfresco.util.testing.category.LuceneTests;
import org.alfresco.util.testing.category.RedundantTests;
import org.apache.commons.lang3.RandomStringUtils;
import org.json.JSONArray;
import org.json.JSONObject;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.springframework.context.ApplicationContext;
import org.springframework.extensions.webscripts.TestWebScriptServer;

@Category(value={LuceneTests.class})
public class InviteServiceTest
extends BaseWebScriptTest {
    private MutableAuthenticationService authenticationService;
    private AuthenticationComponent authenticationComponent;
    private PersonService personService;
    private SiteService siteService;
    private NodeService nodeService;
    private WorkflowService workflowService;
    private MutableAuthenticationDao mutableAuthenticationDao;
    private TransactionService transactionService;
    private NodeArchiveService nodeArchiveService;
    private InvitationServiceImpl invitationServiceImpl;
    private List<String> inviteeEmailAddrs;
    private static final String WF_DEFINITION_INVITE = "activiti$activitiInvitationNominated";
    private static final String USER_INVITER = "InviterUser";
    private static final String USER_INVITER_2 = "InviterUser2";
    private static final String INVITEE_FIRSTNAME = "InviteeFirstName";
    private static final String INVITEE_LASTNAME = "InviteeLastName";
    private static final String INVITER_EMAIL = "FirstName123.LastName123@email.com";
    private static final String INVITER_EMAIL_2 = "FirstNameabc.LastNameabc@email.com";
    private static final String INVITEE_EMAIL_DOMAIN = "alfrescotesting.com";
    private static final String INVITEE_EMAIL_PREFIX = "invitee";
    private static final String INVITEE_SITE_ROLE = "SiteCollaborator";
    private static final String SITE_SHORT_NAME_INVITE_1 = "SiteOneInviteTest";
    private static final String SITE_SHORT_NAME_INVITE_2 = "SiteTwoInviteTest";
    private static final String SITE_SHORT_NAME_INVITE_3 = "SiteThreeInviteTest";
    private static final String URL_INVITE = "/api/invite";
    private static final String URL_INVITES = "/api/invites";
    private static final String URL_SITES = "/api/sites";
    public static String PERSON_FIRSTNAME = "FirstName123";
    public static String PERSON_LASTNAME = "LastName123";
    public static String PERSON_JOBTITLE = "JobTitle123";
    public static String PERSON_ORG = "Organisation123";

    protected void setUp() throws Exception {
        super.setUp();
        AuthenticationUtil.clearCurrentSecurityContext();
        this.authenticationService = (MutableAuthenticationService)this.getServer().getApplicationContext().getBean("AuthenticationService");
        this.authenticationComponent = (AuthenticationComponent)this.getServer().getApplicationContext().getBean("AuthenticationComponent");
        this.personService = (PersonService)this.getServer().getApplicationContext().getBean("PersonService");
        this.siteService = (SiteService)this.getServer().getApplicationContext().getBean("SiteService");
        this.nodeService = (NodeService)this.getServer().getApplicationContext().getBean("NodeService");
        this.workflowService = (WorkflowService)this.getServer().getApplicationContext().getBean("WorkflowService");
        this.mutableAuthenticationDao = (MutableAuthenticationDao)this.getServer().getApplicationContext().getBean("authenticationDao");
        this.transactionService = (TransactionService)this.getServer().getApplicationContext().getBean("TransactionService");
        this.nodeArchiveService = (NodeArchiveService)this.getServer().getApplicationContext().getBean("nodeArchiveService");
        this.invitationServiceImpl = (InvitationServiceImpl)this.getServer().getApplicationContext().getBean("invitationService");
        ScriptInvitationService scriptInvitationService = (ScriptInvitationService)this.getServer().getApplicationContext().getBean("invitationServiceScript");
        scriptInvitationService.setSiteService(this.siteService);
        InviteServiceTest.configureMailExecutorForTestMode(this.getServer());
        this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Object>(){

                    public Object doWork() throws Exception {
                        InviteServiceTest.this.inviteeEmailAddrs = new ArrayList<String>();
                        InviteServiceTest.this.createPerson(PERSON_FIRSTNAME, PERSON_LASTNAME, InviteServiceTest.USER_INVITER, InviteServiceTest.INVITER_EMAIL);
                        InviteServiceTest.this.createPerson(PERSON_FIRSTNAME, PERSON_LASTNAME, InviteServiceTest.USER_INVITER_2, InviteServiceTest.INVITER_EMAIL_2);
                        return null;
                    }
                }, (String)AuthenticationUtil.getSystemUserName());
                String residuallyAuthenticatedUser = AuthenticationUtil.getFullyAuthenticatedUser();
                TestCase.assertNull((String)("Residual authentication on context-initiating thread (this thread):" + residuallyAuthenticatedUser), (Object)residuallyAuthenticatedUser);
                AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Object>(){

                    public Object doWork() throws Exception {
                        String inviterSiteRole;
                        SiteInfo siteInfo = InviteServiceTest.this.siteService.getSite(InviteServiceTest.SITE_SHORT_NAME_INVITE_1);
                        if (siteInfo == null) {
                            InviteServiceTest.this.siteService.createSite("InviteSitePreset", InviteServiceTest.SITE_SHORT_NAME_INVITE_1, "InviteSiteTitle", "InviteSiteDescription", SiteVisibility.PUBLIC);
                        }
                        if ((siteInfo = InviteServiceTest.this.siteService.getSite(InviteServiceTest.SITE_SHORT_NAME_INVITE_2)) == null) {
                            InviteServiceTest.this.siteService.createSite("InviteSitePreset", InviteServiceTest.SITE_SHORT_NAME_INVITE_2, "InviteSiteTitle", "InviteSiteDescription", SiteVisibility.PUBLIC);
                        }
                        if ((siteInfo = InviteServiceTest.this.siteService.getSite(InviteServiceTest.SITE_SHORT_NAME_INVITE_3)) == null) {
                            InviteServiceTest.this.siteService.createSite("InviteSitePreset", InviteServiceTest.SITE_SHORT_NAME_INVITE_3, "InviteSiteTitle", "InviteSiteDescription", SiteVisibility.PUBLIC);
                        }
                        if ((inviterSiteRole = InviteServiceTest.this.siteService.getMembersRole(InviteServiceTest.SITE_SHORT_NAME_INVITE_3, InviteServiceTest.USER_INVITER_2)) == null || !inviterSiteRole.equals(InviteServiceTest.INVITEE_SITE_ROLE)) {
                            InviteServiceTest.this.siteService.setMembership(InviteServiceTest.SITE_SHORT_NAME_INVITE_3, InviteServiceTest.USER_INVITER_2, InviteServiceTest.INVITEE_SITE_ROLE);
                        }
                        return null;
                    }
                }, (String)InviteServiceTest.USER_INVITER);
                InviteServiceTest.this.authenticationComponent.setCurrentUser(InviteServiceTest.USER_INVITER);
                return null;
            }
        });
    }

    public static void configureMailExecutorForTestMode(TestWebScriptServer server) {
        ChildApplicationContextFactory outboundSmptSubsystem = (ChildApplicationContextFactory)server.getApplicationContext().getBean("OutboundSMTP");
        ApplicationContext childAppCtxt = outboundSmptSubsystem.getApplicationContext();
        MailActionExecuter mailActionExecutor = (MailActionExecuter)childAppCtxt.getBean("mail");
        mailActionExecutor.setTestMode(true);
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        AuthenticationUtil.RunAsWork<SiteInfo[]> runAsWork = new AuthenticationUtil.RunAsWork<SiteInfo[]>(){

            public SiteInfo[] doWork() throws Exception {
                SiteInfo[] siteInfos = new SiteInfo[]{InviteServiceTest.this.siteService.getSite(InviteServiceTest.SITE_SHORT_NAME_INVITE_1), InviteServiceTest.this.siteService.getSite(InviteServiceTest.SITE_SHORT_NAME_INVITE_2), InviteServiceTest.this.siteService.getSite(InviteServiceTest.SITE_SHORT_NAME_INVITE_3)};
                return siteInfos;
            }
        };
        final SiteInfo[] siteInfos = (SiteInfo[])AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)runAsWork, (String)AuthenticationUtil.getSystemUserName());
        this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                AuthenticationUtil.RunAsWork<Object> runAsWork = new AuthenticationUtil.RunAsWork<Object>(){

                    public Object doWork() throws Exception {
                        InviteServiceTest.this.deletePersonByUserName(InviteServiceTest.USER_INVITER);
                        for (String inviteeEmail : InviteServiceTest.this.inviteeEmailAddrs) {
                            Set people = InviteServiceTest.this.personService.getPeopleFilteredByProperty(ContentModel.PROP_EMAIL, (Serializable)((Object)inviteeEmail), 1000);
                            for (NodeRef person : people) {
                                String userName = (String)DefaultTypeConverter.INSTANCE.convert(String.class, (Object)InviteServiceTest.this.nodeService.getProperty(person, ContentModel.PROP_USERNAME));
                                try {
                                    InviteServiceTest.this.deletePersonByUserName(userName);
                                }
                                catch (Exception exp) {
                                    exp.printStackTrace();
                                }
                            }
                        }
                        InviteServiceTest.this.siteService.deleteSite(InviteServiceTest.SITE_SHORT_NAME_INVITE_1);
                        InviteServiceTest.this.siteService.deleteSite(InviteServiceTest.SITE_SHORT_NAME_INVITE_2);
                        InviteServiceTest.this.siteService.deleteSite(InviteServiceTest.SITE_SHORT_NAME_INVITE_3);
                        Thread.sleep(5000L);
                        return null;
                    }
                };
                AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)runAsWork, (String)AuthenticationUtil.getSystemUserName());
                WorkflowDefinition wfDef = InviteServiceTest.this.workflowService.getDefinitionByName(InviteServiceTest.WF_DEFINITION_INVITE);
                List workflowList = InviteServiceTest.this.workflowService.getActiveWorkflows(wfDef.id);
                for (WorkflowInstance workflow : workflowList) {
                    InviteServiceTest.this.workflowService.cancelWorkflow(workflow.id);
                }
                return null;
            }
        });
        AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Object>(){

            public Object doWork() throws Exception {
                for (SiteInfo siteInfo : siteInfos) {
                    InviteServiceTest.this.nodeArchiveService.purgeArchivedNode(InviteServiceTest.this.nodeArchiveService.getArchivedNode(siteInfo.getNodeRef()));
                }
                return null;
            }
        }, (String)AuthenticationUtil.getSystemUserName());
    }

    private void createPerson(String firstName, String lastName, String userName, String emailAddress) {
        if (!this.authenticationService.authenticationExists(userName)) {
            this.authenticationService.createAuthentication(userName, "password".toCharArray());
        }
        if (!this.personService.personExists(userName)) {
            PropertyMap personProps = new PropertyMap();
            personProps.put((Object)ContentModel.PROP_USERNAME, (Object)userName);
            personProps.put((Object)ContentModel.PROP_FIRSTNAME, (Object)firstName);
            personProps.put((Object)ContentModel.PROP_LASTNAME, (Object)lastName);
            personProps.put((Object)ContentModel.PROP_EMAIL, (Object)emailAddress);
            personProps.put((Object)ContentModel.PROP_JOBTITLE, (Object)PERSON_JOBTITLE);
            personProps.put((Object)ContentModel.PROP_ORGANIZATION, (Object)PERSON_ORG);
            this.personService.createPerson((Map)personProps);
        }
    }

    private void deletePersonByUserName(String userName) {
        if (this.personService.personExists(userName)) {
            this.personService.deletePerson(userName);
        }
    }

    private JSONObject startInvite(String inviteeFirstName, String inviteeLastName, String inviteeEmail, String inviteeSiteRole, String siteShortName, int expectedStatus) throws Exception {
        this.inviteeEmailAddrs.add(inviteeEmail);
        String serverPath = "http://localhost:8081/share/";
        String acceptURL = "page/accept-invite";
        String rejectURL = "page/reject-invite";
        String inviteeUserName = null;
        JSONObject result = this.createNominatedInvitation(siteShortName, inviteeFirstName, inviteeLastName, inviteeEmail, inviteeUserName, inviteeSiteRole, serverPath, acceptURL, rejectURL, expectedStatus);
        return result;
    }

    private JSONObject startInvite(String inviteeFirstName, String inviteeLastName, String inviteeSiteRole, String siteShortName, int expectedStatus) throws Exception {
        String inviteeEmail = INVITEE_EMAIL_PREFIX + RandomStringUtils.randomAlphanumeric((int)6) + "@alfrescotesting.com";
        return this.startInvite(inviteeFirstName, inviteeLastName, inviteeEmail, inviteeSiteRole, siteShortName, expectedStatus);
    }

    private JSONObject cancelInvite(String inviteId, String siteShortName, int expectedStatus) throws Exception {
        return this.deleteInvitation(inviteId, siteShortName, expectedStatus);
    }

    JSONObject deleteInvitation(String invitationID, String siteShortName, int expectedStatus) throws Exception {
        InviteServiceTest.assertNotNull((Object)invitationID);
        InviteServiceTest.assertNotNull((Object)siteShortName);
        InviteServiceTest.assertFalse((boolean)invitationID.isEmpty());
        InviteServiceTest.assertFalse((boolean)siteShortName.isEmpty());
        TestWebScriptServer.Response response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.DeleteRequest("/api/sites/" + siteShortName + "/invitations/" + invitationID), expectedStatus);
        JSONObject jsonResponse = new JSONObject(response.getContentAsString());
        InviteServiceTest.assertNotNull((Object)jsonResponse);
        return jsonResponse;
    }

    private JSONObject createNominatedInvitation(String siteName, String inviteeFirstName, String inviteeLastName, String inviteeEmail, String inviteeUserName, String inviteeRoleName, String serverPath, String acceptURL, String rejectURL, int expectedStatus) throws Exception {
        JSONObject newInvitation = new JSONObject();
        newInvitation.put("invitationType", (Object)"NOMINATED");
        newInvitation.put("inviteeRoleName", (Object)inviteeRoleName);
        if (inviteeUserName != null) {
            newInvitation.put("inviteeUserName", (Object)inviteeUserName);
        } else {
            newInvitation.put("inviteeFirstName", (Object)inviteeFirstName);
            newInvitation.put("inviteeLastName", (Object)inviteeLastName);
            newInvitation.put("inviteeEmail", (Object)inviteeEmail);
        }
        newInvitation.put("serverPath", (Object)serverPath);
        newInvitation.put("acceptURL", (Object)acceptURL);
        newInvitation.put("rejectURL", (Object)rejectURL);
        TestWebScriptServer.Response response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.PostRequest("/api/sites/" + siteName + "/invitations", newInvitation.toString(), "application/json"), expectedStatus);
        JSONObject result = new JSONObject(response.getContentAsString());
        return result;
    }

    private JSONObject rejectInvite(String inviteId, String inviteTicket, int expectedStatus) throws Exception {
        String rejectInviteUrl = "/api/invite/" + inviteId + "/" + inviteTicket + "/reject";
        TestWebScriptServer.Response response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.PutRequest(rejectInviteUrl, (byte[])null, null), expectedStatus);
        JSONObject result = new JSONObject(response.getContentAsString());
        return result;
    }

    private JSONObject getInvitesByInviteId(String inviteId, int expectedStatus) throws Exception {
        String getInvitesUrl = "/api/invites?inviteId=" + inviteId;
        TestWebScriptServer.Response response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest(getInvitesUrl), expectedStatus);
        JSONObject result = new JSONObject(response.getContentAsString());
        return result;
    }

    private JSONObject getInvitesByInviterUserName(String inviterUserName, int expectedStatus) throws Exception {
        String getInvitesUrl = "/api/invites?inviterUserName=" + inviterUserName;
        TestWebScriptServer.Response response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest(getInvitesUrl), expectedStatus);
        JSONObject result = new JSONObject(response.getContentAsString());
        return result;
    }

    private JSONObject getInvitesByInviteeUserName(String inviteeUserName, int expectedStatus) throws Exception {
        String getInvitesUrl = "/api/invites?inviteeUserName=" + inviteeUserName;
        TestWebScriptServer.Response response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest(getInvitesUrl), expectedStatus);
        JSONObject result = new JSONObject(response.getContentAsString());
        return result;
    }

    private JSONObject getInvitesBySiteShortName(String siteShortName, int expectedStatus) throws Exception {
        String getInvitesUrl = "/api/invites?siteShortName=" + siteShortName;
        TestWebScriptServer.Response response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest(getInvitesUrl), expectedStatus);
        JSONObject result = new JSONObject(response.getContentAsString());
        return result;
    }

    private JSONObject listInvitations(String siteShortName, String userNameSearch, int expectedStatus) throws Exception {
        String getInvitesUrl = "/api/sites/" + siteShortName + "/potentialmembers?authorityType=USER&sortBy=fullName&dir=asc&filter=" + userNameSearch + "&maxResults=250";
        TestWebScriptServer.Response response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest(getInvitesUrl), expectedStatus);
        JSONObject result = new JSONObject(response.getContentAsString());
        return result;
    }

    private JSONObject getInviteInfo(String inviteId, String inviteTicket, String inviteeUid) throws Exception {
        String url = "/api/invite/" + inviteId + "/" + inviteTicket + "?inviteeUserName=" + inviteeUid;
        String runAsUser = AuthenticationUtil.getRunAsUser();
        TestWebScriptServer.Response response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest(url), 200);
        if (!runAsUser.equals(AuthenticationUtil.getRunAsUser())) {
            AuthenticationUtil.setRunAsUser((String)runAsUser);
        }
        JSONObject result = new JSONObject(response.getContentAsString());
        return result;
    }

    public void testStartInvite() throws Exception {
        JSONObject result = this.startInvite(INVITEE_FIRSTNAME, INVITEE_LASTNAME, INVITEE_SITE_ROLE, SITE_SHORT_NAME_INVITE_1, 201);
        JSONObject data = result.getJSONObject("data");
        JSONObject inviteeData = data.getJSONObject(INVITEE_EMAIL_PREFIX);
        InviteServiceTest.assertEquals((Object)INVITEE_FIRSTNAME, (Object)inviteeData.get("firstName"));
        InviteServiceTest.assertEquals((Object)INVITEE_LASTNAME, (Object)inviteeData.get("lastName"));
        InviteServiceTest.assertEquals((Object)this.inviteeEmailAddrs.get(this.inviteeEmailAddrs.size() - 1), (Object)inviteeData.get("email"));
        InviteServiceTest.assertEquals((Object)SITE_SHORT_NAME_INVITE_1, (Object)data.get("resourceName"));
    }

    public void testStartInviteWhenInviteeIsAlreadyMemberOfSite() throws Exception {
        String randomStr = RandomStringUtils.randomNumeric((int)6);
        final String inviteeUserName = "inviteeUserName" + randomStr;
        final String inviteeEmailAddr = INVITEE_EMAIL_PREFIX + randomStr + "@alfrescotesting.com";
        AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Object>(){

            public Object doWork() throws Exception {
                InviteServiceTest.this.createPerson(InviteServiceTest.INVITEE_FIRSTNAME, InviteServiceTest.INVITEE_LASTNAME, inviteeUserName, inviteeEmailAddr);
                return null;
            }
        }, (String)AuthenticationUtil.getSystemUserName());
        AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Object>(){

            public Object doWork() throws Exception {
                InviteServiceTest.this.siteService.setMembership(InviteServiceTest.SITE_SHORT_NAME_INVITE_1, inviteeUserName, InviteServiceTest.INVITEE_SITE_ROLE);
                return null;
            }
        }, (String)USER_INVITER);
        this.startInvite(INVITEE_FIRSTNAME, INVITEE_LASTNAME, inviteeEmailAddr, INVITEE_SITE_ROLE, SITE_SHORT_NAME_INVITE_1, 409);
        this.startInvite(INVITEE_FIRSTNAME, "Belzebub", inviteeEmailAddr, INVITEE_SITE_ROLE, SITE_SHORT_NAME_INVITE_1, 201);
        this.startInvite("Lucifer", INVITEE_LASTNAME, inviteeEmailAddr, INVITEE_SITE_ROLE, SITE_SHORT_NAME_INVITE_1, 201);
    }

    public void testStartInviteForSameInviteeButTwoDifferentSites() throws Exception {
        String inviteeUsername = "InviteeFirstName_InviteeLastName";
        final String inviteeEmail = INVITEE_EMAIL_PREFIX + RandomStringUtils.randomAlphanumeric((int)6) + "@alfrescotesting.com";
        AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Object>(){

            public Object doWork() throws Exception {
                InviteServiceTest.this.createPerson(InviteServiceTest.INVITEE_FIRSTNAME, InviteServiceTest.INVITEE_LASTNAME, "InviteeFirstName_InviteeLastName", inviteeEmail);
                return null;
            }
        }, (String)AuthenticationUtil.getSystemUserName());
        JSONObject result = this.startInvite(INVITEE_FIRSTNAME, INVITEE_LASTNAME, inviteeEmail, INVITEE_SITE_ROLE, SITE_SHORT_NAME_INVITE_1, 201);
        this.startInvite(INVITEE_FIRSTNAME, INVITEE_LASTNAME, inviteeEmail, INVITEE_SITE_ROLE, SITE_SHORT_NAME_INVITE_2, 201);
    }

    public void testCancelInvite() throws Exception {
        JSONObject result = this.startInvite(INVITEE_FIRSTNAME, INVITEE_LASTNAME, INVITEE_SITE_ROLE, SITE_SHORT_NAME_INVITE_1, 201);
        JSONObject data = result.getJSONObject("data");
        String inviteId = data.getString("inviteId");
        this.cancelInvite(inviteId, SITE_SHORT_NAME_INVITE_1, 200);
    }

    public void testCancelInviteWithDifferentSiteIDInRequest() throws Exception {
        JSONObject result = this.startInvite(INVITEE_FIRSTNAME, INVITEE_LASTNAME, INVITEE_SITE_ROLE, SITE_SHORT_NAME_INVITE_1, 201);
        JSONObject data = result.getJSONObject("data");
        String inviteId = data.getString("inviteId");
        this.cancelInvite(inviteId, SITE_SHORT_NAME_INVITE_2, 403);
    }

    public void testCancelInviteWithInvalidInviteID() throws Exception {
        this.cancelInvite("activiti$1019999", SITE_SHORT_NAME_INVITE_1, 404);
    }

    public void testAcceptInvite() throws Exception {
        JSONObject result = this.startInvite(INVITEE_FIRSTNAME, INVITEE_LASTNAME, INVITEE_SITE_ROLE, SITE_SHORT_NAME_INVITE_1, 201);
        JSONObject data = result.getJSONObject("data");
        String inviteId = data.getString("inviteId");
        String inviteTicket = data.getString("inviteTicket");
        String acceptInviteUrl = "/api/invite/" + inviteId + "/" + inviteTicket + "/accept";
        this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.PutRequest(acceptInviteUrl, (byte[])null, null), 200);
        this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.PutRequest(acceptInviteUrl, (byte[])null, null), 409);
        this.rejectInvite(inviteId, inviteTicket, 409);
        this.authenticationComponent.setCurrentUser(USER_INVITER);
        JSONObject getInvitesResult = this.getInvitesByInviteId(inviteId, 200);
    }

    public void testRejectInvite() throws Exception {
        JSONObject result = this.startInvite(INVITEE_FIRSTNAME, INVITEE_LASTNAME, INVITEE_SITE_ROLE, SITE_SHORT_NAME_INVITE_1, 201);
        JSONObject data = result.getJSONObject("data");
        String inviteId = data.getString("inviteId");
        String inviteTicket = data.getString("inviteTicket");
        this.rejectInvite(inviteId, inviteTicket, 200);
        this.rejectInvite(inviteId, inviteTicket, 409);
        this.authenticationComponent.setCurrentUser(USER_INVITER);
        JSONObject getInvitesResult = this.getInvitesByInviteId(inviteId, 200);
    }

    public void testGetInvitationStatus() throws Exception {
        for (String invitationStatus : new String[]{"rejected", "accepted"}) {
            JSONObject result = this.startInvite(INVITEE_FIRSTNAME, INVITEE_LASTNAME, INVITEE_SITE_ROLE, SITE_SHORT_NAME_INVITE_1, 201);
            JSONObject data = result.getJSONObject("data");
            String inviteId = data.getString("inviteId");
            String inviteTicket = data.getString("inviteTicket");
            String inviteeUserName = data.getString("inviteeUserName");
            result = this.getInviteInfo(inviteId, inviteTicket, inviteeUserName);
            String status = result.getJSONObject("invite").getString("invitationStatus");
            InviteServiceTest.assertEquals((String)status, (String)"pending");
            if (invitationStatus.equals("rejected")) {
                this.rejectInvite(inviteId, inviteTicket, 200);
            } else if (invitationStatus.equals("accepted")) {
                String acceptInviteUrl = "/api/invite/" + inviteId + "/" + inviteTicket + "/accept";
                this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.PutRequest(acceptInviteUrl, (byte[])null, null), 200);
            } else {
                InviteServiceTest.fail();
            }
            result = this.getInviteInfo(inviteId, inviteTicket, inviteeUserName);
            status = result.getJSONObject("invite").getString("invitationStatus");
            InviteServiceTest.assertEquals((String)status, (String)invitationStatus);
        }
    }

    public void testGetInvitesByInviteId() throws Exception {
        JSONObject result = this.startInvite(INVITEE_FIRSTNAME, INVITEE_LASTNAME, INVITEE_SITE_ROLE, SITE_SHORT_NAME_INVITE_1, 201);
        JSONObject data = result.getJSONObject("data");
        String inviteId = data.getString("inviteId");
        InviteServiceTest.assertEquals((boolean)true, (inviteId != null && inviteId.length() != 0 ? 1 : 0) != 0);
        JSONObject getInvitesResult = this.getInvitesByInviteId(inviteId, 200);
        InviteServiceTest.assertEquals((int)getInvitesResult.getJSONArray("invites").length(), (int)1);
        JSONObject inviteJSONObj = getInvitesResult.getJSONArray("invites").getJSONObject(0);
        InviteServiceTest.assertEquals((Object)inviteId, (Object)inviteJSONObj.get("inviteId"));
    }

    public void testGetInvitesByInviterUserName() throws Exception {
        this.startInvite(INVITEE_FIRSTNAME, INVITEE_LASTNAME, INVITEE_SITE_ROLE, SITE_SHORT_NAME_INVITE_1, 201);
        JSONObject getInvitesResult = this.getInvitesByInviterUserName(USER_INVITER, 200);
        InviteServiceTest.assertEquals((boolean)true, (getInvitesResult.length() > 0 ? 1 : 0) != 0);
        JSONObject inviteJSONObj = getInvitesResult.getJSONArray("invites").getJSONObject(0);
        InviteServiceTest.assertEquals((Object)USER_INVITER, (Object)inviteJSONObj.getJSONObject("inviter").get("userName"));
    }

    public void testGetInvitesByInviteeUserName() throws Exception {
        JSONObject result = this.startInvite(INVITEE_FIRSTNAME, INVITEE_LASTNAME, INVITEE_SITE_ROLE, SITE_SHORT_NAME_INVITE_1, 201);
        JSONObject data = result.getJSONObject("data");
        String inviteeUserName = data.getString("inviteeUserName");
        InviteServiceTest.assertEquals((boolean)true, (inviteeUserName != null && inviteeUserName.length() != 0 ? 1 : 0) != 0);
        JSONObject getInvitesResult = this.getInvitesByInviteeUserName(inviteeUserName, 200);
        InviteServiceTest.assertEquals((boolean)true, (getInvitesResult.length() > 0 ? 1 : 0) != 0);
        JSONObject inviteJSONObj = getInvitesResult.getJSONArray("invites").getJSONObject(0);
        InviteServiceTest.assertEquals((Object)inviteeUserName, (Object)inviteJSONObj.getJSONObject(INVITEE_EMAIL_PREFIX).get("userName"));
    }

    public void testGetInvitesBySiteShortName() throws Exception {
        JSONObject result = this.startInvite(INVITEE_FIRSTNAME, INVITEE_LASTNAME, INVITEE_SITE_ROLE, SITE_SHORT_NAME_INVITE_1, 201);
        JSONObject data = result.getJSONObject("data");
        String siteShortName = data.getString("resourceName");
        InviteServiceTest.assertEquals((boolean)true, (siteShortName != null && siteShortName.length() != 0 ? 1 : 0) != 0);
        JSONObject getInvitesResult = this.getInvitesBySiteShortName(siteShortName, 200);
        InviteServiceTest.assertEquals((boolean)true, (getInvitesResult.getJSONArray("invites").length() > 0 ? 1 : 0) != 0);
        JSONObject inviteJSONObj = getInvitesResult.getJSONArray("invites").getJSONObject(0);
        InviteServiceTest.assertEquals((Object)siteShortName, (Object)inviteJSONObj.getJSONObject("site").get("shortName"));
    }

    public void testStartInviteForbiddenWhenInviterNotSiteManager() throws Exception {
        AuthenticationUtil.setFullyAuthenticatedUser((String)USER_INVITER_2);
        this.startInvite(INVITEE_FIRSTNAME, INVITEE_LASTNAME, INVITEE_SITE_ROLE, SITE_SHORT_NAME_INVITE_3, 403);
    }

    public void testCancelInviteForbiddenWhenInviterNotSiteManager() throws Exception {
        JSONObject result = this.startInvite(INVITEE_FIRSTNAME, INVITEE_LASTNAME, INVITEE_SITE_ROLE, SITE_SHORT_NAME_INVITE_3, 201);
        JSONObject data = result.getJSONObject("data");
        String inviteId = data.getString("inviteId");
        AuthenticationUtil.setFullyAuthenticatedUser((String)USER_INVITER_2);
        this.cancelInvite(inviteId, SITE_SHORT_NAME_INVITE_3, 403);
    }

    public void testInviteeResourcesDeletedUponRejectWhenNoInvitePending() throws Exception {
        JSONObject result = this.startInvite(INVITEE_FIRSTNAME, INVITEE_LASTNAME, INVITEE_SITE_ROLE, SITE_SHORT_NAME_INVITE_1, 201);
        JSONObject data = result.getJSONObject("data");
        String inviteId = data.getString("inviteId");
        String inviteTicket = data.getString("inviteTicket");
        final String inviteeUserName = data.getString("inviteeUserName");
        this.rejectInvite(inviteId, inviteTicket, 200);
        AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Void>(){

            public Void doWork() throws Exception {
                InviteServiceTest.this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

                    public Void execute() throws Throwable {
                        TestCase.assertEquals((boolean)false, (boolean)InviteServiceTest.this.mutableAuthenticationDao.userExists(inviteeUserName));
                        TestCase.assertEquals((boolean)false, (boolean)InviteServiceTest.this.personService.personExists(inviteeUserName));
                        return null;
                    }
                });
                return null;
            }
        }, (String)AuthenticationUtil.getSystemUserName());
    }

    public void testInviteeResourcesNotDeletedUponRejectWhenInvitesPending() throws Exception {
        this.invitationServiceImpl.setNominatedInvitationWorkflowId(WF_DEFINITION_INVITE);
        final String inviteeEmail = INVITEE_EMAIL_PREFIX + RandomStringUtils.randomAlphanumeric((int)6) + "@alfrescotesting.com";
        AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Object>(){

            public Object doWork() throws Exception {
                InviteServiceTest.this.createPerson(InviteServiceTest.INVITEE_FIRSTNAME, InviteServiceTest.INVITEE_LASTNAME, "InviteeFirstName_InviteeLastName", inviteeEmail);
                return null;
            }
        }, (String)AuthenticationUtil.getSystemUserName());
        JSONObject result = this.startInvite(INVITEE_FIRSTNAME, INVITEE_LASTNAME, inviteeEmail, INVITEE_SITE_ROLE, SITE_SHORT_NAME_INVITE_1, 201);
        JSONObject data = result.getJSONObject("data");
        String invite1Id = data.getString("inviteId");
        String invite1Ticket = data.getString("inviteTicket");
        final String inviteeUserName = data.getString("inviteeUserName");
        this.startInvite(INVITEE_FIRSTNAME, INVITEE_LASTNAME, inviteeEmail, INVITEE_SITE_ROLE, SITE_SHORT_NAME_INVITE_2, 201);
        this.rejectInvite(invite1Id, invite1Ticket, 200);
        boolean inviteeUserExists = (Boolean)AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Boolean>(){

            public Boolean doWork() throws Exception {
                RetryingTransactionHelper tranHelper = InviteServiceTest.this.transactionService.getRetryingTransactionHelper();
                Boolean result = (Boolean)tranHelper.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Boolean>(){

                    public Boolean execute() throws Throwable {
                        Boolean result = InviteServiceTest.this.mutableAuthenticationDao.userExists(inviteeUserName);
                        return result;
                    }
                });
                return result;
            }
        }, (String)AuthenticationUtil.getSystemUserName());
        InviteServiceTest.assertEquals((boolean)true, (boolean)inviteeUserExists);
        boolean inviteePersonExists = (Boolean)AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Boolean>(){

            public Boolean doWork() throws Exception {
                Boolean result = InviteServiceTest.this.personService.personExists(inviteeUserName);
                return result;
            }
        }, (String)AuthenticationUtil.getSystemUserName());
        InviteServiceTest.assertEquals((boolean)true, (boolean)inviteePersonExists);
        this.invitationServiceImpl.setNominatedInvitationWorkflowId("activiti$activitiInvitationNominatedAddDirect");
    }

    public void testETHREEOH_520() throws Exception {
        final String userName = "userInviteServiceTest" + GUID.generate();
        String emailAddress = " ";
        AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Object>(){

            public Object doWork() throws Exception {
                InviteServiceTest.this.createPerson(PERSON_FIRSTNAME, PERSON_LASTNAME, userName, " ");
                return null;
            }
        }, (String)AuthenticationUtil.getSystemUserName());
        this.startInvite(PERSON_FIRSTNAME, PERSON_LASTNAME, " ", INVITEE_SITE_ROLE, SITE_SHORT_NAME_INVITE_1, 400);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Category(value={RedundantTests.class})
    public void testMNT9905() throws Exception {
        String[] managerUsersArr = new String[]{"user1", "user2"};
        String[] allUsersArr = new String[]{"user1", "user2", "user3", "user4"};
        String collaborator = "user3";
        try {
            int n;
            String[] stringArray = allUsersArr;
            int n2 = stringArray.length;
            for (n = 0; n < n2; ++n) {
                String user;
                final String userName = user = stringArray[n];
                AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Object>(){

                    public Object doWork() throws Exception {
                        InviteServiceTest.this.createPerson(userName, userName, userName, "");
                        return null;
                    }
                }, (String)AuthenticationUtil.getSystemUserName());
            }
            stringArray = managerUsersArr;
            n2 = stringArray.length;
            for (n = 0; n < n2; ++n) {
                String manager;
                String manag = manager = stringArray[n];
                this.startInvite(manag, manag, "SiteManager", SITE_SHORT_NAME_INVITE_1, 201);
                this.siteService.setMembership(SITE_SHORT_NAME_INVITE_1, manag, "SiteManager");
            }
            this.authenticationComponent.setCurrentUser(managerUsersArr[0]);
            JSONObject collInv = this.startInvite(collaborator, collaborator, INVITEE_SITE_ROLE, SITE_SHORT_NAME_INVITE_1, 201);
            this.siteService.setMembership(SITE_SHORT_NAME_INVITE_1, collaborator, INVITEE_SITE_ROLE);
            this.authenticationComponent.setCurrentUser(managerUsersArr[1]);
            JSONObject getInvitesResult = this.getInvitesBySiteShortName(SITE_SHORT_NAME_INVITE_1, 200);
            InviteServiceTest.assertEquals((boolean)true, (getInvitesResult.length() == 1 ? 1 : 0) != 0);
            JSONObject userList = this.listInvitations(SITE_SHORT_NAME_INVITE_1, "user", 200);
            JSONArray inviteJSONArr = userList.getJSONArray("people");
            ArrayList<String> siteUsers = new ArrayList<String>();
            for (int i = 0; i < inviteJSONArr.length(); ++i) {
                String role;
                String userName = (String)inviteJSONArr.getJSONObject(i).get("userName");
                if (userName == null || (role = this.siteService.getMembersRole(SITE_SHORT_NAME_INVITE_1, userName)) == null) continue;
                siteUsers.add(userName);
            }
            InviteServiceTest.assertEquals((int)4, (int)siteUsers.size());
            JSONObject data = collInv.getJSONObject("data");
            String inviteId = (String)data.get("inviteId");
            this.cancelInvite(inviteId, SITE_SHORT_NAME_INVITE_1, 200);
        }
        finally {
            AuthenticationUtil.setRunAsUserSystem();
            for (String user : allUsersArr) {
                this.deletePersonByUserName(user);
            }
            this.deletePersonByUserName(collaborator);
        }
    }

    @Test
    public void testDontOwerrideModeratedSitePermissions() throws Exception {
        String MODERATED_SITE_NAME = RandomStringUtils.randomAlphabetic((int)6);
        final String siteManager = RandomStringUtils.randomAlphabetic((int)6);
        final String secondUser = RandomStringUtils.randomAlphabetic((int)6);
        AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Object>(){

            public Object doWork() throws Exception {
                InviteServiceTest.this.createPerson(siteManager, siteManager, siteManager, "");
                InviteServiceTest.this.createPerson(secondUser, secondUser, secondUser, "");
                return null;
            }
        }, (String)AuthenticationUtil.getSystemUserName());
        SiteInfo siteInfo = this.siteService.getSite(MODERATED_SITE_NAME);
        if (siteInfo == null) {
            this.siteService.createSite("InviteSitePreset", MODERATED_SITE_NAME, MODERATED_SITE_NAME, MODERATED_SITE_NAME, SiteVisibility.MODERATED);
        }
        this.siteService.setMembership(MODERATED_SITE_NAME, siteManager, "SiteManager");
        String role = this.siteService.getMembersRole(MODERATED_SITE_NAME, siteManager);
        InviteServiceTest.assertEquals((String)"SiteManager", (String)role);
        String inviteId = this.createModeratedInvitation(MODERATED_SITE_NAME, "", secondUser, "SiteConsumer");
        this.siteService.setMembership(MODERATED_SITE_NAME, secondUser, INVITEE_SITE_ROLE);
        role = this.siteService.getMembersRole(MODERATED_SITE_NAME, secondUser);
        InviteServiceTest.assertEquals((String)INVITEE_SITE_ROLE, (String)role);
        String taskId = this.getTaskId(inviteId);
        InviteServiceTest.assertNotNull((String)"Cannot find taskId", (Object)taskId);
        String oldUser = AuthenticationUtil.getFullyAuthenticatedUser();
        AuthenticationUtil.setFullyAuthenticatedUser((String)siteManager);
        this.workflowService.endTask(taskId, "approve");
        AuthenticationUtil.setFullyAuthenticatedUser((String)oldUser);
        role = this.siteService.getMembersRole(MODERATED_SITE_NAME, secondUser);
        InviteServiceTest.assertEquals((String)INVITEE_SITE_ROLE, (String)role);
    }

    private String createModeratedInvitation(String siteName, String inviteeComments, String inviteeUserName, String inviteeRoleName) throws Exception {
        String URL_SITES = URL_SITES;
        JSONObject newInvitation = new JSONObject();
        newInvitation.put("invitationType", (Object)"MODERATED");
        newInvitation.put("inviteeRoleName", (Object)inviteeRoleName);
        newInvitation.put("inviteeComments", (Object)inviteeComments);
        newInvitation.put("inviteeUserName", (Object)inviteeUserName);
        TestWebScriptServer.Response response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.PostRequest(URL_SITES + "/" + siteName + "/invitations", newInvitation.toString(), "application/json"), 201);
        JSONObject top = new JSONObject(response.getContentAsString());
        JSONObject data = top.getJSONObject("data");
        String inviteId = data.getString("inviteId");
        return inviteId;
    }

    private String getTaskId(String inviteId) throws Exception {
        String url = "/api/task-instances";
        TestWebScriptServer.Response response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest(url), 200);
        JSONObject top = new JSONObject(response.getContentAsString());
        JSONArray data = top.getJSONArray("data");
        for (int i = 0; i < data.length(); ++i) {
            JSONObject task = data.getJSONObject(i);
            JSONObject workflowInstance = task.getJSONObject("workflowInstance");
            if (!inviteId.equalsIgnoreCase(workflowInstance.getString("id"))) continue;
            return task.getString("id");
        }
        return null;
    }
}

