/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.framework.jacksonextensions;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import java.io.IOException;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.StoreRef;

public class NodeRefDeserializer
extends JsonDeserializer<NodeRef> {
    private NodeRef getNodeRef(String nodeRefString) {
        NodeRef nodeRef = null;
        nodeRef = !NodeRef.isNodeRef((String)nodeRefString) ? new NodeRef(StoreRef.STORE_REF_WORKSPACE_SPACESSTORE, nodeRefString) : new NodeRef(nodeRefString);
        return nodeRef;
    }

    public NodeRef deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        JsonToken curr = jp.getCurrentToken();
        if (curr == JsonToken.VALUE_STRING) {
            String nodeRefString = jp.getText();
            NodeRef nodeRef = this.getNodeRef(nodeRefString);
            return nodeRef;
        }
        throw new IOException("Unable to deserialize nodeRef: " + curr.asString());
    }
}

