/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.api.tests;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.Map;
import java.util.function.Consumer;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.alfresco.repo.tenant.TenantUtil;
import org.alfresco.rest.api.Nodes;
import org.alfresco.rest.api.model.AssocChild;
import org.alfresco.rest.api.model.Download;
import org.alfresco.rest.api.nodes.NodesEntityResource;
import org.alfresco.rest.api.tests.AbstractBaseApiTest;
import org.alfresco.rest.api.tests.client.HttpResponse;
import org.alfresco.rest.api.tests.client.PublicApiException;
import org.alfresco.rest.api.tests.client.data.Document;
import org.alfresco.rest.api.tests.client.data.Folder;
import org.alfresco.rest.api.tests.util.RestApiUtil;
import org.alfresco.rest.framework.core.exceptions.ApiException;
import org.alfresco.service.cmr.download.DownloadStatus;
import org.alfresco.service.cmr.site.SiteVisibility;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.junit.Assert;
import org.junit.Before;
import org.junit.FixMethodOrder;
import org.junit.Test;
import org.junit.runners.MethodSorters;

@FixMethodOrder(value=MethodSorters.NAME_ASCENDING)
public class TestDownloads
extends AbstractBaseApiTest {
    private static Log logger = LogFactory.getLog(TestDownloads.class);
    private static final int NUMBER_OF_TIMES_TO_RETRY_TEST_CANCEL_STATUS = 5;
    private static final int STATUS_CHECK_SLEEP_TIME = 5;
    private static final int NUMBER_OF_TIMES_TO_CHECK_STATUS = 200;
    public static final String NODES_SECONDARY_CHILDREN = "nodes/%s/secondary-children";
    public static final String API_DOWNLOADS = "downloads";
    private static final String DOC4_NAME = "docTest4.txt";
    private static final String SUB_FOLDER1_NAME = "subFolder1";
    private static final String DOC3_NAME = "docTest3.txt";
    private static final String FOLDER1_NAME = "folder1";
    private static final String FOLDER3_NAME = "folder3";
    private static final String ZIPPABLE_DOC1_NAME = "docTest1.txt";
    private static final String DUMMY_CONTENT = "dummy content";
    private Nodes nodesApi;
    private String zippableDocId1;
    private String zippableDocId2;
    private String zippableDocId3_InFolder1;
    private String zippableFolderId1;
    private String zippableFolderId2_InFolder1;
    private String zippableDocId4_InFolder2;
    private String zippableFolderId3;
    private String zippableDoc_user2;

    @Before
    public void setupTest() throws IOException, Exception {
        this.nodesApi = (Nodes)this.applicationContext.getBean("Nodes", Nodes.class);
        this.setRequestContext(user1);
        Document zippableDoc1 = this.createTextFile(tDocLibNodeId, ZIPPABLE_DOC1_NAME, DUMMY_CONTENT);
        this.zippableDocId1 = zippableDoc1.getId();
        this.zippableDocId2 = this.createTextFile(tDocLibNodeId, "docTest2", DUMMY_CONTENT).getId();
        Folder zippableFolder1 = this.createFolder(tDocLibNodeId, FOLDER1_NAME);
        this.zippableFolderId1 = zippableFolder1.getId();
        this.zippableDocId3_InFolder1 = this.createTextFile(this.zippableFolderId1, DOC3_NAME, DUMMY_CONTENT).getId();
        Folder zippableFolder2_InFolder1 = this.createFolder(this.zippableFolderId1, SUB_FOLDER1_NAME);
        this.zippableFolderId2_InFolder1 = zippableFolder2_InFolder1.getId();
        this.zippableDocId4_InFolder2 = this.createTextFile(this.zippableFolderId2_InFolder1, DOC4_NAME, DUMMY_CONTENT).getId();
        Folder zippableFolder3 = this.createFolder(tDocLibNodeId, FOLDER3_NAME);
        this.zippableFolderId3 = zippableFolder3.getId();
        this.setRequestContext(user2);
        String user2Site = this.createSite("TestSite B - " + this.RUNID, SiteVisibility.PRIVATE).getId();
        String user2DocLib = this.getSiteContainerNodeId(user2Site, "documentLibrary");
        this.zippableDoc_user2 = this.createTextFile(user2DocLib, "user2doc", DUMMY_CONTENT).getId();
        this.setRequestContext(user1);
        AssocChild secChild = new AssocChild(zippableDoc1.getId(), "cm:contains");
        this.post(String.format(NODES_SECONDARY_CHILDREN, zippableFolder3.getId()), RestApiUtil.toJsonAsStringNonNull(secChild), 201);
    }

    @Test
    public void test001CreateDownload() throws Exception {
        Download download = this.createDownload(202, this.zippableDocId1);
        this.assertPendingDownloadProps(download);
        this.assertValidZipNodeid(download);
        this.assertDoneDownload(download, 1, 13);
        download = this.createDownload(202, this.zippableDocId1, this.zippableDocId2);
        this.assertPendingDownloadProps(download);
        this.assertValidZipNodeid(download);
        this.assertDoneDownload(download, 2, 26);
        this.createDownload(400, new String[0]);
        download = this.createDownload(400, this.zippableDocId1, this.zippableDocId1);
        download = this.createDownload(202, this.zippableFolderId1, this.zippableDocId3_InFolder1);
        this.assertPendingDownloadProps(download);
        this.assertValidZipNodeid(download);
        this.assertDoneDownload(download, 3, 39);
        download = this.createDownload(202, this.zippableDocId1, this.zippableFolderId3);
        this.assertPendingDownloadProps(download);
        this.assertValidZipNodeid(download);
        this.assertDoneDownload(download, 2, 26);
        download = this.createDownload(403, this.zippableDocId1, this.zippableDoc_user2);
    }

    @Test
    public void test002GetDownloadInfo() throws Exception {
        Download download = this.createDownload(202, this.zippableFolderId1, this.zippableFolderId2_InFolder1, this.zippableDocId4_InFolder2);
        this.assertInProgressDownload(download, 4, 52);
        this.assertDoneDownload(download, 4, 52);
        this.cancelWithRetry(() -> {
            Download downloadToBeCancelled = this.createDownload(202, this.zippableFolderId1, this.zippableDocId3_InFolder1);
            this.cancel(downloadToBeCancelled.getId());
            this.assertCancelledDownload(downloadToBeCancelled, 3, 39);
        });
    }

    @Test
    public void test003CancelDownload() throws Exception {
        this.cancelWithRetry(() -> {
            Download download = this.createDownload(202, this.zippableFolderId1, this.zippableDocId3_InFolder1, this.zippableDocId1, this.zippableDocId2);
            this.cancel(download.getId());
            this.assertCancelledDownload(download, 5, 65);
        });
        Download download = this.createDownload(202, this.zippableDocId1, this.zippableDocId2);
        this.assertDoneDownload(download, 2, 26);
        this.cancel(download.getId());
        Thread.sleep(500L);
        Download downloadStatus = this.getDownload(download.getId());
        Assert.assertTrue((String)"A cancel operation on a DONE download has no effect.", (boolean)downloadStatus.getStatus().equals((Object)DownloadStatus.Status.DONE));
        this.cancel(400, this.zippableDocId1);
        download = this.createDownload(202, this.zippableDocId1);
        this.setRequestContext(user2);
        this.cancel(403, download.getId());
    }

    @Test
    public void test004GetDownloadContent() throws Exception {
        Download download = this.createDownload(202, this.zippableDocId1);
        this.assertDoneDownload(download, 1, 13);
        HttpResponse response = this.downloadContent(download);
        ZipInputStream zipStream = this.getZipStreamFromResponse(response);
        ZipEntry zipEntry = zipStream.getNextEntry();
        Assert.assertEquals((String)"Zip entry name is not correct", (Object)ZIPPABLE_DOC1_NAME, (Object)zipEntry.getName());
        Assert.assertTrue((String)"Zip entry size is not correct", (zipEntry.getCompressedSize() <= 13L ? 1 : 0) != 0);
        Assert.assertTrue((String)"No more entries should be in this zip", (zipStream.getNextEntry() == null ? 1 : 0) != 0);
        zipStream.close();
        Map<String, String> responseHeaders = response.getHeaders();
        Assert.assertNotNull(responseHeaders);
        Assert.assertEquals((Object)String.format("attachment; filename=\"%s\"; filename*=UTF-8''%s", "docTest1.txt.zip", "docTest1.txt.zip"), (Object)responseHeaders.get("Content-Disposition"));
        download = this.createDownload(202, this.zippableFolderId1, this.zippableDocId3_InFolder1);
        this.assertDoneDownload(download, 3, 39);
        response = this.downloadContent(download);
        zipStream = this.getZipStreamFromResponse(response);
        Assert.assertEquals((String)"Zip entry name is not correct", (Object)"folder1/", (Object)zipStream.getNextEntry().getName());
        Assert.assertEquals((String)"Zip entry name is not correct", (Object)"folder1/docTest3.txt", (Object)zipStream.getNextEntry().getName());
        Assert.assertEquals((String)"Zip entry name is not correct", (Object)"folder1/subFolder1/", (Object)zipStream.getNextEntry().getName());
        Assert.assertEquals((String)"Zip entry name is not correct", (Object)"folder1/subFolder1/docTest4.txt", (Object)zipStream.getNextEntry().getName());
        Assert.assertEquals((String)"Zip entry name is not correct", (Object)DOC3_NAME, (Object)zipStream.getNextEntry().getName());
        Assert.assertTrue((String)"No more entries should be in this zip", (zipStream.getNextEntry() == null ? 1 : 0) != 0);
        zipStream.close();
        responseHeaders = response.getHeaders();
        Assert.assertNotNull(responseHeaders);
        Assert.assertEquals((Object)String.format("attachment; filename=\"%s\"; filename*=UTF-8''%s", "archive.zip", "archive.zip"), (Object)responseHeaders.get("Content-Disposition"));
        download = this.createDownload(202, this.zippableDocId1, this.zippableFolderId3);
        this.assertDoneDownload(download, 2, 26);
        response = this.downloadContent(download);
        zipStream = this.getZipStreamFromResponse(response);
        Assert.assertEquals((String)"Zip entry name is not correct", (Object)ZIPPABLE_DOC1_NAME, (Object)zipStream.getNextEntry().getName());
        Assert.assertEquals((String)"Zip entry name is not correct", (Object)"folder3/", (Object)zipStream.getNextEntry().getName());
        Assert.assertEquals((String)"Zip entry name is not correct", (Object)"folder3/docTest1.txt", (Object)zipStream.getNextEntry().getName());
        Assert.assertTrue((String)"No more entries should be in this zip", (zipStream.getNextEntry() == null ? 1 : 0) != 0);
    }

    @Test
    public void test005DeleteDownloadNode() throws Exception {
        Download download = this.createDownload(202, this.zippableDocId1);
        this.assertDoneDownload(download, 1, 13);
        this.deleteNode(download.getId(), true, 204);
        this.getDownload(download.getId(), 404);
        download = this.createDownload(202, this.zippableDocId1);
        this.assertDoneDownload(download, 1, 13);
        this.setRequestContext(user2);
        this.deleteNode(download.getId(), true, 403);
        this.setRequestContext(user1);
        this.assertDoneDownload(download, 1, 13);
        this.setRequestContext(user2);
        this.getDownload(download.getId(), 403);
    }

    protected ZipInputStream getZipStreamFromResponse(HttpResponse response) {
        return new ZipInputStream(new ByteArrayInputStream(response.getResponseAsBytes()));
    }

    protected HttpResponse downloadContent(Download download) throws Exception {
        return this.getSingle(NodesEntityResource.class, download.getId() + "/content", null, 200);
    }

    private void cancelWithRetry(CancelAction cancelAction) throws Exception {
        for (int i = 0; i <= 5; ++i) {
            if (i == 5) {
                logger.error((Object)"Did not manage to test the cancel status, the download node gets to the DONE status too fast.");
            }
            try {
                cancelAction.run();
                continue;
            }
            catch (DownloadAlreadyDoneException e) {
                // empty catch block
            }
        }
    }

    private void assertDoneDownload(Download download, int expectedFilesAdded, int expectedTotal) throws Exception, InterruptedException {
        this.assertExpectedStatus(DownloadStatus.Status.DONE, download, "Download should be DONE by now.", downloadStatus -> {
            Assert.assertTrue((String)"The number of bytes added in the archive does not match the total", (downloadStatus.getBytesAdded() == downloadStatus.getTotalBytes() ? 1 : 0) != 0);
            Assert.assertEquals((String)("The number of files added in the archive should be " + expectedFilesAdded), (long)expectedFilesAdded, (long)downloadStatus.getFilesAdded());
            Assert.assertEquals((String)("The total number of bytes should be " + expectedTotal), (long)expectedTotal, (long)downloadStatus.getTotalBytes());
            Assert.assertEquals((String)("The total number of files of the final archive should be " + expectedFilesAdded), (long)expectedFilesAdded, (long)downloadStatus.getTotalFiles());
        }, null, null);
    }

    protected void assertCancelledDownload(Download download, int expectedTotalFiles, int expectedTotal) throws PublicApiException, Exception, InterruptedException {
        this.assertExpectedStatus(DownloadStatus.Status.CANCELLED, download, "Download should be CANCELLED by now.", downloadStatus -> {
            Assert.assertTrue((String)"The total bytes added to the archive by now should be greater than 0", (downloadStatus.getBytesAdded() > 0L && downloadStatus.getBytesAdded() <= downloadStatus.getTotalBytes() ? 1 : 0) != 0);
            Assert.assertTrue((String)"The download has been cancelled, there should still be files to be added.", (downloadStatus.getFilesAdded() < downloadStatus.getTotalFiles() ? 1 : 0) != 0);
            Assert.assertEquals((String)("The total number of bytes should be " + expectedTotal), (long)expectedTotal, (long)downloadStatus.getTotalBytes());
            Assert.assertEquals((String)("The total number of files to be added to the archive should be " + expectedTotalFiles), (long)expectedTotalFiles, (long)downloadStatus.getTotalFiles());
        }, DownloadStatus.Status.DONE, downloadStatus -> {
            throw new DownloadAlreadyDoneException();
        });
    }

    private void assertInProgressDownload(Download download, int expectedTotalFiles, int expectedTotal) throws Exception, InterruptedException {
        this.assertExpectedStatus(DownloadStatus.Status.IN_PROGRESS, download, "Download creation is taking too long.Download status should be at least IN_PROGRESS by now.", downloadStatus -> {
            Assert.assertTrue((String)"The total bytes added to the archive by now should be greater than 0", (downloadStatus.getBytesAdded() > 0L && downloadStatus.getBytesAdded() <= downloadStatus.getTotalBytes() ? 1 : 0) != 0);
            Assert.assertTrue((String)"The download is in progress, there should still be files to be added.", (downloadStatus.getFilesAdded() < downloadStatus.getTotalFiles() ? 1 : 0) != 0);
            Assert.assertEquals((String)("The total number of bytes should be " + expectedTotal), (long)expectedTotal, (long)downloadStatus.getTotalBytes());
            Assert.assertEquals((String)("The total number of files to be added to the archive should be " + expectedTotalFiles), (long)expectedTotalFiles, (long)downloadStatus.getTotalFiles());
        }, DownloadStatus.Status.DONE, downloadStatus -> {
            try {
                this.assertDoneDownload(download, expectedTotalFiles, expectedTotal);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        });
    }

    private void assertExpectedStatus(DownloadStatus.Status expectedStatus, Download download, String failMessage, Consumer<Download> assertionsToDo, DownloadStatus.Status alternateExpectedStatus, Consumer<Download> alternateAssertionsToDo) throws Exception {
        for (int i = 0; i <= 200; ++i) {
            if (i == 200) {
                Assert.fail((String)failMessage);
            }
            Download downloadStatus = this.getDownload(download.getId());
            if (alternateExpectedStatus != null && downloadStatus.getStatus().equals((Object)alternateExpectedStatus)) {
                alternateAssertionsToDo.accept(downloadStatus);
                break;
            }
            if (downloadStatus.getStatus().equals((Object)expectedStatus)) {
                assertionsToDo.accept(downloadStatus);
                break;
            }
            Thread.sleep(5L);
        }
    }

    @Override
    protected void setRequestContext(String user) {
        this.setRequestContext(networkOne.getId(), user, null);
    }

    private void assertValidZipNodeid(final Download download) {
        try {
            TenantUtil.runAsUserTenant((TenantUtil.TenantRunAsWork)new TenantUtil.TenantRunAsWork<Void>(){

                public Void doWork() throws Exception {
                    TestDownloads.this.nodesApi.validateNode(download.getId());
                    return null;
                }
            }, (String)user1, (String)networkOne.getId());
        }
        catch (ApiException ex) {
            Assert.fail((String)("The download nodeid is not valid." + ex.getMessage()));
        }
    }

    private void assertPendingDownloadProps(Download download) {
        Assert.assertEquals((String)"The download request hasn't been processed yet, the status is not correct", (Object)DownloadStatus.Status.PENDING, (Object)download.getStatus());
        Assert.assertEquals((String)"Should be 0, the download req hasn't been processed yet", (long)0L, (long)download.getBytesAdded());
        Assert.assertEquals((String)"Should be 0, the download req hasn't been processed yet", (long)0L, (long)download.getFilesAdded());
        Assert.assertEquals((String)"Should be 0, the download req hasn't been processed yet", (long)0L, (long)download.getTotalBytes());
        Assert.assertEquals((String)"Should be 0, the download req hasn't been processed yet", (long)0L, (long)download.getTotalFiles());
    }

    @Override
    public String getScope() {
        return "public";
    }

    private Download createDownload(int expectedStatus, String ... nodeIds) throws Exception {
        Download downloadRequest = new Download();
        downloadRequest.setNodeIds(Arrays.asList(nodeIds));
        this.setRequestContext(user1);
        Download download = this.create(downloadRequest, expectedStatus);
        return download;
    }

    public Download create(Download download, int expectedStatus) throws Exception {
        HttpResponse response = this.post(API_DOWNLOADS, RestApiUtil.toJsonAsStringNonNull(download), expectedStatus);
        return this.getDownloadFromResponse(response);
    }

    public Download getDownload(String downloadId, int expectedStatus) throws Exception {
        HttpResponse response = this.getSingle(API_DOWNLOADS, downloadId, expectedStatus);
        return this.getDownloadFromResponse(response);
    }

    public Download getDownload(String downloadId) throws Exception {
        return this.getDownload(downloadId, 200);
    }

    public void cancel(String downloadId) throws Exception {
        this.cancel(202, downloadId);
    }

    public void cancel(int expectedStatusCode, String downloadId) throws Exception {
        this.delete(API_DOWNLOADS, downloadId, expectedStatusCode);
    }

    protected Download getDownloadFromResponse(HttpResponse response) throws Exception {
        if (Arrays.asList(202, 200).contains(response.getStatusCode())) {
            return RestApiUtil.parseRestApiEntry(response.getJsonResponse(), Download.class);
        }
        return null;
    }

    private static interface CancelAction {
        public void run() throws Exception;
    }

    private static class DownloadAlreadyDoneException
    extends RuntimeException {
        private DownloadAlreadyDoneException() {
        }
    }
}

