/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.webdav;

import jakarta.servlet.ServletConfig;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.transaction.UserTransaction;
import java.io.IOException;
import java.io.Serializable;
import java.util.Hashtable;
import java.util.List;
import org.alfresco.repo.cache.SimpleCache;
import org.alfresco.repo.security.authentication.AuthenticationContext;
import org.alfresco.repo.tenant.TenantService;
import org.alfresco.repo.webdav.ActivityPostProducer;
import org.alfresco.repo.webdav.ActivityPosterImpl;
import org.alfresco.repo.webdav.CopyMethod;
import org.alfresco.repo.webdav.DeleteMethod;
import org.alfresco.repo.webdav.ExceptionHandler;
import org.alfresco.repo.webdav.GetMethod;
import org.alfresco.repo.webdav.HeadMethod;
import org.alfresco.repo.webdav.LockMethod;
import org.alfresco.repo.webdav.MkcolMethod;
import org.alfresco.repo.webdav.MoveMethod;
import org.alfresco.repo.webdav.OptionsMethod;
import org.alfresco.repo.webdav.PostMethod;
import org.alfresco.repo.webdav.PropFindMethod;
import org.alfresco.repo.webdav.PropPatchMethod;
import org.alfresco.repo.webdav.PutMethod;
import org.alfresco.repo.webdav.UnlockMethod;
import org.alfresco.repo.webdav.WebDAVActivityPoster;
import org.alfresco.repo.webdav.WebDAVHelper;
import org.alfresco.repo.webdav.WebDAVMethod;
import org.alfresco.service.ServiceRegistry;
import org.alfresco.service.cmr.activities.ActivityPoster;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.search.SearchService;
import org.alfresco.service.namespace.NamespacePrefixResolver;
import org.alfresco.service.namespace.NamespaceService;
import org.alfresco.service.transaction.TransactionService;
import org.alfresco.util.FileFilterMode;
import org.alfresco.util.PropertyCheck;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

public class WebDAVServlet
extends HttpServlet {
    private static final long serialVersionUID = 6900069445027527165L;
    private static Log logger = LogFactory.getLog((String)"org.alfresco.webdav.protocol");
    public static final String WEBDAV_PREFIX = "webdav";
    private static final String BEAN_INIT_PARAMS = "webdav.initParams";
    private ServiceRegistry serviceRegistry;
    private TransactionService transactionService;
    private static TenantService tenantService;
    private static NodeService nodeService;
    private static SearchService searchService;
    private static NamespaceService namespaceService;
    protected Hashtable<String, Class<? extends WebDAVMethod>> m_davMethods;
    private static SimpleCache<String, NodeRef> singletonCache;
    private static final String KEY_WEBDAV_ROOT_NODEREF = "key.webdavRoot.noderef";
    private static String rootPath;
    private static NodeRef defaultRootNode;
    private WebDAVHelper m_davHelper;
    private WebDAVActivityPoster activityPoster;
    private WebDAVInitParameters initParams;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        if (!this.initParams.getEnabled()) {
            response.sendError(404);
            return;
        }
        long startTime = 0L;
        if (logger.isTraceEnabled()) {
            startTime = System.currentTimeMillis();
        }
        if (request.getMethod().equals("POST") && !this.initParams.allowInsecurePOSTMethod()) {
            logger.error((Object)"POST method is not allowed!");
            response.sendError(405);
            return;
        }
        FileFilterMode.setClient((FileFilterMode.Client)FileFilterMode.Client.webdav);
        try {
            WebDAVMethod method = this.createMethod(request, response);
            if (method == null) {
                if (logger.isErrorEnabled()) {
                    logger.error((Object)("WebDAV method not implemented - " + request.getMethod()));
                }
                response.sendError(501);
                return;
            }
            if (method.getRootNodeRef() == null) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("No root node for request [" + request.getMethod() + " " + request.getRequestURI() + "]"));
                }
                response.sendError(500);
                return;
            }
            method.execute();
        }
        catch (Throwable e) {
            ExceptionHandler exHandler = new ExceptionHandler(e, request, response);
            exHandler.handle();
        }
        finally {
            if (logger.isTraceEnabled()) {
                logger.trace((Object)(request.getMethod() + " took " + (System.currentTimeMillis() - startTime) + "ms to execute [" + request.getRequestURI() + "]"));
            }
            FileFilterMode.clearClient();
        }
    }

    protected WebDAVMethod createMethod(HttpServletRequest request, HttpServletResponse response) {
        WebDAVMethod method;
        block5: {
            String strHttpMethod = request.getMethod();
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("WebDAV request " + strHttpMethod + " on path " + request.getRequestURI()));
            }
            Class<? extends WebDAVMethod> methodClass = this.m_davMethods.get(strHttpMethod);
            method = null;
            if (methodClass != null) {
                try {
                    method = methodClass.newInstance();
                    method.setDetails(request, response, this.m_davHelper, WebDAVServlet.getRootNodeRef());
                    if (method instanceof ActivityPostProducer) {
                        ActivityPostProducer activityPostProducer = (ActivityPostProducer)((Object)method);
                        activityPostProducer.setActivityPoster(this.activityPoster);
                    }
                }
                catch (Exception ex) {
                    if (!logger.isDebugEnabled()) break block5;
                    logger.debug((Object)ex);
                }
            }
        }
        return method;
    }

    private static NodeRef getRootNodeRef() {
        NodeRef rootNodeRef = (NodeRef)singletonCache.get((Serializable)((Object)KEY_WEBDAV_ROOT_NODEREF));
        if (rootNodeRef == null) {
            rootNodeRef = tenantService.getRootNode(nodeService, searchService, namespaceService, rootPath, defaultRootNode);
            singletonCache.put((Serializable)((Object)KEY_WEBDAV_ROOT_NODEREF), (Object)rootNodeRef);
        }
        return rootNodeRef;
    }

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        WebApplicationContext context = WebApplicationContextUtils.getWebApplicationContext((ServletContext)this.getServletContext());
        if (context == null) {
            return;
        }
        WebApplicationContext wc = WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)this.getServletContext());
        this.initParams = (WebDAVInitParameters)wc.getBean(BEAN_INIT_PARAMS);
        if (!this.initParams.getEnabled()) {
            logger.info((Object)"Marking servlet WebDAV as unavailable!");
            return;
        }
        String storeValue = this.initParams.getStoreName();
        rootPath = this.initParams.getRootPath();
        this.serviceRegistry = (ServiceRegistry)context.getBean("ServiceRegistry");
        this.transactionService = this.serviceRegistry.getTransactionService();
        tenantService = (TenantService)context.getBean("tenantService");
        nodeService = (NodeService)context.getBean("NodeService");
        searchService = (SearchService)context.getBean("SearchService");
        namespaceService = (NamespaceService)context.getBean("NamespaceService");
        ActivityPoster poster = (ActivityPoster)context.getBean("activitiesPoster");
        singletonCache = (SimpleCache)context.getBean("immutableSingletonCache");
        this.activityPoster = new ActivityPosterImpl("WebDAV", poster);
        this.m_davHelper = (WebDAVHelper)context.getBean("webDAVHelper");
        this.initializeRootNode(storeValue, rootPath, context, nodeService, searchService, namespaceService, tenantService, this.transactionService);
        this.m_davMethods = new Hashtable();
        this.m_davMethods.put("PROPFIND", PropFindMethod.class);
        this.m_davMethods.put("PROPPATCH", PropPatchMethod.class);
        this.m_davMethods.put("COPY", CopyMethod.class);
        this.m_davMethods.put("DELETE", DeleteMethod.class);
        this.m_davMethods.put("GET", GetMethod.class);
        this.m_davMethods.put("HEAD", HeadMethod.class);
        this.m_davMethods.put("LOCK", LockMethod.class);
        this.m_davMethods.put("MKCOL", MkcolMethod.class);
        this.m_davMethods.put("MOVE", MoveMethod.class);
        this.m_davMethods.put("OPTIONS", OptionsMethod.class);
        this.m_davMethods.put("POST", PostMethod.class);
        this.m_davMethods.put("PUT", PutMethod.class);
        this.m_davMethods.put("UNLOCK", UnlockMethod.class);
    }

    protected WebDAVHelper getDAVHelper() {
        return this.m_davHelper;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initializeRootNode(String storeValue, String rootPath, WebApplicationContext context, NodeService nodeService, SearchService searchService, NamespaceService namespaceService, TenantService tenantService, TransactionService m_transactionService) {
        AuthenticationContext authComponent = (AuthenticationContext)context.getBean("authenticationContext");
        authComponent.setSystemUserAsCurrentUser();
        UserTransaction tx = m_transactionService.getUserTransaction(true);
        try {
            StoreRef storeRef;
            if (tx != null) {
                tx.begin();
            }
            if (!nodeService.exists(storeRef = new StoreRef(storeValue))) {
                throw new RuntimeException("No store for path: " + String.valueOf(storeRef));
            }
            NodeRef storeRootNodeRef = nodeService.getRootNode(storeRef);
            List nodeRefs = searchService.selectNodes(storeRootNodeRef, rootPath, null, (NamespacePrefixResolver)namespaceService, false);
            if (nodeRefs.size() > 1) {
                throw new RuntimeException("Multiple possible children for : \n   path: " + rootPath + "\n   results: " + String.valueOf(nodeRefs));
            }
            if (nodeRefs.size() == 0) {
                throw new RuntimeException("Node is not found for : \n   root path: " + rootPath);
            }
            defaultRootNode = (NodeRef)nodeRefs.get(0);
            if (tx != null) {
                tx.commit();
            }
        }
        catch (Exception ex) {
            logger.error((Object)ex);
        }
        finally {
            authComponent.clearCurrentSecurityContext();
        }
    }

    public static NodeRef getWebdavRootNode() {
        return WebDAVServlet.getRootNodeRef();
    }

    public static class WebDAVInitParameters {
        private boolean enabled = false;
        private String storeName;
        private String rootPath;
        private String urlPathPrefix;
        private boolean allowInsecurePOSTMethod = false;

        public boolean getEnabled() {
            return this.enabled;
        }

        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }

        public String getStoreName() throws ServletException {
            if (!PropertyCheck.isValidPropertyString((String)this.storeName)) {
                throw new ServletException("WebDAV missing 'storeName' value.");
            }
            return this.storeName;
        }

        public void setStoreName(String storeName) {
            this.storeName = storeName;
        }

        public String getRootPath() throws ServletException {
            if (!PropertyCheck.isValidPropertyString((String)this.rootPath)) {
                throw new ServletException("WebDAV missing 'rootPath' value.");
            }
            return this.rootPath;
        }

        public void setRootPath(String rootPath) {
            this.rootPath = rootPath;
        }

        public String getUrlPathPrefix() {
            return this.urlPathPrefix;
        }

        public void setUrlPathPrefix(String urlPathPrefix) {
            this.urlPathPrefix = urlPathPrefix;
        }

        public boolean allowInsecurePOSTMethod() {
            return this.allowInsecurePOSTMethod;
        }

        public void setAllowInsecurePOSTMethod(boolean allowInsecurePOSTMethod) {
            this.allowInsecurePOSTMethod = allowInsecurePOSTMethod;
        }
    }
}

