/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.api.tags;

import java.util.List;
import org.alfresco.rest.api.Tags;
import org.alfresco.rest.api.model.Tag;
import org.alfresco.rest.api.tags.TagsEntityResource;
import org.alfresco.rest.framework.resource.parameters.Parameters;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.StoreRef;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentMatchers;
import org.mockito.BDDMockito;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.junit.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class TagsEntityResourceTest {
    private static final String TAG_ID = "tag-dummy-id";
    private static final String TAG_NAME = "tag-dummy-name";
    private static final NodeRef TAG_NODE_REF = new NodeRef(StoreRef.STORE_REF_WORKSPACE_SPACESSTORE, "tag-dummy-id");
    @Mock
    private Parameters parametersMock;
    @Mock
    private Tags tagsMock;
    @InjectMocks
    private TagsEntityResource tagsEntityResource;

    @Test
    public void testCreate() {
        Tag tag = Tag.builder().tag(TAG_NAME).create();
        List<Tag> tags = List.of(tag);
        BDDMockito.given((Object)this.tagsMock.createTags((List)ArgumentMatchers.any(), (Parameters)ArgumentMatchers.any())).willCallRealMethod();
        BDDMockito.given((Object)this.tagsMock.createTags((StoreRef)ArgumentMatchers.any(), (List)ArgumentMatchers.any(), (Parameters)ArgumentMatchers.any())).willReturn(List.of(Tag.builder().nodeRef(TAG_NODE_REF).tag(TAG_NAME).create()));
        List actualCreatedTags = this.tagsEntityResource.create(tags, this.parametersMock);
        ((Tags)BDDMockito.then((Object)this.tagsMock).should()).createTags(StoreRef.STORE_REF_WORKSPACE_SPACESSTORE, tags, this.parametersMock);
        List<Tag> expectedTags = List.of(Tag.builder().nodeRef(TAG_NODE_REF).tag(TAG_NAME).create());
        ((ListAssert)Assertions.assertThat((List)actualCreatedTags).isNotEmpty()).isEqualTo(expectedTags);
    }
}

