/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.api.tests;

import java.util.HashMap;
import java.util.List;
import org.alfresco.rest.AbstractSingleNetworkSiteTest;
import org.alfresco.rest.api.Activities;
import org.alfresco.rest.api.nodes.NodesEntityResource;
import org.alfresco.rest.api.tests.client.HttpResponse;
import org.alfresco.rest.api.tests.client.data.Activity;
import org.alfresco.rest.api.tests.client.data.Document;
import org.alfresco.rest.api.tests.client.data.Folder;
import org.alfresco.rest.api.tests.client.data.Node;
import org.alfresco.rest.api.tests.util.RestApiUtil;
import org.junit.Assert;
import org.junit.Test;

public class ActivitiesPostingTest
extends AbstractSingleNetworkSiteTest {
    @Test
    public void testCreateUpdate() throws Exception {
        this.setRequestContext(user1);
        List<Activity> activities = this.getMyActivities();
        int beforeCount = activities.size();
        String folder1 = "folder" + System.currentTimeMillis() + "_1";
        Folder createdFolder = this.createFolder(tDocLibNodeId, folder1, null);
        Assert.assertNotNull((Object)createdFolder);
        String f1Id = createdFolder.getId();
        String docName = "d1.txt";
        Document documentResp = this.createEmptyTextFile(f1Id, docName);
        Document dUpdate = new Document();
        dUpdate.setName("d1b.txt");
        this.put("nodes", documentResp.getId(), RestApiUtil.toJsonAsStringNonNull(dUpdate), null, 200);
        HttpResponse response = this.getSingle(NodesEntityResource.class, documentResp.getId() + "/content", null, 200);
        String textContent = response.getResponse();
        Assert.assertNotNull((Object)textContent);
        this.deleteNode(documentResp.getId());
        this.deleteNode(createdFolder.getId());
        activities = this.getMyActivities();
        Assert.assertEquals((long)(beforeCount + 6), (long)activities.size());
        Activity act = this.matchActivity(activities, "org.alfresco.documentlibrary.folder-added", user1, tSiteId, tDocLibNodeId, folder1);
        Assert.assertNotNull((Object)act);
        act = this.matchActivity(activities, "org.alfresco.documentlibrary.file-added", user1, tSiteId, createdFolder.getId(), docName);
        Assert.assertNotNull((Object)act);
        act = this.matchActivity(activities, "org.alfresco.documentlibrary.file-updated", user1, tSiteId, createdFolder.getId(), dUpdate.getName());
        Assert.assertNotNull((Object)act);
        act = this.matchActivity(activities, "org.alfresco.documentlibrary.folder-deleted", user1, tSiteId, tDocLibNodeId, folder1);
        Assert.assertNotNull((Object)act);
        act = this.matchActivity(activities, "org.alfresco.documentlibrary.file-deleted", user1, tSiteId, createdFolder.getId(), dUpdate.getName());
        Assert.assertNotNull((Object)act);
        act = this.matchActivity(activities, "org.alfresco.documentlibrary.file-downloaded", user1, tSiteId, createdFolder.getId(), dUpdate.getName());
        Assert.assertNotNull((Object)act);
    }

    @Test
    public void testNonFileActivities() throws Exception {
        this.setRequestContext(user1);
        String folder1 = "InSitefolder" + System.currentTimeMillis() + "_1";
        Folder createdFolder = this.createFolder(tDocLibNodeId, folder1, null);
        Assert.assertNotNull((Object)createdFolder);
        List<Activity> activities = this.getMyActivities();
        Node aNode = this.createNode(createdFolder.getId(), "mynode", "cm:failedThumbnail", null);
        Assert.assertNotNull((Object)aNode);
        this.deleteNode(aNode.getId());
        List<Activity> activitiesAgain = this.getMyActivities();
        Assert.assertEquals((String)"No activites should be created for non-file activities", activities, activitiesAgain);
    }

    @Test
    public void testNonSite() throws Exception {
        this.setRequestContext(user1);
        List<Activity> activities = this.getMyActivities();
        String folder1 = "nonSitefolder" + System.currentTimeMillis() + "_1";
        Folder createdFolder = this.createFolder("-my-", folder1, null);
        Assert.assertNotNull((Object)createdFolder);
        String f1Id = createdFolder.getId();
        String docName = "nonsite_d1.txt";
        Document documentResp = this.createEmptyTextFile(f1Id, docName);
        Assert.assertNotNull((Object)documentResp);
        Document dUpdate = new Document();
        dUpdate.setName("nonsite_d2.txt");
        this.put("nodes", documentResp.getId(), RestApiUtil.toJsonAsStringNonNull(dUpdate), null, 200);
        List<Activity> activitiesAgain = this.getMyActivities();
        Assert.assertEquals((String)"No activites should be created for non-site nodes", activities, activitiesAgain);
    }

    private List<Activity> getMyActivities() throws Exception {
        this.repoService.generateFeed();
        this.setRequestContext(user1);
        HashMap<String, String> meParams = new HashMap<String, String>();
        meParams.put("who", String.valueOf(Activities.ActivityWho.me));
        return this.publicApiClient.people().getActivities(user1, meParams).getList();
    }

    private Activity matchActivity(List<Activity> list, String type, String user, String siteId, String parentId, String title) {
        for (Activity act : list) {
            if (!type.equals(act.getActivityType()) || !user.equals(act.getPostPersonId()) || !siteId.equals(act.getSiteId()) || !parentId.equals(act.getSummary().get("parentObjectId")) || !title.equals(act.getSummary().get("title"))) continue;
            return act;
        }
        return null;
    }
}

