/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.web.scripts.discussion;

import java.util.Date;
import java.util.Map;
import org.alfresco.query.PagingRequest;
import org.alfresco.query.PagingResults;
import org.alfresco.repo.web.scripts.discussion.AbstractDiscussionWebScript;
import org.alfresco.service.cmr.discussion.PostInfo;
import org.alfresco.service.cmr.discussion.TopicInfo;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.site.SiteInfo;
import org.json.simple.JSONObject;
import org.springframework.extensions.webscripts.Cache;
import org.springframework.extensions.webscripts.Status;
import org.springframework.extensions.webscripts.WebScriptException;
import org.springframework.extensions.webscripts.WebScriptRequest;

public class ForumTopicsRecentGet
extends AbstractDiscussionWebScript {
    protected static final int RECENT_SEARCH_PERIOD_DAYS = 7;
    protected static final long ONE_DAY_MS = 86400000L;

    @Override
    protected Map<String, Object> executeImpl(SiteInfo site, NodeRef nodeRef, TopicInfo topic, PostInfo post, WebScriptRequest req, JSONObject json, Status status, Cache cache) {
        if (topic != null || post != null) {
            String error = "Can't list Topics inside an existing Topic or Post";
            throw new WebScriptException(400, error);
        }
        String numDaysS = req.getParameter("numdays");
        int numDays = 7;
        if (numDaysS != null) {
            numDays = Integer.parseInt(numDaysS);
        }
        Date now = new Date();
        Date from = new Date(now.getTime() - (long)numDays * 86400000L);
        Date to = new Date(now.getTime() + 86400000L);
        PagingResults topics = null;
        PagingRequest paging = this.buildPagingRequest(req);
        topics = site != null ? this.discussionService.listTopics(site.getShortName(), from, to, false, paging) : this.discussionService.listTopics(nodeRef, from, to, false, paging);
        if (site != null && nodeRef == null) {
            nodeRef = site.getNodeRef();
        }
        Map<String, Object> model = this.buildCommonModel(site, topic, post, req);
        model.put("forum", nodeRef);
        model.put("data", this.renderTopics((PagingResults<TopicInfo>)topics, paging, site));
        return model;
    }
}

