/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.framework.resource.content;

import java.util.Date;

public class CacheDirective {
    private final boolean neverCache;
    private final boolean isPublic;
    private final boolean mustRevalidate;
    private final Date lastModified;
    private final String eTag;
    private final Long maxAge;

    private CacheDirective(Builder builder) {
        this.neverCache = builder.neverCache;
        this.isPublic = builder.isPublic;
        this.mustRevalidate = builder.mustRevalidate;
        this.lastModified = builder.lastModified == null ? null : new Date(builder.lastModified.getTime());
        this.eTag = builder.eTag;
        this.maxAge = builder.maxAge;
    }

    public boolean isNeverCache() {
        return this.neverCache;
    }

    public boolean isPublic() {
        return this.isPublic;
    }

    public boolean isMustRevalidate() {
        return this.mustRevalidate;
    }

    public Date getLastModified() {
        if (this.lastModified != null) {
            return new Date(this.lastModified.getTime());
        }
        return null;
    }

    public String getETag() {
        return this.eTag;
    }

    public Long getMaxAge() {
        return this.maxAge;
    }

    public static class Builder {
        private boolean neverCache = true;
        private boolean isPublic = false;
        private boolean mustRevalidate = true;
        private Date lastModified = null;
        private String eTag = null;
        private Long maxAge = null;

        public Builder setNeverCache(boolean neverCache) {
            this.neverCache = neverCache;
            return this;
        }

        public Builder setPublic(boolean aPublic) {
            this.isPublic = aPublic;
            return this;
        }

        public Builder setMustRevalidate(boolean mustRevalidate) {
            this.mustRevalidate = mustRevalidate;
            return this;
        }

        public Builder setLastModified(Date lastModified) {
            this.lastModified = lastModified;
            return this;
        }

        public Builder setETag(String eTag) {
            this.eTag = eTag;
            return this;
        }

        public Builder setMaxAge(Long maxAge) {
            this.maxAge = maxAge;
            return this;
        }

        public CacheDirective build() {
            return new CacheDirective(this);
        }
    }
}

