/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.api.tests;

import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import org.alfresco.repo.tenant.TenantUtil;
import org.alfresco.rest.api.tests.EnterpriseTestApi;
import org.alfresco.rest.api.tests.RepoService;
import org.alfresco.rest.api.tests.client.PublicApiClient;
import org.alfresco.rest.api.tests.client.PublicApiException;
import org.alfresco.rest.api.tests.client.RequestContext;
import org.alfresco.rest.api.tests.client.data.MemberOfSite;
import org.alfresco.rest.api.tests.client.data.SiteRole;
import org.alfresco.service.cmr.site.SiteVisibility;
import org.alfresco.util.GUID;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestPersonSites
extends EnterpriseTestApi {
    private RepoService.TestNetwork network1;
    private RepoService.TestNetwork network2;
    private RepoService.TestNetwork network4;
    private RepoService.TestPerson person11;
    private RepoService.TestPerson person12;
    private RepoService.TestPerson person21;
    private RepoService.TestPerson person41;
    private RepoService.TestPerson person42;
    private List<RepoService.TestSite> sites = new ArrayList<RepoService.TestSite>(10);
    private RepoService.TestPerson person31;
    private RepoService.TestPerson person32;
    private RepoService.TestSite site1;
    private RepoService.TestSite site2;
    private RepoService.TestSite site3;
    private String site1_id = "a_" + GUID.generate();
    private String site1_title = "c_" + GUID.generate();
    private SiteRole site1_role = SiteRole.SiteContributor;
    private String site2_id = "b_" + GUID.generate();
    private String site2_title = "a_" + GUID.generate();
    private SiteRole site2_role = SiteRole.SiteManager;
    private String site3_id = "c_" + GUID.generate();
    private String site3_title = "b_" + GUID.generate();
    private SiteRole site3_role = SiteRole.SiteConsumer;
    private RepoService.TestSite site41;
    private RepoService.TestSite site42;
    private RepoService.TestSite site43;
    private RepoService.TestSite site44;

    @Override
    @Before
    public void setup() throws Exception {
        super.setup();
        Iterator<RepoService.TestNetwork> networksIt = this.getTestFixture().getNetworksIt();
        Assert.assertTrue((boolean)networksIt.hasNext());
        this.network1 = networksIt.next();
        Assert.assertTrue((boolean)networksIt.hasNext());
        this.network2 = networksIt.next();
        final ArrayList people = new ArrayList(1);
        TenantUtil.runAsSystemTenant((TenantUtil.TenantRunAsWork)new TenantUtil.TenantRunAsWork<Void>(){

            public Void doWork() throws Exception {
                RepoService.TestPerson person = TestPersonSites.this.network1.createUser();
                people.add(person);
                person = TestPersonSites.this.network1.createUser();
                people.add(person);
                return null;
            }
        }, (String)this.network1.getId());
        TenantUtil.runAsSystemTenant((TenantUtil.TenantRunAsWork)new TenantUtil.TenantRunAsWork<Void>(){

            public Void doWork() throws Exception {
                RepoService.TestPerson person = TestPersonSites.this.network2.createUser();
                people.add(person);
                return null;
            }
        }, (String)this.network2.getId());
        this.person11 = (RepoService.TestPerson)people.get(0);
        this.person12 = (RepoService.TestPerson)people.get(1);
        this.person21 = (RepoService.TestPerson)people.get(2);
        TenantUtil.runAsUserTenant((TenantUtil.TenantRunAsWork)new TenantUtil.TenantRunAsWork<Void>(){

            public Void doWork() throws Exception {
                RepoService.TestSite site = TestPersonSites.this.network1.createSite(SiteVisibility.PUBLIC);
                site.inviteToSite(TestPersonSites.this.person11.getId(), SiteRole.SiteContributor);
                TestPersonSites.this.sites.add(site);
                site = TestPersonSites.this.network1.createSite(SiteVisibility.MODERATED);
                site.inviteToSite(TestPersonSites.this.person11.getId(), SiteRole.SiteContributor);
                TestPersonSites.this.sites.add(site);
                site = TestPersonSites.this.network1.createSite(SiteVisibility.PRIVATE);
                site.inviteToSite(TestPersonSites.this.person11.getId(), SiteRole.SiteConsumer);
                TestPersonSites.this.sites.add(site);
                site = TestPersonSites.this.network1.createSite(SiteVisibility.PUBLIC);
                site.inviteToSite(TestPersonSites.this.person11.getId(), SiteRole.SiteManager);
                TestPersonSites.this.sites.add(site);
                site = TestPersonSites.this.network1.createSite(SiteVisibility.PRIVATE);
                site.inviteToSite(TestPersonSites.this.person11.getId(), SiteRole.SiteCollaborator);
                TestPersonSites.this.sites.add(site);
                site = TestPersonSites.this.network1.createSite(SiteVisibility.PRIVATE);
                site.inviteToSite(TestPersonSites.this.person11.getId(), SiteRole.SiteConsumer);
                TestPersonSites.this.sites.add(site);
                return null;
            }
        }, (String)this.person12.getId(), (String)this.network1.getId());
    }

    private void initializeSites() throws Exception {
        TenantUtil.runAsSystemTenant((TenantUtil.TenantRunAsWork)new TenantUtil.TenantRunAsWork<Void>(){

            public Void doWork() throws Exception {
                TestPersonSites.this.person31 = TestPersonSites.this.network1.createUser();
                TestPersonSites.this.person32 = TestPersonSites.this.network1.createUser();
                return null;
            }
        }, (String)this.network1.getId());
        this.site1 = (RepoService.TestSite)TenantUtil.runAsUserTenant((TenantUtil.TenantRunAsWork)new TenantUtil.TenantRunAsWork<RepoService.TestSite>(){

            public RepoService.TestSite doWork() throws Exception {
                RepoService.SiteInformation siteInfo = new RepoService.SiteInformation(TestPersonSites.this.site1_id, TestPersonSites.this.site1_title, TestPersonSites.this.site1_title, SiteVisibility.PRIVATE);
                RepoService.TestSite site = TestPersonSites.this.network1.createSite(siteInfo);
                site.inviteToSite(TestPersonSites.this.person32.getId(), TestPersonSites.this.site1_role);
                return site;
            }
        }, (String)this.person31.getId(), (String)this.network1.getId());
        this.site2 = (RepoService.TestSite)TenantUtil.runAsUserTenant((TenantUtil.TenantRunAsWork)new TenantUtil.TenantRunAsWork<RepoService.TestSite>(){

            public RepoService.TestSite doWork() throws Exception {
                RepoService.SiteInformation siteInfo = new RepoService.SiteInformation(TestPersonSites.this.site2_id, TestPersonSites.this.site2_title, TestPersonSites.this.site2_title, SiteVisibility.PRIVATE);
                RepoService.TestSite site = TestPersonSites.this.network1.createSite(siteInfo);
                site.inviteToSite(TestPersonSites.this.person32.getId(), TestPersonSites.this.site2_role);
                return site;
            }
        }, (String)this.person31.getId(), (String)this.network1.getId());
        this.site3 = (RepoService.TestSite)TenantUtil.runAsUserTenant((TenantUtil.TenantRunAsWork)new TenantUtil.TenantRunAsWork<RepoService.TestSite>(){

            public RepoService.TestSite doWork() throws Exception {
                RepoService.SiteInformation siteInfo = new RepoService.SiteInformation(TestPersonSites.this.site3_id, TestPersonSites.this.site3_title, TestPersonSites.this.site3_title, SiteVisibility.PRIVATE);
                RepoService.TestSite site = TestPersonSites.this.network1.createSite(siteInfo);
                site.inviteToSite(TestPersonSites.this.person32.getId(), TestPersonSites.this.site3_role);
                return site;
            }
        }, (String)this.person31.getId(), (String)this.network1.getId());
    }

    private void initializePersonAndNetwork4WithSites() throws Exception {
        if (this.network4 == null) {
            this.network4 = this.getRepoService().createNetwork(this.getClass().getSimpleName().toLowerCase() + "-3-" + GUID.generate(), true);
            this.network4.create();
            TenantUtil.runAsSystemTenant((TenantUtil.TenantRunAsWork)new TenantUtil.TenantRunAsWork<Void>(){

                public Void doWork() throws Exception {
                    TestPersonSites.this.person41 = TestPersonSites.this.network4.createUser();
                    TestPersonSites.this.person42 = TestPersonSites.this.network4.createUser();
                    return null;
                }
            }, (String)this.network4.getId());
            TenantUtil.runAsUserTenant((TenantUtil.TenantRunAsWork)new TenantUtil.TenantRunAsWork<Void>(){

                public Void doWork() throws Exception {
                    TestPersonSites.this.site41 = TestPersonSites.this.network4.createSite("A", SiteVisibility.PRIVATE);
                    TestPersonSites.this.site41.inviteToSite(TestPersonSites.this.person41.getId(), SiteRole.SiteContributor);
                    TestPersonSites.this.site42 = TestPersonSites.this.network4.createSite("B", SiteVisibility.PUBLIC);
                    TestPersonSites.this.site42.inviteToSite(TestPersonSites.this.person41.getId(), SiteRole.SiteContributor);
                    TestPersonSites.this.site43 = TestPersonSites.this.network4.createSite("C", SiteVisibility.PUBLIC);
                    TestPersonSites.this.site43.inviteToSite(TestPersonSites.this.person41.getId(), SiteRole.SiteContributor);
                    TestPersonSites.this.site44 = TestPersonSites.this.network4.createSite("D", SiteVisibility.MODERATED);
                    TestPersonSites.this.site44.inviteToSite(TestPersonSites.this.person41.getId(), SiteRole.SiteContributor);
                    return null;
                }
            }, (String)this.person42.getId(), (String)this.network4.getId());
        }
    }

    @Test
    public void testPersonSites() throws Exception {
        TreeSet<MemberOfSite> personSites = new TreeSet<MemberOfSite>();
        RepoService.TestSite personRemoveSite = this.sites.get(this.sites.size() - 1);
        this.sites.remove(this.sites.size() - 1);
        personSites.addAll(this.network1.getSiteMemberships(this.person11.getId()));
        personSites.addAll((Collection)TenantUtil.runAsUserTenant((TenantUtil.TenantRunAsWork)new TenantUtil.TenantRunAsWork<List<MemberOfSite>>(){

            public List<MemberOfSite> doWork() throws Exception {
                ArrayList<MemberOfSite> expectedSites = new ArrayList<MemberOfSite>();
                RepoService.TestSite site = TestPersonSites.this.network1.createSite(SiteVisibility.PRIVATE);
                expectedSites.add(new MemberOfSite(site, SiteRole.SiteManager));
                site = TestPersonSites.this.network1.createSite(SiteVisibility.PUBLIC);
                expectedSites.add(new MemberOfSite(site, SiteRole.SiteManager));
                site = TestPersonSites.this.network1.createSite(SiteVisibility.MODERATED);
                expectedSites.add(new MemberOfSite(site, SiteRole.SiteManager));
                return expectedSites;
            }
        }, (String)this.person11.getId(), (String)this.network1.getId()));
        personSites.addAll((Collection)TenantUtil.runAsUserTenant((TenantUtil.TenantRunAsWork)new TenantUtil.TenantRunAsWork<List<MemberOfSite>>(){

            public List<MemberOfSite> doWork() throws Exception {
                ArrayList<MemberOfSite> expectedSites = new ArrayList<MemberOfSite>();
                RepoService.TestSite site = TestPersonSites.this.network1.createSite(SiteVisibility.PRIVATE);
                site.inviteToSite(TestPersonSites.this.person11.getId(), SiteRole.SiteConsumer);
                expectedSites.add(new MemberOfSite(site, SiteRole.SiteConsumer));
                site = TestPersonSites.this.network1.createSite(SiteVisibility.PUBLIC);
                site.inviteToSite(TestPersonSites.this.person11.getId(), SiteRole.SiteConsumer);
                expectedSites.add(new MemberOfSite(site, SiteRole.SiteConsumer));
                site = TestPersonSites.this.network1.createSite(SiteVisibility.MODERATED);
                site.inviteToSite(TestPersonSites.this.person11.getId(), SiteRole.SiteConsumer);
                expectedSites.add(new MemberOfSite(site, SiteRole.SiteConsumer));
                return expectedSites;
            }
        }, (String)this.person12.getId(), (String)this.network1.getId()));
        ArrayList expectedSites = new ArrayList(personSites);
        PublicApiClient.Sites sitesProxy = this.publicApiClient.sites();
        try {
            this.publicApiClient.setRequestContext(new RequestContext(this.network1.getId(), this.person11.getId()));
            sitesProxy.getPersonSites(GUID.generate(), null);
            Assert.fail((String)"");
        }
        catch (PublicApiException e) {
            Assert.assertEquals((long)404L, (long)e.getHttpResponse().getStatusCode());
        }
        int skipCount = 0;
        int maxItems = 2;
        PublicApiClient.Paging paging = this.getPaging(skipCount, maxItems, expectedSites.size(), expectedSites.size());
        this.publicApiClient.setRequestContext(new RequestContext(this.network1.getId(), this.person11.getId()));
        PublicApiClient.ListResponse<MemberOfSite> resp = sitesProxy.getPersonSites(this.person11.getId(), this.createParams(paging, null));
        this.checkList(expectedSites.subList(skipCount, skipCount + paging.getExpectedPaging().getCount()), paging.getExpectedPaging(), resp);
        skipCount = 2;
        maxItems = 8;
        paging = this.getPaging(skipCount, maxItems, expectedSites.size(), expectedSites.size());
        this.publicApiClient.setRequestContext(new RequestContext(this.network1.getId(), this.person11.getId()));
        resp = sitesProxy.getPersonSites(this.person11.getId(), this.createParams(paging, null));
        this.checkList(expectedSites.subList(skipCount, skipCount + paging.getExpectedPaging().getCount()), paging.getExpectedPaging(), resp);
        skipCount = 0;
        maxItems = 2;
        paging = this.getPaging(skipCount, maxItems, expectedSites.size(), expectedSites.size());
        this.publicApiClient.setRequestContext(new RequestContext(this.network1.getId(), this.person11.getId()));
        resp = sitesProxy.getPersonSites("-me-", this.createParams(paging, null));
        this.checkList(expectedSites.subList(skipCount, skipCount + paging.getExpectedPaging().getCount()), paging.getExpectedPaging(), resp);
        try {
            skipCount = 0;
            maxItems = 2;
            paging = this.getPaging(skipCount, maxItems, expectedSites.size(), null);
            this.publicApiClient.setRequestContext(new RequestContext(this.network1.getId(), this.person21.getId()));
            sitesProxy.getPersonSites(this.person11.getId(), this.createParams(paging, null));
            Assert.fail((String)"");
        }
        catch (PublicApiException e) {
            Assert.assertEquals((long)401L, (long)e.getHttpResponse().getStatusCode());
        }
        MemberOfSite memberOfSite = (MemberOfSite)expectedSites.get(0);
        this.publicApiClient.setRequestContext(new RequestContext(this.network1.getId(), this.person11.getId()));
        MemberOfSite ret = sitesProxy.getPersonSite(this.person11.getId(), memberOfSite.getSiteId());
        memberOfSite.expected(ret);
        try {
            memberOfSite = (MemberOfSite)expectedSites.get(0);
            this.publicApiClient.setRequestContext(new RequestContext(this.network1.getId(), this.person11.getId()));
            sitesProxy.getPersonSite(GUID.generate(), memberOfSite.getSiteId());
            Assert.fail();
        }
        catch (PublicApiException e) {
            Assert.assertEquals((long)404L, (long)e.getHttpResponse().getStatusCode());
        }
        try {
            this.publicApiClient.setRequestContext(new RequestContext(this.network1.getId(), this.person11.getId()));
            sitesProxy.getPersonSite(this.person11.getId(), GUID.generate());
            Assert.fail();
        }
        catch (PublicApiException e) {
            Assert.assertEquals((long)404L, (long)e.getHttpResponse().getStatusCode());
        }
        try {
            memberOfSite = (MemberOfSite)expectedSites.get(0);
            this.publicApiClient.setRequestContext(new RequestContext(this.network1.getId(), this.person11.getId()));
            sitesProxy.getPersonSite(GUID.generate(), memberOfSite.getSiteId());
            Assert.fail();
        }
        catch (PublicApiException e) {
            Assert.assertEquals((long)404L, (long)e.getHttpResponse().getStatusCode());
        }
        try {
            this.publicApiClient.setRequestContext(new RequestContext(this.network1.getId(), this.person11.getId()));
            sitesProxy.getPersonSite(this.person11.getId(), GUID.generate());
            Assert.fail();
        }
        catch (PublicApiException e) {
            Assert.assertEquals((long)404L, (long)e.getHttpResponse().getStatusCode());
        }
        this.publicApiClient.setRequestContext(new RequestContext(this.network1.getId(), this.person11.getId()));
        sitesProxy.remove("people", this.person11.getId(), "sites", personRemoveSite.getSiteId(), "Unable to DELETE a person site");
        try {
            sitesProxy.getPersonSite(this.person11.getId(), personRemoveSite.getSiteId());
        }
        catch (PublicApiException e) {
            Assert.assertEquals((long)404L, (long)e.getHttpResponse().getStatusCode());
        }
        try {
            memberOfSite = (MemberOfSite)expectedSites.get(0);
            this.publicApiClient.setRequestContext(new RequestContext(this.network1.getId(), this.person11.getId()));
            sitesProxy.create("people", this.person11.getId(), "sites", memberOfSite.getSiteId(), null, "Unable to POST to a person site");
            Assert.fail();
        }
        catch (PublicApiException e) {
            Assert.assertEquals((long)405L, (long)e.getHttpResponse().getStatusCode());
        }
        try {
            this.publicApiClient.setRequestContext(new RequestContext(this.network1.getId(), this.person11.getId()));
            sitesProxy.create("people", this.person11.getId(), "sites", null, null, "Unable to POST to person sites");
            Assert.fail();
        }
        catch (PublicApiException e) {
            Assert.assertEquals((long)405L, (long)e.getHttpResponse().getStatusCode());
        }
        try {
            memberOfSite = (MemberOfSite)expectedSites.get(0);
            this.publicApiClient.setRequestContext(new RequestContext(this.network1.getId(), this.person11.getId()));
            sitesProxy.update("people", this.person11.getId(), "sites", memberOfSite.getSiteId(), null, "Unable to PUT a person site");
            Assert.fail();
        }
        catch (PublicApiException e) {
            Assert.assertEquals((long)405L, (long)e.getHttpResponse().getStatusCode());
        }
        try {
            this.publicApiClient.setRequestContext(new RequestContext(this.network1.getId(), this.person11.getId()));
            sitesProxy.update("people", this.person11.getId(), "sites", null, null, "Unable to PUT person sites");
            Assert.fail();
        }
        catch (PublicApiException e) {
            Assert.assertEquals((long)405L, (long)e.getHttpResponse().getStatusCode());
        }
        try {
            this.publicApiClient.setRequestContext(new RequestContext(this.network1.getId(), this.person11.getId()));
            sitesProxy.remove("people", this.person11.getId(), "sites", null, "Unable to DELETE person sites");
            Assert.fail();
        }
        catch (PublicApiException e) {
            Assert.assertEquals((long)405L, (long)e.getHttpResponse().getStatusCode());
        }
    }

    private PublicApiClient.ListResponse<MemberOfSite> getSiteMembershipsForPerson32(final PublicApiClient.Paging paging, String sortColumn, boolean asc) throws Exception {
        final PublicApiClient.Sites sitesProxy = this.publicApiClient.sites();
        this.publicApiClient.setRequestContext(new RequestContext(this.network1.getId(), this.person32.getId()));
        final HashMap<String, CallSite> params = new HashMap<String, CallSite>();
        if (sortColumn != null) {
            params.put("orderBy", (CallSite)((Object)(sortColumn + " " + (asc ? "ASC" : "DESC"))));
        }
        PublicApiClient.ListResponse resp = (PublicApiClient.ListResponse)TenantUtil.runAsUserTenant((TenantUtil.TenantRunAsWork)new TenantUtil.TenantRunAsWork<PublicApiClient.ListResponse<MemberOfSite>>(){

            public PublicApiClient.ListResponse<MemberOfSite> doWork() throws Exception {
                PublicApiClient.ListResponse<MemberOfSite> resp = sitesProxy.getPersonSites(TestPersonSites.this.person32.getId(), TestPersonSites.this.createParams(paging, params));
                return resp;
            }
        }, (String)this.person32.getId(), (String)this.network1.getId());
        return resp;
    }

    public void testSortingAndPagingByTitleAsc() throws Exception {
        int skipCount = 1;
        int maxItems = 2;
        int totalResults = 3;
        PublicApiClient.Paging paging = this.getPaging(skipCount, maxItems, totalResults, totalResults);
        PublicApiClient.ListResponse<MemberOfSite> resp = this.getSiteMembershipsForPerson32(paging, "title", true);
        LinkedList<MemberOfSite> expectedList = new LinkedList<MemberOfSite>();
        expectedList.add(new MemberOfSite(this.site3, this.site3_role));
        expectedList.add(new MemberOfSite(this.site1, this.site1_role));
        this.checkList(expectedList, paging.getExpectedPaging(), resp);
    }

    public void testSortingAndPagingByTitleDesc() throws Exception {
        int skipCount = 1;
        int maxItems = 2;
        int totalResults = 3;
        PublicApiClient.Paging paging = this.getPaging(skipCount, maxItems, totalResults, totalResults);
        PublicApiClient.ListResponse<MemberOfSite> resp = this.getSiteMembershipsForPerson32(paging, "title", false);
        LinkedList<MemberOfSite> expectedList = new LinkedList<MemberOfSite>();
        expectedList.add(new MemberOfSite(this.site3, this.site3_role));
        expectedList.add(new MemberOfSite(this.site2, this.site2_role));
        this.checkList(expectedList, paging.getExpectedPaging(), resp);
    }

    public void testSortingAndPagingByRoleAsc() throws Exception {
        int skipCount = 1;
        int maxItems = 2;
        int totalResults = 3;
        PublicApiClient.Paging paging = this.getPaging(skipCount, maxItems, totalResults, totalResults);
        PublicApiClient.ListResponse<MemberOfSite> resp = this.getSiteMembershipsForPerson32(paging, "role", true);
        LinkedList<MemberOfSite> expectedList = new LinkedList<MemberOfSite>();
        expectedList.add(new MemberOfSite(this.site1, this.site1_role));
        expectedList.add(new MemberOfSite(this.site2, this.site2_role));
        this.checkList(expectedList, paging.getExpectedPaging(), resp);
    }

    public void testSortingAndPagingByRoleDesc() throws Exception {
        int skipCount = 1;
        int maxItems = 2;
        int totalResults = 3;
        PublicApiClient.Paging paging = this.getPaging(skipCount, maxItems, totalResults, totalResults);
        PublicApiClient.ListResponse<MemberOfSite> resp = this.getSiteMembershipsForPerson32(paging, "role", false);
        LinkedList<MemberOfSite> expectedList = new LinkedList<MemberOfSite>();
        expectedList.add(new MemberOfSite(this.site1, this.site1_role));
        expectedList.add(new MemberOfSite(this.site3, this.site3_role));
        this.checkList(expectedList, paging.getExpectedPaging(), resp);
    }

    public void testSortingAndPagingBySiteIdAsc() throws Exception {
        int skipCount = 1;
        int maxItems = 2;
        int totalResults = 3;
        PublicApiClient.Paging paging = this.getPaging(skipCount, maxItems, totalResults, totalResults);
        PublicApiClient.ListResponse<MemberOfSite> resp = this.getSiteMembershipsForPerson32(paging, "id", true);
        LinkedList<MemberOfSite> expectedList = new LinkedList<MemberOfSite>();
        expectedList.add(new MemberOfSite(this.site2, this.site2_role));
        expectedList.add(new MemberOfSite(this.site3, this.site3_role));
        this.checkList(expectedList, paging.getExpectedPaging(), resp);
    }

    public void testSortingAndPagingBySiteIdDesc() throws Exception {
        int skipCount = 1;
        int maxItems = 2;
        int totalResults = 3;
        PublicApiClient.Paging paging = this.getPaging(skipCount, maxItems, totalResults, totalResults);
        PublicApiClient.ListResponse<MemberOfSite> resp = this.getSiteMembershipsForPerson32(paging, "id", false);
        LinkedList<MemberOfSite> expectedList = new LinkedList<MemberOfSite>();
        expectedList.add(new MemberOfSite(this.site2, this.site2_role));
        expectedList.add(new MemberOfSite(this.site1, this.site1_role));
        this.checkList(expectedList, paging.getExpectedPaging(), resp);
    }

    public void testSortingAndPagingDefault() throws Exception {
        int totalResults = 3;
        PublicApiClient.Paging paging = this.getPaging(null, null, totalResults, totalResults);
        PublicApiClient.ListResponse<MemberOfSite> resp = this.getSiteMembershipsForPerson32(null, null, false);
        LinkedList<MemberOfSite> expectedList = new LinkedList<MemberOfSite>();
        expectedList.add(new MemberOfSite(this.site2, this.site2_role));
        expectedList.add(new MemberOfSite(this.site3, this.site3_role));
        expectedList.add(new MemberOfSite(this.site1, this.site1_role));
        this.checkList(expectedList, paging.getExpectedPaging(), resp);
    }

    @Test
    public void testSortingAndPaging() throws Exception {
        this.initializeSites();
        this.testSortingAndPagingByTitleAsc();
        this.testSortingAndPagingByTitleDesc();
        this.testSortingAndPagingByRoleAsc();
        this.testSortingAndPagingByRoleDesc();
        this.testSortingAndPagingBySiteIdAsc();
        this.testSortingAndPagingBySiteIdDesc();
        this.testSortingAndPagingDefault();
    }

    @Test
    public void testSitesWithSameTitles() throws Exception {
        this.initializeSites();
        final String site4_name = "d_" + GUID.generate();
        final String site4_title = this.site3_title;
        final SiteRole site4_role = SiteRole.SiteCollaborator;
        RepoService.TestSite site4 = (RepoService.TestSite)TenantUtil.runAsUserTenant((TenantUtil.TenantRunAsWork)new TenantUtil.TenantRunAsWork<RepoService.TestSite>(){

            public RepoService.TestSite doWork() throws Exception {
                RepoService.SiteInformation siteInfo = new RepoService.SiteInformation(site4_name, site4_title, site4_title, SiteVisibility.PRIVATE);
                RepoService.TestSite site = TestPersonSites.this.network1.createSite(siteInfo);
                site.inviteToSite(TestPersonSites.this.person32.getId(), site4_role);
                return site;
            }
        }, (String)this.person31.getId(), (String)this.network1.getId());
        Assert.assertNotNull((Object)site4);
        int totalResults = 4;
        PublicApiClient.Paging paging = this.getPaging(null, null, totalResults, totalResults);
        PublicApiClient.ListResponse<MemberOfSite> resp = this.getSiteMembershipsForPerson32(null, null, false);
        LinkedList<MemberOfSite> expectedList = new LinkedList<MemberOfSite>();
        expectedList.add(new MemberOfSite(this.site2, this.site2_role));
        expectedList.add(new MemberOfSite(this.site3, this.site3_role));
        expectedList.add(new MemberOfSite(site4, site4_role));
        expectedList.add(new MemberOfSite(this.site1, this.site1_role));
        try {
            this.checkList(expectedList, paging.getExpectedPaging(), resp);
        }
        catch (AssertionError error) {
            Collections.swap(expectedList, 1, 2);
            this.checkList(expectedList, paging.getExpectedPaging(), resp);
        }
    }

    private PublicApiClient.ListResponse<MemberOfSite> getSiteMembershipsForPersonAndNetwork(final PublicApiClient.Paging paging, final Map<String, String> params, final RepoService.TestPerson person, RepoService.TestNetwork network, boolean runAsUserTenant) throws Exception {
        final PublicApiClient.Sites sitesProxy = this.publicApiClient.sites();
        this.publicApiClient.setRequestContext(new RequestContext(network.getId(), person.getId()));
        PublicApiClient.ListResponse resp = runAsUserTenant ? (PublicApiClient.ListResponse)TenantUtil.runAsUserTenant((TenantUtil.TenantRunAsWork)new TenantUtil.TenantRunAsWork<PublicApiClient.ListResponse<MemberOfSite>>(){

            public PublicApiClient.ListResponse<MemberOfSite> doWork() throws Exception {
                PublicApiClient.ListResponse<MemberOfSite> resp = sitesProxy.getPersonSites(person.getId(), TestPersonSites.this.createParams(paging, params));
                return resp;
            }
        }, (String)person.getId(), (String)network.getId()) : sitesProxy.getPersonSites(person.getId(), this.createParams(paging, params));
        return resp;
    }

    private List<MemberOfSite> getPersonSites(RepoService.TestPerson person, RepoService.TestSite ... sites) throws PublicApiException {
        PublicApiClient.Sites sitesProxy = this.publicApiClient.sites();
        ArrayList<MemberOfSite> memberOfSiteList = new ArrayList<MemberOfSite>();
        for (RepoService.TestSite site : sites) {
            memberOfSiteList.add(sitesProxy.getPersonSite(person.getId(), site.getSiteId()));
        }
        return memberOfSiteList;
    }

    private PublicApiClient.ListResponse<MemberOfSite> getSiteMembershipsForPerson41(PublicApiClient.Paging paging, String siteVisibility, boolean runAsUserTenant) throws Exception {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("orderBy", "title ASC");
        if (siteVisibility != null) {
            params.put("where", "(visibility=" + siteVisibility + ")");
        }
        return this.getSiteMembershipsForPersonAndNetwork(paging, params, this.person41, this.network4, runAsUserTenant);
    }

    private PublicApiClient.ListResponse<MemberOfSite> getSiteMembershipsForPerson41NOTWhere(PublicApiClient.Paging paging, String siteVisibility, boolean runAsUserTenant) throws Exception {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("orderBy", "title ASC");
        if (siteVisibility != null) {
            params.put("where", "(NOT visibility=" + siteVisibility + ")");
        }
        return this.getSiteMembershipsForPersonAndNetwork(paging, params, this.person41, this.network4, runAsUserTenant);
    }

    private PublicApiClient.ListResponse<MemberOfSite> getSiteMembershipsForPerson41(PublicApiClient.Paging paging, String siteVisibility) throws Exception {
        return this.getSiteMembershipsForPerson41(paging, siteVisibility, true);
    }

    public void testGetSiteMembershipsWhereSiteVisibilityPrivate() throws Exception {
        int totalResults = 1;
        PublicApiClient.Paging paging = this.getPaging(null, null, totalResults, totalResults);
        PublicApiClient.ListResponse<MemberOfSite> resp = this.getSiteMembershipsForPerson41(null, SiteVisibility.PRIVATE.name());
        List<MemberOfSite> expectedList = this.getPersonSites(this.person41, this.site41);
        this.checkList(expectedList, paging.getExpectedPaging(), resp);
    }

    public void testGetSiteMembershipsWhereSiteVisibilityPublic() throws Exception {
        int totalResults = 2;
        PublicApiClient.Paging paging = this.getPaging(null, null, totalResults, totalResults);
        PublicApiClient.ListResponse<MemberOfSite> resp = this.getSiteMembershipsForPerson41(null, SiteVisibility.PUBLIC.name());
        List<MemberOfSite> expectedList = this.getPersonSites(this.person41, this.site42, this.site43);
        this.checkList(expectedList, paging.getExpectedPaging(), resp);
    }

    public void testGetSiteMembershipsWhereSiteVisibilityPublicAndSkipCount() throws Exception {
        Integer skipCount = 1;
        int maxItems = 2;
        int totalResults = 2;
        PublicApiClient.Paging paging = this.getPaging(skipCount, maxItems, totalResults, totalResults);
        PublicApiClient.ListResponse<MemberOfSite> resp = this.getSiteMembershipsForPerson41(paging, SiteVisibility.PUBLIC.name());
        List<MemberOfSite> expectedList = this.getPersonSites(this.person41, this.site43);
        this.checkList(expectedList, paging.getExpectedPaging(), resp);
    }

    public void testGetSiteMembershipsWhereSiteVisibilityModerated() throws Exception {
        int totalResults = 1;
        PublicApiClient.Paging paging = this.getPaging(null, null, totalResults, totalResults);
        PublicApiClient.ListResponse<MemberOfSite> resp = this.getSiteMembershipsForPerson41(null, SiteVisibility.MODERATED.name());
        List<MemberOfSite> expectedList = this.getPersonSites(this.person41, this.site44);
        this.checkList(expectedList, paging.getExpectedPaging(), resp);
    }

    public void testGetSiteMembershipsWhereSiteVisibilityInvalid() throws Exception {
        try {
            this.getSiteMembershipsForPerson41(null, "invalidVisibility", false);
            Assert.fail((String)"");
        }
        catch (PublicApiException e) {
            Assert.assertEquals((long)400L, (long)e.getHttpResponse().getStatusCode());
        }
    }

    public void testGetSiteMembershipsWhereSiteVisibilityNOTIncluded() throws Exception {
        try {
            this.getSiteMembershipsForPerson41NOTWhere(null, SiteVisibility.MODERATED.name(), false);
            Assert.fail((String)"");
        }
        catch (PublicApiException e) {
            Assert.assertEquals((long)400L, (long)e.getHttpResponse().getStatusCode());
        }
    }

    @Test
    public void testGetSiteMembershipsWithWhereClause() throws Exception {
        this.initializePersonAndNetwork4WithSites();
        this.publicApiClient.setRequestContext(new RequestContext(this.network4.getId(), this.person41.getId()));
        this.testGetSiteMembershipsWhereSiteVisibilityPrivate();
        this.testGetSiteMembershipsWhereSiteVisibilityPublic();
        this.testGetSiteMembershipsWhereSiteVisibilityPublicAndSkipCount();
        this.testGetSiteMembershipsWhereSiteVisibilityModerated();
        this.testGetSiteMembershipsWhereSiteVisibilityInvalid();
        this.testGetSiteMembershipsWhereSiteVisibilityNOTIncluded();
    }
}

