/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.web.scripts.blogs.posts;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.alfresco.model.ContentModel;
import org.alfresco.query.PagingRequest;
import org.alfresco.query.PagingResults;
import org.alfresco.repo.web.scripts.blogs.posts.AbstractGetBlogWebScript;
import org.alfresco.service.cmr.blog.BlogPostInfo;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.site.SiteInfo;
import org.springframework.extensions.webscripts.WebScriptRequest;

public class BlogPostsPerMonthGet
extends AbstractGetBlogWebScript {
    @Override
    protected PagingResults<BlogPostInfo> getBlogResultsImpl(SiteInfo site, NodeRef node, Date fromDate, Date toDate, PagingRequest pagingReq) {
        if (site != null) {
            return this.blogService.getPublished(site.getShortName(), fromDate, toDate, null, pagingReq);
        }
        return this.blogService.getPublished(node, fromDate, toDate, null, pagingReq);
    }

    @Override
    protected void createFtlModel(WebScriptRequest req, Map<String, Object> model, NodeRef node, PagingRequest pagingReq, PagingResults<BlogPostInfo> blogPostList) {
        model.put("data", this.getBlogPostMonths(blogPostList));
    }

    private Date getBeginOfMonthDate(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.set(date.getYear(), date.getMonth(), 1);
        return calendar.getTime();
    }

    private Date getEndOfMonthDate(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.set(date.getYear(), date.getMonth(), date.getDay());
        int lastDayOfSpecifiedMonth = calendar.getActualMaximum(5);
        calendar.set(date.getYear(), date.getMonth(), lastDayOfSpecifiedMonth, 23, 59, 59);
        return calendar.getTime();
    }

    private Map<String, Object> getMonthDataObject(Date date) {
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("year", date.getYear() + 1900);
        data.put("month", date.getMonth());
        data.put("firstPostInMonth", date);
        data.put("beginOfMonth", this.getBeginOfMonthDate(date));
        data.put("endOfMonth", this.getEndOfMonthDate(date));
        data.put("count", 1);
        return data;
    }

    private List<Map<String, Object>> getBlogPostMonths(PagingResults<BlogPostInfo> nodes) {
        ArrayList<Map<String, Object>> data = new ArrayList<Map<String, Object>>();
        if (!nodes.getPage().isEmpty()) {
            int currYear = -1;
            int currMonth = -1;
            Map<String, Object> currData = null;
            for (int x = 0; x < nodes.getPage().size(); ++x) {
                NodeRef node = ((BlogPostInfo)nodes.getPage().get(x)).getNodeRef();
                Date date = (Date)this.nodeService.getProperty(node, ContentModel.PROP_PUBLISHED);
                if (currYear != date.getYear() + 1900 || currMonth != date.getMonth()) {
                    currYear = date.getYear() + 1900;
                    currMonth = date.getMonth();
                    currData = this.getMonthDataObject(date);
                    data.add(currData);
                    continue;
                }
                Object countObj = currData.get("count");
                Integer countInt = countObj == null ? 0 : (Integer)countObj;
                currData.put("count", countInt + 1);
            }
        } else {
            Map<String, Object> emptyData = this.getMonthDataObject(new Date());
            emptyData.put("count", 0);
            data.add(emptyData);
        }
        return data;
    }
}

