/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.api.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.security.permissions.AccessDeniedException;
import org.alfresco.rest.api.model.Assoc;
import org.alfresco.rest.api.model.AssocChild;
import org.alfresco.rest.api.model.AssocTarget;
import org.alfresco.rest.api.model.ClassDefinition;
import org.alfresco.rest.api.model.ContentInfo;
import org.alfresco.rest.api.model.NodePermissions;
import org.alfresco.rest.api.model.PathInfo;
import org.alfresco.rest.api.model.UserInfo;
import org.alfresco.rest.api.search.model.SearchEntry;
import org.alfresco.rest.framework.resource.UniqueId;
import org.alfresco.service.ServiceRegistry;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.security.NoSuchPersonException;
import org.alfresco.service.cmr.security.PersonService;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.EqualsHelper;
import org.apache.chemistry.opencmis.commons.data.PropertyData;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Node
implements Comparable<Node> {
    private static final Log logger = LogFactory.getLog(Node.class);
    protected NodeRef nodeRef;
    protected String name;
    protected Date createdAt;
    protected Date modifiedAt;
    protected UserInfo createdByUser;
    protected UserInfo modifiedByUser;
    protected Date archivedAt;
    protected UserInfo archivedByUser;
    protected String versionLabel;
    protected String versionComment;
    protected String nodeId;
    protected Boolean isFolder;
    protected Boolean isFile;
    protected Boolean isLink;
    protected Boolean isLocked;
    protected NodeRef parentNodeRef;
    protected PathInfo pathInfo;
    protected String prefixTypeQName;
    protected String relativePath;
    protected List<AssocChild> secondaryChildren;
    protected List<AssocTarget> targets;
    protected List<String> aspectNames;
    protected Map<String, Object> properties;
    protected List<String> allowableOperations;
    protected NodePermissions nodePermissions;
    protected ClassDefinition definition;
    protected SearchEntry search = null;
    protected String location;
    protected Boolean isFavorite;
    protected ContentInfo contentInfo;
    protected Assoc association;
    protected String title;
    protected NodeRef guid;
    protected String description;
    protected String createdBy;
    protected String modifiedBy;

    public Node(NodeRef nodeRef, NodeRef parentNodeRef, Map<QName, Serializable> nodeProps, Map<String, UserInfo> mapUserInfo, ServiceRegistry sr) {
        if (nodeRef == null) {
            throw new IllegalArgumentException();
        }
        this.nodeRef = nodeRef;
        this.parentNodeRef = parentNodeRef;
        this.mapMinimalInfo(nodeProps, mapUserInfo, sr);
    }

    protected Object getValue(Map<String, PropertyData<?>> props, String name) {
        PropertyData<?> prop = props.get(name);
        Object value = prop != null ? prop.getFirstValue() : null;
        return value;
    }

    public Node() {
    }

    protected void mapMinimalInfo(Map<QName, Serializable> nodeProps, Map<String, UserInfo> mapUserInfo, ServiceRegistry sr) {
        PersonService personService = sr.getPersonService();
        this.name = (String)((Object)nodeProps.get(ContentModel.PROP_NAME));
        if (mapUserInfo == null) {
            mapUserInfo = new HashMap<String, UserInfo>(2);
        }
        this.createdAt = (Date)nodeProps.get(ContentModel.PROP_CREATED);
        this.createdByUser = Node.lookupUserInfo((String)((Object)nodeProps.get(ContentModel.PROP_CREATOR)), mapUserInfo, personService);
        this.modifiedAt = (Date)nodeProps.get(ContentModel.PROP_MODIFIED);
        this.modifiedByUser = Node.lookupUserInfo((String)((Object)nodeProps.get(ContentModel.PROP_MODIFIER)), mapUserInfo, personService);
    }

    public static UserInfo lookupUserInfo(String userName, Map<String, UserInfo> mapUserInfo, PersonService personService) {
        return Node.lookupUserInfo(userName, mapUserInfo, personService, false);
    }

    public static UserInfo lookupUserInfo(String userName, Map<String, UserInfo> mapUserInfo, PersonService personService, boolean displayNameOnly) {
        UserInfo userInfo = mapUserInfo.get(userName);
        if (userInfo == null && userName != null) {
            String sysUserName = AuthenticationUtil.getSystemUserName();
            if (userName.equals(sysUserName) || AuthenticationUtil.isMtEnabled() && userName.startsWith(sysUserName + "@")) {
                userInfo = new UserInfo(displayNameOnly ? null : userName, userName, "");
            } else {
                PersonService.PersonInfo pInfo = null;
                try {
                    NodeRef pNodeRef = personService.getPersonOrNull(userName);
                    if (pNodeRef != null) {
                        pInfo = personService.getPerson(pNodeRef);
                    }
                }
                catch (NoSuchPersonException noSuchPersonException) {
                }
                catch (AccessDeniedException accessDeniedException) {
                    // empty catch block
                }
                if (pInfo != null) {
                    userInfo = new UserInfo(displayNameOnly ? null : userName, pInfo.getFirstName(), pInfo.getLastName());
                } else {
                    logger.warn((Object)("Unknown person: " + userName));
                    userInfo = new UserInfo(displayNameOnly ? null : userName, userName, "");
                }
            }
            mapUserInfo.put(userName, userInfo);
        }
        return userInfo;
    }

    @JsonProperty(value="id")
    @UniqueId
    public NodeRef getNodeRef() {
        return this.nodeRef;
    }

    public void setNodeRef(NodeRef nodeRef) {
        this.nodeRef = nodeRef;
    }

    public Date getCreatedAt() {
        return this.createdAt;
    }

    public void setCreated(Date createdAt) {
        this.createdAt = createdAt;
    }

    public Date getModifiedAt() {
        return this.modifiedAt;
    }

    public UserInfo getModifiedByUser() {
        return this.modifiedByUser;
    }

    public UserInfo getCreatedByUser() {
        return this.createdByUser;
    }

    public void setCreatedByUser(UserInfo createdByUser) {
        this.createdByUser = createdByUser;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public PathInfo getPath() {
        return this.pathInfo;
    }

    public void setPath(PathInfo pathInfo) {
        this.pathInfo = pathInfo;
    }

    public String getNodeType() {
        return this.prefixTypeQName;
    }

    public void setNodeType(String prefixType) {
        this.prefixTypeQName = prefixType;
    }

    public Map<String, Object> getProperties() {
        return this.properties;
    }

    public void setProperties(Map<String, Object> props) {
        this.properties = props;
    }

    public List<String> getAspectNames() {
        return this.aspectNames;
    }

    public void setAspectNames(List<String> aspectNames) {
        this.aspectNames = aspectNames;
    }

    public NodeRef getParentId() {
        return this.parentNodeRef;
    }

    public void setParentId(NodeRef parentNodeRef) {
        this.parentNodeRef = parentNodeRef;
    }

    public Boolean getIsFolder() {
        return this.isFolder;
    }

    public void setIsFolder(Boolean isFolder) {
        this.isFolder = isFolder;
    }

    public Boolean getIsFile() {
        return this.isFile;
    }

    public void setIsFile(Boolean isFile) {
        this.isFile = isFile;
    }

    public Boolean getIsLink() {
        return this.isLink;
    }

    public void setIsLink(Boolean isLink) {
        this.isLink = isLink;
    }

    public Boolean getIsLocked() {
        return this.isLocked;
    }

    public void setIsLocked(Boolean isLocked) {
        this.isLocked = isLocked;
    }

    public Boolean getIsFavorite() {
        return this.isFavorite;
    }

    public void setIsFavorite(Boolean isFavorite) {
        this.isFavorite = isFavorite;
    }

    public List<String> getAllowableOperations() {
        return this.allowableOperations;
    }

    public void setAllowableOperations(List<String> allowableOperations) {
        this.allowableOperations = allowableOperations;
    }

    public NodePermissions getPermissions() {
        return this.nodePermissions;
    }

    public void setPermissions(NodePermissions nodePermissions) {
        this.nodePermissions = nodePermissions;
    }

    public List<AssocTarget> getTargets() {
        return this.targets;
    }

    public void setTargets(List<AssocTarget> targets) {
        this.targets = targets;
    }

    public Date getArchivedAt() {
        return this.archivedAt;
    }

    public void setArchivedAt(Date archivedAt) {
        this.archivedAt = archivedAt;
    }

    public UserInfo getArchivedByUser() {
        return this.archivedByUser;
    }

    public void setArchivedByUser(UserInfo archivedByUser) {
        this.archivedByUser = archivedByUser;
    }

    public String getVersionLabel() {
        return this.versionLabel;
    }

    public void setVersionLabel(String versionLabel) {
        this.versionLabel = versionLabel;
    }

    public String getVersionComment() {
        return this.versionComment;
    }

    public void setVersionComment(String versionComment) {
        this.versionComment = versionComment;
    }

    public String getLocation() {
        return this.location;
    }

    public void setLocation(String location) {
        this.location = location;
    }

    public String getNodeId() {
        return this.nodeId;
    }

    public void setNodeId(String nodeId) {
        this.nodeId = nodeId;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Node)) {
            return false;
        }
        Node node = (Node)other;
        return EqualsHelper.nullSafeEquals((Object)this.getNodeRef(), (Object)node.getNodeRef());
    }

    public String getRelativePath() {
        return this.relativePath;
    }

    public void setRelativePath(String relativePath) {
        this.relativePath = relativePath;
    }

    public List<AssocChild> getSecondaryChildren() {
        return this.secondaryChildren;
    }

    public void setSecondaryChildren(List<AssocChild> secondaryChildren) {
        this.secondaryChildren = secondaryChildren;
    }

    public ClassDefinition getDefinition() {
        return this.definition;
    }

    public void setDefinition(ClassDefinition definition) {
        this.definition = definition;
    }

    @Override
    public int compareTo(Node node) {
        return this.getNodeRef().toString().compareTo(node.getNodeRef().toString());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Node [id=").append(this.getNodeRef().getId());
        sb.append(", parentId=").append(this.getParentId());
        sb.append(", type=").append(this.getNodeType());
        sb.append(", name=").append(this.getName());
        sb.append(", isFolder=").append(this.getIsFolder());
        sb.append(", isFile=").append(this.getIsFile());
        sb.append(", modifiedAt=").append(this.getModifiedAt());
        sb.append(", modifiedByUser=").append(this.getModifiedByUser());
        sb.append(", createdAt=").append(this.getCreatedAt());
        sb.append(", createdByUser=").append(this.getCreatedByUser());
        if (this.getArchivedAt() != null) {
            sb.append(", archivedAt=").append(this.getArchivedAt());
        }
        if (this.getArchivedByUser() != null) {
            sb.append(", archivedByUser=").append(this.getArchivedByUser());
        }
        if (this.getVersionLabel() != null) {
            sb.append(", versionLabel=").append(this.getVersionLabel());
        }
        if (this.getVersionComment() != null) {
            sb.append(", versionComment=").append(this.getVersionComment());
        }
        if (this.getLocation() != null) {
            sb.append(", location=").append(this.getLocation());
        }
        if (this.getNodeId() != null) {
            sb.append(", nodeId=").append(this.getNodeId());
        }
        if (this.getIsLink() != null) {
            sb.append(", isLink=").append(this.getIsLink());
        }
        if (this.getPath() != null) {
            sb.append(", path=").append(this.getPath());
        }
        if (this.getContent() != null) {
            sb.append(", content=").append(this.getContent());
        }
        if (this.getAspectNames() != null) {
            sb.append(", aspectNames=").append(this.getAspectNames());
        }
        if (this.getProperties() != null) {
            // empty if block
        }
        if (this.getRelativePath() != null) {
            sb.append(", relativePath=").append(this.getRelativePath());
        }
        if (this.getAllowableOperations() != null) {
            sb.append(", allowableOperations=").append(this.getAllowableOperations());
        }
        if (this.getSearch() != null) {
            sb.append(", search=").append(this.getSearch());
        }
        sb.append("]");
        return sb.toString();
    }

    public void setContent(ContentInfo contentInfo) {
        this.contentInfo = contentInfo;
    }

    public ContentInfo getContent() {
        return this.contentInfo;
    }

    public Assoc getAssociation() {
        return this.association;
    }

    public void setAssociation(Assoc association) {
        this.association = association;
    }

    public SearchEntry getSearch() {
        return this.search;
    }

    public void setSearch(SearchEntry search) {
        this.search = search;
    }

    public NodeRef getGuid() {
        return this.guid;
    }

    public void setGuid(NodeRef guid) {
        this.guid = guid;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getCreatedBy() {
        return this.createdBy;
    }

    public void setCreatedBy(String createdBy) {
        this.createdBy = createdBy;
    }

    public String getModifiedBy() {
        return this.modifiedBy;
    }

    public void setModifiedBy(String modifiedBy) {
        this.modifiedBy = modifiedBy;
    }
}

