/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.api.nodes;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.alfresco.rest.api.Nodes;
import org.alfresco.rest.api.model.Assoc;
import org.alfresco.rest.api.model.AssocChild;
import org.alfresco.rest.api.model.Node;
import org.alfresco.rest.api.model.UserInfo;
import org.alfresco.rest.framework.resource.parameters.CollectionWithPagingInfo;
import org.alfresco.rest.framework.resource.parameters.Paging;
import org.alfresco.rest.framework.resource.parameters.Parameters;
import org.alfresco.rest.framework.resource.parameters.where.Query;
import org.alfresco.rest.framework.resource.parameters.where.QueryHelper;
import org.alfresco.rest.workflow.api.impl.MapBasedQueryWalker;
import org.alfresco.service.ServiceRegistry;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.cmr.repository.AssociationRef;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.namespace.NamespacePrefixResolver;
import org.alfresco.service.namespace.NamespaceService;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.namespace.QNamePattern;
import org.alfresco.service.namespace.RegexQNamePattern;
import org.alfresco.util.ParameterCheck;
import org.alfresco.util.PropertyCheck;
import org.springframework.beans.factory.InitializingBean;

public class AbstractNodeRelation
implements InitializingBean {
    protected static final List<String> EXCLUDED_NS = Arrays.asList("http://www.alfresco.org/model/system/1.0");
    private static final Set<String> WHERE_PARAMS_ASSOC_TYPE = new HashSet<String>(Arrays.asList("assocType"));
    protected ServiceRegistry sr;
    protected NodeService nodeService;
    protected NamespaceService namespaceService;
    protected DictionaryService dictionaryService;
    protected Nodes nodes;

    public void setNodes(Nodes nodes) {
        this.nodes = nodes;
    }

    public void setServiceRegistry(ServiceRegistry sr) {
        this.sr = sr;
    }

    public void afterPropertiesSet() {
        PropertyCheck.mandatory((Object)this, (String)"serviceRegistry", (Object)this.sr);
        ParameterCheck.mandatory((String)"nodes", (Object)this.nodes);
        this.nodeService = this.sr.getNodeService();
        this.namespaceService = this.sr.getNamespaceService();
        this.dictionaryService = this.sr.getDictionaryService();
    }

    protected QNamePattern getAssocTypeFromWhereElseAll(Parameters parameters) {
        QNamePattern assocTypeQNamePattern = RegexQNamePattern.MATCH_ALL;
        Query q = parameters.getQuery();
        if (q != null) {
            MapBasedQueryWalker propertyWalker = new MapBasedQueryWalker(WHERE_PARAMS_ASSOC_TYPE, null);
            QueryHelper.walk(q, propertyWalker);
            String assocTypeQNameStr = propertyWalker.getProperty("assocType", 8, String.class);
            if (assocTypeQNameStr != null) {
                assocTypeQNamePattern = this.nodes.getAssocType(assocTypeQNameStr);
            }
        }
        return assocTypeQNamePattern;
    }

    protected CollectionWithPagingInfo<Node> listNodePeerAssocs(List<AssociationRef> assocRefs, Parameters parameters, boolean returnTarget) {
        HashMap<QName, String> qnameMap = new HashMap<QName, String>(3);
        HashMap<String, UserInfo> mapUserInfo = new HashMap<String, UserInfo>(10);
        List<String> includeParam = parameters.getInclude();
        ArrayList<Node> collection = new ArrayList<Node>(assocRefs.size());
        for (AssociationRef assocRef : assocRefs) {
            NodeRef nodeRef = returnTarget ? assocRef.getTargetRef() : assocRef.getSourceRef();
            Node node = this.nodes.getFolderOrDocument(nodeRef, null, null, includeParam, mapUserInfo);
            QName assocTypeQName = assocRef.getTypeQName();
            if (EXCLUDED_NS.contains(assocTypeQName.getNamespaceURI())) continue;
            String assocType = (String)qnameMap.get(assocTypeQName);
            if (assocType == null) {
                assocType = assocTypeQName.toPrefixString((NamespacePrefixResolver)this.namespaceService);
                qnameMap.put(assocTypeQName, assocType);
            }
            node.setAssociation(new Assoc(assocType));
            collection.add(node);
        }
        return this.listPage(collection, parameters.getPaging());
    }

    protected CollectionWithPagingInfo<Node> listNodeChildAssocs(List<ChildAssociationRef> childAssocRefs, Parameters parameters, Boolean isPrimary, boolean returnChild) {
        HashMap<QName, String> qnameMap = new HashMap<QName, String>(3);
        HashMap<String, UserInfo> mapUserInfo = new HashMap<String, UserInfo>(10);
        List<String> includeParam = parameters.getInclude();
        ArrayList<Node> collection = new ArrayList<Node>(childAssocRefs.size());
        for (ChildAssociationRef childAssocRef : childAssocRefs) {
            if (isPrimary != null && isPrimary.booleanValue() != childAssocRef.isPrimary()) continue;
            NodeRef nodeRef = returnChild ? childAssocRef.getChildRef() : childAssocRef.getParentRef();
            Node node = this.nodes.getFolderOrDocument(nodeRef, null, null, includeParam, mapUserInfo);
            QName assocTypeQName = childAssocRef.getTypeQName();
            if (EXCLUDED_NS.contains(assocTypeQName.getNamespaceURI())) continue;
            String assocType = (String)qnameMap.get(assocTypeQName);
            if (assocType == null) {
                assocType = assocTypeQName.toPrefixString((NamespacePrefixResolver)this.namespaceService);
                qnameMap.put(assocTypeQName, assocType);
            }
            node.setAssociation(new AssocChild(assocType, childAssocRef.isPrimary()));
            collection.add(node);
        }
        return this.listPage(collection, parameters.getPaging());
    }

    protected <T> CollectionWithPagingInfo<T> listPage(List<T> result, Paging paging) {
        int skipCount = paging.getSkipCount();
        int pageSize = paging.getMaxItems();
        int pageEnd = skipCount + pageSize;
        ArrayList<T> page = new ArrayList<T>(pageSize);
        if (result == null) {
            result = Collections.emptyList();
        }
        Iterator<T> it = result.iterator();
        for (int counter = 0; counter < pageEnd && it.hasNext(); ++counter) {
            T element = it.next();
            if (counter < skipCount) continue;
            if (counter > pageEnd - 1) break;
            page.add(element);
        }
        int totalCount = result.size();
        boolean hasMoreItems = skipCount + page.size() < totalCount;
        return CollectionWithPagingInfo.asPaged(paging, page, hasMoreItems, totalCount);
    }
}

