/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.framework.jacksonextensions;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.PropertyName;
import com.fasterxml.jackson.databind.type.SimpleType;
import java.io.IOException;
import org.alfresco.rest.api.model.Document;
import org.alfresco.rest.api.model.DocumentTarget;
import org.alfresco.rest.api.model.Folder;
import org.alfresco.rest.api.model.FolderTarget;
import org.alfresco.rest.api.model.Site;
import org.alfresco.rest.api.model.SiteTarget;
import org.alfresco.rest.api.model.Target;
import org.alfresco.service.cmr.favourites.FavouritesService;

public class TargetDeserializer
extends JsonDeserializer<Target> {
    public Target deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        Target target = null;
        JsonToken curr = jp.getCurrentToken();
        if (curr == JsonToken.START_OBJECT) {
            while (jp.nextToken() != JsonToken.END_OBJECT) {
                BeanProperty.Std p;
                SimpleType t;
                String fieldname = jp.getCurrentName();
                if (FavouritesService.Type.SITE.toString().equals(fieldname.toUpperCase())) {
                    jp.nextToken();
                    try {
                        t = SimpleType.construct(Site.class);
                        p = new BeanProperty.Std(new PropertyName(""), (JavaType)t, null, null, null, null);
                        JsonDeserializer siteDeserializer = ctxt.findContextualValueDeserializer((JavaType)t, (BeanProperty)p);
                        Site site = (Site)siteDeserializer.deserialize(jp, ctxt);
                        target = new SiteTarget(site);
                        continue;
                    }
                    catch (JsonMappingException e) {
                        throw new IllegalArgumentException("Target body is invalid for target type");
                    }
                }
                if (FavouritesService.Type.FILE.toString().equals(fieldname.toUpperCase())) {
                    jp.nextToken();
                    try {
                        t = SimpleType.construct(Document.class);
                        p = new BeanProperty.Std(new PropertyName(""), (JavaType)t, null, null, null, null);
                        JsonDeserializer documentDeserializer = ctxt.findContextualValueDeserializer((JavaType)t, (BeanProperty)p);
                        Document document = (Document)documentDeserializer.deserialize(jp, ctxt);
                        target = new DocumentTarget(document);
                        continue;
                    }
                    catch (JsonMappingException e) {
                        throw new IllegalArgumentException("Target body is invalid for target type");
                    }
                }
                if (!FavouritesService.Type.FOLDER.toString().equals(fieldname.toUpperCase())) continue;
                jp.nextToken();
                try {
                    t = SimpleType.construct(Folder.class);
                    p = new BeanProperty.Std(new PropertyName(""), (JavaType)t, null, null, null, null);
                    JsonDeserializer folderDeserializer = ctxt.findContextualValueDeserializer((JavaType)t, (BeanProperty)p);
                    Folder folder = (Folder)folderDeserializer.deserialize(jp, ctxt);
                    target = new FolderTarget(folder);
                }
                catch (JsonMappingException e) {
                    throw new IllegalArgumentException("Target body is invalid for target type");
                }
            }
            return target;
        }
        throw new IOException("Unable to deserialize favourite: " + curr.asString());
    }
}

