/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.api.tests;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.rest.AbstractSingleNetworkSiteTest;
import org.alfresco.rest.api.model.Site;
import org.alfresco.rest.api.nodes.NodesEntityResource;
import org.alfresco.rest.api.tests.RepoService;
import org.alfresco.rest.api.tests.client.HttpResponse;
import org.alfresco.rest.api.tests.client.PublicApiClient;
import org.alfresco.rest.api.tests.client.data.ContentInfo;
import org.alfresco.rest.api.tests.client.data.Document;
import org.alfresco.rest.api.tests.client.data.Node;
import org.alfresco.rest.api.tests.client.data.Rendition;
import org.alfresco.rest.api.tests.util.MultiPartBuilder;
import org.alfresco.rest.api.tests.util.RestApiUtil;
import org.alfresco.service.cmr.site.SiteVisibility;
import org.junit.Assert;
import org.junit.Test;

public class NodeVersionRenditionsApiTest
extends AbstractSingleNetworkSiteTest {
    private static final long DELAY_IN_MS = 500L;
    private static final List<String> DEFAULT_RENDITIONS_FOR_TXT = new ArrayList<String>(List.of("avatar", "avatar32", "doclib", "imgpreview", "medium", "pdf"));

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testUpFileVersionRenditions() throws Exception {
        this.setRequestContext(user1);
        String myFolderNodeId = this.getMyNodeId();
        String f1Id = this.createFolder(myFolderNodeId, "f1").getId();
        try {
            int verCnt = 1;
            int cnt = 1;
            String versionLabel = "1.0";
            String textContentSuffix = "Amazingly few discotheques provide jukeboxes ";
            String contentName = "content-2-" + System.currentTimeMillis();
            String content = textContentSuffix + cnt;
            Boolean majorVersion = true;
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("majorVersion", majorVersion.toString());
            Document documentResp = this.createTextFile(f1Id, contentName, content, "UTF-8", params);
            String docId = documentResp.getId();
            Assert.assertTrue((boolean)documentResp.getAspectNames().contains("cm:versionable"));
            Assert.assertNotNull(documentResp.getProperties());
            Assert.assertEquals((Object)versionLabel, (Object)documentResp.getProperties().get("cm:versionLabel"));
            cnt = 2;
            versionLabel = this.updateFileVersions(user1, docId, cnt, textContentSuffix, verCnt, majorVersion, versionLabel);
            Assert.assertEquals((Object)"3.0", (Object)versionLabel);
            Assert.assertEquals((long)3L, (long)(verCnt += cnt));
            HttpResponse response = this.getAll(this.getNodeVersionsUrl(docId), null, null, 200);
            List<Node> nodes = RestApiUtil.parseRestApiEntries(response.getJsonResponse(), Node.class);
            Assert.assertEquals((long)verCnt, (long)nodes.size());
            Thread.sleep(500L);
            this.checkCreateAndGetVersionRendition(docId, "1.0", "doclib");
            this.checkCreateAndGetVersionRendition(docId, "3.0", "doclib");
            this.checkCreateAndGetVersionRendition(docId, "2.0", "doclib");
            this.checkCreateAndGetVersionRendition(docId, null, "doclib");
        }
        finally {
            this.setRequestContext(user1);
            this.deleteNode(f1Id, true, 204);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testUpFileVersionRenditionsWithDoclib() throws Exception {
        this.setRequestContext(user1);
        String myFolderNodeId = this.getMyNodeId();
        String f1Id = this.createFolder(myFolderNodeId, "f1").getId();
        try {
            int verCnt = 1;
            int cnt = 1;
            String versionLabel = "0.1";
            String textContentSuffix = "Amazingly few discotheques provide jukeboxes ";
            String contentName = "content-2-" + System.currentTimeMillis();
            String content = textContentSuffix + cnt;
            Boolean majorVersion = false;
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("majorVersion", majorVersion.toString());
            params.put("renditions", "doclib");
            Document documentResp = this.createTextFile(f1Id, contentName, content, "UTF-8", params);
            String docId = documentResp.getId();
            Assert.assertTrue((boolean)documentResp.getAspectNames().contains("cm:versionable"));
            Assert.assertNotNull(documentResp.getProperties());
            Assert.assertEquals((Object)versionLabel, (Object)documentResp.getProperties().get("cm:versionLabel"));
            this.checkAndGetVersionRendition(docId, null, "doclib");
            cnt = 1;
            versionLabel = this.updateFileVersions(user1, docId, cnt, textContentSuffix, verCnt, majorVersion, versionLabel);
            Assert.assertEquals((Object)"0.2", (Object)versionLabel);
            Assert.assertEquals((long)2L, (long)(verCnt += cnt));
            HttpResponse response = this.getAll(this.getNodeVersionsUrl(docId), null, null, 200);
            List<Node> nodes = RestApiUtil.parseRestApiEntries(response.getJsonResponse(), Node.class);
            Assert.assertEquals((long)verCnt, (long)nodes.size());
            Thread.sleep(500L);
            this.checkCreateAndGetVersionRendition(docId, "0.2", "doclib");
            this.checkAndGetVersionRendition(docId, null, "doclib");
        }
        finally {
            this.setRequestContext(user1);
            this.deleteNode(f1Id, true, 204);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testNegative() throws Exception {
        AuthenticationUtil.clearCurrentSecurityContext();
        this.setRequestContext(null);
        this.getAll(this.getNodeVersionRenditionsUrl("dummy", "1.0"), null, 401);
        this.getSingle(this.getNodeVersionRenditionsUrl("dummy", "1.0"), "doclib", null, 401);
        this.getSingle(this.getNodeVersionRenditionsUrl("dummy", "1.0"), "doclib/content", null, 401);
        Rendition renditionRequest = new Rendition();
        renditionRequest.setId("doclib");
        this.post(this.getNodeVersionRenditionsUrl("dummy", "1.0"), RestApiUtil.toJsonAsString(renditionRequest), 401);
        this.setRequestContext(user1);
        String myFolderNodeId = this.getMyNodeId();
        String f1Id = this.createFolder(myFolderNodeId, "f1").getId();
        try {
            boolean verCnt = true;
            int cnt = 1;
            String versionLabel = "1.0";
            String textContentSuffix = "Amazingly few discotheques provide jukeboxes ";
            String contentName = "content-2-" + System.currentTimeMillis();
            String content = textContentSuffix + cnt;
            Document documentResp = this.createTextFile(f1Id, contentName, content, "UTF-8", null);
            String docId = documentResp.getId();
            this.getAll(this.getNodeVersionRenditionsUrl(docId, "1.0"), null, 200);
            this.checkCreateAndGetVersionRendition(docId, "1.0", "doclib");
            renditionRequest.setId("doclib");
            this.post(this.getNodeVersionRenditionsUrl(docId, "1.0"), RestApiUtil.toJsonAsString(renditionRequest), 409);
            this.getSingle(this.getNodeVersionRenditionsUrl("dummy", "1.0"), "dummy", null, 404);
            this.getSingle(this.getNodeVersionRenditionsUrl("dummy", "1.0"), "dummy/content", null, 404);
            renditionRequest.setId("dummy");
            this.post(this.getNodeVersionRenditionsUrl("dummy", "1.0"), RestApiUtil.toJsonAsString(renditionRequest), 404);
            this.getAll(this.getNodeVersionRenditionsUrl(docId, "4.0"), null, 404);
            this.getSingle(this.getNodeVersionRenditionsUrl(docId, "4.0"), "doclib", null, 404);
            this.getSingle(this.getNodeVersionRenditionsUrl(docId, "4.0"), "doclib/content", null, 404);
            renditionRequest.setId("doclib");
            this.post(this.getNodeVersionRenditionsUrl(docId, "4.0"), RestApiUtil.toJsonAsString(renditionRequest), 404);
            this.getAll(this.getNodeVersionRenditionsUrl("dummy", "1.0"), null, 404);
            this.getSingle(this.getNodeVersionRenditionsUrl("dummy", "1.0"), "doclib", null, 404);
            this.getSingle(this.getNodeVersionRenditionsUrl("dummy", "1.0"), "doclib/content", null, 404);
            renditionRequest.setId("doclib");
            this.post(this.getNodeVersionRenditionsUrl("dummy", "1.0"), RestApiUtil.toJsonAsString(renditionRequest), 404);
        }
        finally {
            this.setRequestContext(user1);
            this.deleteNode(f1Id, true, 204);
        }
    }

    @Test
    public void testRequestVersionRenditionContentDirectUrl() throws Exception {
        this.setRequestContext(user1);
        RepoService.TestNetwork networkN1 = this.repoService.createNetworkWithAlias("ping", true);
        networkN1.create();
        RepoService.TestPerson userOneN1 = networkN1.createUser();
        this.setRequestContext(networkN1.getId(), userOneN1.getId(), null);
        String siteTitle = "RandomSite" + System.currentTimeMillis();
        Site userOneN1Site = this.createSite(siteTitle, SiteVisibility.PRIVATE);
        String PROP_LTM = "cm:lastThumbnailModification";
        String RENDITION_NAME = "imgpreview";
        String userId = userOneN1.getId();
        this.setRequestContext(networkN1.getId(), userOneN1.getId(), null);
        String folderName = "folder" + System.currentTimeMillis();
        String parentId = this.getSiteContainerNodeId(userOneN1Site.getId(), "documentLibrary");
        String folder_Id = this.createNode(parentId, folderName, "cm:folder", null).getId();
        String fileName = "quick.pdf";
        File file = this.getResourceFile(fileName);
        MultiPartBuilder.MultiPartRequest reqBody = MultiPartBuilder.create().setFileData(new MultiPartBuilder.FileData(fileName, file)).build();
        Map<String, String> params = Collections.singletonMap("include", "properties");
        HttpResponse response = this.post(this.getNodeChildrenUrl(folder_Id), reqBody.getBody(), params, null, "alfresco", reqBody.getContentType(), 201);
        Document document1 = RestApiUtil.parseRestApiEntry(response.getJsonResponse(), Document.class);
        String contentNodeId = document1.getId();
        Assert.assertNotNull(document1.getProperties());
        Thread.sleep(500L);
        response = this.getSingle(this.getNodeRenditionsUrl(contentNodeId), RENDITION_NAME, 200);
        Rendition rendition = RestApiUtil.parseRestApiEntry(response.getJsonResponse(), Rendition.class);
        Assert.assertNotNull((Object)rendition);
        Assert.assertEquals((Object)((Object)Rendition.RenditionStatus.NOT_CREATED), (Object)((Object)rendition.getStatus()));
        params = new HashMap<String, String>();
        params.put("placeholder", "false");
        this.getSingle(this.getNodeRenditionsUrl(contentNodeId), RENDITION_NAME + "/content", params, 404);
        rendition = this.createAndGetRendition(contentNodeId, RENDITION_NAME);
        Assert.assertNotNull((Object)rendition);
        params = new HashMap<String, String>();
        params.put("placeholder", "false");
        response = this.getSingle(this.getNodeRenditionsUrl(contentNodeId), RENDITION_NAME + "/content", params, 200);
        byte[] renditionBytes1 = response.getResponseAsBytes();
        Assert.assertNotNull((Object)renditionBytes1);
        params = Collections.singletonMap("include", "properties");
        response = this.getSingle(NodesEntityResource.class, contentNodeId, params, 200);
        Document document1b = RestApiUtil.parseRestApiEntry(response.getJsonResponse(), Document.class);
        Assert.assertEquals((Object)document1b.getModifiedByUser().getId(), (Object)document1.getModifiedByUser().getId());
        fileName = "quick-2.pdf";
        file = this.getResourceFile(fileName);
        reqBody = MultiPartBuilder.create().setFileData(new MultiPartBuilder.FileData("quick.pdf", file)).setOverwrite(true).build();
        response = this.post(this.getNodeChildrenUrl(folder_Id), reqBody.getBody(), null, null, "alfresco", reqBody.getContentType(), 201);
        Document document2 = RestApiUtil.parseRestApiEntry(response.getJsonResponse(), Document.class);
        Assert.assertEquals((Object)contentNodeId, (Object)document2.getId());
        Thread.sleep(2000L);
        params = new HashMap<String, String>();
        params.put("placeholder", "false");
        response = this.getSingle(this.getNodeRenditionsUrl(contentNodeId), RENDITION_NAME + "/content", params, 200);
        Assert.assertNotNull((Object)response.getResponseAsBytes());
        Assert.assertNotEquals((Object)renditionBytes1, (Object)response.getResponseAsBytes());
        params = Collections.singletonMap("include", "properties");
        response = this.getSingle(NodesEntityResource.class, contentNodeId, params, 200);
        Document document2b = RestApiUtil.parseRestApiEntry(response.getJsonResponse(), Document.class);
        String contentNodeId2b = document2b.getId();
        HttpResponse dauResponse = this.post(this.getRequestVersionRenditionContentDirectUrl(contentNodeId2b, "1.0", RENDITION_NAME), null, null, null, null, 501);
    }

    @Test
    public void testRequestVersionRenditionContentDirectUrlErrorResponses() throws Exception {
        this.setRequestContext(user1);
        String folderNodeId = this.createUniqueFolder(this.getMyNodeId());
        String contentNodeId = this.createUniqueContent(folderNodeId);
        this.createVersionRendition(contentNodeId, "1.0", "doclib");
        this.enableRestDirectAccessUrls();
        HttpResponse dauResponseForNoSuchNode = this.post(this.getRequestVersionRenditionContentDirectUrl("nosuchnode", "1.0", "doclib"), null, 404);
        HttpResponse dauResponseForNodeIsNotAFile = this.post(this.getRequestVersionRenditionContentDirectUrl(folderNodeId, "1.0", "doclib"), null, 400);
        HttpResponse dauResponseForNoSuchVersion = this.post(this.getRequestVersionRenditionContentDirectUrl(contentNodeId, "2.0", "doclib"), null, 404);
        HttpResponse dauResponseForNoSuchRendition = this.post(this.getRequestVersionRenditionContentDirectUrl(contentNodeId, "1.0", "avatar"), null, 404);
        this.disableRestDirectAccessUrls();
    }

    private void checkCreateAndGetVersionRendition(String docId, String versionId, String renditionId) throws Exception {
        String getRenditionsUrl = versionId != null && !versionId.isEmpty() ? this.getNodeVersionRenditionsUrl(docId, versionId) : this.getNodeRenditionsUrl(docId);
        PublicApiClient.Paging paging = this.getPaging(0, 50);
        HttpResponse response = this.getAll(getRenditionsUrl, paging, 200);
        List<Rendition> renditions = RestApiUtil.parseRestApiEntries(response.getJsonResponse(), Rendition.class);
        Assert.assertTrue((renditions.size() == DEFAULT_RENDITIONS_FOR_TXT.size() ? 1 : 0) != 0);
        for (Rendition rendition : renditions) {
            Assert.assertEquals((Object)((Object)Rendition.RenditionStatus.NOT_CREATED), (Object)((Object)rendition.getStatus()));
            Assert.assertTrue((boolean)DEFAULT_RENDITIONS_FOR_TXT.contains(rendition.getId()));
        }
        response = this.getSingle(getRenditionsUrl, renditionId, 200);
        Rendition rendition = RestApiUtil.parseRestApiEntry(response.getJsonResponse(), Rendition.class);
        Assert.assertNotNull((Object)rendition);
        Assert.assertEquals((Object)((Object)Rendition.RenditionStatus.NOT_CREATED), (Object)((Object)rendition.getStatus()));
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("placeholder", "false");
        this.getSingle(getRenditionsUrl, renditionId + "/content", params, 404);
        params = new HashMap();
        params.put("placeholder", "true");
        response = this.getSingle(getRenditionsUrl, renditionId + "/content", params, 200);
        Assert.assertNotNull((Object)response.getResponseAsBytes());
        rendition = this.createAndGetRendition(docId, versionId, renditionId);
        Assert.assertNotNull((Object)rendition);
        Assert.assertEquals((Object)((Object)Rendition.RenditionStatus.CREATED), (Object)((Object)rendition.getStatus()));
        ContentInfo contentInfo = rendition.getContent();
        Assert.assertNotNull((Object)contentInfo);
        Assert.assertEquals((Object)"image/png", (Object)contentInfo.getMimeType());
        Assert.assertEquals((Object)"PNG Image", (Object)contentInfo.getMimeTypeName());
        Assert.assertNotNull((Object)contentInfo.getEncoding());
        Assert.assertTrue((contentInfo.getSizeInBytes() > 0L ? 1 : 0) != 0);
    }

    private void checkAndGetVersionRendition(String docId, String versionId, String renditionId) throws Exception {
        String getRenditionsUrl = versionId != null && !versionId.isEmpty() ? this.getNodeVersionRenditionsUrl(docId, versionId) : this.getNodeRenditionsUrl(docId);
        PublicApiClient.Paging paging = this.getPaging(0, 50);
        HttpResponse response = this.getAll(getRenditionsUrl, paging, 200);
        List<Rendition> renditions = RestApiUtil.parseRestApiEntries(response.getJsonResponse(), Rendition.class);
        Assert.assertTrue((renditions.size() == DEFAULT_RENDITIONS_FOR_TXT.size() ? 1 : 0) != 0);
        for (Rendition rendition : renditions) {
            Assert.assertTrue((boolean)DEFAULT_RENDITIONS_FOR_TXT.contains(rendition.getId()));
        }
        Rendition rendition = this.waitAndGetRendition(docId, versionId, renditionId);
        Assert.assertNotNull((Object)rendition);
        Assert.assertEquals((Object)((Object)Rendition.RenditionStatus.CREATED), (Object)((Object)rendition.getStatus()));
        ContentInfo contentInfo = rendition.getContent();
        Assert.assertNotNull((Object)contentInfo);
        Assert.assertEquals((Object)"image/png", (Object)contentInfo.getMimeType());
        Assert.assertEquals((Object)"PNG Image", (Object)contentInfo.getMimeTypeName());
        Assert.assertNotNull((Object)contentInfo.getEncoding());
        Assert.assertTrue((contentInfo.getSizeInBytes() > 0L ? 1 : 0) != 0);
    }

    private void createVersionRendition(String contentNodeId, String versionId, String renditionId) throws Exception {
        this.getAll(this.getNodeVersionRenditionsUrl(contentNodeId, versionId), null, 200);
        this.checkCreateAndGetVersionRendition(contentNodeId, versionId, renditionId);
    }

    @Override
    public String getScope() {
        return "public";
    }
}

