/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.api.tests;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.alfresco.repo.tenant.TenantUtil;
import org.alfresco.rest.api.tests.EnterpriseTestApi;
import org.alfresco.rest.api.tests.RepoService;
import org.alfresco.rest.api.tests.client.HttpResponse;
import org.alfresco.rest.api.tests.client.PublicApiClient;
import org.alfresco.rest.api.tests.client.PublicApiException;
import org.alfresco.rest.api.tests.client.RequestContext;
import org.alfresco.rest.api.tests.client.data.Site;
import org.alfresco.rest.api.tests.client.data.SiteImpl;
import org.alfresco.rest.api.tests.client.data.SiteMember;
import org.alfresco.rest.api.tests.client.data.SiteRole;
import org.alfresco.service.cmr.site.SiteVisibility;
import org.alfresco.util.GUID;
import org.json.simple.JSONObject;
import org.junit.Assert;
import org.junit.Test;

public class TestSiteMembers
extends EnterpriseTestApi {
    @Test
    public void testSiteMembers() throws Exception {
        SiteMember siteMember1;
        Iterator<RepoService.TestNetwork> networksIt = this.getTestFixture().getNetworksIt();
        final RepoService.TestNetwork testNetwork = networksIt.next();
        final List<String> networkPeople = testNetwork.getPersonIds();
        String personId = networkPeople.get(0);
        PublicApiClient.Sites sitesProxy = this.publicApiClient.sites();
        final ArrayList<SiteMember> expectedSiteMembers = new ArrayList<SiteMember>();
        RepoService.TestSite testSite = (RepoService.TestSite)TenantUtil.runAsUserTenant((TenantUtil.TenantRunAsWork)new TenantUtil.TenantRunAsWork<RepoService.TestSite>(){

            public RepoService.TestSite doWork() throws Exception {
                RepoService.TestSite testSite = testNetwork.createSite(SiteVisibility.PRIVATE);
                for (int i = 1; i <= 5; ++i) {
                    String inviteeId = (String)networkPeople.get(i);
                    testSite.inviteToSite(inviteeId, SiteRole.SiteConsumer);
                    SiteMember sm = new SiteMember(inviteeId, TestSiteMembers.this.repoService.getPerson(inviteeId), testSite.getSiteId(), SiteRole.SiteConsumer.toString());
                    expectedSiteMembers.add(sm);
                }
                return testSite;
            }
        }, (String)personId, (String)testNetwork.getId());
        SiteMember sm = new SiteMember(personId, this.repoService.getPerson(personId), testSite.getSiteId(), SiteRole.SiteManager.toString());
        expectedSiteMembers.add(sm);
        Collections.sort(expectedSiteMembers);
        int skipCount = 0;
        int maxItems = 2;
        PublicApiClient.Paging paging = this.getPaging(skipCount, maxItems, expectedSiteMembers.size(), 6);
        this.publicApiClient.setRequestContext(new RequestContext(testNetwork.getId(), personId));
        PublicApiClient.ListResponse<SiteMember> siteMembers = sitesProxy.getSiteMembers(testSite.getSiteId(), this.createParams(paging, null));
        this.checkList(expectedSiteMembers.subList(skipCount, skipCount + paging.getExpectedPaging().getCount()), paging.getExpectedPaging(), siteMembers);
        skipCount = 2;
        maxItems = 10;
        paging = this.getPaging(skipCount, maxItems, expectedSiteMembers.size(), 6);
        this.publicApiClient.setRequestContext(new RequestContext(testNetwork.getId(), personId));
        siteMembers = sitesProxy.getSiteMembers(testSite.getSiteId(), this.createParams(paging, null));
        this.checkList(expectedSiteMembers.subList(skipCount, skipCount + paging.getExpectedPaging().getCount()), paging.getExpectedPaging(), siteMembers);
        HttpResponse response = sitesProxy.getAll("sites", testSite.getSiteId(), "members", null, this.createParams(paging, Collections.singletonMap("includeSource", "true")), "Failed to get all site members");
        this.checkList(expectedSiteMembers.subList(skipCount, skipCount + paging.getExpectedPaging().getCount()), paging.getExpectedPaging(), SiteMember.parseSiteMembers(testSite.getSiteId(), response.getJsonResponse()));
        JSONObject source = sitesProxy.parseListSource(response.getJsonResponse());
        Site sourceSite = SiteImpl.parseSite(source);
        Assert.assertNotNull((Object)sourceSite);
        testSite.expected(sourceSite);
        try {
            skipCount = 2;
            maxItems = 10;
            paging = this.getPaging(skipCount, maxItems, expectedSiteMembers.size(), 6);
            this.publicApiClient.setRequestContext(new RequestContext(testNetwork.getId(), personId));
            sitesProxy.getSiteMembers(GUID.generate(), this.createParams(paging, null));
            Assert.fail();
        }
        catch (PublicApiException e) {
            Assert.assertEquals((long)404L, (long)e.getHttpResponse().getStatusCode());
        }
        try {
            SiteMember siteMember = (SiteMember)expectedSiteMembers.get(0);
            this.publicApiClient.setRequestContext(new RequestContext(testNetwork.getId(), personId));
            sitesProxy.update("sites", testSite.getSiteId(), "members", null, siteMember.toJSON().toString(), "Unable to PUT site members");
            Assert.fail();
        }
        catch (PublicApiException e) {
            Assert.assertEquals((long)405L, (long)e.getHttpResponse().getStatusCode());
        }
        try {
            siteMember1 = (SiteMember)expectedSiteMembers.get(0);
            this.publicApiClient.setRequestContext(new RequestContext(testNetwork.getId(), personId));
            sitesProxy.create("sites", testSite.getSiteId(), "members", siteMember1.getMemberId(), siteMember1.toJSON().toString(), "Unable to POST to a site member");
            Assert.fail();
        }
        catch (PublicApiException e) {
            Assert.assertEquals((long)405L, (long)e.getHttpResponse().getStatusCode());
        }
        try {
            siteMember1 = (SiteMember)expectedSiteMembers.get(0);
            this.publicApiClient.setRequestContext(new RequestContext(testNetwork.getId(), personId));
            sitesProxy.update("sites", testSite.getSiteId(), "members", null, siteMember1.toJSON().toString(), "Unable to PUT site members");
            Assert.fail();
        }
        catch (PublicApiException e) {
            Assert.assertEquals((long)405L, (long)e.getHttpResponse().getStatusCode());
        }
        try {
            this.publicApiClient.setRequestContext(new RequestContext(testNetwork.getId(), personId));
            sitesProxy.remove("sites", testSite.getSiteId(), "members", null, "Unable to DELETE site members");
            Assert.fail();
        }
        catch (PublicApiException e) {
            Assert.assertEquals((long)405L, (long)e.getHttpResponse().getStatusCode());
        }
        siteMember1 = (SiteMember)expectedSiteMembers.get(0);
        this.publicApiClient.setRequestContext(new RequestContext(testNetwork.getId(), personId));
        SiteMember ret = sitesProxy.updateSiteMember(testSite.getSiteId(), siteMember1);
        Assert.assertEquals((Object)siteMember1.getRole(), (Object)ret.getRole());
        RepoService.TestPerson expectedSiteMember = this.repoService.getPerson(siteMember1.getMemberId());
        expectedSiteMember.expected(ret.getMember());
        siteMember1 = (SiteMember)expectedSiteMembers.get(0);
        this.publicApiClient.setRequestContext(new RequestContext(testNetwork.getId(), personId));
        ret = sitesProxy.getSingleSiteMember(testSite.getSiteId(), siteMember1.getMemberId());
        siteMember1.expected(ret);
        Iterator<RepoService.TestNetwork> accountsIt = this.getTestFixture().getNetworksIt();
        Assert.assertTrue((boolean)accountsIt.hasNext());
        final RepoService.TestNetwork network1 = accountsIt.next();
        Assert.assertTrue((boolean)accountsIt.hasNext());
        final RepoService.TestNetwork network2 = accountsIt.next();
        final ArrayList people = new ArrayList();
        TenantUtil.runAsSystemTenant((TenantUtil.TenantRunAsWork)new TenantUtil.TenantRunAsWork<Void>(){

            public Void doWork() throws Exception {
                RepoService.TestPerson person = network1.createUser();
                people.add(person);
                person = network1.createUser();
                people.add(person);
                person = network1.createUser();
                people.add(person);
                return null;
            }
        }, (String)network1.getId());
        RepoService.TestPerson person1 = (RepoService.TestPerson)people.get(0);
        RepoService.TestPerson person2 = (RepoService.TestPerson)people.get(1);
        RepoService.TestPerson person3 = (RepoService.TestPerson)people.get(2);
        TenantUtil.runAsSystemTenant((TenantUtil.TenantRunAsWork)new TenantUtil.TenantRunAsWork<Void>(){

            public Void doWork() throws Exception {
                RepoService.TestPerson person = network2.createUser();
                people.add(person);
                return null;
            }
        }, (String)network2.getId());
        RepoService.TestPerson person4 = (RepoService.TestPerson)people.get(3);
        RepoService.TestSite site = (RepoService.TestSite)TenantUtil.runAsUserTenant((TenantUtil.TenantRunAsWork)new TenantUtil.TenantRunAsWork<RepoService.TestSite>(){

            public RepoService.TestSite doWork() throws Exception {
                RepoService.TestSite site = network1.createSite(SiteVisibility.PUBLIC);
                return site;
            }
        }, (String)person2.getId(), (String)network1.getId());
        try {
            this.publicApiClient.setRequestContext(new RequestContext(network1.getId(), person2.getId()));
            sitesProxy.createSiteMember(site.getSiteId(), new SiteMember(person1.getId(), "dodgyRole"));
            Assert.fail((String)"");
        }
        catch (PublicApiException e) {
            Assert.assertEquals((long)400L, (long)e.getHttpResponse().getStatusCode());
        }
        try {
            this.publicApiClient.setRequestContext(new RequestContext(network1.getId(), person1.getId()));
            sitesProxy.createSiteMember(site.getSiteId(), new SiteMember(person3.getId(), SiteRole.SiteContributor.toString()));
            Assert.fail((String)"");
        }
        catch (PublicApiException e) {
            Assert.assertEquals((long)403L, (long)e.getHttpResponse().getStatusCode());
        }
        try {
            this.publicApiClient.setRequestContext(new RequestContext(network1.getId(), person2.getId()));
            sitesProxy.createSiteMember(site.getSiteId(), new SiteMember("dodgyUser", SiteRole.SiteContributor.toString()));
            Assert.fail((String)"");
        }
        catch (PublicApiException e) {
            Assert.assertEquals((long)404L, (long)e.getHttpResponse().getStatusCode());
        }
        try {
            this.publicApiClient.setRequestContext(new RequestContext(network1.getId(), person2.getId()));
            sitesProxy.createSiteMember("dodgySite", new SiteMember(person1.getId(), SiteRole.SiteContributor.toString()));
            Assert.fail((String)"");
        }
        catch (PublicApiException e) {
            Assert.assertEquals((long)404L, (long)e.getHttpResponse().getStatusCode());
        }
        try {
            this.publicApiClient.setRequestContext(new RequestContext(network1.getId(), person1.getId()));
            sitesProxy.createSiteMember(site.getSiteId(), new SiteMember(person1.getId(), SiteRole.SiteContributor.toString()));
            Assert.fail((String)"");
        }
        catch (PublicApiException e) {
            Assert.assertEquals((String)e.getMessage(), (long)403L, (long)e.getHttpResponse().getStatusCode());
        }
        try {
            this.publicApiClient.setRequestContext(new RequestContext(network1.getId(), person4.getId()));
            sitesProxy.createSiteMember(site.getSiteId(), new SiteMember(person1.getId(), SiteRole.SiteContributor.toString()));
            Assert.fail((String)"");
        }
        catch (PublicApiException e) {
            Assert.assertEquals((long)401L, (long)e.getHttpResponse().getStatusCode());
        }
        this.publicApiClient.setRequestContext(new RequestContext(network1.getId(), person2.getId()));
        SiteMember sm2 = new SiteMember(person1.getId(), SiteRole.SiteConsumer.toString());
        SiteMember siteMember = sitesProxy.createSiteMember(site.getSiteId(), sm2);
        Assert.assertEquals((Object)person1.getId(), (Object)siteMember.getMemberId());
        Assert.assertEquals((Object)SiteRole.SiteConsumer.toString(), (Object)siteMember.getRole());
        try {
            this.publicApiClient.setRequestContext(new RequestContext(network1.getId(), person2.getId()));
            sitesProxy.createSiteMember(site.getSiteId(), new SiteMember(person1.getId(), SiteRole.SiteContributor.toString()));
            Assert.fail((String)"");
        }
        catch (PublicApiException e) {
            Assert.assertEquals((long)409L, (long)e.getHttpResponse().getStatusCode());
        }
        try {
            this.publicApiClient.setRequestContext(new RequestContext(network1.getId(), person1.getId()));
            sitesProxy.createSiteMember(site.getSiteId(), new SiteMember(person4.getId(), SiteRole.SiteContributor.toString()));
            Assert.fail((String)"");
        }
        catch (PublicApiException e) {
            Assert.assertEquals((String)e.getMessage(), (long)404L, (long)e.getHttpResponse().getStatusCode());
        }
        try {
            this.publicApiClient.setRequestContext(new RequestContext(network1.getId(), person1.getId()));
            sitesProxy.createSiteMember(site.getSiteId(), new SiteMember(person4.getId(), SiteRole.SiteContributor.toString()));
            Assert.fail((String)"");
        }
        catch (PublicApiException e) {
            Assert.assertEquals((String)e.getMessage(), (long)404L, (long)e.getHttpResponse().getStatusCode());
        }
        try {
            this.publicApiClient.setRequestContext(new RequestContext(network1.getId(), person2.getId()));
            sitesProxy.createSiteMember(site.getSiteId(), new SiteMember(null, SiteRole.SiteContributor.toString()));
            Assert.fail((String)"");
        }
        catch (PublicApiException e) {
            Assert.assertEquals((long)400L, (long)e.getHttpResponse().getStatusCode());
        }
        try {
            this.publicApiClient.setRequestContext(new RequestContext(network1.getId(), person2.getId()));
            sitesProxy.createSiteMember(site.getSiteId(), new SiteMember(person1.getId(), null));
            Assert.fail((String)"");
        }
        catch (PublicApiException e) {
            Assert.assertEquals((long)400L, (long)e.getHttpResponse().getStatusCode());
        }
        List<SiteMember> expectedSiteMembers2 = site.getMembers();
        int skipCount2 = 0;
        int maxItems2 = Integer.MAX_VALUE;
        PublicApiClient.Paging paging2 = this.getPaging(skipCount2, maxItems2, expectedSiteMembers2.size(), 2);
        PublicApiClient.ListResponse<SiteMember> siteMembers2 = sitesProxy.getSiteMembers(site.getSiteId(), this.createParams(paging2, null));
        this.checkList(expectedSiteMembers2.subList(skipCount2, skipCount2 + paging2.getExpectedPaging().getCount()), paging2.getExpectedPaging(), siteMembers2);
        accountsIt = this.getTestFixture().getNetworksIt();
        Assert.assertTrue((boolean)accountsIt.hasNext());
        network1 = accountsIt.next();
        Assert.assertTrue((boolean)accountsIt.hasNext());
        final ArrayList people2 = new ArrayList();
        TenantUtil.runAsSystemTenant((TenantUtil.TenantRunAsWork)new TenantUtil.TenantRunAsWork<Void>(){

            public Void doWork() throws Exception {
                RepoService.TestPerson person = network1.createUser();
                people2.add(person);
                person = network1.createUser();
                people2.add(person);
                person = network1.createUser();
                people2.add(person);
                return null;
            }
        }, (String)network1.getId());
        RepoService.TestPerson person12 = (RepoService.TestPerson)people2.get(0);
        RepoService.TestPerson person22 = (RepoService.TestPerson)people2.get(1);
        RepoService.TestPerson person32 = (RepoService.TestPerson)people2.get(2);
        RepoService.TestSite site2 = (RepoService.TestSite)TenantUtil.runAsUserTenant((TenantUtil.TenantRunAsWork)new TenantUtil.TenantRunAsWork<RepoService.TestSite>(){

            public RepoService.TestSite doWork() throws Exception {
                RepoService.TestSite site = network1.createSite(SiteVisibility.PRIVATE);
                return site;
            }
        }, (String)person22.getId(), (String)network1.getId());
        this.publicApiClient.setRequestContext(new RequestContext(network1.getId(), person22.getId()));
        SiteMember siteMember2 = sitesProxy.createSiteMember(site2.getSiteId(), new SiteMember(person12.getId(), SiteRole.SiteContributor.toString()));
        Assert.assertEquals((Object)person12.getId(), (Object)siteMember2.getMemberId());
        Assert.assertEquals((Object)SiteRole.SiteContributor.toString(), (Object)siteMember2.getRole());
        SiteMember toRemove = new SiteMember("-me-");
        this.publicApiClient.setRequestContext(new RequestContext(network1.getId(), person12.getId()));
        sitesProxy.removeSiteMember(site2.getSiteId(), toRemove);
        this.publicApiClient.setRequestContext(new RequestContext(network1.getId(), person22.getId()));
        siteMember2 = sitesProxy.createSiteMember(site2.getSiteId(), new SiteMember(person12.getId(), SiteRole.SiteContributor.toString()));
        Assert.assertEquals((Object)person12.getId(), (Object)siteMember2.getMemberId());
        Assert.assertEquals((Object)SiteRole.SiteContributor.toString(), (Object)siteMember2.getRole());
        siteMember2.setSiteId(site2.getSiteId());
        this.publicApiClient.setRequestContext(new RequestContext(network1.getId(), person22.getId()));
        SiteMember siteMemberAno = sitesProxy.createSiteMember(site2.getSiteId(), new SiteMember(person32.getId(), SiteRole.SiteCollaborator.toString()));
        Assert.assertEquals((Object)person32.getId(), (Object)siteMemberAno.getMemberId());
        Assert.assertEquals((Object)SiteRole.SiteCollaborator.toString(), (Object)siteMemberAno.getRole());
        siteMemberAno.setSiteId(site2.getSiteId());
        try {
            this.publicApiClient.setRequestContext(new RequestContext(network1.getId(), person22.getId()));
            sitesProxy.removeSiteMember(GUID.generate(), siteMember2);
            Assert.fail();
        }
        catch (PublicApiException e) {
            Assert.assertEquals((long)404L, (long)e.getHttpResponse().getStatusCode());
        }
        try {
            this.publicApiClient.setRequestContext(new RequestContext(network1.getId(), person22.getId()));
            sitesProxy.removeSiteMember(site2.getSiteId(), new SiteMember(GUID.generate()));
            Assert.fail();
        }
        catch (PublicApiException e) {
            Assert.assertEquals((long)404L, (long)e.getHttpResponse().getStatusCode());
        }
        try {
            this.publicApiClient.setRequestContext(new RequestContext(network1.getId(), person12.getId()));
            sitesProxy.updateSiteMember(site2.getSiteId(), new SiteMember(person12.getId(), SiteRole.SiteCollaborator.toString()));
            Assert.fail();
        }
        catch (PublicApiException e) {
            Assert.assertEquals((long)422L, (long)e.getHttpResponse().getStatusCode());
        }
        try {
            this.publicApiClient.setRequestContext(new RequestContext(network1.getId(), person12.getId()));
            sitesProxy.removeSiteMember(site2.getSiteId(), new SiteMember(person32.getId()));
            Assert.fail();
        }
        catch (PublicApiException e) {
            Assert.assertEquals((long)422L, (long)e.getHttpResponse().getStatusCode());
        }
        this.publicApiClient.setRequestContext(new RequestContext(network1.getId(), person22.getId()));
        sitesProxy.removeSiteMember(site2.getSiteId(), siteMember2);
        expectedSiteMembers2 = site2.getMembers();
        Assert.assertFalse((boolean)expectedSiteMembers2.contains(siteMember2));
        Assert.assertTrue((boolean)expectedSiteMembers2.contains(siteMemberAno));
        skipCount2 = 0;
        maxItems2 = Integer.MAX_VALUE;
        paging2 = this.getPaging(skipCount2, maxItems2, expectedSiteMembers2.size(), 2);
        this.publicApiClient.setRequestContext(new RequestContext(network1.getId(), person22.getId()));
        siteMembers2 = sitesProxy.getSiteMembers(site2.getSiteId(), this.createParams(paging2, null));
        this.checkList(expectedSiteMembers2.subList(skipCount2, skipCount2 + paging2.getExpectedPaging().getCount()), paging2.getExpectedPaging(), siteMembers2);
        try {
            this.publicApiClient.setRequestContext(new RequestContext(network1.getId(), person22.getId()));
            sitesProxy.updateSiteMember(GUID.generate(), siteMember2);
            Assert.fail();
        }
        catch (PublicApiException e) {
            Assert.assertEquals((long)404L, (long)e.getHttpResponse().getStatusCode());
        }
        try {
            this.publicApiClient.setRequestContext(new RequestContext(network1.getId(), person22.getId()));
            sitesProxy.updateSiteMember(site2.getSiteId(), new SiteMember(GUID.generate()));
            Assert.fail();
        }
        catch (PublicApiException e) {
            Assert.assertEquals((long)404L, (long)e.getHttpResponse().getStatusCode());
        }
        try {
            this.publicApiClient.setRequestContext(new RequestContext(network1.getId(), person22.getId()));
            sitesProxy.updateSiteMember(site2.getSiteId(), new SiteMember(person12.getId(), "invalidRole"));
            Assert.fail();
        }
        catch (PublicApiException e) {
            Assert.assertEquals((long)400L, (long)e.getHttpResponse().getStatusCode());
        }
        try {
            this.publicApiClient.setRequestContext(new RequestContext(network1.getId(), person22.getId()));
            sitesProxy.updateSiteMember(site2.getSiteId(), new SiteMember(person12.getId(), SiteRole.SiteContributor.toString()));
            Assert.fail();
        }
        catch (PublicApiException e) {
            Assert.assertEquals((long)400L, (long)e.getHttpResponse().getStatusCode());
        }
        try {
            this.publicApiClient.setRequestContext(new RequestContext(network1.getId(), person22.getId()));
            sitesProxy.updateSiteMember(site2.getSiteId(), new SiteMember(person22.getId(), SiteRole.SiteContributor.toString()));
            Assert.fail();
        }
        catch (PublicApiException e) {
            Assert.assertEquals((long)422L, (long)e.getHttpResponse().getStatusCode());
        }
        this.publicApiClient.setRequestContext(new RequestContext(network1.getId(), person22.getId()));
        SiteMember sm3 = new SiteMember(person12.getId(), SiteRole.SiteContributor.toString());
        SiteMember ret2 = sitesProxy.createSiteMember(site2.getSiteId(), sm3);
        Assert.assertEquals((Object)SiteRole.SiteContributor.toString(), (Object)ret2.getRole());
        person12.expected(ret2.getMember());
        sm3 = new SiteMember(person12.getId(), SiteRole.SiteCollaborator.toString());
        ret2 = sitesProxy.updateSiteMember(site2.getSiteId(), sm3);
        Assert.assertEquals((Object)SiteRole.SiteCollaborator.toString(), (Object)ret2.getRole());
        person12.expected(ret2.getMember());
        SiteMember smToCheck = sitesProxy.getSingleSiteMember(site2.getSiteId(), person12.getId());
        Assert.assertNotNull((Object)smToCheck);
        Assert.assertEquals((Object)sm3.getRole(), (Object)smToCheck.getRole());
        expectedSiteMembers2 = new ArrayList<SiteMember>();
        SiteMember sm1 = new SiteMember(person12.getId(), person12, site2.getSiteId(), SiteRole.SiteCollaborator.toString());
        expectedSiteMembers2.add(sm1);
        SiteMember sm22 = new SiteMember(person22.getId(), person22, site2.getSiteId(), SiteRole.SiteManager.toString());
        expectedSiteMembers2.add(sm22);
        SiteMember sm32 = new SiteMember(person32.getId(), person32, site2.getSiteId(), SiteRole.SiteCollaborator.toString());
        expectedSiteMembers2.add(sm32);
        Collections.sort(expectedSiteMembers2);
        int skipCount3 = 0;
        int maxItems3 = Integer.MAX_VALUE;
        PublicApiClient.Paging paging3 = this.getPaging(skipCount3, maxItems3, expectedSiteMembers2.size(), 3);
        this.publicApiClient.setRequestContext(new RequestContext(network1.getId(), person22.getId()));
        PublicApiClient.ListResponse<SiteMember> siteMembers3 = sitesProxy.getSiteMembers(site2.getSiteId(), this.createParams(paging3, null));
        this.checkList(expectedSiteMembers2.subList(skipCount3, skipCount3 + paging3.getExpectedPaging().getCount()), paging3.getExpectedPaging(), siteMembers3);
    }
}

