/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.api.people;

import java.util.List;
import org.alfresco.rest.api.Sites;
import org.alfresco.rest.api.model.FavouriteSite;
import org.alfresco.rest.api.people.PeopleEntityResource;
import org.alfresco.rest.framework.WebApiDescription;
import org.alfresco.rest.framework.resource.RelationshipResource;
import org.alfresco.rest.framework.resource.actions.interfaces.RelationshipResourceAction;
import org.alfresco.rest.framework.resource.parameters.CollectionWithPagingInfo;
import org.alfresco.rest.framework.resource.parameters.Parameters;
import org.alfresco.util.ParameterCheck;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.InitializingBean;

@RelationshipResource(name="favorite-sites", entityResource=PeopleEntityResource.class, title="Person Favorite Sites")
public class PersonFavouriteSitesRelation
implements RelationshipResourceAction.Read<FavouriteSite>,
RelationshipResourceAction.ReadById<FavouriteSite>,
RelationshipResourceAction.Create<FavouriteSite>,
RelationshipResourceAction.Delete,
InitializingBean {
    private static final Log logger = LogFactory.getLog(PersonFavouriteSitesRelation.class);
    private Sites sites;

    public void setSites(Sites sites) {
        this.sites = sites;
    }

    public void afterPropertiesSet() {
        ParameterCheck.mandatory((String)"sites", (Object)this.sites);
    }

    @Override
    @WebApiDescription(title="Get Person Favorite Sites", description="Get a paged list of the person's favorite sites")
    public CollectionWithPagingInfo<FavouriteSite> readAll(String personId, Parameters parameters) {
        return this.sites.getFavouriteSites(personId, parameters);
    }

    @Override
    @WebApiDescription(title="Get Person Favorite Site", description="Get information on a person's specific favorite site")
    public FavouriteSite readById(String personId, String siteShortName, Parameters parameters) {
        return this.sites.getFavouriteSite(personId, siteShortName);
    }

    @Override
    @WebApiDescription(title="Add Person Favorite Site", description="Favorite a site")
    public List<FavouriteSite> create(String personId, List<FavouriteSite> entity, Parameters parameters) {
        for (FavouriteSite favSite : entity) {
            this.sites.addFavouriteSite(personId, favSite);
        }
        return entity;
    }

    @Override
    @WebApiDescription(title="Remove Person Favorite Site", description="Un-favorite a site")
    public void delete(String personId, String siteId, Parameters parameters) {
        this.sites.removeFavouriteSite(personId, siteId);
    }
}

