/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.web.scripts.node;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.alfresco.model.ApplicationModel;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.node.archive.NodeArchiveService;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.repo.web.scripts.BaseWebScriptTest;
import org.alfresco.service.cmr.coci.CheckOutCheckInService;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.security.AccessStatus;
import org.alfresco.service.cmr.security.MutableAuthenticationService;
import org.alfresco.service.cmr.security.PermissionService;
import org.alfresco.service.cmr.security.PersonService;
import org.alfresco.service.cmr.site.SiteInfo;
import org.alfresco.service.cmr.site.SiteService;
import org.alfresco.service.cmr.site.SiteVisibility;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.PropertyMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.springframework.context.support.AbstractRefreshableApplicationContext;
import org.springframework.extensions.webscripts.TestWebScriptServer;

public class NodeWebScripTest
extends BaseWebScriptTest {
    private static Log logger = LogFactory.getLog(NodeWebScripTest.class);
    private static String CREATE_LINK_API = "/api/node/doclink/";
    private static String DESTINATION_NODE_REF_PARAM = "destinationNodeRef";
    private static String MULTIPLE_FILES_PARAM = "multipleFiles";
    private String TEST_SITE_NAME = "TestNodeSite";
    private SiteInfo TEST_SITE;
    private MutableAuthenticationService authenticationService;
    private RetryingTransactionHelper retryingTransactionHelper;
    private PersonService personService;
    private SiteService siteService;
    private NodeService nodeService;
    private NodeArchiveService nodeArchiveService;
    private CheckOutCheckInService checkOutCheckInService;
    private PermissionService permissionService;
    private static final String USER_ONE = "UserOneSecondToo";
    private static final String USER_TWO = "UserTwoSecondToo";
    private static final String USER_THREE = "UserThreeStill";
    private static final String PASSWORD = "passwordTEST";

    protected void setUp() throws Exception {
        super.setUp();
        AbstractRefreshableApplicationContext ctx = (AbstractRefreshableApplicationContext)this.getServer().getApplicationContext();
        this.retryingTransactionHelper = (RetryingTransactionHelper)ctx.getBean("retryingTransactionHelper");
        this.authenticationService = (MutableAuthenticationService)ctx.getBean("AuthenticationService");
        this.personService = (PersonService)ctx.getBean("PersonService");
        this.siteService = (SiteService)ctx.getBean("SiteService");
        this.nodeService = (NodeService)ctx.getBean("NodeService");
        this.nodeArchiveService = (NodeArchiveService)ctx.getBean("nodeArchiveService");
        this.checkOutCheckInService = (CheckOutCheckInService)ctx.getBean("checkOutCheckInService");
        this.permissionService = (PermissionService)ctx.getBean("permissionService");
        AuthenticationUtil.setAdminUserAsFullyAuthenticatedUser();
        this.TEST_SITE = this.createSite(this.TEST_SITE_NAME);
        this.createUser(USER_ONE, true);
        this.createUser(USER_TWO, false);
        AuthenticationUtil.setFullyAuthenticatedUser((String)USER_ONE);
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        AuthenticationUtil.setAdminUserAsFullyAuthenticatedUser();
        SiteInfo siteInfo = this.siteService.getSite(this.TEST_SITE.getShortName());
        if (siteInfo != null) {
            this.siteService.deleteSite(this.TEST_SITE.getShortName());
            this.nodeArchiveService.purgeArchivedNode(this.nodeArchiveService.getArchivedNode(siteInfo.getNodeRef()));
        }
        for (String user : new String[]{USER_ONE, USER_TWO, USER_THREE}) {
            AuthenticationUtil.setAdminUserAsFullyAuthenticatedUser();
            if (this.personService.personExists(user)) {
                this.personService.deletePerson(user);
            }
            if (!this.authenticationService.authenticationExists(user)) continue;
            this.authenticationService.deleteAuthentication(user);
        }
    }

    private SiteInfo createSite(final String shortName) {
        return (SiteInfo)this.retryingTransactionHelper.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<SiteInfo>(){

            public SiteInfo execute() throws Throwable {
                SiteInfo siteInfo = NodeWebScripTest.this.siteService.getSite(shortName);
                if (siteInfo != null) {
                    NodeWebScripTest.this.siteService.deleteSite(shortName);
                    NodeWebScripTest.this.nodeArchiveService.purgeArchivedNode(NodeWebScripTest.this.nodeArchiveService.getArchivedNode(siteInfo.getNodeRef()));
                }
                SiteInfo site = NodeWebScripTest.this.siteService.createSite("Testing", shortName, shortName, null, SiteVisibility.PUBLIC);
                NodeWebScripTest.this.siteService.createContainer(shortName, "documentLibrary", ContentModel.TYPE_FOLDER, null);
                return site;
            }
        }, false, true);
    }

    private void createUser(String userName, boolean contributor) {
        if (this.personService.personExists(userName)) {
            this.personService.deletePerson(userName);
        }
        if (this.authenticationService.authenticationExists(userName)) {
            this.authenticationService.deleteAuthentication(userName);
        }
        this.authenticationService.createAuthentication(userName, PASSWORD.toCharArray());
        PropertyMap personProps = new PropertyMap();
        personProps.put((Object)ContentModel.PROP_USERNAME, (Object)userName);
        personProps.put((Object)ContentModel.PROP_FIRSTNAME, (Object)"First");
        personProps.put((Object)ContentModel.PROP_LASTNAME, (Object)"Last");
        personProps.put((Object)ContentModel.PROP_EMAIL, (Object)"FirstName123.LastName123@email.com");
        personProps.put((Object)ContentModel.PROP_JOBTITLE, (Object)"JobTitle123");
        personProps.put((Object)ContentModel.PROP_JOBTITLE, (Object)"Organisation123");
        this.personService.createPerson((Map)personProps);
        if (contributor) {
            this.siteService.setMembership(this.TEST_SITE_NAME, userName, "SiteContributor");
        } else {
            this.siteService.setMembership(this.TEST_SITE_NAME, userName, "SiteConsumer");
        }
    }

    private JSONObject asJSON(TestWebScriptServer.Response response) throws Exception {
        JSONParser p = new JSONParser();
        String json = response.getContentAsString();
        Object o = p.parse(json);
        if (o instanceof JSONObject) {
            return (JSONObject)o;
        }
        throw new IllegalArgumentException("Expected JSONObject, got " + String.valueOf(o) + " from " + json);
    }

    public void testFolderCreation() throws Exception {
        NodeRef siteDocLib = this.siteService.getContainer(this.TEST_SITE.getShortName(), "documentLibrary");
        String testFolderName = "testing";
        HashMap<QName, String> testFolderProps = new HashMap<QName, String>();
        testFolderProps.put(ContentModel.PROP_NAME, testFolderName);
        NodeRef testFolder = this.nodeService.createNode(siteDocLib, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"testing"), ContentModel.TYPE_FOLDER, testFolderProps).getChildRef();
        String testNodeName = "aNEWfolder";
        String testNodeTitle = "aTITLEforAfolder";
        String testNodeDescription = "DESCRIPTIONofAfolder";
        JSONObject jsonReq = null;
        JSONObject json = null;
        NodeRef folder = null;
        TestWebScriptServer.Request req = new TestWebScriptServer.Request("POST", "/api/node/folder/" + testFolder.getStoreRef().getProtocol() + "/" + testFolder.getStoreRef().getIdentifier() + "/" + testFolder.getId());
        jsonReq = new JSONObject();
        jsonReq.put((Object)"name", (Object)testNodeName);
        req.setBody(jsonReq.toString().getBytes());
        req.setType("application/json");
        json = this.asJSON(this.sendRequest(req, 200));
        NodeWebScripTest.assertNotNull((Object)json.get((Object)"nodeRef"));
        folder = new NodeRef((String)json.get((Object)"nodeRef"));
        NodeWebScripTest.assertEquals((boolean)true, (boolean)this.nodeService.exists(folder));
        NodeWebScripTest.assertEquals((Object)testNodeName, (Object)this.nodeService.getProperty(folder, ContentModel.PROP_NAME));
        NodeWebScripTest.assertEquals((Object)testNodeName, (Object)this.nodeService.getProperty(folder, ContentModel.PROP_TITLE));
        NodeWebScripTest.assertEquals(null, (Object)this.nodeService.getProperty(folder, ContentModel.PROP_DESCRIPTION));
        NodeWebScripTest.assertEquals((Object)testFolder, (Object)this.nodeService.getPrimaryParent(folder).getParentRef());
        NodeWebScripTest.assertEquals((Object)ContentModel.TYPE_FOLDER, (Object)this.nodeService.getType(folder));
        this.nodeService.deleteNode(folder);
        req = new TestWebScriptServer.Request("POST", "/api/site/folder/" + this.TEST_SITE_NAME + "/documentLibrary");
        jsonReq = new JSONObject();
        jsonReq.put((Object)"name", (Object)testNodeName);
        jsonReq.put((Object)"description", (Object)testNodeDescription);
        req.setBody(jsonReq.toString().getBytes());
        json = this.asJSON(this.sendRequest(req, 200));
        NodeWebScripTest.assertNotNull((Object)json.get((Object)"nodeRef"));
        folder = new NodeRef((String)json.get((Object)"nodeRef"));
        NodeWebScripTest.assertEquals((boolean)true, (boolean)this.nodeService.exists(folder));
        NodeWebScripTest.assertEquals((Object)testNodeName, (Object)this.nodeService.getProperty(folder, ContentModel.PROP_NAME));
        NodeWebScripTest.assertEquals((Object)testNodeName, (Object)this.nodeService.getProperty(folder, ContentModel.PROP_TITLE));
        NodeWebScripTest.assertEquals((Object)testNodeDescription, (Object)this.nodeService.getProperty(folder, ContentModel.PROP_DESCRIPTION));
        NodeWebScripTest.assertEquals((Object)siteDocLib, (Object)this.nodeService.getPrimaryParent(folder).getParentRef());
        NodeWebScripTest.assertEquals((Object)ContentModel.TYPE_FOLDER, (Object)this.nodeService.getType(folder));
        this.nodeService.deleteNode(folder);
        req = new TestWebScriptServer.Request("POST", "/api/site/folder/" + this.TEST_SITE_NAME + "/documentLibrary/" + testFolderName);
        jsonReq = new JSONObject();
        jsonReq.put((Object)"name", (Object)testNodeName);
        jsonReq.put((Object)"title", (Object)testNodeTitle);
        jsonReq.put((Object)"description", (Object)testNodeDescription);
        req.setBody(jsonReq.toString().getBytes());
        json = this.asJSON(this.sendRequest(req, 200));
        NodeWebScripTest.assertNotNull((Object)json.get((Object)"nodeRef"));
        folder = new NodeRef((String)json.get((Object)"nodeRef"));
        NodeWebScripTest.assertEquals((boolean)true, (boolean)this.nodeService.exists(folder));
        NodeWebScripTest.assertEquals((Object)testNodeName, (Object)this.nodeService.getProperty(folder, ContentModel.PROP_NAME));
        NodeWebScripTest.assertEquals((Object)testNodeTitle, (Object)this.nodeService.getProperty(folder, ContentModel.PROP_TITLE));
        NodeWebScripTest.assertEquals((Object)testNodeDescription, (Object)this.nodeService.getProperty(folder, ContentModel.PROP_DESCRIPTION));
        NodeWebScripTest.assertEquals((Object)testFolder, (Object)this.nodeService.getPrimaryParent(folder).getParentRef());
        NodeWebScripTest.assertEquals((Object)ContentModel.TYPE_FOLDER, (Object)this.nodeService.getType(folder));
        this.nodeService.deleteNode(folder);
        req = new TestWebScriptServer.Request("POST", "/api/site/folder/" + this.TEST_SITE_NAME + "/documentLibrary/" + testFolderName);
        jsonReq = new JSONObject();
        jsonReq.put((Object)"name", (Object)testNodeName);
        jsonReq.put((Object)"type", (Object)"cm:folder");
        req.setBody(jsonReq.toString().getBytes());
        json = this.asJSON(this.sendRequest(req, 200));
        NodeWebScripTest.assertNotNull((Object)json.get((Object)"nodeRef"));
        folder = new NodeRef((String)json.get((Object)"nodeRef"));
        NodeWebScripTest.assertEquals((boolean)true, (boolean)this.nodeService.exists(folder));
        NodeWebScripTest.assertEquals((Object)testNodeName, (Object)this.nodeService.getProperty(folder, ContentModel.PROP_NAME));
        NodeWebScripTest.assertEquals((Object)ContentModel.TYPE_FOLDER, (Object)this.nodeService.getType(folder));
        this.nodeService.deleteNode(folder);
        req = new TestWebScriptServer.Request("POST", "/api/site/folder/" + this.TEST_SITE_NAME + "/documentLibrary/" + testFolderName);
        jsonReq = new JSONObject();
        jsonReq.put((Object)"name", (Object)testNodeName);
        jsonReq.put((Object)"type", (Object)"cm:systemfolder");
        req.setBody(jsonReq.toString().getBytes());
        json = this.asJSON(this.sendRequest(req, 200));
        NodeWebScripTest.assertNotNull((Object)json.get((Object)"nodeRef"));
        folder = new NodeRef((String)json.get((Object)"nodeRef"));
        NodeWebScripTest.assertEquals((boolean)true, (boolean)this.nodeService.exists(folder));
        NodeWebScripTest.assertEquals((Object)testNodeName, (Object)this.nodeService.getProperty(folder, ContentModel.PROP_NAME));
        NodeWebScripTest.assertEquals((Object)ContentModel.TYPE_SYSTEM_FOLDER, (Object)this.nodeService.getType(folder));
        this.nodeService.deleteNode(folder);
        req = new TestWebScriptServer.Request("POST", "/api/site/folder/" + this.TEST_SITE_NAME + "/documentLibrary/" + testFolderName);
        jsonReq = new JSONObject();
        jsonReq.put((Object)"name", (Object)testNodeName);
        jsonReq.put((Object)"type", (Object)"cm:content");
        req.setBody(jsonReq.toString().getBytes());
        this.sendRequest(req, 400);
        AuthenticationUtil.setFullyAuthenticatedUser((String)USER_ONE);
        req = new TestWebScriptServer.Request("POST", "/api/node/folder/" + testFolder.getStoreRef().getProtocol() + "/" + testFolder.getStoreRef().getIdentifier() + "/" + testFolder.getId());
        jsonReq = new JSONObject();
        jsonReq.put((Object)"name", (Object)testNodeName);
        req.setBody(jsonReq.toString().getBytes());
        req.setType("application/json");
        json = this.asJSON(this.sendRequest(req, 200));
        NodeWebScripTest.assertNotNull((Object)json.get((Object)"nodeRef"));
        folder = new NodeRef((String)json.get((Object)"nodeRef"));
        NodeWebScripTest.assertEquals((boolean)true, (boolean)this.nodeService.exists(folder));
        this.nodeService.deleteNode(folder);
        AuthenticationUtil.setFullyAuthenticatedUser((String)USER_TWO);
        this.sendRequest(req, 403);
    }

    public void testLinkCreation() throws Exception {
        NodeRef siteDocLib = this.siteService.getContainer(this.TEST_SITE.getShortName(), "documentLibrary");
        String testFolder1Name = "testingLinkCreationFolder1";
        HashMap<QName, String> testFolderProps = new HashMap<QName, String>();
        testFolderProps.put(ContentModel.PROP_NAME, testFolder1Name);
        NodeRef testFolder1 = this.nodeService.createNode(siteDocLib, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"testingLinkCreationFolder1"), ContentModel.TYPE_FOLDER, testFolderProps).getChildRef();
        JSONObject jsonReq = null;
        JSONObject json = null;
        JSONArray jsonArray = new JSONArray();
        JSONArray jsonLinkNodes = null;
        JSONObject jsonLinkNode = null;
        NodeRef testFile1 = this.createNode(testFolder1, "testingLinkCreationFile1", ContentModel.TYPE_CONTENT, AuthenticationUtil.getAdminUserName());
        NodeRef testFile2 = this.createNode(testFolder1, "testingLinkCreationFile2", ContentModel.TYPE_CONTENT, AuthenticationUtil.getAdminUserName());
        NodeRef testFile3 = this.createNode(testFolder1, "testingLinkCreationFile3", ContentModel.TYPE_CONTENT, AuthenticationUtil.getAdminUserName());
        String testFolder2Name = "testingLinkCreationFolder2";
        testFolderProps = new HashMap();
        testFolderProps.put(ContentModel.PROP_NAME, testFolder2Name);
        NodeRef testFolder2 = this.nodeService.createNode(siteDocLib, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"testingLinkCreationFolder2"), ContentModel.TYPE_FOLDER, testFolderProps).getChildRef();
        TestWebScriptServer.Request req = new TestWebScriptServer.Request("POST", CREATE_LINK_API + testFile1.getStoreRef().getProtocol() + "/" + testFile1.getStoreRef().getIdentifier() + "/" + testFile1.getId());
        jsonReq = new JSONObject();
        jsonReq.put((Object)DESTINATION_NODE_REF_PARAM, (Object)testFolder1.toString());
        jsonArray.add((Object)testFile1.toString());
        jsonReq.put((Object)MULTIPLE_FILES_PARAM, (Object)jsonArray);
        req.setBody(jsonReq.toString().getBytes());
        req.setType("application/json");
        json = this.asJSON(this.sendRequest(req, 200));
        jsonLinkNodes = (JSONArray)json.get((Object)"linkNodes");
        NodeWebScripTest.assertNotNull((Object)jsonLinkNodes);
        NodeWebScripTest.assertEquals((int)1, (int)jsonLinkNodes.size());
        NodeWebScripTest.assertEquals((Object)"true", (Object)json.get((Object)"overallSuccess"));
        NodeWebScripTest.assertEquals((Object)"1", (Object)json.get((Object)"successCount"));
        NodeWebScripTest.assertEquals((Object)"0", (Object)json.get((Object)"failureCount"));
        jsonLinkNode = (JSONObject)jsonLinkNodes.get(0);
        String nodeRef = (String)jsonLinkNode.get((Object)"nodeRef");
        NodeRef file1Link = new NodeRef(nodeRef);
        NodeWebScripTest.assertEquals((boolean)true, (boolean)this.nodeService.hasAspect(testFile1, ApplicationModel.ASPECT_LINKED));
        NodeWebScripTest.assertEquals((boolean)true, (boolean)this.nodeService.exists(file1Link));
        this.nodeService.deleteNode(file1Link);
        NodeWebScripTest.assertEquals((boolean)false, (boolean)this.nodeService.hasAspect(testFile1, ApplicationModel.ASPECT_LINKED));
        req = new TestWebScriptServer.Request("POST", CREATE_LINK_API + testFolder2.getStoreRef().getProtocol() + "/" + testFolder2.getStoreRef().getIdentifier() + "/" + testFolder2.getId());
        jsonReq = new JSONObject();
        jsonReq.put((Object)DESTINATION_NODE_REF_PARAM, (Object)testFolder1.toString());
        jsonArray = new JSONArray();
        jsonArray.add((Object)testFolder2.toString());
        jsonReq.put((Object)MULTIPLE_FILES_PARAM, (Object)jsonArray);
        req.setBody(jsonReq.toString().getBytes());
        req.setType("application/json");
        json = this.asJSON(this.sendRequest(req, 200));
        jsonLinkNodes = (JSONArray)json.get((Object)"linkNodes");
        NodeWebScripTest.assertNotNull((Object)jsonLinkNodes);
        NodeWebScripTest.assertEquals((int)1, (int)jsonLinkNodes.size());
        NodeWebScripTest.assertEquals((Object)"true", (Object)json.get((Object)"overallSuccess"));
        NodeWebScripTest.assertEquals((Object)"1", (Object)json.get((Object)"successCount"));
        NodeWebScripTest.assertEquals((Object)"0", (Object)json.get((Object)"failureCount"));
        jsonLinkNode = (JSONObject)jsonLinkNodes.get(0);
        nodeRef = (String)jsonLinkNode.get((Object)"nodeRef");
        NodeRef folder2Link = new NodeRef(nodeRef);
        NodeWebScripTest.assertEquals((boolean)true, (boolean)this.nodeService.hasAspect(testFolder2, ApplicationModel.ASPECT_LINKED));
        NodeWebScripTest.assertEquals((boolean)true, (boolean)this.nodeService.exists(folder2Link));
        req = new TestWebScriptServer.Request("POST", CREATE_LINK_API + testFolder2.getStoreRef().getProtocol() + "/" + testFolder2.getStoreRef().getIdentifier() + "/" + testFolder2.getId());
        jsonReq = new JSONObject();
        jsonReq.put((Object)DESTINATION_NODE_REF_PARAM, (Object)siteDocLib.toString());
        jsonArray = new JSONArray();
        jsonArray.add((Object)testFolder2.toString());
        jsonReq.put((Object)MULTIPLE_FILES_PARAM, (Object)jsonArray);
        req.setBody(jsonReq.toString().getBytes());
        req.setType("application/json");
        json = this.asJSON(this.sendRequest(req, 200));
        jsonLinkNodes = (JSONArray)json.get((Object)"linkNodes");
        NodeWebScripTest.assertNotNull((Object)jsonLinkNodes);
        NodeWebScripTest.assertEquals((int)1, (int)jsonLinkNodes.size());
        NodeWebScripTest.assertEquals((Object)"true", (Object)json.get((Object)"overallSuccess"));
        NodeWebScripTest.assertEquals((Object)"1", (Object)json.get((Object)"successCount"));
        NodeWebScripTest.assertEquals((Object)"0", (Object)json.get((Object)"failureCount"));
        jsonLinkNode = (JSONObject)jsonLinkNodes.get(0);
        nodeRef = (String)jsonLinkNode.get((Object)"nodeRef");
        NodeRef folder2Link2 = new NodeRef(nodeRef);
        this.nodeService.deleteNode(folder2Link);
        NodeWebScripTest.assertEquals((boolean)true, (boolean)this.nodeService.hasAspect(testFolder2, ApplicationModel.ASPECT_LINKED));
        this.nodeService.deleteNode(folder2Link2);
        NodeWebScripTest.assertEquals((boolean)false, (boolean)this.nodeService.hasAspect(testFolder2, ApplicationModel.ASPECT_LINKED));
        req = new TestWebScriptServer.Request("POST", CREATE_LINK_API + testFolder1.getStoreRef().getProtocol() + "/" + testFolder1.getStoreRef().getIdentifier() + "/" + testFolder1.getId());
        jsonReq = new JSONObject();
        jsonReq.put((Object)DESTINATION_NODE_REF_PARAM, (Object)testFolder1.toString());
        jsonArray = new JSONArray();
        jsonArray.add((Object)testFile1.toString());
        jsonArray.add((Object)testFile2.toString());
        jsonArray.add((Object)testFile3.toString());
        jsonReq.put((Object)MULTIPLE_FILES_PARAM, (Object)jsonArray);
        req.setBody(jsonReq.toString().getBytes());
        req.setType("application/json");
        json = this.asJSON(this.sendRequest(req, 200));
        jsonLinkNodes = (JSONArray)json.get((Object)"linkNodes");
        NodeWebScripTest.assertNotNull((Object)jsonLinkNodes);
        NodeWebScripTest.assertEquals((int)3, (int)jsonLinkNodes.size());
        NodeWebScripTest.assertEquals((Object)"true", (Object)json.get((Object)"overallSuccess"));
        NodeWebScripTest.assertEquals((Object)"3", (Object)json.get((Object)"successCount"));
        NodeWebScripTest.assertEquals((Object)"0", (Object)json.get((Object)"failureCount"));
        NodeRef fileLink = null;
        ArrayList<NodeRef> fileLinks = new ArrayList<NodeRef>();
        for (int i = 0; i < jsonLinkNodes.size(); ++i) {
            jsonLinkNode = (JSONObject)jsonLinkNodes.get(i);
            nodeRef = (String)jsonLinkNode.get((Object)"nodeRef");
            fileLink = new NodeRef(nodeRef);
            fileLinks.add(fileLink);
            NodeWebScripTest.assertEquals((boolean)true, (boolean)this.nodeService.exists(fileLink));
        }
        req = new TestWebScriptServer.Request("POST", CREATE_LINK_API + testFolder1.getStoreRef().getProtocol() + "/" + testFolder1.getStoreRef().getIdentifier() + "/" + testFolder1.getId());
        jsonReq = new JSONObject();
        jsonReq.put((Object)DESTINATION_NODE_REF_PARAM, (Object)testFolder1.toString());
        jsonArray = new JSONArray();
        jsonArray.add((Object)testFile1.toString());
        jsonReq.put((Object)MULTIPLE_FILES_PARAM, (Object)jsonArray);
        req.setBody(jsonReq.toString().getBytes());
        req.setType("application/json");
        json = this.asJSON(this.sendRequest(req, 400));
        this.nodeService.deleteNode(testFile1);
        this.nodeService.deleteNode(testFile2);
        this.nodeService.deleteNode(testFile3);
        for (NodeRef linkNodeRef : fileLinks) {
            NodeWebScripTest.assertEquals((boolean)false, (boolean)this.nodeService.exists(linkNodeRef));
        }
        SiteInfo site2 = this.createSite("Site2TestingNodeCreateLink");
        NodeRef siteNodeRef = site2.getNodeRef();
        req = new TestWebScriptServer.Request("POST", CREATE_LINK_API + testFolder1.getStoreRef().getProtocol() + "/" + testFolder1.getStoreRef().getIdentifier() + "/" + testFolder1.getId());
        jsonReq = new JSONObject();
        jsonReq.put((Object)DESTINATION_NODE_REF_PARAM, (Object)testFolder1.toString());
        jsonArray = new JSONArray();
        jsonArray.add((Object)siteNodeRef.toString());
        jsonReq.put((Object)MULTIPLE_FILES_PARAM, (Object)jsonArray);
        req.setBody(jsonReq.toString().getBytes());
        req.setType("application/json");
        json = this.asJSON(this.sendRequest(req, 400));
        NodeRef site2DocLib = this.siteService.getContainer(this.TEST_SITE.getShortName(), "documentLibrary");
        NodeRef testFileSite2 = this.createNode(site2DocLib, "testingLinkCreationFileInSite2", ContentModel.TYPE_CONTENT, AuthenticationUtil.getAdminUserName());
        req = new TestWebScriptServer.Request("POST", CREATE_LINK_API + testFolder1.getStoreRef().getProtocol() + "/" + testFolder1.getStoreRef().getIdentifier() + "/" + testFolder1.getId());
        jsonReq = new JSONObject();
        jsonReq.put((Object)DESTINATION_NODE_REF_PARAM, (Object)site2DocLib.toString());
        jsonArray = new JSONArray();
        jsonArray.add((Object)testFileSite2.toString());
        jsonReq.put((Object)MULTIPLE_FILES_PARAM, (Object)jsonArray);
        req.setBody(jsonReq.toString().getBytes());
        req.setType("application/json");
        json = this.asJSON(this.sendRequest(req, 200));
        this.siteService.deleteSite(site2.getShortName());
        this.nodeArchiveService.purgeArchivedNode(this.nodeArchiveService.getArchivedNode(siteNodeRef));
        NodeRef testFile4 = this.createNode(testFolder1, "testingLinkCreationFile4", ContentModel.TYPE_CONTENT, AuthenticationUtil.getAdminUserName());
        req = new TestWebScriptServer.Request("POST", CREATE_LINK_API + testFile4.getStoreRef().getProtocol() + "/" + testFile4.getStoreRef().getIdentifier() + "/" + testFile4.getId());
        jsonReq = new JSONObject();
        jsonReq.put((Object)DESTINATION_NODE_REF_PARAM, (Object)"alfresco://company/shared");
        jsonArray = new JSONArray();
        jsonArray.add((Object)testFile4.toString());
        jsonReq.put((Object)MULTIPLE_FILES_PARAM, (Object)jsonArray);
        req.setBody(jsonReq.toString().getBytes());
        req.setType("application/json");
        json = this.asJSON(this.sendRequest(req, 200));
        req = new TestWebScriptServer.Request("POST", CREATE_LINK_API + testFile4.getStoreRef().getProtocol() + "/" + testFile4.getStoreRef().getIdentifier() + "/" + testFile4.getId());
        jsonReq = new JSONObject();
        jsonReq.put((Object)DESTINATION_NODE_REF_PARAM, (Object)"alfresco://user/home");
        jsonArray = new JSONArray();
        jsonArray.add((Object)testFile4.toString());
        jsonReq.put((Object)MULTIPLE_FILES_PARAM, (Object)jsonArray);
        req.setBody(jsonReq.toString().getBytes());
        req.setType("application/json");
        json = this.asJSON(this.sendRequest(req, 200));
        AuthenticationUtil.setAdminUserAsFullyAuthenticatedUser();
        req = new TestWebScriptServer.Request("POST", CREATE_LINK_API + testFile4.getStoreRef().getProtocol() + "/" + testFile4.getStoreRef().getIdentifier() + "/" + testFile4.getId());
        jsonReq = new JSONObject();
        jsonReq.put((Object)DESTINATION_NODE_REF_PARAM, (Object)"alfresco://company/home");
        jsonArray = new JSONArray();
        jsonArray.add((Object)testFile4.toString());
        jsonReq.put((Object)MULTIPLE_FILES_PARAM, (Object)jsonArray);
        req.setBody(jsonReq.toString().getBytes());
        req.setType("application/json");
        json = this.asJSON(this.sendRequest(req, 200));
        req = new TestWebScriptServer.Request("DELETE", CREATE_LINK_API + testFile4.getStoreRef().getProtocol() + "/" + testFile4.getStoreRef().getIdentifier() + "/" + testFile4.getId() + "/delete");
        req.setType("application/json");
        json = this.asJSON(this.sendRequest(req, 200));
        NodeWebScripTest.assertEquals((boolean)false, (boolean)this.nodeService.hasAspect(testFile4, ApplicationModel.ASPECT_LINKED));
        AuthenticationUtil.setFullyAuthenticatedUser((String)USER_ONE);
        final NodeRef testFile5 = this.createNode(testFolder1, "testingLinkCreationFileWithLock", ContentModel.TYPE_CONTENT, AuthenticationUtil.getAdminUserName());
        req = new TestWebScriptServer.Request("POST", CREATE_LINK_API + testFile5.getStoreRef().getProtocol() + "/" + testFile5.getStoreRef().getIdentifier() + "/" + testFile5.getId());
        jsonReq = new JSONObject();
        jsonReq.put((Object)DESTINATION_NODE_REF_PARAM, (Object)testFolder1.toString());
        jsonArray = new JSONArray();
        jsonArray.add((Object)testFile5.toString());
        jsonReq.put((Object)MULTIPLE_FILES_PARAM, (Object)jsonArray);
        req.setBody(jsonReq.toString().getBytes());
        req.setType("application/json");
        json = this.asJSON(this.sendRequest(req, 200));
        jsonLinkNodes = (JSONArray)json.get((Object)"linkNodes");
        NodeWebScripTest.assertNotNull((Object)jsonLinkNodes);
        NodeWebScripTest.assertEquals((int)1, (int)jsonLinkNodes.size());
        NodeWebScripTest.assertEquals((Object)"true", (Object)json.get((Object)"overallSuccess"));
        NodeWebScripTest.assertEquals((Object)"1", (Object)json.get((Object)"successCount"));
        NodeWebScripTest.assertEquals((Object)"0", (Object)json.get((Object)"failureCount"));
        jsonLinkNode = (JSONObject)jsonLinkNodes.get(0);
        nodeRef = (String)jsonLinkNode.get((Object)"nodeRef");
        NodeRef file5Link = new NodeRef(nodeRef);
        NodeWebScripTest.assertEquals((boolean)true, (boolean)this.nodeService.hasAspect(testFile5, ApplicationModel.ASPECT_LINKED));
        NodeWebScripTest.assertEquals((boolean)true, (boolean)this.nodeService.exists(file5Link));
        final NodeRef workingCopy = (NodeRef)this.retryingTransactionHelper.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<NodeRef>(){

            public NodeRef execute() throws Exception {
                return NodeWebScripTest.this.checkOutCheckInService.checkout(testFile5);
            }
        });
        NodeWebScripTest.assertNotNull((Object)workingCopy);
        req = new TestWebScriptServer.Request("POST", CREATE_LINK_API + workingCopy.getStoreRef().getProtocol() + "/" + workingCopy.getStoreRef().getIdentifier() + "/" + workingCopy.getId());
        jsonReq = new JSONObject();
        jsonReq.put((Object)DESTINATION_NODE_REF_PARAM, (Object)testFolder1.toString());
        jsonArray = new JSONArray();
        jsonArray.add((Object)workingCopy.toString());
        jsonReq.put((Object)MULTIPLE_FILES_PARAM, (Object)jsonArray);
        req.setBody(jsonReq.toString().getBytes());
        req.setType("application/json");
        json = this.asJSON(this.sendRequest(req, 400));
        this.nodeService.deleteNode(file5Link);
        NodeWebScripTest.assertEquals((boolean)false, (boolean)this.nodeService.hasAspect(testFile5, ApplicationModel.ASPECT_LINKED));
        this.retryingTransactionHelper.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Object>(){

            public Object execute() throws Exception {
                NodeWebScripTest.this.checkOutCheckInService.checkin(workingCopy, new HashMap());
                return null;
            }
        });
        NodeWebScripTest.assertEquals((boolean)false, (boolean)this.nodeService.hasAspect(testFile5, ContentModel.ASPECT_LOCKABLE));
        NodeRef testFile6 = this.createNode(testFolder1, "testingLinkCreationFile6", ContentModel.TYPE_CONTENT, AuthenticationUtil.getAdminUserName());
        AuthenticationUtil.setFullyAuthenticatedUser((String)USER_TWO);
        NodeWebScripTest.assertTrue((this.permissionService.hasPermission(testFile6, "Read") == AccessStatus.ALLOWED ? 1 : 0) != 0);
        NodeWebScripTest.assertTrue((this.permissionService.hasPermission(testFile6, "Write") == AccessStatus.DENIED ? 1 : 0) != 0);
        req = new TestWebScriptServer.Request("POST", CREATE_LINK_API + testFile6.getStoreRef().getProtocol() + "/" + testFile6.getStoreRef().getIdentifier() + "/" + testFile6.getId());
        jsonReq = new JSONObject();
        jsonReq.put((Object)DESTINATION_NODE_REF_PARAM, (Object)"alfresco://user/home");
        jsonArray = new JSONArray();
        jsonArray.add((Object)testFile6.toString());
        jsonReq.put((Object)MULTIPLE_FILES_PARAM, (Object)jsonArray);
        req.setBody(jsonReq.toString().getBytes());
        req.setType("application/json");
        json = this.asJSON(this.sendRequest(req, 200));
        jsonLinkNodes = (JSONArray)json.get((Object)"linkNodes");
        NodeWebScripTest.assertNotNull((Object)jsonLinkNodes);
        NodeWebScripTest.assertEquals((int)1, (int)jsonLinkNodes.size());
        NodeWebScripTest.assertEquals((Object)"true", (Object)json.get((Object)"overallSuccess"));
        NodeWebScripTest.assertEquals((Object)"1", (Object)json.get((Object)"successCount"));
        NodeWebScripTest.assertEquals((Object)"0", (Object)json.get((Object)"failureCount"));
        jsonLinkNode = (JSONObject)jsonLinkNodes.get(0);
        nodeRef = (String)jsonLinkNode.get((Object)"nodeRef");
        NodeRef testFileSite3Link = new NodeRef(nodeRef);
        this.nodeService.exists(testFileSite3Link);
        NodeWebScripTest.assertEquals((boolean)true, (boolean)this.nodeService.hasAspect(testFile6, ApplicationModel.ASPECT_LINKED));
    }

    private NodeRef createNode(NodeRef parentNode, String nodeCmName, QName nodeType, String ownerUserName) {
        QName childName = QName.createQName((String)"http://www.alfresco.org/model/application/1.0", (String)nodeCmName);
        HashMap<QName, String> props = new HashMap<QName, String>();
        props.put(ContentModel.PROP_NAME, nodeCmName);
        ChildAssociationRef childAssoc = this.nodeService.createNode(parentNode, ContentModel.ASSOC_CONTAINS, childName, nodeType, props);
        return childAssoc.getChildRef();
    }
}

