/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.api.tests;

import jakarta.transaction.HeuristicMixedException;
import jakarta.transaction.HeuristicRollbackException;
import jakarta.transaction.NotSupportedException;
import jakarta.transaction.RollbackException;
import jakarta.transaction.SystemException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.rest.AbstractSingleNetworkSiteTest;
import org.alfresco.rest.api.Queries;
import org.alfresco.rest.api.tests.PersonInfo;
import org.alfresco.rest.api.tests.client.HttpResponse;
import org.alfresco.rest.api.tests.client.PublicApiClient;
import org.alfresco.rest.api.tests.client.data.Company;
import org.alfresco.rest.api.tests.client.data.Person;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.search.SearchParameters;
import org.alfresco.service.cmr.search.SearchService;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentCaptor;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;

@RunWith(value=MockitoJUnitRunner.class)
public class QueriesPeopleApiTest
extends AbstractSingleNetworkSiteTest {
    private static final String URL_QUERIES_LSP = "queries/people";
    private static String TEST_TERM_PREFIX = Long.toString(System.currentTimeMillis() / 1000L);
    private static int TEST_COUNT = 22;
    private static int testCounter = 0;
    private static final String USER0 = TEST_TERM_PREFIX + "user0";
    private static final String USER1 = TEST_TERM_PREFIX + "user1";
    private static final String USER2 = TEST_TERM_PREFIX + "user2";
    private static final String USER3 = TEST_TERM_PREFIX + "user3";
    private static final String USER4 = TEST_TERM_PREFIX + "user4";
    private static final String USER5 = TEST_TERM_PREFIX + "user5";
    private static final String FIRST_A = TEST_TERM_PREFIX + "FirstA";
    private static final String FIRST_B = TEST_TERM_PREFIX + "FirstB";
    private static final String FIRST_C = TEST_TERM_PREFIX + "FirstC";
    private static final String LAST_A = TEST_TERM_PREFIX + "LastA";
    private static final String LAST_B = TEST_TERM_PREFIX + "LastB";
    private static final String LAST_C = TEST_TERM_PREFIX + "LastC";
    private static final List<String> testUsernames = new ArrayList<String>();
    private static final List<Person> testPersons = new ArrayList<Person>();
    private static final List<NodeRef> testPersonNodeRefs = new ArrayList<NodeRef>();
    private static final String[][] userProperties = new String[][]{{USER0, FIRST_A, LAST_A}, {USER1, FIRST_A, LAST_B}, {USER2, FIRST_B, LAST_A}, {USER3, FIRST_C}, {USER4, null, LAST_A}, {USER5, null, LAST_C}};
    private String term = "";
    private String orderBy = null;
    private String fields = null;
    private PublicApiClient.Paging paging;
    private Map<String, String> params;
    private HttpResponse response;
    private List<Person> people;

    @Override
    @Before
    public void setup() throws Exception {
        super.setup();
        if (testCounter++ == 0) {
            this.createTestUsers();
        }
        this.paging = this.getPaging(0, 100);
        this.params = new HashMap<String, String>();
        this.term = TEST_TERM_PREFIX;
        this.orderBy = null;
        this.fields = null;
        this.setRequestContext(user1);
    }

    @Override
    @After
    public void tearDown() throws Exception {
        super.tearDown();
        if (testCounter == TEST_COUNT) {
            this.deleteTestUsers();
        }
    }

    private void createTestUsers() throws IllegalArgumentException, SystemException, NotSupportedException, HeuristicRollbackException, HeuristicMixedException, RollbackException {
        AuthenticationUtil.setFullyAuthenticatedUser((String)user1);
        for (String[] properties : userProperties) {
            int l = properties.length;
            if (l <= 0) continue;
            PersonInfo personInfo = QueriesPeopleApiTest.newPersonInfo(properties);
            String originalUsername = personInfo.getUsername();
            String id = this.createUser(personInfo, networkOne);
            Person person = new Person(id, null, true, personInfo.getFirstName(), personInfo.getLastName(), personInfo.getCompany(), personInfo.getSkype(), personInfo.getLocation(), personInfo.getTel(), personInfo.getMob(), personInfo.getInstantmsg(), personInfo.getGoogle(), null);
            testUsernames.add(originalUsername);
            testPersons.add(person);
            NodeRef nodeRef = personService.getPerson(id);
            nodeRef = this.tenantService.getName(nodeRef);
            testPersonNodeRefs.add(nodeRef);
        }
    }

    private void deleteTestUsers() {
        for (String id : testUsernames) {
            try {
                this.deleteUser(id, null);
            }
            catch (Exception e) {
                System.err.println("Failed to delete test user " + id);
            }
        }
        testPersons.clear();
    }

    private static PersonInfo newPersonInfo(String ... properties) throws IllegalArgumentException {
        int l = properties.length;
        if (l > 17) {
            throw new IllegalArgumentException("Too many properties supplied for " + String.valueOf(properties));
        }
        return new PersonInfo(l <= 1 ? null : properties[1], l <= 2 ? null : properties[2], l <= 0 ? null : properties[0], l <= 3 || properties[3] == null ? "password" : properties[3], l <= 4 ? null : new Company(properties[4], l <= 5 ? null : properties[5], l <= 6 ? null : properties[6], l <= 7 ? null : properties[7], l <= 8 ? null : properties[8], l <= 9 ? null : properties[9], l <= 10 ? null : properties[10], l <= 11 ? null : properties[11]), l <= 12 ? null : properties[12], l <= 13 ? null : properties[13], l <= 14 ? null : properties[14], l <= 15 ? null : properties[15], l <= 16 ? null : properties[16], l <= 17 ? null : properties[17]);
    }

    private void checkApiCall(String term, String orderBy, String fields, PublicApiClient.Paging paging, int expectedStatus, List<String> expectedPeople, int ... userIds) throws Exception {
        this.createParamIdNotNull("term", term);
        this.createParamIdNotNull("orderBy", orderBy);
        this.createParamIdNotNull("fields", fields);
        this.dummySearchServiceQueryNodeRefs.clear();
        for (int i : userIds) {
            NodeRef nodeRef = testPersonNodeRefs.get(i);
            this.dummySearchServiceQueryNodeRefs.add(nodeRef);
        }
        this.response = this.getAll(URL_QUERIES_LSP, paging, this.params, expectedStatus);
        if (expectedStatus == 200) {
            String termWithEscapedAsterisks = term.replaceAll("\\*", "\\\\*");
            String expectedQuery = "TYPE:\"{http://www.alfresco.org/model/content/1.0}person\" AND (\"*" + termWithEscapedAsterisks + "*\")";
            ArgumentCaptor searchParametersCaptor = ArgumentCaptor.forClass(SearchParameters.class);
            ((SearchService)Mockito.verify((Object)this.mockSearchService, (VerificationMode)Mockito.times((int)(++this.callCountToMockSearchService)))).query((SearchParameters)searchParametersCaptor.capture());
            SearchParameters parameters = (SearchParameters)searchParametersCaptor.getValue();
            Assert.assertEquals((String)"Query", (Object)expectedQuery, (Object)parameters.getQuery());
            this.people = Person.parsePeople(this.response.getJsonResponse()).getList();
            if (!expectedPeople.isEmpty()) {
                StringJoiner actual = new StringJoiner("\n");
                StringJoiner expected = new StringJoiner("\n");
                for (String people : expectedPeople) {
                    expected.add(people);
                }
                for (Person person : this.people) {
                    actual.add(person.toString());
                }
                String exp = expected.toString().replaceAll(TEST_TERM_PREFIX, "");
                String act = actual.toString().replaceAll(TEST_TERM_PREFIX, "");
                Assert.assertEquals((Object)exp, (Object)act);
            }
        }
    }

    private void createParamIdNotNull(String param, String value) {
        if (value != null && this.params != null) {
            this.params.put(param, value);
        }
    }

    private List<String> expectedPeople(int ... userIds) {
        ArrayList<String> list = new ArrayList<String>();
        for (int i : userIds) {
            Person person = testPersons.get(i);
            String string = person.toString();
            list.add(string);
        }
        return list;
    }

    @Test
    public void testUnauthenticated() throws Exception {
        this.setRequestContext(null);
        this.checkApiCall(this.term, this.orderBy, this.fields, this.paging, 401, null, new int[0]);
    }

    @Test
    public void testOnlyTestUsersAndDefaultOrder() throws Exception {
        this.checkApiCall(this.term, this.orderBy, this.fields, this.paging, 200, this.expectedPeople(4, 5, 0, 1, 2, 3), 4, 5, 0, 1, 2, 3);
    }

    @Test
    public void testSearchFirstname() throws Exception {
        this.checkApiCall(FIRST_A, this.orderBy, this.fields, this.paging, 200, this.expectedPeople(0, 1), 0, 1);
    }

    @Test
    public void testSearchLastName() throws Exception {
        this.checkApiCall(LAST_A, this.orderBy, this.fields, this.paging, 200, this.expectedPeople(4, 0, 2), 4, 0, 2);
    }

    @Test
    public void testSearchUsername() throws Exception {
        this.checkApiCall(USER0, this.orderBy, this.fields, this.paging, 200, this.expectedPeople(0), 0);
    }

    @Test
    public void testNoParams() throws Exception {
        this.params = null;
        this.checkApiCall(this.term, this.orderBy, this.fields, this.paging, 400, null, new int[0]);
    }

    @Test
    public void testNoTerm() throws Exception {
        this.checkApiCall(null, this.orderBy, this.fields, this.paging, 400, null, new int[0]);
    }

    @Test
    public void testTermShorterThan2() throws Exception {
        this.checkApiCall("X", this.orderBy, this.fields, this.paging, 400, null, new int[0]);
    }

    @Test
    public void testOrderbySameAsDefault() throws Exception {
        this.orderBy = "firstName asc, lastName";
        this.checkApiCall(this.term, this.orderBy, this.fields, this.paging, 200, this.expectedPeople(4, 5, 0, 1, 2, 3), 4, 5, 0, 1, 2, 3);
    }

    @Test
    public void testOrderbyDescAndAsc() throws Exception {
        this.orderBy = "firstName desc, lastName";
        this.checkApiCall(this.term, this.orderBy, this.fields, this.paging, 200, this.expectedPeople(3, 2, 0, 1, 4, 5), 3, 2, 0, 1, 4, 5);
    }

    @Test
    public void testOrderbyDescAndDesc() throws Exception {
        this.orderBy = "firstName desc, lastName desc";
        this.checkApiCall(this.term, this.orderBy, this.fields, this.paging, 200, this.expectedPeople(3, 2, 1, 0, 5, 4), 3, 2, 1, 0, 5, 4);
    }

    @Test
    public void testOrderbyId() throws Exception {
        this.orderBy = "id";
        this.checkApiCall(this.term, this.orderBy, this.fields, this.paging, 200, this.expectedPeople(0, 1, 2, 3, 4, 5), 0, 1, 2, 3, 4, 5);
    }

    @Test
    public void testBadOrderByField() throws Exception {
        this.orderBy = "rubbish";
        this.checkApiCall(this.term, this.orderBy, this.fields, this.paging, 400, null, new int[0]);
    }

    @Test
    public void testFieldsFirstLast() throws Exception {
        this.fields = Queries.PARAM_FIRSTNAME + "," + Queries.PARAM_LASTNAME;
        this.term = LAST_A;
        List<String> expectedPeople = Arrays.asList("Person [lastName=LastA, company=Company [address1=null, address2=null, address3=null, postcode=null, telephone=null, fax=null, email=null], ]", "Person [firstName=FirstA, lastName=LastA, company=Company [address1=null, address2=null, address3=null, postcode=null, telephone=null, fax=null, email=null], ]", "Person [firstName=FirstB, lastName=LastA, company=Company [address1=null, address2=null, address3=null, postcode=null, telephone=null, fax=null, email=null], ]");
        this.checkApiCall(this.term, this.orderBy, this.fields, this.paging, 200, expectedPeople, 4, 0, 2);
    }

    @Test
    public void testFieldsId() throws Exception {
        this.fields = "id";
        String tenantSuffix = useDefaultNetwork ? "" : "@" + networkOne.getId();
        List<String> expectedPeople = Arrays.asList("Person [id=user4" + tenantSuffix + ", company=Company [address1=null, address2=null, address3=null, postcode=null, telephone=null, fax=null, email=null], ]", "Person [id=user0" + tenantSuffix + ", company=Company [address1=null, address2=null, address3=null, postcode=null, telephone=null, fax=null, email=null], ]", "Person [id=user2" + tenantSuffix + ", company=Company [address1=null, address2=null, address3=null, postcode=null, telephone=null, fax=null, email=null], ]");
        this.checkApiCall(LAST_A, this.orderBy, this.fields, this.paging, 200, expectedPeople, 4, 0, 2);
    }

    @Test
    public void testSearchFirstnameWithWildcard() throws Exception {
        this.term = FIRST_A.substring(0, FIRST_A.length() - 3) + "*A";
        this.checkApiCall(this.term, this.orderBy, this.fields, this.paging, 200, this.expectedPeople(0, 1), 0, 1);
    }

    @Test
    public void testSearchLastNameWithWildcard() throws Exception {
        this.term = LAST_A;
        this.term = this.term.substring(0, this.term.length() - 3) + "*A";
        this.checkApiCall(this.term, this.orderBy, this.fields, this.paging, 200, this.expectedPeople(4, 0, 2), 4, 0, 2);
    }

    @Test
    public void testSearchUsernameWithWildcard() throws Exception {
        this.term = TEST_TERM_PREFIX + "us*1";
        this.checkApiCall(this.term, this.orderBy, this.fields, this.paging, 200, this.expectedPeople(0), 0);
    }

    @Test
    public void testOrderbyDescAndAscWithWildcard() throws Exception {
        this.term = TEST_TERM_PREFIX + "la*A";
        this.orderBy = "firstName desc,lastName";
        this.checkApiCall(this.term, this.orderBy, this.fields, this.paging, 200, this.expectedPeople(2, 0, 4), 2, 0, 4);
    }

    @Test
    public void testOnlyWildcard() throws Exception {
        this.checkApiCall("*", this.orderBy, this.fields, this.paging, 400, null, new int[0]);
    }

    @Test
    public void testBadOrderByDirection() throws Exception {
        this.orderBy = "firstName rubbish, lastName asc";
        this.checkApiCall(this.term, this.orderBy, this.fields, this.paging, 400, null, new int[0]);
    }

    @Test
    public void testFieldsWithSpace() throws Exception {
        this.fields = Queries.PARAM_FIRSTNAME + ", " + Queries.PARAM_LASTNAME;
        this.term = LAST_A;
        List<String> expectedPeople = Arrays.asList("Person [lastName=LastA, company=Company [address1=null, address2=null, address3=null, postcode=null, telephone=null, fax=null, email=null], ]", "Person [firstName=FirstA, lastName=LastA, company=Company [address1=null, address2=null, address3=null, postcode=null, telephone=null, fax=null, email=null], ]", "Person [firstName=FirstB, lastName=LastA, company=Company [address1=null, address2=null, address3=null, postcode=null, telephone=null, fax=null, email=null], ]");
        this.checkApiCall(this.term, this.orderBy, this.fields, this.paging, 200, expectedPeople, 4, 0, 2);
    }
}

