/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.api.tests.client.data;

import java.text.ParseException;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Map;
import org.alfresco.model.ContentModel;
import org.alfresco.rest.api.tests.PublicApiDateFormat;
import org.alfresco.rest.api.tests.client.data.ExpectedComparison;
import org.alfresco.rest.api.tests.client.data.FavouriteNode;
import org.alfresco.rest.api.tests.client.data.JSONAble;
import org.apache.chemistry.opencmis.commons.data.Properties;
import org.apache.chemistry.opencmis.commons.data.PropertyData;
import org.json.simple.JSONObject;

public class FavouriteFolder
extends FavouriteNode
implements ExpectedComparison,
JSONAble {
    private static final long serialVersionUID = 5020819866533183524L;

    public FavouriteFolder(String guid) {
        super(guid);
    }

    public FavouriteFolder(String id, String guid) {
        super(id, guid);
    }

    public static FavouriteFolder getFolder(String id, String guid, Properties props) {
        FavouriteFolder folder = new FavouriteFolder(id, guid);
        Map properties = props.getProperties();
        folder.setName((String)((PropertyData)properties.get("cmis:name")).getFirstValue());
        folder.setTitle((String)((PropertyData)properties.get(ContentModel.PROP_TITLE.toString())).getFirstValue());
        folder.setCreatedBy((String)((PropertyData)properties.get("cmis:createdBy")).getFirstValue());
        folder.setModifiedBy((String)((PropertyData)properties.get("cmis:lastModifiedBy")).getFirstValue());
        GregorianCalendar modifiedAt = (GregorianCalendar)((PropertyData)properties.get("cmis:lastModificationDate")).getFirstValue();
        folder.setModifiedAt(modifiedAt.getTime());
        GregorianCalendar createdAt = (GregorianCalendar)((PropertyData)properties.get("cmis:creationDate")).getFirstValue();
        folder.setCreatedAt(createdAt.getTime());
        return folder;
    }

    @Override
    public JSONObject toJSON() {
        JSONObject json = super.toJSON();
        return json;
    }

    public static FavouriteFolder parseFolder(JSONObject jsonObject) throws ParseException {
        String id = (String)jsonObject.get((Object)"id");
        String guid = (String)jsonObject.get((Object)"guid");
        String name = (String)jsonObject.get((Object)"name");
        String title = (String)jsonObject.get((Object)"title");
        String description = (String)jsonObject.get((Object)"description");
        Date createdAt = PublicApiDateFormat.getDateFormat().parse((String)jsonObject.get((Object)"createdAt"));
        Date modifiedAt = PublicApiDateFormat.getDateFormat().parse((String)jsonObject.get((Object)"modifiedAt"));
        String createdBy = (String)jsonObject.get((Object)"createdBy");
        String modifiedBy = (String)jsonObject.get((Object)"modifiedBy");
        FavouriteFolder folder = new FavouriteFolder(id, guid);
        folder.setName(name);
        folder.setTitle(title);
        folder.setCreatedBy(createdBy);
        folder.setModifiedBy(modifiedBy);
        folder.setModifiedAt(modifiedAt);
        folder.setCreatedAt(createdAt);
        folder.setDescription(description);
        folder.parseAndSetPath(jsonObject);
        return folder;
    }

    @Override
    public void expected(Object o) {
        super.expected(o);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(250);
        sb.append("FavouriteFolder [nodeId=").append(this.nodeId).append(", guid=").append(this.guid).append(", name=").append(this.name).append(", title=").append(this.title).append(", description=").append(this.description).append(", createdAt=").append(this.createdAt).append(", modifiedAt=").append(this.modifiedAt).append(", createdBy=").append(this.createdBy).append(", modifiedBy=").append(this.modifiedBy).append(", path=").append(this.path).append(']');
        return sb.toString();
    }
}

