/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.api.model;

import java.io.Serializable;
import java.util.Date;
import java.util.Map;
import org.alfresco.model.ContentModel;
import org.alfresco.rest.api.model.Person;
import org.alfresco.rest.framework.resource.UniqueId;
import org.alfresco.service.namespace.QName;

public class Comment {
    public static final QName PROP_COMMENT_CONTENT = QName.createQName((String)"RestApi", (String)"commentContent");
    public static final QName PROP_COMMENT_CREATED_BY = QName.createQName((String)"RestApi", (String)"createdBy");
    public static final QName PROP_COMMENT_MODIFIED_BY = QName.createQName((String)"RestApi", (String)"modifiedBy");
    private String id;
    private String title;
    private String content;
    private Date createdAt;
    private Person createdBy;
    private Date modifiedAt;
    private Person modifiedBy;
    private Boolean edited;
    private boolean canEdit;
    private boolean canDelete;

    public Comment() {
    }

    public Comment(String id, Map<QName, Serializable> nodeProps, boolean canEdit, boolean canDelete) {
        if (id == null) {
            throw new IllegalArgumentException();
        }
        this.id = id;
        this.mapProperties(nodeProps);
        this.canEdit = canEdit;
        this.canDelete = canDelete;
    }

    @UniqueId
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public boolean getCanEdit() {
        return this.canEdit;
    }

    public boolean getCanDelete() {
        return this.canDelete;
    }

    public String getTitle() {
        return this.title;
    }

    public String getContent() {
        return this.content;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public Date getCreatedAt() {
        return this.createdAt;
    }

    public Person getCreatedBy() {
        return this.createdBy;
    }

    public Person getModifiedBy() {
        return this.modifiedBy;
    }

    public Date getModifiedAt() {
        return this.modifiedAt;
    }

    public Boolean getEdited() {
        return this.edited;
    }

    protected void mapProperties(Map<QName, Serializable> nodeProps) {
        String propTitle = (String)((Object)nodeProps.get(ContentModel.PROP_TITLE));
        if (propTitle != null) {
            this.title = propTitle;
        }
        this.modifiedAt = (Date)nodeProps.get(ContentModel.PROP_MODIFIED);
        this.createdAt = (Date)nodeProps.get(ContentModel.PROP_CREATED);
        if (this.modifiedAt != null && this.createdAt != null) {
            long diff = this.modifiedAt.getTime() - this.createdAt.getTime();
            this.edited = diff >= 100L;
        }
        this.content = (String)((Object)nodeProps.get(PROP_COMMENT_CONTENT));
        nodeProps.remove(PROP_COMMENT_CONTENT);
        this.createdBy = (Person)nodeProps.get(PROP_COMMENT_CREATED_BY);
        nodeProps.remove(PROP_COMMENT_CREATED_BY);
        this.modifiedBy = (Person)nodeProps.get(PROP_COMMENT_MODIFIED_BY);
        nodeProps.remove(PROP_COMMENT_MODIFIED_BY);
    }

    public String toString() {
        return "Comment [id=" + this.id + ", title=" + this.title + ", content=" + this.content + ", createdAt=" + String.valueOf(this.createdAt) + ", createdBy=" + String.valueOf(this.createdBy) + ", modifiedAt=" + String.valueOf(this.modifiedAt) + ", modifiedBy=" + String.valueOf(this.modifiedBy) + ", edited=" + this.edited + "]";
    }
}

