/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.api.rules;

import java.util.List;
import org.alfresco.rest.api.Rules;
import org.alfresco.rest.api.model.rules.RuleExecution;
import org.alfresco.rest.api.nodes.NodesEntityResource;
import org.alfresco.rest.framework.resource.RelationshipResource;
import org.alfresco.rest.framework.resource.actions.interfaces.RelationshipResourceAction;
import org.alfresco.rest.framework.resource.parameters.Parameters;
import org.alfresco.service.Experimental;
import org.alfresco.util.PropertyCheck;
import org.springframework.beans.factory.InitializingBean;

@RelationshipResource(name="rule-executions", entityResource=NodesEntityResource.class, title="Executing rules")
@Experimental
public class NodeRuleExecutionsRelation
implements RelationshipResourceAction.Create<RuleExecution>,
InitializingBean {
    private final Rules rules;

    public NodeRuleExecutionsRelation(Rules rules) {
        this.rules = rules;
    }

    public void afterPropertiesSet() throws Exception {
        PropertyCheck.mandatory((Object)this, (String)"rules", (Object)this.rules);
    }

    @Override
    public List<RuleExecution> create(String folderNodeId, List<RuleExecution> ruleExecutionParameters, Parameters parameters) {
        RuleExecution ruleExecution = ruleExecutionParameters.stream().findFirst().orElse(new RuleExecution());
        return List.of(this.rules.executeRules(folderNodeId, ruleExecution.getIsEachSubFolderIncluded()));
    }
}

