/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.framework.webscripts;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.alfresco.rest.framework.resource.content.ContentInfo;
import org.springframework.extensions.webscripts.Cache;

public class WithResponse {
    private ContentInfo contentInfo;
    private int status;
    private Map<String, List<String>> headers;
    private Cache cache;

    public WithResponse(int status, ContentInfo contentInfo, Cache cache) {
        this.contentInfo = contentInfo;
        this.status = status;
        this.headers = new HashMap<String, List<String>>();
        this.cache = cache;
    }

    public void setContentInfo(ContentInfo contentInfo) {
        this.contentInfo = contentInfo;
    }

    public void setStatus(int status) {
        this.status = status;
    }

    public void setHeader(String name, String value) {
        this.headers.put(name, new ArrayList<String>(Arrays.asList(value)));
    }

    public void addHeader(String name, String value) {
        List<String> existing = this.headers.get(name);
        if (existing != null) {
            existing.add(value);
        } else {
            this.setHeader(name, value);
        }
    }

    public void setCache(Cache cache) {
        this.cache = cache;
    }

    public ContentInfo getContentInfo() {
        return this.contentInfo;
    }

    public int getStatus() {
        return this.status;
    }

    public Cache getCache() {
        return this.cache;
    }

    public Map<String, List<String>> getHeaders() {
        return this.headers;
    }
}

