/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.api.search.context;

import java.util.List;
import org.alfresco.repo.search.impl.solr.facet.facetsresponse.GenericFacetResponse;
import org.alfresco.rest.api.search.context.FacetFieldContext;
import org.alfresco.rest.api.search.context.FacetQueryContext;
import org.alfresco.rest.api.search.context.SpellCheckContext;
import org.alfresco.rest.api.search.model.SearchQuery;

public class SearchContext {
    private final Consistency consistency;
    private final List<FacetQueryContext> facetQueries;
    private final SpellCheckContext spellCheck;
    private final List<FacetFieldContext> facetsFields;
    private final List<GenericFacetResponse> facets;
    private final SearchQuery request;

    public SearchContext(long lastTxId, List<GenericFacetResponse> facets, List<FacetQueryContext> facetResults, List<FacetFieldContext> facetsFields, SpellCheckContext spellCheck, SearchQuery request) {
        this.spellCheck = spellCheck;
        this.request = request;
        this.consistency = lastTxId > 0L ? new Consistency(lastTxId) : null;
        this.facetQueries = facetResults;
        this.facetsFields = facetsFields;
        this.facets = facets;
    }

    public Consistency getConsistency() {
        return this.consistency;
    }

    public List<FacetQueryContext> getFacetQueries() {
        return this.facetQueries;
    }

    public SpellCheckContext getSpellCheck() {
        return this.spellCheck;
    }

    public List<GenericFacetResponse> getFacets() {
        return this.facets;
    }

    public List<FacetFieldContext> getFacetsFields() {
        return this.facetsFields;
    }

    public SearchQuery getRequest() {
        return this.request;
    }

    public class Consistency {
        private final long lastTxId;

        public Consistency(long lastTxId) {
            this.lastTxId = lastTxId;
        }

        public long getlastTxId() {
            return this.lastTxId;
        }
    }
}

