/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.web.scripts.thumbnail;

import java.io.InputStream;
import java.util.Collections;
import java.util.Map;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.model.Repository;
import org.alfresco.repo.rendition2.SynchronousTransformClient;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.transaction.TransactionServiceImpl;
import org.alfresco.repo.web.scripts.BaseWebScriptTest;
import org.alfresco.service.cmr.model.FileFolderService;
import org.alfresco.service.cmr.model.FileInfo;
import org.alfresco.service.cmr.repository.ContentService;
import org.alfresco.service.cmr.repository.ContentWriter;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.security.MutableAuthenticationService;
import org.alfresco.service.cmr.security.PersonService;
import org.alfresco.test_category.OwnJVMTestsCategory;
import org.alfresco.util.GUID;
import org.alfresco.util.PropertyMap;
import org.json.JSONArray;
import org.json.JSONObject;
import org.junit.experimental.categories.Category;
import org.springframework.extensions.webscripts.TestWebScriptServer;

@Category(value={OwnJVMTestsCategory.class})
public class ThumbnailServiceTest
extends BaseWebScriptTest {
    private NodeRef testRoot;
    private NodeRef pdfNode;
    private NodeRef jpgNode;
    private FileFolderService fileFolderService;
    private ContentService contentService;
    private SynchronousTransformClient synchronousTransformClient;
    private Repository repositoryHelper;
    private TransactionServiceImpl transactionService;
    private MutableAuthenticationService authenticationService;
    private PersonService personService;
    private static final String USER_ALFRESCO = "AlfrescoUser";

    protected void setUp() throws Exception {
        super.setUp();
        this.fileFolderService = (FileFolderService)this.getServer().getApplicationContext().getBean("FileFolderService");
        this.contentService = (ContentService)this.getServer().getApplicationContext().getBean("ContentService");
        this.synchronousTransformClient = (SynchronousTransformClient)this.getServer().getApplicationContext().getBean("synchronousTransformClient");
        this.repositoryHelper = (Repository)this.getServer().getApplicationContext().getBean("repositoryHelper");
        this.authenticationService = (MutableAuthenticationService)this.getServer().getApplicationContext().getBean("AuthenticationService");
        this.personService = (PersonService)this.getServer().getApplicationContext().getBean("PersonService");
        try {
            this.transactionService = (TransactionServiceImpl)this.getServer().getApplicationContext().getBean("transactionComponent");
        }
        catch (ClassCastException e) {
            throw new AlfrescoRuntimeException("The ThumbnailServiceTest needs direct access to the TransactionServiceImpl");
        }
        AuthenticationUtil.setFullyAuthenticatedUser((String)AuthenticationUtil.getSystemUserName());
        this.testRoot = this.repositoryHelper.getCompanyHome();
        InputStream pdfStream = ThumbnailServiceTest.class.getClassLoader().getResourceAsStream("org/alfresco/repo/web/scripts/thumbnail/test_doc.pdf");
        ThumbnailServiceTest.assertNotNull((Object)pdfStream);
        InputStream jpgStream = ThumbnailServiceTest.class.getClassLoader().getResourceAsStream("org/alfresco/repo/web/scripts/thumbnail/test_image.jpg");
        ThumbnailServiceTest.assertNotNull((Object)jpgStream);
        String guid = GUID.generate();
        FileInfo fileInfoPdf = this.fileFolderService.create(this.testRoot, "test_doc" + guid + ".pdf", ContentModel.TYPE_CONTENT);
        this.pdfNode = fileInfoPdf.getNodeRef();
        ContentWriter contentWriter = this.contentService.getWriter(fileInfoPdf.getNodeRef(), ContentModel.PROP_CONTENT, true);
        contentWriter.setEncoding("UTF-8");
        contentWriter.setMimetype("application/pdf");
        contentWriter.putContent(pdfStream);
        FileInfo fileInfoJpg = this.fileFolderService.create(this.testRoot, "test_image" + guid + ".jpg", ContentModel.TYPE_CONTENT);
        this.jpgNode = fileInfoJpg.getNodeRef();
        contentWriter = this.contentService.getWriter(fileInfoJpg.getNodeRef(), ContentModel.PROP_CONTENT, true);
        contentWriter.setEncoding("UTF-8");
        contentWriter.setMimetype("image/jpeg");
        contentWriter.putContent(jpgStream);
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        this.transactionService.setAllowWrite(true);
        AuthenticationUtil.clearCurrentSecurityContext();
    }

    public void testCreateThumbnail() throws Exception {
        if (this.synchronousTransformClient.isSupported("application/pdf", -1L, null, "application/x-shockwave-flash", Collections.emptyMap(), null, null)) {
            String url = "/api/node/" + this.pdfNode.getStoreRef().getProtocol() + "/" + this.pdfNode.getStoreRef().getIdentifier() + "/" + this.pdfNode.getId() + "/content/thumbnails";
            JSONObject tn = new JSONObject();
            tn.put("thumbnailName", (Object)"webpreview");
            TestWebScriptServer.Response response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.PostRequest(url, tn.toString(), "application/json"), 200);
            System.out.println(response.getContentAsString());
        }
        TestWebScriptServer.Response getAllResp = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest(this.getThumbnailsURL(this.jpgNode)), 200);
        JSONArray getArr = new JSONArray(getAllResp.getContentAsString());
        ThumbnailServiceTest.assertNotNull((Object)getArr);
        ThumbnailServiceTest.assertEquals((int)0, (int)getArr.length());
        String url = "/api/node/" + this.jpgNode.getStoreRef().getProtocol() + "/" + this.jpgNode.getStoreRef().getIdentifier() + "/" + this.jpgNode.getId() + "/content/thumbnails";
        JSONObject tn = new JSONObject();
        tn.put("thumbnailName", (Object)"medium");
        TestWebScriptServer.Response response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.PostRequest(url, tn.toString(), "application/json"), 200);
        System.out.println(response.getContentAsString());
        JSONObject result = new JSONObject(response.getContentAsString());
        String thumbnailUrl = result.getString("url").substring(17);
        System.out.println(thumbnailUrl);
        response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest(thumbnailUrl), 200);
        getAllResp = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest(this.getThumbnailsURL(this.jpgNode)), 200);
        getArr = new JSONArray(getAllResp.getContentAsString());
        ThumbnailServiceTest.assertNotNull((Object)getArr);
        ThumbnailServiceTest.assertEquals((int)1, (int)getArr.length());
        ThumbnailServiceTest.assertEquals((Object)"medium", (Object)getArr.getJSONObject(0).get("thumbnailName"));
    }

    private void createUser(String userName) {
        if (!this.authenticationService.authenticationExists(userName)) {
            this.authenticationService.createAuthentication(userName, "password".toCharArray());
            PropertyMap personProps = new PropertyMap();
            personProps.put((Object)ContentModel.PROP_USERNAME, (Object)userName);
            personProps.put((Object)ContentModel.PROP_FIRSTNAME, (Object)"First");
            personProps.put((Object)ContentModel.PROP_LASTNAME, (Object)"Last");
            personProps.put((Object)ContentModel.PROP_EMAIL, (Object)"FirstName123.LastName123@email.com");
            personProps.put((Object)ContentModel.PROP_JOBTITLE, (Object)"JobTitle123");
            personProps.put((Object)ContentModel.PROP_JOBTITLE, (Object)"Organisation123");
            this.personService.createPerson((Map)personProps);
        }
    }

    public void testCreateThumbnailInReadonlyMode() throws Exception {
        this.createUser(USER_ALFRESCO);
        AuthenticationUtil.setFullyAuthenticatedUser((String)USER_ALFRESCO);
        this.transactionService.setAllowWrite(false);
        if (this.synchronousTransformClient.isSupported("application/pdf", -1L, null, "application/x-shockwave-flash", Collections.emptyMap(), null, null)) {
            String url = "/api/node/" + this.pdfNode.getStoreRef().getProtocol() + "/" + this.pdfNode.getStoreRef().getIdentifier() + "/" + this.pdfNode.getId() + "/content/thumbnails/webpreview?c=force";
            JSONObject tn = new JSONObject();
            tn.put("thumbnailName", (Object)"webpreview");
            this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest(url), 200, USER_ALFRESCO);
        }
        this.transactionService.setAllowWrite(true);
        TestWebScriptServer.Response getAllResp = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest(this.getThumbnailsURL(this.jpgNode)), 200);
        JSONArray getArr = new JSONArray(getAllResp.getContentAsString());
        ThumbnailServiceTest.assertNotNull((Object)getArr);
        ThumbnailServiceTest.assertEquals((int)0, (int)getArr.length());
    }

    public void testUpdateThumbnail() throws Exception {
        String url = "/api/node/" + this.jpgNode.getStoreRef().getProtocol() + "/" + this.jpgNode.getStoreRef().getIdentifier() + "/" + this.jpgNode.getId() + "/content/thumbnails";
        JSONObject tn = new JSONObject();
        tn.put("thumbnailName", (Object)"doclib");
        TestWebScriptServer.Response response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.PostRequest(url, tn.toString(), "application/json"), 200);
        System.out.println(response.getContentAsString());
        TestWebScriptServer.Response getAllResp = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest(this.getThumbnailsURL(this.jpgNode)), 200);
        JSONArray getArr = new JSONArray(getAllResp.getContentAsString());
        ThumbnailServiceTest.assertNotNull((Object)getArr);
        ThumbnailServiceTest.assertEquals((int)1, (int)getArr.length());
        ThumbnailServiceTest.assertEquals((Object)"doclib", (Object)getArr.getJSONObject(0).get("thumbnailName"));
        this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest(this.getThumbnailsURL(this.jpgNode) + "/incorrectname"), 404);
        this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.PutRequest(this.getThumbnailsURL(this.jpgNode) + "/incorrectname", "", "application/json"), 404);
        this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.PutRequest(this.getThumbnailsURL(this.jpgNode) + "/doclib", "", "application/json"), 200);
    }

    public void testThumbnailDefinitions() throws Exception {
        int i;
        boolean hasWebPreview;
        boolean hasMedium;
        JSONArray array;
        TestWebScriptServer.Response response;
        String url;
        if (this.synchronousTransformClient.isSupported("application/pdf", -1L, null, "application/x-shockwave-flash", Collections.emptyMap(), null, null)) {
            url = "/api/node/" + this.pdfNode.getStoreRef().getProtocol() + "/" + this.pdfNode.getStoreRef().getIdentifier() + "/" + this.pdfNode.getId() + "/content/thumbnaildefinitions";
            response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest(url), 200);
            array = new JSONArray(response.getContentAsString());
            ThumbnailServiceTest.assertNotNull((Object)array);
            ThumbnailServiceTest.assertFalse((array.length() == 0 ? 1 : 0) != 0);
            hasMedium = false;
            hasWebPreview = false;
            for (i = 0; i < array.length(); ++i) {
                if (array.getString(i).equals("medium")) {
                    hasMedium = true;
                    continue;
                }
                if (!array.getString(i).equals("webpreview")) continue;
                hasWebPreview = true;
            }
            ThumbnailServiceTest.assertTrue((boolean)hasMedium);
            ThumbnailServiceTest.assertTrue((boolean)hasWebPreview);
        }
        url = "/api/node/" + this.jpgNode.getStoreRef().getProtocol() + "/" + this.jpgNode.getStoreRef().getIdentifier() + "/" + this.jpgNode.getId() + "/content/thumbnaildefinitions";
        response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest(url), 200);
        array = new JSONArray(response.getContentAsString());
        ThumbnailServiceTest.assertNotNull((Object)array);
        ThumbnailServiceTest.assertFalse((array.length() == 0 ? 1 : 0) != 0);
        hasMedium = false;
        hasWebPreview = false;
        for (i = 0; i < array.length(); ++i) {
            if (array.getString(i).equals("medium")) {
                hasMedium = true;
                continue;
            }
            if (!array.getString(i).equals("webpreview")) continue;
            hasWebPreview = true;
        }
        ThumbnailServiceTest.assertTrue((boolean)hasMedium);
        ThumbnailServiceTest.assertFalse((boolean)hasWebPreview);
    }

    public void testCreateAsyncThumbnail() throws Exception {
        TestWebScriptServer.Response response;
        JSONObject tn;
        String url;
        if (this.synchronousTransformClient.isSupported("application/pdf", -1L, null, "application/x-shockwave-flash", Collections.emptyMap(), null, null)) {
            url = "/api/node/" + this.pdfNode.getStoreRef().getProtocol() + "/" + this.pdfNode.getStoreRef().getIdentifier() + "/" + this.pdfNode.getId() + "/content/thumbnails?as=true";
            tn = new JSONObject();
            tn.put("thumbnailName", (Object)"webpreview");
            response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.PostRequest(url, tn.toString(), "application/json"), 200);
            ThumbnailServiceTest.assertEquals((String)"", (String)response.getContentAsString().trim());
            this.getWait(this.pdfNode, "webpreview");
        }
        url = "/api/node/" + this.jpgNode.getStoreRef().getProtocol() + "/" + this.jpgNode.getStoreRef().getIdentifier() + "/" + this.jpgNode.getId() + "/content/thumbnails?as=true";
        tn = new JSONObject();
        tn.put("thumbnailName", (Object)"medium");
        response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.PostRequest(url, tn.toString(), "application/json"), 200);
        ThumbnailServiceTest.assertEquals((String)"", (String)response.getContentAsString().trim());
        this.getWait(this.jpgNode, "medium");
    }

    private void getWait(NodeRef node, String thumbnailName) throws Exception {
        String url = "/api/node/" + node.getStoreRef().getProtocol() + "/" + node.getStoreRef().getIdentifier() + "/" + node.getId() + "/content/thumbnails/" + thumbnailName;
        int retries = 50;
        int tries = 0;
        while (true) {
            TestWebScriptServer.Response response;
            if (tries >= retries) {
                ThumbnailServiceTest.fail((String)("Thumbnail never gets created " + thumbnailName));
            }
            if ((response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest(url), 0)).getStatus() == 200) break;
            if (response.getStatus() == 500) {
                System.out.println("Error during getWait: " + response.getContentAsString());
                ThumbnailServiceTest.fail((String)"A 500 status was found whilst waiting for the thumbnail to be processed");
            } else {
                Thread.sleep(100L);
            }
            ++tries;
        }
    }

    public void testPlaceHolder() throws Exception {
        if (this.synchronousTransformClient.isSupported("application/pdf", -1L, null, "application/x-shockwave-flash", Collections.emptyMap(), null, null)) {
            this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest(this.getThumbnailsURL(this.pdfNode) + "/webpreview"), 404);
            this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest(this.getThumbnailsURL(this.pdfNode) + "/webpreview?ph=true"), 404);
        }
        this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest(this.getThumbnailsURL(this.jpgNode) + "/medium"), 404);
        this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest(this.getThumbnailsURL(this.jpgNode) + "/medium?ph=true"), 200);
        System.out.println(this.getThumbnailsURL(this.jpgNode) + "/medium?ph=true");
    }

    private String getThumbnailsURL(NodeRef nodeRef) {
        return "/api/node/" + nodeRef.getStoreRef().getProtocol() + "/" + nodeRef.getStoreRef().getIdentifier() + "/" + nodeRef.getId() + "/content/thumbnails";
    }
}

