/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.api.rules;

import java.util.List;
import junit.framework.TestCase;
import org.alfresco.rest.api.RuleSets;
import org.alfresco.rest.api.model.rules.RuleSetLink;
import org.alfresco.rest.api.rules.NodeRuleSetLinksRelation;
import org.alfresco.rest.framework.resource.parameters.Parameters;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.BDDMockito;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class NodeRuleSetsRelationTest
extends TestCase {
    private static final String FOLDER_NODE_ID = "dummy-folder-node-id";
    private static final String LINK_TO_NODE_ID = "dummy-link-to-node-id";
    private static final String RULE_SET_NODE_ID = "dummy-rule-set-node-id";
    @Mock
    private RuleSets ruleSets;
    @Mock
    private Parameters parameters;
    @InjectMocks
    private NodeRuleSetLinksRelation nodeRuleSetLinksRelation;

    @Test
    public void shouldProperlyCreateLink() {
        RuleSetLink ruleSetLink = new RuleSetLink();
        List<RuleSetLink> ruleResult = List.of(ruleSetLink);
        RuleSetLink requestBody = new RuleSetLink();
        requestBody.setId(LINK_TO_NODE_ID);
        Mockito.when((Object)this.ruleSets.linkToRuleSet(FOLDER_NODE_ID, LINK_TO_NODE_ID)).thenReturn((Object)ruleSetLink);
        List actual = this.nodeRuleSetLinksRelation.create(FOLDER_NODE_ID, List.of(requestBody), this.parameters);
        Assert.assertEquals(ruleResult, (Object)actual);
    }

    @Test
    public void testUnlinkRuleSet() {
        this.ruleSets.unlinkRuleSet(FOLDER_NODE_ID, RULE_SET_NODE_ID);
        ((RuleSets)BDDMockito.then((Object)this.ruleSets).should()).unlinkRuleSet(FOLDER_NODE_ID, RULE_SET_NODE_ID);
        BDDMockito.then((Object)this.ruleSets).shouldHaveNoMoreInteractions();
    }
}

