/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.api.tests.client.data;

import java.io.Serializable;
import java.util.ArrayList;
import org.alfresco.rest.api.tests.client.PublicApiClient;
import org.alfresco.rest.api.tests.client.data.Site;
import org.alfresco.rest.api.tests.client.data.SiteImpl;
import org.alfresco.rest.api.tests.client.data.SiteRole;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;

public class FavouriteSite
extends SiteImpl
implements Serializable {
    private static final long serialVersionUID = 6106140056062813842L;

    public FavouriteSite(String siteId) {
        this.siteId = siteId;
    }

    public FavouriteSite(Site site) {
        super(null, site.getSiteId(), site.getGuid(), site.getTitle(), site.getDescription(), site.getVisibility(), site.getType(), site.getRole());
    }

    public FavouriteSite(String networkId, String siteId, String siteGuid, String title, String description, String visibility, String type, SiteRole role) {
        super(networkId, siteId, siteGuid, title, description, visibility, type, role);
    }

    public static FavouriteSite parseFavouriteSite(JSONObject entry) {
        Site site = SiteImpl.parseSite(entry);
        FavouriteSite favouriteSite = new FavouriteSite(site);
        return favouriteSite;
    }

    public static PublicApiClient.ListResponse<FavouriteSite> parseFavouriteSites(JSONObject jsonObject) {
        JSONArray jsonEntries;
        JSONObject jsonList = (JSONObject)jsonObject.get((Object)"list");
        ArrayList<FavouriteSite> favouriteSites = new ArrayList<FavouriteSite>(jsonList.size());
        if (jsonList != null && (jsonEntries = (JSONArray)jsonList.get((Object)"entries")) != null) {
            for (int i = 0; i < jsonEntries.size(); ++i) {
                JSONObject jsonEntry = (JSONObject)jsonEntries.get(i);
                JSONObject entry = (JSONObject)jsonEntry.get((Object)"entry");
                favouriteSites.add(FavouriteSite.parseFavouriteSite(entry));
            }
        }
        PublicApiClient.ExpectedPaging paging = PublicApiClient.ExpectedPaging.parsePagination(jsonList);
        return new PublicApiClient.ListResponse<FavouriteSite>(paging, favouriteSites);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FavouriteSite other = (FavouriteSite)obj;
        return this.getSiteId().equals(other.getSiteId());
    }
}

