/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.web.scripts.blogs;

import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.alfresco.model.BlogIntegrationModel;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.web.scripts.blogs.CommentsLibJs;
import org.alfresco.service.ServiceRegistry;
import org.alfresco.service.cmr.repository.NodeRef;

public class BlogPostLibJs {
    public static boolean hasExternalBlogConfiguration(NodeRef node, ServiceRegistry services) {
        if (node == null) {
            return false;
        }
        if (services.getNodeService().hasAspect(node, BlogIntegrationModel.ASPECT_BLOG_DETAILS)) {
            return true;
        }
        return BlogPostLibJs.hasExternalBlogConfiguration(services.getNodeService().getPrimaryParent(node).getParentRef(), services);
    }

    public static Map<String, Object> getBlogPostData(NodeRef node, ServiceRegistry services) {
        boolean isPublished;
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("node", node);
        String creator = (String)((Object)services.getNodeService().getProperty(node, ContentModel.PROP_CREATOR));
        NodeRef person = services.getPersonService().getPersonOrNull(creator);
        if (person != null) {
            data.put("author", person);
        }
        data.put("commentCount", CommentsLibJs.getCommentsCount(node, services));
        Serializable published = services.getNodeService().getProperty(node, ContentModel.PROP_PUBLISHED);
        boolean bl = isPublished = published != null;
        if (isPublished) {
            data.put("releasedDate", published);
        }
        data.put("isDraft", !isPublished);
        Date updatedDate = (Date)services.getNodeService().getProperty(node, ContentModel.PROP_UPDATED);
        boolean isUpdated = updatedDate != null;
        data.put("isUpdated", isUpdated);
        if (isUpdated) {
            data.put("updatedDate", updatedDate);
        }
        data.put("createdDate", services.getNodeService().getProperty(node, ContentModel.PROP_CREATED));
        data.put("modifiedDate", services.getNodeService().getProperty(node, ContentModel.PROP_MODIFIED));
        Date lastUpdate = (Date)services.getNodeService().getProperty(node, BlogIntegrationModel.PROP_LAST_UPDATE);
        if (isPublished && lastUpdate != null) {
            Date modifiedDate = (Date)data.get("releasedDate");
            if (isUpdated) {
                modifiedDate = (Date)data.get("updatedDate");
            }
            data.put("outOfDate", modifiedDate.getTime() - lastUpdate.getTime() > 5000L);
        } else {
            data.put("outOfDate", false);
        }
        data.put("tags", services.getTaggingService().getTags(node));
        return data;
    }
}

