/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.web.scripts.workflow;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.alfresco.repo.web.scripts.workflow.WorkflowModelBuilder;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.security.AuthenticationService;
import org.alfresco.service.cmr.security.AuthorityService;
import org.alfresco.service.cmr.security.PersonService;
import org.alfresco.service.cmr.workflow.WorkflowService;
import org.alfresco.service.namespace.NamespaceService;
import org.alfresco.util.ModelUtil;
import org.springframework.extensions.surf.util.ISO8601DateFormat;
import org.springframework.extensions.webscripts.Cache;
import org.springframework.extensions.webscripts.DeclarativeWebScript;
import org.springframework.extensions.webscripts.Status;
import org.springframework.extensions.webscripts.WebScriptException;
import org.springframework.extensions.webscripts.WebScriptRequest;
import org.springframework.util.StringUtils;

public abstract class AbstractWorkflowWebscript
extends DeclarativeWebScript {
    public static final String NULL = "null";
    public static final String EMPTY = "";
    public static final String PARAM_MAX_ITEMS = "maxItems";
    public static final String PARAM_SKIP_COUNT = "skipCount";
    public static final String PARAM_EXCLUDE = "exclude";
    public static final int DEFAULT_MAX_ITEMS = -1;
    public static final int DEFAULT_SKIP_COUNT = 0;
    protected NamespaceService namespaceService;
    protected NodeService nodeService;
    protected PersonService personService;
    protected DictionaryService dictionaryService;
    protected AuthenticationService authenticationService;
    protected AuthorityService authorityService;
    protected WorkflowService workflowService;

    protected Map<String, Object> executeImpl(WebScriptRequest req, Status status, Cache cache) {
        WorkflowModelBuilder modelBuilder = new WorkflowModelBuilder(this.namespaceService, this.nodeService, this.authenticationService, this.personService, this.workflowService, this.dictionaryService);
        return this.buildModel(modelBuilder, req, status, cache);
    }

    public void setNamespaceService(NamespaceService namespaceService) {
        this.namespaceService = namespaceService;
    }

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public void setPersonService(PersonService personService) {
        this.personService = personService;
    }

    public void setDictionaryService(DictionaryService dictionaryService) {
        this.dictionaryService = dictionaryService;
    }

    public void setAuthenticationService(AuthenticationService authenticationService) {
        this.authenticationService = authenticationService;
    }

    public void setAuthorityService(AuthorityService authorityService) {
        this.authorityService = authorityService;
    }

    public void setWorkflowService(WorkflowService workflowService) {
        this.workflowService = workflowService;
    }

    protected abstract Map<String, Object> buildModel(WorkflowModelBuilder var1, WebScriptRequest var2, Status var3, Cache var4);

    protected void processDateFilter(WebScriptRequest req, String paramName, Map<String, Object> filters) {
        String dateParam = req.getParameter(paramName);
        if (dateParam != null) {
            Object date = EMPTY;
            if (!EMPTY.equals(dateParam) && !NULL.equals(dateParam)) {
                date = this.getDateParameter(req, paramName);
            }
            filters.put(paramName, date);
        }
    }

    protected Date getDateParameter(WebScriptRequest req, String paramName) {
        String dateString = req.getParameter(paramName);
        if (dateString != null) {
            try {
                return ISO8601DateFormat.parse((String)dateString.replaceAll(" ", "+"));
            }
            catch (Exception e) {
                String msg = "Invalid date value: " + dateString;
                throw new WebScriptException(400, msg);
            }
        }
        return null;
    }

    protected int getIntParameter(WebScriptRequest req, String paramName, int defaultValue) {
        String paramString = req.getParameter(paramName);
        if (paramString != null) {
            try {
                int param = Integer.valueOf(paramString);
                if (param > 0) {
                    return param;
                }
            }
            catch (NumberFormatException e) {
                throw new WebScriptException(400, e.getMessage());
            }
        }
        return defaultValue;
    }

    protected Map<String, Object> createResultModel(WebScriptRequest req, String dataPropertyName, List<Map<String, Object>> results) {
        int totalItems = 0;
        try {
            totalItems = this.getCapacity(results);
        }
        catch (Exception e) {
            totalItems = results.size();
        }
        int maxItems = this.getIntParameter(req, PARAM_MAX_ITEMS, -1);
        int skipCount = this.getIntParameter(req, PARAM_SKIP_COUNT, 0);
        HashMap<String, Object> model = new HashMap<String, Object>();
        model.put(dataPropertyName, this.applyPagination(results, maxItems, skipCount));
        if (maxItems != -1 || skipCount != 0) {
            model.put("paging", ModelUtil.buildPaging((int)totalItems, (int)(maxItems == -1 ? totalItems : maxItems), (int)skipCount));
        }
        return model;
    }

    private int getCapacity(List<?> list) throws Exception {
        Field dataField = ArrayList.class.getDeclaredField("elementData");
        dataField.setAccessible(true);
        return ((Object[])dataField.get(list)).length;
    }

    protected List<Map<String, Object>> applyPagination(List<Map<String, Object>> results, int maxItems, int skipCount) {
        if (maxItems == -1 && skipCount == 0) {
            return results;
        }
        return ModelUtil.page(results, (int)maxItems, (int)skipCount);
    }

    protected boolean isDateMatchForFilter(Date date, Object filterValue, boolean dateBeforeFilter) {
        boolean match = true;
        if (filterValue.equals(EMPTY)) {
            if (date != null) {
                match = false;
            }
        } else if (date == null) {
            match = false;
        } else if (dateBeforeFilter) {
            if (date.getTime() >= ((Date)filterValue).getTime()) {
                match = false;
            }
        } else if (date.getTime() <= ((Date)filterValue).getTime()) {
            match = false;
        }
        return match;
    }

    public class ExcludeFilter {
        private static final String WILDCARD = "*";
        private List<String> exactFilters;
        private List<String> wilcardFilters;
        private boolean containsWildcards = false;

        public ExcludeFilter(AbstractWorkflowWebscript this$0, String filters) {
            String[] filterArray = StringUtils.tokenizeToStringArray((String)filters, (String)",");
            this.exactFilters = new ArrayList<String>(filterArray.length);
            this.wilcardFilters = new ArrayList<String>(filterArray.length);
            for (String filter : filterArray) {
                if (filter.endsWith(WILDCARD)) {
                    this.containsWildcards = true;
                    this.wilcardFilters.add(filter.substring(0, filter.length() - WILDCARD.length()));
                    continue;
                }
                this.exactFilters.add(filter);
            }
        }

        public boolean isMatch(String item) {
            boolean match = this.exactFilters.contains(item);
            if (item != null && !match && this.containsWildcards) {
                for (String wildcardFilter : this.wilcardFilters) {
                    if (!item.startsWith(wildcardFilter)) continue;
                    match = true;
                    break;
                }
            }
            return match;
        }
    }
}

