/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.api.impl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.alfresco.query.PagingResults;
import org.alfresco.rest.api.People;
import org.alfresco.rest.api.Preferences;
import org.alfresco.rest.api.impl.Util;
import org.alfresco.rest.api.model.Preference;
import org.alfresco.rest.framework.core.exceptions.RelationshipResourceNotFoundException;
import org.alfresco.rest.framework.resource.parameters.CollectionWithPagingInfo;
import org.alfresco.rest.framework.resource.parameters.Paging;
import org.alfresco.service.cmr.preference.PreferenceService;
import org.alfresco.util.Pair;

public class PreferencesImpl
implements Preferences {
    private People people;
    private PreferenceService preferenceService;

    public void setPeople(People people) {
        this.people = people;
    }

    public void setPreferenceService(PreferenceService preferenceService) {
        this.preferenceService = preferenceService;
    }

    @Override
    public Preference getPreference(String personId, String preferenceName) {
        Serializable preferenceValue = this.preferenceService.getPreference(personId = this.people.validatePerson(personId), preferenceName);
        if (preferenceValue != null) {
            return new Preference(preferenceName, preferenceValue);
        }
        throw new RelationshipResourceNotFoundException(personId, preferenceName);
    }

    @Override
    public CollectionWithPagingInfo<Preference> getPreferences(String personId, Paging paging) {
        personId = this.people.validatePerson(personId);
        PagingResults preferences = this.preferenceService.getPagedPreferences(personId, null, Util.getPagingRequest(paging));
        ArrayList<Preference> ret = new ArrayList<Preference>(preferences.getPage().size());
        for (Pair prefEntity : preferences.getPage()) {
            Preference pref = new Preference((String)prefEntity.getFirst(), (Serializable)prefEntity.getSecond());
            ret.add(pref);
        }
        return CollectionWithPagingInfo.asPaged(paging, ret, preferences.hasMoreItems(), (Integer)preferences.getTotalResultCount().getFirst());
    }

    @Override
    public Preference updatePreference(String personId, Preference preference) {
        Map<String, Object> preferencesToSet;
        personId = this.people.validatePerson(personId, true);
        if (preference.getValue() == null || "".equals(preference.getValue())) {
            preferencesToSet = new HashMap<String, Object>(1);
            preferencesToSet.put(preference.getName(), null);
        } else {
            preferencesToSet = Map.of(preference.getName(), preference.getValue());
        }
        this.preferenceService.setPreferences(personId, preferencesToSet);
        return new Preference(preference.getName(), this.preferenceService.getPreference(personId, preference.getName()));
    }
}

