/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.api.impl.mapper.rules;

import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.alfresco.repo.action.ActionImpl;
import org.alfresco.repo.action.CompositeActionImpl;
import org.alfresco.rest.api.actions.ActionValidator;
import org.alfresco.rest.api.impl.rules.ActionParameterConverter;
import org.alfresco.rest.api.model.mapper.RestModelMapper;
import org.alfresco.rest.api.model.rules.Action;
import org.alfresco.service.Experimental;
import org.alfresco.service.cmr.action.CompositeAction;
import org.alfresco.util.GUID;
import org.apache.commons.collections.CollectionUtils;

@Experimental
public class RestRuleActionModelMapper
implements RestModelMapper<Action, org.alfresco.service.cmr.action.Action> {
    private final ActionParameterConverter parameterConverter;
    private final List<ActionValidator> actionValidators;

    public RestRuleActionModelMapper(ActionParameterConverter parameterConverter, List<ActionValidator> actionValidators) {
        this.parameterConverter = parameterConverter;
        this.actionValidators = actionValidators;
    }

    @Override
    public Action toRestModel(org.alfresco.service.cmr.action.Action actionModel) {
        if (actionModel == null) {
            return null;
        }
        Action.Builder builder = Action.builder().actionDefinitionId(actionModel.getActionDefinitionName());
        if (actionModel.getParameterValues() != null) {
            Map convertedParams = actionModel.getParameterValues().entrySet().stream().collect(HashMap::new, (m, v) -> m.put((String)v.getKey(), this.parameterConverter.convertParamFromServiceModel((Serializable)v.getValue())), HashMap::putAll);
            convertedParams.remove("actionContext");
            builder.params(convertedParams);
        }
        return builder.create();
    }

    @Override
    public org.alfresco.service.cmr.action.Action toServiceModel(Collection<Action> actions) {
        if (CollectionUtils.isEmpty(actions)) {
            return null;
        }
        CompositeActionImpl compositeAction = new CompositeActionImpl(null, GUID.generate());
        actions.forEach(arg_0 -> this.lambda$toServiceModel$1((CompositeAction)compositeAction, arg_0));
        return compositeAction;
    }

    private org.alfresco.service.cmr.action.Action toServiceAction(Action action) {
        Map<String, Serializable> params = Optional.ofNullable(action.getParams()).orElse(Collections.emptyMap());
        this.validateAction(action);
        Map<String, Serializable> convertedParams = this.parameterConverter.getConvertedParams(params, action.getActionDefinitionId());
        return new ActionImpl(null, GUID.generate(), action.getActionDefinitionId(), convertedParams);
    }

    private void validateAction(Action action) {
        this.actionValidators.stream().filter(v -> v.getActionDefinitionIds().contains(action.getActionDefinitionId()) || v.getActionDefinitionIds().equals(List.of("all"))).sorted(Comparator.comparing(ActionValidator::getPriority)).forEachOrdered(v -> v.validate(action));
    }

    private /* synthetic */ void lambda$toServiceModel$1(CompositeAction compositeAction, Action action) {
        compositeAction.addAction(this.toServiceAction(action));
    }
}

