/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.api.tests.client.data;

import java.io.Serializable;
import java.text.Collator;
import java.util.ArrayList;
import org.alfresco.rest.api.tests.client.PublicApiClient;
import org.alfresco.rest.api.tests.client.data.AssertUtil;
import org.alfresco.rest.api.tests.client.data.ExpectedComparison;
import org.alfresco.rest.api.tests.client.data.Person;
import org.alfresco.rest.api.tests.client.data.SiteRole;
import org.alfresco.rest.api.tests.client.data.Status;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.junit.Assert;

public class SiteMember
implements Serializable,
ExpectedComparison,
Comparable<SiteMember> {
    private static final long serialVersionUID = 505331886661880389L;
    public static final String FIELD_USERNAME = "username";
    public static final String FIELD_SITE_ID = "siteId";
    public static final String FIELD_STATE = "status.state";
    private String memberId;
    private Person member;
    private String siteId;
    private String role;
    private Status status;
    private boolean isMemberOfGroup;
    private Collator collator = Collator.getInstance();

    public SiteMember() {
    }

    public SiteMember(String memberId) {
        this.memberId = memberId;
    }

    public SiteMember(String memberId, String role) {
        this.memberId = memberId;
        this.role = role;
    }

    public SiteMember(String memberId, Person member, String siteId, String role) {
        this.memberId = memberId;
        this.member = member;
        this.siteId = siteId;
        this.role = role;
    }

    public SiteMember(String memberId, Person member, String siteId, String role, boolean isMemberOfGroup) {
        this.memberId = memberId;
        this.member = member;
        this.siteId = siteId;
        this.role = role;
        this.isMemberOfGroup = isMemberOfGroup;
    }

    public String getMemberId() {
        return this.memberId;
    }

    public Person getMember() {
        return this.member;
    }

    public void setMember(Person member) {
        this.member = member;
    }

    public void setRole(String role) {
        this.role = role;
    }

    public String getSiteId() {
        return this.siteId;
    }

    public void setSiteId(String siteId) {
        this.siteId = siteId;
    }

    public Status getStatus() {
        return this.status;
    }

    public void setStatus(Status status) {
        this.status = status;
    }

    public String getRole() {
        return this.role;
    }

    public boolean isMemberOfGroup() {
        return this.isMemberOfGroup;
    }

    public void setMemberOfGroup(boolean memberOfGroup) {
        this.isMemberOfGroup = memberOfGroup;
    }

    public String toString() {
        return "SiteMember [memberId=" + this.memberId + ", member=" + String.valueOf(this.member) + ", siteId=" + this.siteId + ", role=" + this.role + ", status=" + String.valueOf(this.status) + ", isMemberOfGroup=" + this.isMemberOfGroup + "]";
    }

    public static SiteMember parseSiteMember(String siteId, JSONObject jsonObject) {
        String id = (String)jsonObject.get((Object)"id");
        String role = (String)jsonObject.get((Object)"role");
        boolean isMemberOfGroup = (Boolean)jsonObject.get((Object)"isMemberOfGroup");
        JSONObject personJSON = (JSONObject)jsonObject.get((Object)"person");
        Person member = Person.parsePerson(personJSON);
        return new SiteMember(id, member, siteId, role, isMemberOfGroup);
    }

    public static PublicApiClient.ListResponse<SiteMember> parseSiteMembers(String siteId, JSONObject jsonObject) {
        ArrayList<SiteMember> siteMembers = new ArrayList<SiteMember>();
        JSONObject jsonList = (JSONObject)jsonObject.get((Object)"list");
        Assert.assertNotNull((Object)jsonList);
        JSONArray jsonEntries = (JSONArray)jsonList.get((Object)"entries");
        Assert.assertNotNull((Object)jsonEntries);
        for (int i = 0; i < jsonEntries.size(); ++i) {
            JSONObject jsonEntry = (JSONObject)jsonEntries.get(i);
            JSONObject entry = (JSONObject)jsonEntry.get((Object)"entry");
            siteMembers.add(SiteMember.parseSiteMember(siteId, entry));
        }
        PublicApiClient.ExpectedPaging paging = PublicApiClient.ExpectedPaging.parsePagination(jsonList);
        PublicApiClient.ListResponse<SiteMember> resp = new PublicApiClient.ListResponse<SiteMember>(paging, siteMembers);
        return resp;
    }

    public JSONObject toJSON() {
        JSONObject entry = new JSONObject();
        if (this.getMemberId() != null) {
            entry.put((Object)"id", (Object)this.getMemberId());
        }
        if (this.getRole() != null) {
            entry.put((Object)"role", (Object)this.getRole());
        }
        return entry;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.memberId == null ? 0 : this.memberId.hashCode());
        result = 31 * result + (this.role == null ? 0 : this.role.hashCode());
        result = 31 * result + (this.siteId == null ? 0 : this.siteId.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SiteMember other = (SiteMember)obj;
        if (this.memberId == null ? other.memberId != null : !this.memberId.equals(other.memberId)) {
            return false;
        }
        if (this.role == null ? other.role != null : !this.role.equals(other.role)) {
            return false;
        }
        return !(this.siteId == null ? other.siteId != null : !this.siteId.equals(other.siteId));
    }

    @Override
    public void expected(Object o) {
        Assert.assertTrue((boolean)(o instanceof SiteMember));
        SiteMember other = (SiteMember)o;
        AssertUtil.assertEquals("memberId", this.memberId, other.getMemberId());
        if (this.member != null) {
            this.member.expected(other.getMember());
        }
        AssertUtil.assertEquals(FIELD_SITE_ID, this.siteId, other.getSiteId());
        AssertUtil.assertEquals("role", this.role, other.getRole());
        if (this.status != null) {
            this.status.expected(other.getStatus());
        }
    }

    @Override
    public int compareTo(SiteMember o) {
        String firstName = this.member.getFirstName();
        String lastName = this.member.getLastName();
        int ret = this.collator.compare(lastName, o.getMember().getLastName());
        if (ret == 0) {
            ret = this.collator.compare(firstName, o.getMember().getFirstName());
        }
        if (ret == 0) {
            ret = SiteRole.valueOf(this.role).compareTo(SiteRole.valueOf(o.getRole()));
        }
        return ret;
    }
}

