/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.web.scripts.invitation;

import java.util.HashMap;
import java.util.Map;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.security.permissions.AccessDeniedException;
import org.alfresco.service.cmr.invitation.Invitation;
import org.alfresco.service.cmr.invitation.InvitationExceptionForbidden;
import org.alfresco.service.cmr.invitation.InvitationExceptionNotFound;
import org.alfresco.service.cmr.invitation.InvitationService;
import org.alfresco.service.cmr.site.SiteInfo;
import org.alfresco.service.cmr.site.SiteService;
import org.springframework.extensions.webscripts.Cache;
import org.springframework.extensions.webscripts.DeclarativeWebScript;
import org.springframework.extensions.webscripts.Status;
import org.springframework.extensions.webscripts.WebScriptException;
import org.springframework.extensions.webscripts.WebScriptRequest;

public class InvitationDelete
extends DeclarativeWebScript {
    private InvitationService invitationService;
    private SiteService siteService;

    public void setInvitationService(InvitationService invitationService) {
        this.invitationService = invitationService;
    }

    public void setSiteService(SiteService siteService) {
        this.siteService = siteService;
    }

    protected Map<String, Object> executeImpl(WebScriptRequest req, Status status, Cache cache) {
        HashMap<String, Object> model = new HashMap<String, Object>();
        Map templateVars = req.getServiceMatch().getTemplateVars();
        final String siteShortName = (String)templateVars.get("shortname");
        final String invitationId = (String)templateVars.get("invitationId");
        this.validateParameters(siteShortName, invitationId);
        try {
            String currentUser = AuthenticationUtil.getRunAsUser();
            if (siteShortName != null && "SiteManager".equals(this.siteService.getMembersRole(siteShortName, currentUser))) {
                AuthenticationUtil.RunAsWork<Void> runAsSystem = new AuthenticationUtil.RunAsWork<Void>(){

                    public Void doWork() throws Exception {
                        InvitationDelete.this.checkAndCancelTheInvitation(invitationId, siteShortName);
                        return null;
                    }
                };
                AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)runAsSystem, (String)AuthenticationUtil.getSystemUserName());
            } else {
                this.checkAndCancelTheInvitation(invitationId, siteShortName);
            }
        }
        catch (InvitationExceptionForbidden fe) {
            throw new WebScriptException(403, "Unable to cancel workflow", (Throwable)fe);
        }
        catch (AccessDeniedException ade) {
            throw new WebScriptException(403, "Unable to cancel workflow", (Throwable)ade);
        }
        return model;
    }

    private void validateParameters(String siteShortName, String invitationId) {
        if (invitationId == null || invitationId.length() == 0) {
            throw new WebScriptException(400, "Invalid invitation id provided");
        }
        SiteInfo site = this.siteService.getSite(siteShortName);
        if (site == null) {
            throw new WebScriptException(404, "Invalid site id provided");
        }
    }

    protected void checkAndCancelTheInvitation(String invId, String siteShortName) {
        Invitation invitation = null;
        try {
            invitation = this.invitationService.getInvitation(invId);
        }
        catch (InvitationExceptionNotFound ienf) {
            this.throwInvitationNotFoundException(invId, siteShortName);
        }
        if (invitation == null) {
            this.throwInvitationNotFoundException(invId, siteShortName);
        }
        if (invitation != null && invitation.getResourceName() != null && !siteShortName.equals(invitation.getResourceName())) {
            throw new WebScriptException(403, "Unable to cancel workflow");
        }
        this.invitationService.cancel(invId);
    }

    protected void throwInvitationNotFoundException(String invId, String siteShortName) {
        throw new WebScriptException(404, "The invitation :" + invId + " for web site :" + siteShortName + ", does not exist.");
    }
}

