/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.api.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.text.Collator;
import java.util.Date;
import org.alfresco.rest.api.model.Person;
import org.alfresco.rest.api.sites.SiteEntityResource;
import org.alfresco.rest.framework.core.exceptions.InvalidArgumentException;
import org.alfresco.rest.framework.resource.EmbeddedEntityResource;
import org.alfresco.rest.framework.resource.UniqueId;
import org.alfresco.util.Pair;

public class SiteMembershipRequest
implements Comparable<SiteMembershipRequest> {
    private static Collator collator = Collator.getInstance();
    private String id;
    private String message;
    private Date createdAt;
    private Date modifiedAt;
    private String title;
    private Person person;
    private String client;

    public static Pair<String, String> splitId(String id) {
        int idx = id.indexOf(":");
        if (idx != -1) {
            String workflowId = id.substring(0, idx);
            String key = id.substring(idx + 1);
            Pair ret = new Pair((Object)workflowId, (Object)key);
            return ret;
        }
        throw new InvalidArgumentException("Site invite id is invalid: " + id);
    }

    @EmbeddedEntityResource(propertyName="site", entityResource=SiteEntityResource.class)
    @UniqueId
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    @JsonIgnore
    public String getTitle() {
        return this.title;
    }

    public Date getCreatedAt() {
        return this.createdAt;
    }

    public void setCreatedAt(Date createdAt) {
        this.createdAt = createdAt;
    }

    public Date getModifiedAt() {
        return this.modifiedAt;
    }

    public void setModifiedAt(Date modifiedAt) {
        this.modifiedAt = modifiedAt;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public Person getPerson() {
        return this.person;
    }

    public void setPerson(Person person) {
        this.person = person;
    }

    public String getClient() {
        return this.client;
    }

    public void setClient(String client) {
        this.client = client;
    }

    public String toString() {
        return "SiteMembershipRequest [id=" + this.id + ", message=" + this.message + ", createdAt=" + String.valueOf(this.createdAt) + ", modifiedAt=" + String.valueOf(this.modifiedAt) + ", client=" + this.client + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SiteMembershipRequest other = (SiteMembershipRequest)obj;
        return !(this.id == null ? other.id != null : !this.id.equals(other.id));
    }

    @Override
    public int compareTo(SiteMembershipRequest o) {
        int ret = 0;
        ret = this.title == null && o.getTitle() != null ? -1 : (this.title != null && o.getTitle() == null ? 1 : collator.compare(this.title, o.getTitle()));
        return ret;
    }
}

