/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.api.tests.client.data;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.alfresco.rest.api.model.Association;
import org.alfresco.rest.api.model.AssociationSource;
import org.alfresco.rest.api.model.Model;
import org.alfresco.rest.api.tests.client.PublicApiClient;
import org.alfresco.rest.api.tests.client.data.AssertUtil;
import org.alfresco.rest.api.tests.client.data.ExpectedComparison;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.junit.Assert;

public class Type
extends org.alfresco.rest.api.model.Type
implements Serializable,
ExpectedComparison {
    @Override
    public void expected(Object model) {
        Assert.assertTrue((String)("model is an instance of " + String.valueOf(model.getClass())), (boolean)(model instanceof Type));
        Type other = (Type)model;
        AssertUtil.assertEquals("id", this.getId(), other.getId());
        AssertUtil.assertEquals("title", this.getTitle(), other.getTitle());
        AssertUtil.assertEquals("description", this.getDescription(), other.getDescription());
        AssertUtil.assertEquals("parenId", this.getParentId(), other.getParentId());
        AssertUtil.assertEquals("isArchive", this.getIsArchive(), other.getIsArchive());
        AssertUtil.assertEquals("isContainer", this.getIsContainer(), other.getIsContainer());
        AssertUtil.assertEquals("includedInSupertypeQuery", this.getIncludedInSupertypeQuery(), other.getIncludedInSupertypeQuery());
        if (this.getModel() != null && other.getModel() != null) {
            AssertUtil.assertEquals("modelId", this.getModel().getId(), other.getModel().getId());
            AssertUtil.assertEquals("author", this.getModel().getAuthor(), other.getModel().getAuthor());
            AssertUtil.assertEquals("namespaceUri", this.getModel().getNamespaceUri(), other.getModel().getNamespaceUri());
            AssertUtil.assertEquals("namespacePrefix", this.getModel().getNamespacePrefix(), other.getModel().getNamespacePrefix());
        }
    }

    public JSONObject toJSON() {
        JSONObject jsonObject = new JSONObject();
        if (this.getId() != null) {
            jsonObject.put((Object)"id", (Object)this.getId());
        }
        jsonObject.put((Object)"title", (Object)this.getTitle());
        if (this.getParentId() != null) {
            jsonObject.put((Object)"parentId", (Object)this.getParentId());
        }
        if (this.getDescription() != null) {
            jsonObject.put((Object)"description", (Object)this.getDescription());
        }
        if (this.getProperties() != null) {
            jsonObject.put((Object)"properties", (Object)this.getProperties());
        }
        if (this.getModel() != null) {
            jsonObject.put((Object)"model", (Object)this.getModel());
        }
        if (this.getMandatoryAspects() != null) {
            jsonObject.put((Object)"mandatoryAspects", (Object)this.getMandatoryAspects());
        }
        if (this.getIsContainer() != null) {
            jsonObject.put((Object)"isContainer", (Object)this.getIsContainer());
        }
        if (this.getIsArchive() != null) {
            jsonObject.put((Object)"isArchive", (Object)this.getIsArchive());
        }
        if (this.getIncludedInSupertypeQuery() != null) {
            jsonObject.put((Object)"includedInSupertypeQuery", (Object)this.getIncludedInSupertypeQuery());
        }
        if (this.getAssociations() != null) {
            jsonObject.put((Object)"associations", (Object)this.getAssociations());
        }
        return jsonObject;
    }

    public static Type parseType(JSONObject jsonObject) {
        String id = (String)jsonObject.get((Object)"id");
        String title = (String)jsonObject.get((Object)"title");
        String description = (String)jsonObject.get((Object)"description");
        String parentId = (String)jsonObject.get((Object)"parentId");
        List properties = (List)jsonObject.get((Object)"properties");
        ArrayList mandatoryAspects = jsonObject.get((Object)"mandatoryAspects") != null ? new ArrayList((List)jsonObject.get((Object)"mandatoryAspects")) : null;
        Boolean isContainer = (Boolean)jsonObject.get((Object)"isContainer");
        Boolean isArchive = (Boolean)jsonObject.get((Object)"isArchive");
        Boolean includedInSupertypeQuery = (Boolean)jsonObject.get((Object)"includedInSupertypeQuery");
        ArrayList<Association> associations = null;
        if (jsonObject.get((Object)"associations") != null) {
            associations = new ArrayList<Association>();
            JSONArray jsonArray = (JSONArray)jsonObject.get((Object)"associations");
            for (int i = 0; i < jsonArray.size(); ++i) {
                Association association = new Association();
                JSONObject object = (JSONObject)jsonArray.get(i);
                association.setId((String)object.get((Object)"id"));
                association.setTitle((String)object.get((Object)"title"));
                association.setDescription((String)object.get((Object)"description"));
                association.setIsChild((Boolean)object.get((Object)"isChild"));
                association.setIsProtected((Boolean)object.get((Object)"isProtected"));
                JSONObject sourceModel = (JSONObject)object.get((Object)"source");
                if (sourceModel != null) {
                    AssociationSource source = new AssociationSource();
                    source.setCls((String)sourceModel.get((Object)"cls"));
                    source.setRole((String)sourceModel.get((Object)"role"));
                    source.setIsMandatory((Boolean)sourceModel.get((Object)"isMandatory"));
                    source.setIsMany((Boolean)sourceModel.get((Object)"isMany"));
                    source.setIsMandatoryEnforced((Boolean)sourceModel.get((Object)"isMandatoryEnforced"));
                    association.setSource(source);
                }
                JSONObject targetModel = (JSONObject)object.get((Object)"target");
                AssociationSource target = new AssociationSource();
                target.setCls((String)targetModel.get((Object)"cls"));
                target.setRole((String)targetModel.get((Object)"role"));
                target.setIsMandatory((Boolean)targetModel.get((Object)"isMandatory"));
                target.setIsMany((Boolean)targetModel.get((Object)"isMany"));
                target.setIsMandatoryEnforced((Boolean)targetModel.get((Object)"isMandatoryEnforced"));
                association.setTarget(target);
                associations.add(association);
            }
        }
        JSONObject jsonModel = (JSONObject)jsonObject.get((Object)"model");
        Model model = new Model();
        model.setId((String)jsonModel.get((Object)"id"));
        model.setDescription((String)jsonModel.get((Object)"description"));
        model.setNamespacePrefix((String)jsonModel.get((Object)"namespacePrefix"));
        model.setNamespaceUri((String)jsonModel.get((Object)"namespaceUri"));
        model.setAuthor((String)jsonModel.get((Object)"author"));
        Type type = new Type();
        type.setId(id);
        type.setTitle(title);
        type.setDescription(description);
        type.setParentId(parentId);
        type.setProperties(properties);
        type.setMandatoryAspects(mandatoryAspects);
        type.setIsContainer(isContainer);
        type.setIsArchive(isArchive);
        type.setIncludedInSupertypeQuery(includedInSupertypeQuery);
        type.setAssociations(associations);
        type.setModel(model);
        return type;
    }

    public static PublicApiClient.ListResponse<Type> parseTypes(JSONObject jsonObject) {
        ArrayList<Type> types = new ArrayList<Type>();
        JSONObject jsonList = (JSONObject)jsonObject.get((Object)"list");
        Assert.assertNotNull((Object)jsonList);
        JSONArray jsonEntries = (JSONArray)jsonList.get((Object)"entries");
        Assert.assertNotNull((Object)jsonEntries);
        for (int i = 0; i < jsonEntries.size(); ++i) {
            JSONObject jsonEntry = (JSONObject)jsonEntries.get(i);
            JSONObject entry = (JSONObject)jsonEntry.get((Object)"entry");
            types.add(Type.parseType(entry));
        }
        PublicApiClient.ExpectedPaging paging = PublicApiClient.ExpectedPaging.parsePagination(jsonList);
        return new PublicApiClient.ListResponse<Type>(paging, types);
    }
}

