/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.web.scripts.bean;

import java.io.IOException;
import java.util.Map;
import org.alfresco.repo.web.scripts.bean.AbstractLoginBean;
import org.json.JSONException;
import org.json.JSONObject;
import org.springframework.extensions.surf.util.Content;
import org.springframework.extensions.webscripts.Status;
import org.springframework.extensions.webscripts.WebScriptException;
import org.springframework.extensions.webscripts.WebScriptRequest;

public class LoginPost
extends AbstractLoginBean {
    @Override
    protected Map<String, Object> executeImpl(WebScriptRequest req, Status status) {
        Content c = req.getContent();
        if (c == null) {
            throw new WebScriptException(400, "Missing POST body.");
        }
        try {
            JSONObject json = new JSONObject(c.getContent());
            String username = json.getString("username");
            String password = json.getString("password");
            if (username == null || username.length() == 0) {
                throw new WebScriptException(400, "Username not specified");
            }
            if (password == null) {
                throw new WebScriptException(400, "Password not specified");
            }
            try {
                return this.login(username, password);
            }
            catch (WebScriptException e) {
                status.setCode(e.getStatus());
                status.setMessage(e.getMessage());
                status.setRedirect(true);
                return null;
            }
        }
        catch (JSONException jErr) {
            throw new WebScriptException(400, "Unable to parse JSON POST body: " + jErr.getMessage());
        }
        catch (IOException ioErr) {
            throw new WebScriptException(500, "Unable to retrieve POST body: " + ioErr.getMessage());
        }
    }
}

