/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.web.scripts.comments;

import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import org.alfresco.repo.policy.BehaviourFilter;
import org.alfresco.repo.web.scripts.comments.CommentsPost;
import org.alfresco.service.ServiceRegistry;
import org.alfresco.service.cmr.activities.ActivityService;
import org.alfresco.service.cmr.repository.ContentService;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.security.PermissionService;
import org.alfresco.service.cmr.security.PersonService;
import org.alfresco.service.cmr.site.SiteInfo;
import org.alfresco.service.cmr.site.SiteService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.json.JSONStringer;
import org.json.JSONWriter;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;
import org.springframework.extensions.webscripts.Cache;
import org.springframework.extensions.webscripts.DeclarativeWebScript;
import org.springframework.extensions.webscripts.Status;
import org.springframework.extensions.webscripts.WebScriptException;
import org.springframework.extensions.webscripts.WebScriptRequest;

public abstract class AbstractCommentsWebScript
extends DeclarativeWebScript {
    protected static final String COMMENTS_TOPIC_NAME = "Comments";
    private static Log logger = LogFactory.getLog(CommentsPost.class);
    protected static final String JSON_KEY_SITE = "site";
    protected static final String JSON_KEY_SITE_ID = "siteid";
    protected static final String JSON_KEY_ITEM_TITLE = "itemTitle";
    protected static final String JSON_KEY_PAGE = "page";
    protected static final String JSON_KEY_TITLE = "title";
    protected static final String JSON_KEY_PAGE_PARAMS = "pageParams";
    protected static final String JSON_KEY_NODEREF = "nodeRef";
    protected static final String JSON_KEY_CONTENT = "content";
    protected static final String COMMENT_CREATED_ACTIVITY = "org.alfresco.comments.comment-created";
    protected static final String COMMENT_DELETED_ACTIVITY = "org.alfresco.comments.comment-deleted";
    protected ServiceRegistry serviceRegistry;
    protected NodeService nodeService;
    protected ContentService contentService;
    protected PersonService personService;
    protected SiteService siteService;
    protected PermissionService permissionService;
    protected ActivityService activityService;
    protected BehaviourFilter behaviourFilter;
    protected static final String PARAM_MESSAGE = "message";
    protected static final String PARAM_NODE = "node";
    protected static final String PARAM_ITEM = "item";

    public void setServiceRegistry(ServiceRegistry serviceRegistry) {
        this.serviceRegistry = serviceRegistry;
        this.nodeService = serviceRegistry.getNodeService();
        this.siteService = serviceRegistry.getSiteService();
        this.contentService = serviceRegistry.getContentService();
        this.personService = serviceRegistry.getPersonService();
        this.permissionService = serviceRegistry.getPermissionService();
    }

    public void setBehaviourFilter(BehaviourFilter behaviourFilter) {
        this.behaviourFilter = behaviourFilter;
    }

    public void setActivityService(ActivityService activityService) {
        this.activityService = activityService;
    }

    protected NodeRef parseRequestForNodeRef(WebScriptRequest req) {
        Map templateVars = req.getServiceMatch().getTemplateVars();
        String storeType = (String)templateVars.get("store_type");
        String storeId = (String)templateVars.get("store_id");
        String nodeId = (String)templateVars.get("id");
        StoreRef storeRef = new StoreRef(storeType, storeId);
        return new NodeRef(storeRef, nodeId);
    }

    protected String getOrNull(JSONObject json, String key) {
        if (json != null && json.containsKey((Object)key)) {
            return (String)json.get((Object)key);
        }
        return null;
    }

    protected JSONObject parseJSON(WebScriptRequest req) {
        JSONObject json = null;
        String contentType = req.getContentType();
        if (contentType != null && contentType.indexOf(59) != -1) {
            contentType = contentType.substring(0, contentType.indexOf(59));
        }
        if ("application/json".equals(contentType)) {
            JSONParser parser = new JSONParser();
            try {
                json = (JSONObject)parser.parse(req.getContent().getContent());
            }
            catch (IOException io) {
                throw new WebScriptException(400, "Invalid JSON: " + io.getMessage());
            }
            catch (ParseException pe) {
                throw new WebScriptException(400, "Invalid JSON: " + pe.getMessage());
            }
        }
        return json;
    }

    protected JSONObject parseJSONFromString(String input) {
        block3: {
            JSONObject json = null;
            JSONParser parser = new JSONParser();
            try {
                if (input != null) {
                    json = (JSONObject)parser.parse(input);
                    return json;
                }
            }
            catch (ParseException pe) {
                if (!logger.isDebugEnabled()) break block3;
                logger.debug((Object)("Invalid JSON: " + pe.getMessage()));
            }
        }
        return null;
    }

    protected void postActivity(JSONObject json, WebScriptRequest req, NodeRef nodeRef, String activityType) {
        String jsonActivityData = "";
        String siteId = "";
        Object page = "";
        String title = "";
        if (nodeRef == null) {
            return;
        }
        String strNodeRef = nodeRef.toString();
        SiteInfo siteInfo = this.getSiteInfo(req, COMMENT_CREATED_ACTIVITY.equals(activityType));
        if (siteInfo == null || siteInfo.getShortName() == null || siteInfo.getShortName().length() == 0) {
            return;
        }
        siteId = siteInfo.getShortName();
        if (COMMENT_CREATED_ACTIVITY.equals(activityType)) {
            try {
                org.json.JSONObject params = new org.json.JSONObject(this.getOrNull(json, JSON_KEY_PAGE_PARAMS));
                Object strParams = "";
                Iterator itr = params.keys();
                while (itr.hasNext()) {
                    String strParam = itr.next().toString();
                    strParams = (String)strParams + strParam + "=" + params.getString(strParam) + "&";
                }
                page = this.getOrNull(json, JSON_KEY_PAGE) + "?" + (strParams != "" ? ((String)strParams).substring(0, ((String)strParams).length() - 1) : "");
                title = this.getOrNull(json, JSON_KEY_ITEM_TITLE);
            }
            catch (Exception e) {
                logger.warn((Object)"Error parsing JSON", (Throwable)e);
            }
        } else {
            title = req.getParameter(JSON_KEY_ITEM_TITLE);
            page = req.getParameter(JSON_KEY_PAGE) + "?nodeRef=" + strNodeRef;
        }
        try {
            JSONWriter jsonWriter = new JSONStringer().object();
            jsonWriter.key(JSON_KEY_TITLE).value((Object)title);
            jsonWriter.key(JSON_KEY_PAGE).value(page);
            jsonWriter.key(JSON_KEY_NODEREF).value((Object)strNodeRef);
            jsonActivityData = jsonWriter.endObject().toString();
            this.activityService.postActivity(activityType, siteId, COMMENTS_TOPIC_NAME, jsonActivityData);
        }
        catch (Exception e) {
            logger.warn((Object)"Error adding comment to activities feed", (Throwable)e);
        }
    }

    protected SiteInfo getSiteInfo(WebScriptRequest req, boolean searchForSiteInJSON) {
        JSONObject json;
        String siteName = req.getParameter(JSON_KEY_SITE);
        if (siteName == null && searchForSiteInJSON && (json = this.parseJSON(req)) != null) {
            if (json.containsKey((Object)JSON_KEY_SITE)) {
                siteName = (String)json.get((Object)JSON_KEY_SITE);
            } else if (json.containsKey((Object)JSON_KEY_SITE_ID)) {
                siteName = (String)json.get((Object)JSON_KEY_SITE_ID);
            }
        }
        if (siteName != null) {
            SiteInfo site = this.siteService.getSite(siteName);
            return site;
        }
        return null;
    }

    protected Map<String, Object> executeImpl(WebScriptRequest req, Status status, Cache cache) {
        NodeRef nodeRef = this.parseRequestForNodeRef(req);
        return this.executeImpl(nodeRef, req, status, cache);
    }

    protected abstract Map<String, Object> executeImpl(NodeRef var1, WebScriptRequest var2, Status var3, Cache var4);
}

