/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.web.scripts.facet;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import org.alfresco.repo.i18n.StaticMessageLookup;
import org.alfresco.repo.search.impl.solr.facet.SolrFacetService;
import org.alfresco.repo.web.scripts.facet.AbstractSolrFacetConfigAdminWebScript;
import org.alfresco.repo.web.scripts.facet.FacetablePropertyFTL;
import org.alfresco.service.cmr.dictionary.PropertyDefinition;
import org.alfresco.service.cmr.i18n.MessageLookup;
import org.alfresco.service.namespace.NamespaceException;
import org.alfresco.service.namespace.NamespacePrefixResolver;
import org.alfresco.service.namespace.NamespaceService;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.ModelUtil;
import org.alfresco.util.ScriptPagingDetails;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.extensions.surf.util.I18NUtil;
import org.springframework.extensions.webscripts.Cache;
import org.springframework.extensions.webscripts.Status;
import org.springframework.extensions.webscripts.WebScriptException;
import org.springframework.extensions.webscripts.WebScriptRequest;

public class FacetablePropertiesGet
extends AbstractSolrFacetConfigAdminWebScript {
    public static final Log logger = LogFactory.getLog(FacetablePropertiesGet.class);
    public static final String PROPERTIES_KEY = "properties";
    private static final String QUERY_PARAM_MAX_ITEMS = "maxItems";
    private static final String QUERY_PARAM_SKIP_COUNT = "skipCount";
    private static final int DEFAULT_MAX_ITEMS_PER_PAGE = 50;
    private static final String TEMPLATE_VAR_CLASSNAME = "classname";
    private static final String QUERY_PARAM_NAMESPACE = "nsp";
    private static final String QUERY_PARAM_LOCALE = "locale";
    private NamespaceService namespaceService;
    private MessageLookup messageLookup = new StaticMessageLookup();

    @Override
    public void setNamespaceService(NamespaceService service) {
        this.namespaceService = service;
    }

    @Override
    protected Map<String, Object> executeImpl(WebScriptRequest req, Status status, Cache cache) {
        return this.unprotectedExecuteImpl(req, status, cache);
    }

    @Override
    protected Map<String, Object> unprotectedExecuteImpl(WebScriptRequest req, Status status, Cache cache) {
        SortedSet<FacetablePropertyFTL<?>> facetableProperties;
        QName contentClassQName;
        String userLocaleString = req.getParameter(QUERY_PARAM_LOCALE);
        Locale userLocale = userLocaleString == null ? Locale.getDefault() : new Locale(userLocaleString);
        Map templateVars = req.getServiceMatch().getTemplateVars();
        String contentClassName = (String)templateVars.get(TEMPLATE_VAR_CLASSNAME);
        try {
            contentClassQName = contentClassName == null ? null : QName.createQName((String)contentClassName, (NamespacePrefixResolver)this.namespaceService);
        }
        catch (NamespaceException e) {
            throw new WebScriptException(404, "Unrecognised classname: " + contentClassName, (Throwable)e);
        }
        HashMap<String, Object> model = new HashMap<String, Object>();
        if (contentClassQName == null) {
            facetableProperties = this.toFacetablePropertyModel(this.facetService.getFacetableProperties(), userLocale);
            facetableSyntheticProperties = this.facetService.getFacetableSyntheticProperties();
            facetableProperties.addAll(this.toFacetablePropertyModel_(facetableSyntheticProperties, userLocale));
        } else {
            facetableProperties = this.toFacetablePropertyModel(this.facetService.getFacetableProperties(contentClassQName), userLocale);
            facetableSyntheticProperties = this.facetService.getFacetableSyntheticProperties(contentClassQName);
            facetableProperties.addAll(this.toFacetablePropertyModel_(facetableSyntheticProperties, userLocale));
        }
        facetableProperties.add(new FacetablePropertyFTL.SpecialFacetablePropertyFTL("TAG", "Tag"));
        facetableProperties.add(new FacetablePropertyFTL.SpecialFacetablePropertyFTL("SITE", "Site"));
        ArrayList<ResultFilter> filters = new ArrayList<ResultFilter>();
        final String namespaceFilter = req.getParameter(QUERY_PARAM_NAMESPACE);
        if (namespaceFilter != null) {
            filters.add(new ResultFilter(){

                @Override
                public boolean filter(FacetablePropertyFTL<?> facetableProperty) {
                    QName propQName = facetableProperty.getQname();
                    Collection prefixes = FacetablePropertiesGet.this.namespaceService.getPrefixes(propQName.getNamespaceURI());
                    return prefixes.contains(namespaceFilter);
                }
            });
        }
        List<FacetablePropertyFTL<?>> filteredFacetableProperties = this.filter(facetableProperties, filters);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Retrieved " + facetableProperties.size() + " available facets; filtered to " + filteredFacetableProperties.size()));
        }
        ScriptPagingDetails paging = new ScriptPagingDetails(this.getNonNegativeIntParameter(req, QUERY_PARAM_MAX_ITEMS, 50), this.getNonNegativeIntParameter(req, QUERY_PARAM_SKIP_COUNT, 0));
        model.put(PROPERTIES_KEY, ModelUtil.page(filteredFacetableProperties, (ScriptPagingDetails)paging));
        model.put("paging", ModelUtil.buildPaging((ScriptPagingDetails)paging));
        return model;
    }

    private List<FacetablePropertyFTL<?>> filter(Collection<FacetablePropertyFTL<?>> propsData, List<ResultFilter> filters) {
        ArrayList filteredResult = new ArrayList();
        for (FacetablePropertyFTL<?> prop : propsData) {
            boolean passedAllFilters = true;
            for (ResultFilter filter : filters) {
                if (filter.filter(prop)) continue;
                passedAllFilters = false;
            }
            if (!passedAllFilters) continue;
            filteredResult.add(prop);
        }
        return filteredResult;
    }

    private FacetablePropertyFTL<?> toFacetablePropertyModel(PropertyDefinition propDef, Locale locale) {
        String title = propDef.getTitle(this.messageLookup, locale);
        return new FacetablePropertyFTL.StandardFacetablePropertyFTL(propDef, title);
    }

    private FacetablePropertyFTL<?> toFacetablePropertyModel(SolrFacetService.SyntheticPropertyDefinition propDef, Locale locale) {
        String i18nKeyPrefix = "cm_contentmodel.property.cm_content.cm_content.";
        String localisedTitle = I18NUtil.getMessage((String)("cm_contentmodel.property.cm_content.cm_content." + propDef.syntheticPropertyName), (Locale)locale);
        return new FacetablePropertyFTL.SyntheticFacetablePropertyFTL(propDef.containingPropertyDef, localisedTitle, propDef.syntheticPropertyName, propDef.dataTypeDefinition);
    }

    private SortedSet<FacetablePropertyFTL<?>> toFacetablePropertyModel(Collection<PropertyDefinition> propDefs, Locale locale) {
        TreeSet result = new TreeSet(new FacetablePropertyFTL.FacetablePropertyFTLComparator());
        for (PropertyDefinition propDef : propDefs) {
            result.add(this.toFacetablePropertyModel(propDef, locale));
        }
        return result;
    }

    private SortedSet<FacetablePropertyFTL<?>> toFacetablePropertyModel_(Collection<SolrFacetService.SyntheticPropertyDefinition> propDefs, Locale locale) {
        TreeSet result = new TreeSet(new FacetablePropertyFTL.FacetablePropertyFTLComparator());
        for (SolrFacetService.SyntheticPropertyDefinition propDef : propDefs) {
            result.add(this.toFacetablePropertyModel(propDef, locale));
        }
        return result;
    }

    private static interface ResultFilter {
        public boolean filter(FacetablePropertyFTL<?> var1);
    }
}

