/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.web.scripts.quickshare;

import java.util.HashMap;
import java.util.Map;
import org.alfresco.repo.web.scripts.WebScriptUtil;
import org.alfresco.repo.web.scripts.quickshare.AbstractQuickShareContent;
import org.alfresco.service.cmr.quickshare.QuickShareDTO;
import org.alfresco.service.cmr.repository.InvalidNodeRefException;
import org.alfresco.service.cmr.repository.NodeRef;
import org.springframework.extensions.webscripts.Cache;
import org.springframework.extensions.webscripts.Status;
import org.springframework.extensions.webscripts.WebScriptException;
import org.springframework.extensions.webscripts.WebScriptRequest;

public class ShareContentPost
extends AbstractQuickShareContent {
    protected Map<String, Object> executeImpl(WebScriptRequest req, Status status, Cache cache) {
        if (!this.isEnabled()) {
            throw new WebScriptException(403, "QuickShare is disabled system-wide");
        }
        Map params = req.getServiceMatch().getTemplateVars();
        NodeRef nodeRef = WebScriptUtil.getNodeRef(params);
        if (nodeRef == null) {
            String msg = "A valid NodeRef must be specified!";
            throw new WebScriptException(400, msg);
        }
        try {
            QuickShareDTO dto = this.quickShareService.shareContent(nodeRef);
            HashMap<String, Object> model = new HashMap<String, Object>(1);
            model.put("sharedDTO", dto);
            return model;
        }
        catch (InvalidNodeRefException inre) {
            throw new WebScriptException(404, "Unable to find node: " + String.valueOf(nodeRef));
        }
    }
}

