/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.web.scripts.site;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.alfresco.model.ContentModel;
import org.alfresco.query.PagingRequest;
import org.alfresco.query.PagingResults;
import org.alfresco.repo.node.getchildren.FilterProp;
import org.alfresco.repo.node.getchildren.FilterPropString;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.web.scripts.site.SiteState;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.security.PersonService;
import org.alfresco.service.cmr.site.SiteInfo;
import org.alfresco.service.cmr.site.SiteService;
import org.alfresco.util.Pair;
import org.alfresco.util.ScriptPagingDetails;
import org.springframework.extensions.webscripts.Cache;
import org.springframework.extensions.webscripts.DeclarativeWebScript;
import org.springframework.extensions.webscripts.Status;
import org.springframework.extensions.webscripts.WebScriptException;
import org.springframework.extensions.webscripts.WebScriptRequest;

public class SiteAdminSitesGet
extends DeclarativeWebScript {
    private static final String NAME_FILTER = "nf";
    private static final String MAX_ITEMS = "maxItems";
    private static final String SKIP_COUNT = "skipCount";
    private static final int DEFAULT_MAX_ITEMS_PER_PAGE = 50;
    private SiteService siteService;
    private NodeService nodeService;
    private PersonService personService;

    public void setSiteService(SiteService siteService) {
        this.siteService = siteService;
    }

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public void setPersonService(PersonService personService) {
        this.personService = personService;
    }

    protected Map<String, Object> executeImpl(WebScriptRequest req, Status status, Cache cache) {
        String currentUser = AuthenticationUtil.getFullyAuthenticatedUser();
        if (!this.siteService.isSiteAdmin(currentUser)) {
            throw new WebScriptException(404, "Resource not found.");
        }
        final ScriptPagingDetails paging = new ScriptPagingDetails(this.getIntParameter(req, MAX_ITEMS, 50), this.getIntParameter(req, SKIP_COUNT, 0));
        paging.setRequestTotalCountMax(Integer.MAX_VALUE);
        final List<FilterProp> filterProp = this.getFilterProperties(req.getParameter(NAME_FILTER));
        final ArrayList<Pair> sortProps = new ArrayList<Pair>();
        sortProps.add(new Pair((Object)ContentModel.PROP_NAME, (Object)true));
        PagingResults pagingResults = (PagingResults)AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<PagingResults<SiteInfo>>(){

            public PagingResults<SiteInfo> doWork() throws Exception {
                return SiteAdminSitesGet.this.siteService.listSites(filterProp, sortProps, (PagingRequest)paging);
            }
        }, (String)AuthenticationUtil.getAdminUserName());
        List result = pagingResults.getPage();
        ArrayList<SiteState> sites = new ArrayList<SiteState>(result.size());
        for (SiteInfo info : result) {
            sites.add(SiteState.create(info, this.siteService.listMembers(info.getShortName(), null, "SiteManager", 0), currentUser, this.nodeService, this.personService));
        }
        HashMap<String, Serializable> sitesData = new HashMap<String, Serializable>(6);
        sitesData.put("items", sites);
        sitesData.put("count", Integer.valueOf(result.size()));
        sitesData.put("hasMoreItems", Boolean.valueOf(pagingResults.hasMoreItems()));
        sitesData.put("totalItems", Integer.valueOf(pagingResults.getTotalResultCount() == null ? -1 : (Integer)pagingResults.getTotalResultCount().getFirst()));
        sitesData.put(SKIP_COUNT, Integer.valueOf(paging.getSkipCount()));
        sitesData.put(MAX_ITEMS, Integer.valueOf(paging.getMaxItems()));
        HashMap<String, Object> model = new HashMap<String, Object>(1);
        model.put("data", sitesData);
        return model;
    }

    private int getIntParameter(WebScriptRequest req, String paramName, int defaultValue) {
        String paramString = req.getParameter(paramName);
        if (paramString != null) {
            try {
                int param = Integer.valueOf(paramString);
                if (param >= 0) {
                    return param;
                }
            }
            catch (NumberFormatException e) {
                throw new WebScriptException(400, e.getMessage());
            }
        }
        return defaultValue;
    }

    private List<FilterProp> getFilterProperties(String filter) {
        if (filter == null || filter.isEmpty() || filter.equals("*")) {
            return null;
        }
        ArrayList<FilterProp> filterProps = new ArrayList<FilterProp>();
        filterProps.add((FilterProp)new FilterPropString(ContentModel.PROP_NAME, filter, FilterPropString.FilterTypeString.STARTSWITH_IGNORECASE));
        filterProps.add((FilterProp)new FilterPropString(ContentModel.PROP_TITLE, filter, FilterPropString.FilterTypeString.STARTSWITH_IGNORECASE));
        return filterProps;
    }
}

