/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.api.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.alfresco.model.ContentModel;
import org.alfresco.query.PagingRequest;
import org.alfresco.query.PagingResults;
import org.alfresco.repo.dictionary.CompiledModel;
import org.alfresco.repo.dictionary.CustomModelDefinitionImpl;
import org.alfresco.repo.dictionary.Facetable;
import org.alfresco.repo.dictionary.M2Aspect;
import org.alfresco.repo.dictionary.M2Class;
import org.alfresco.repo.dictionary.M2Constraint;
import org.alfresco.repo.dictionary.M2Model;
import org.alfresco.repo.dictionary.M2Property;
import org.alfresco.repo.dictionary.M2Type;
import org.alfresco.repo.dictionary.ValueDataTypeValidator;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.rest.api.CustomModels;
import org.alfresco.rest.api.impl.Util;
import org.alfresco.rest.api.model.AbstractCommonDetails;
import org.alfresco.rest.api.model.AbstractCustomClass;
import org.alfresco.rest.api.model.CustomAspect;
import org.alfresco.rest.api.model.CustomModel;
import org.alfresco.rest.api.model.CustomModelConstraint;
import org.alfresco.rest.api.model.CustomModelDownload;
import org.alfresco.rest.api.model.CustomModelNamedValue;
import org.alfresco.rest.api.model.CustomModelProperty;
import org.alfresco.rest.api.model.CustomType;
import org.alfresco.rest.framework.core.exceptions.ApiException;
import org.alfresco.rest.framework.core.exceptions.ConstraintViolatedException;
import org.alfresco.rest.framework.core.exceptions.EntityNotFoundException;
import org.alfresco.rest.framework.core.exceptions.InvalidArgumentException;
import org.alfresco.rest.framework.core.exceptions.PermissionDeniedException;
import org.alfresco.rest.framework.resource.parameters.CollectionWithPagingInfo;
import org.alfresco.rest.framework.resource.parameters.Paging;
import org.alfresco.rest.framework.resource.parameters.Parameters;
import org.alfresco.service.cmr.dictionary.AspectDefinition;
import org.alfresco.service.cmr.dictionary.ClassDefinition;
import org.alfresco.service.cmr.dictionary.ConstraintDefinition;
import org.alfresco.service.cmr.dictionary.CustomModelDefinition;
import org.alfresco.service.cmr.dictionary.CustomModelException;
import org.alfresco.service.cmr.dictionary.CustomModelService;
import org.alfresco.service.cmr.dictionary.DataTypeDefinition;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.cmr.dictionary.ModelDefinition;
import org.alfresco.service.cmr.dictionary.NamespaceDefinition;
import org.alfresco.service.cmr.dictionary.PropertyDefinition;
import org.alfresco.service.cmr.dictionary.TypeDefinition;
import org.alfresco.service.cmr.i18n.MessageLookup;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.security.PersonService;
import org.alfresco.service.namespace.NamespacePrefixResolver;
import org.alfresco.service.namespace.NamespaceService;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.Pair;
import org.alfresco.util.collections.CollectionUtils;
import org.alfresco.util.collections.Function;
import org.apache.commons.lang3.StringUtils;
import org.springframework.extensions.surf.util.I18NUtil;

public class CustomModelsImpl
implements CustomModels {
    public static final Pattern NAME_PATTERN = Pattern.compile("^[A-Za-z0-9_\\-]+$");
    public static final Pattern URI_PATTERN = Pattern.compile("^[A-Za-z0-9:/_\\.\\-]+$");
    public static final String MODEL_NAME_NULL_ERR = "cmm.rest_api.model_name_null";
    public static final String TYPE_NAME_NULL_ERR = "cmm.rest_api.type_name_null";
    public static final String ASPECT_NAME_NULL_ERR = "cmm.rest_api.aspect_name_null";
    public static final String CONSTRAINT_NAME_NULL_ERR = "cmm.rest_api.constraint_name_null";
    protected CustomModelService customModelService;
    protected DictionaryService dictionaryService;
    protected PersonService personService;
    protected NodeService nodeService;
    protected NamespaceService namespaceService;
    protected ValueDataTypeValidator valueDataTypeValidator;
    private static final String DEFAULT_DATA_TYPE = "d:text";
    private static final String BOOLEAN_DATA_TYPE = "d:boolean";
    private static final String SELECT_ALL = "all";
    private static final String SELECT_STATUS = "status";
    private static final String SELECT_PROPS = "props";
    private static final String SELECT_ALL_PROPS = "allProps";
    private static final String PARAM_UPDATE_PROP = "update";
    private static final String PARAM_DELETE_PROP = "delete";
    private static final String PARAM_WITH_EXT_MODULE = "extModule";

    public void setCustomModelService(CustomModelService customModelService) {
        this.customModelService = customModelService;
    }

    public void setDictionaryService(DictionaryService dictionaryService) {
        this.dictionaryService = dictionaryService;
    }

    public void setPersonService(PersonService personService) {
        this.personService = personService;
    }

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public void setNamespaceService(NamespaceService namespaceService) {
        this.namespaceService = namespaceService;
    }

    public void setValueDataTypeValidator(ValueDataTypeValidator valueDataTypeValidator) {
        this.valueDataTypeValidator = valueDataTypeValidator;
    }

    @Override
    public CustomModel getCustomModel(String modelName, Parameters parameters) {
        CustomModelDefinition modelDef = this.getCustomModelImpl(modelName);
        if (this.hasSelectProperty(parameters, SELECT_ALL)) {
            return new CustomModel(modelDef, this.convertToCustomTypes(modelDef.getTypeDefinitions(), false), this.convertToCustomAspects(modelDef.getAspectDefinitions(), false), this.convertToCustomModelConstraints(modelDef.getModelDefinedConstraints()));
        }
        return new CustomModel(modelDef);
    }

    private CustomModelDefinition getCustomModelImpl(String modelName) {
        if (modelName == null) {
            throw new InvalidArgumentException(MODEL_NAME_NULL_ERR);
        }
        CustomModelDefinition model = null;
        try {
            model = this.customModelService.getCustomModel(modelName);
        }
        catch (CustomModelException ex) {
            throw new EntityNotFoundException(modelName);
        }
        if (model == null) {
            throw new EntityNotFoundException(modelName);
        }
        return model;
    }

    @Override
    public CollectionWithPagingInfo<CustomModel> getCustomModels(Parameters parameters) {
        Paging paging = parameters.getPaging();
        PagingRequest pagingRequest = Util.getPagingRequest(paging);
        PagingResults results = this.customModelService.getCustomModels(pagingRequest);
        Integer totalItems = (Integer)results.getTotalResultCount().getFirst();
        List page = results.getPage();
        ArrayList<CustomModel> models = new ArrayList<CustomModel>(page.size());
        for (CustomModelDefinition modelDefinition : page) {
            models.add(new CustomModel(modelDefinition));
        }
        return CollectionWithPagingInfo.asPaged(paging, models, results.hasMoreItems(), totalItems == null ? null : Integer.valueOf(totalItems));
    }

    @Override
    public CustomModel createCustomModel(CustomModel model) {
        this.validateCurrentUser();
        return this.createCustomModelImpl(model, true);
    }

    private CustomModel createCustomModelImpl(CustomModel model, boolean basicModelOnly) {
        M2Model m2Model = null;
        m2Model = basicModelOnly ? this.convertToM2Model(model, null, null, null) : this.convertToM2Model(model, model.getTypes(), model.getAspects(), model.getConstraints());
        boolean activate = CustomModel.ModelStatus.ACTIVE.equals((Object)model.getStatus());
        try {
            CustomModelDefinition modelDefinition = this.customModelService.createCustomModel(m2Model, activate);
            return new CustomModel(modelDefinition);
        }
        catch (CustomModelException.ModelExistsException me) {
            throw new ConstraintViolatedException(me.getMessage());
        }
        catch (CustomModelException.CustomModelConstraintException ncx) {
            throw new ConstraintViolatedException(ncx.getMessage());
        }
        catch (CustomModelException.InvalidCustomModelException iex) {
            throw new InvalidArgumentException(iex.getMessage());
        }
        catch (Exception e) {
            throw new ApiException("cmm.rest_api.model_invalid", e);
        }
    }

    @Override
    public CustomModel updateCustomModel(String modelName, CustomModel model, Parameters parameters) {
        boolean isNamespacePrefixChanged;
        this.validateCurrentUser();
        ModelDetails existingModelDetails = new ModelDetails(this, this.getCustomModelImpl(modelName));
        CustomModel existingModel = existingModelDetails.getModel();
        if (this.hasSelectProperty(parameters, SELECT_STATUS)) {
            CustomModel.ModelStatus status = model.getStatus();
            if (status == null) {
                throw new InvalidArgumentException("cmm.rest_api.model_status_null");
            }
            try {
                if (CustomModel.ModelStatus.ACTIVE.equals((Object)status)) {
                    this.customModelService.activateCustomModel(modelName);
                } else {
                    this.customModelService.deactivateCustomModel(modelName);
                }
                existingModel.setStatus(status);
                return existingModel;
            }
            catch (CustomModelException.CustomModelConstraintException mce) {
                throw new ConstraintViolatedException(mce.getMessage());
            }
            catch (Exception ex) {
                throw new ApiException(ex.getMessage(), ex);
            }
        }
        if (model.getName() != null && !existingModel.getName().equals(model.getName())) {
            throw new InvalidArgumentException("cmm.rest_api.model_name_cannot_update");
        }
        existingModel.setNamespaceUri(model.getNamespaceUri());
        boolean bl = isNamespacePrefixChanged = !existingModel.getNamespacePrefix().equals(model.getNamespacePrefix());
        if (isNamespacePrefixChanged) {
            this.replacePrefix(existingModelDetails.getTypes(), existingModel.getNamespacePrefix(), model.getNamespacePrefix());
            this.replacePrefix(existingModelDetails.getAspects(), existingModel.getNamespacePrefix(), model.getNamespacePrefix());
        }
        existingModel.setNamespacePrefix(model.getNamespacePrefix());
        existingModel.setAuthor(model.getAuthor());
        existingModel.setDescription(model.getDescription());
        CustomModelDefinition modelDef = this.updateModel(existingModelDetails, "cmm.rest_api.model_update_failure");
        return new CustomModel(modelDef);
    }

    private void replacePrefix(List<? extends AbstractCustomClass> existingTypesOrAspects, String modelOldNamespacePrefix, String modelNewNamespacePrefix) {
        for (AbstractCustomClass abstractCustomClass : existingTypesOrAspects) {
            Pair<String, String> prefixLocalNamePair;
            String parentName = abstractCustomClass.getParentName();
            if (parentName != null && modelOldNamespacePrefix.equals((prefixLocalNamePair = this.splitPrefixedQName(parentName)).getFirst())) {
                String newParentName = this.constructName((String)prefixLocalNamePair.getSecond(), modelNewNamespacePrefix);
                abstractCustomClass.setParentName(newParentName);
            }
            List<CustomModelProperty> properties = abstractCustomClass.getProperties();
            for (CustomModelProperty prop : properties) {
                List<String> constraintRefs = prop.getConstraintRefs();
                if (constraintRefs.size() <= 0) continue;
                ArrayList<String> modifiedRefs = new ArrayList<String>(constraintRefs.size());
                for (String ref : constraintRefs) {
                    Pair<String, String> prefixLocalNamePair2 = this.splitPrefixedQName(ref);
                    String newRef = this.constructName((String)prefixLocalNamePair2.getSecond(), modelNewNamespacePrefix);
                    modifiedRefs.add(newRef);
                }
                prop.setConstraintRefs(modifiedRefs);
            }
        }
    }

    @Override
    public void deleteCustomModel(String modelName) {
        this.validateCurrentUser();
        if (modelName == null) {
            throw new InvalidArgumentException(MODEL_NAME_NULL_ERR);
        }
        try {
            this.customModelService.deleteCustomModel(modelName);
        }
        catch (CustomModelException.ModelDoesNotExistException ee) {
            throw new EntityNotFoundException(modelName);
        }
        catch (CustomModelException.ActiveModelConstraintException ae) {
            throw new ConstraintViolatedException(ae.getMessage());
        }
        catch (Exception ex) {
            throw new ApiException(ex.getMessage(), ex);
        }
    }

    @Override
    public CustomType getCustomType(String modelName, String typeName, Parameters parameters) {
        if (typeName == null) {
            throw new InvalidArgumentException(TYPE_NAME_NULL_ERR);
        }
        CustomModelDefinition modelDef = this.getCustomModelImpl(modelName);
        QName typeQname = QName.createQName((String)modelDef.getName().getNamespaceURI(), (String)typeName);
        TypeDefinition customTypeDef = this.customModelService.getCustomType(typeQname);
        if (customTypeDef == null) {
            throw new EntityNotFoundException(typeName);
        }
        boolean includeInheritedProps = this.hasSelectProperty(parameters, SELECT_ALL_PROPS);
        return this.convertToCustomType(customTypeDef, includeInheritedProps);
    }

    @Override
    public CollectionWithPagingInfo<CustomType> getCustomTypes(String modelName, Parameters parameters) {
        CustomModelDefinition modelDef = this.getCustomModelImpl(modelName);
        Collection typeDefinitions = modelDef.getTypeDefinitions();
        Paging paging = Paging.DEFAULT;
        List<CustomType> customTypes = this.convertToCustomTypes(typeDefinitions, false);
        return CollectionWithPagingInfo.asPaged(paging, customTypes, false, typeDefinitions.size());
    }

    @Override
    public CustomType createCustomType(String modelName, CustomType type) {
        this.validateCurrentUser();
        ModelDetails existingModelDetails = new ModelDetails(this, this.getCustomModelImpl(modelName));
        this.validateTypeAspectParent(type, existingModelDetails.getModel());
        existingModelDetails.getTypes().add(type);
        this.updateModel(existingModelDetails, "cmm.rest_api.type_create_failure");
        return type;
    }

    @Override
    public CustomType updateCustomType(String modelName, CustomType type, Parameters parameters) {
        return this.updateTypeAspect(modelName, type, parameters);
    }

    private <T extends AbstractCustomClass> T updateTypeAspect(String modelName, T classDef, Parameters parameters) {
        this.validateCurrentUser();
        boolean isAspect = classDef instanceof CustomAspect;
        String name = classDef.getName();
        if (name == null) {
            String msgId = isAspect ? ASPECT_NAME_NULL_ERR : TYPE_NAME_NULL_ERR;
            throw new InvalidArgumentException(msgId);
        }
        ModelDetails existingModelDetails = new ModelDetails(this, this.getCustomModelImpl(modelName));
        List<AbstractCustomClass> allClassDefs = isAspect ? existingModelDetails.getAspects() : existingModelDetails.getTypes();
        AbstractCustomClass existingClassDef = this.getObjectByName(allClassDefs, name);
        if (existingClassDef == null) {
            throw new EntityNotFoundException(name);
        }
        if (this.hasSelectProperty(parameters, SELECT_PROPS)) {
            String errorMsg = null;
            String propName = parameters.getParameter(PARAM_DELETE_PROP);
            if (propName == null) {
                errorMsg = "cmm.rest_api.property_create_update_failure";
                this.mergeProperties(existingClassDef, classDef, parameters, existingModelDetails.isActive());
            } else {
                errorMsg = "cmm.rest_api.property_delete_failure";
                this.deleteProperty(existingClassDef, propName);
            }
            this.updateModel(existingModelDetails, errorMsg);
        } else {
            boolean isParentChanged;
            existingClassDef.setTitle(classDef.getTitle());
            existingClassDef.setDescription(classDef.getDescription());
            boolean bl = isParentChanged = !StringUtils.equals((CharSequence)existingClassDef.getParentName(), (CharSequence)classDef.getParentName());
            if (isParentChanged && existingModelDetails.isActive()) {
                String errMsgId = isAspect ? "cmm.rest_api.aspect_parent_cannot_update" : "cmm.rest_api.type_parent_cannot_update";
                throw new ConstraintViolatedException(errMsgId);
            }
            this.validateTypeAspectParent(classDef, existingModelDetails.getModel());
            existingClassDef.setParentName(classDef.getParentName());
            String errMsgId = isAspect ? "cmm.rest_api.aspect_update_failure" : "cmm.rest_api.type_update_failure";
            this.updateModel(existingModelDetails, errMsgId);
        }
        return (T)existingClassDef;
    }

    @Override
    public void deleteCustomType(String modelName, String typeName) {
        this.validateCurrentUser();
        if (typeName == null) {
            throw new InvalidArgumentException(TYPE_NAME_NULL_ERR);
        }
        ModelDetails existingModelDetails = new ModelDetails(this, this.getCustomModelImpl(modelName));
        if (existingModelDetails.isActive()) {
            throw new ConstraintViolatedException("cmm.rest_api.type_cannot_delete");
        }
        Map<String, AbstractCommonDetails> allTypes = CustomModelsImpl.transformToMap(existingModelDetails.getTypes(), CustomModelsImpl.toNameFunction());
        CustomType typeToBeDeleted = (CustomType)allTypes.get(typeName);
        if (typeToBeDeleted == null) {
            throw new EntityNotFoundException(typeName);
        }
        this.validateTypeAspectDelete(allTypes.values(), typeToBeDeleted.getPrefixedName());
        allTypes.remove(typeName);
        existingModelDetails.setTypes(new ArrayList<AbstractCommonDetails>(allTypes.values()));
        this.updateModel(existingModelDetails, "cmm.rest_api.type_delete_failure");
    }

    @Override
    public CustomAspect getCustomAspect(String modelName, String aspectName, Parameters parameters) {
        if (aspectName == null) {
            throw new InvalidArgumentException(ASPECT_NAME_NULL_ERR);
        }
        CustomModelDefinition modelDef = this.getCustomModelImpl(modelName);
        QName aspectQname = QName.createQName((String)modelDef.getName().getNamespaceURI(), (String)aspectName);
        AspectDefinition customAspectDef = this.customModelService.getCustomAspect(aspectQname);
        if (customAspectDef == null) {
            throw new EntityNotFoundException(aspectName);
        }
        boolean includeInheritedProps = this.hasSelectProperty(parameters, SELECT_ALL_PROPS);
        return this.convertToCustomAspect(customAspectDef, includeInheritedProps);
    }

    @Override
    public CollectionWithPagingInfo<CustomAspect> getCustomAspects(String modelName, Parameters parameters) {
        CustomModelDefinition modelDef = this.getCustomModelImpl(modelName);
        Collection aspectDefinitions = modelDef.getAspectDefinitions();
        Paging paging = Paging.DEFAULT;
        List<CustomAspect> customAspects = this.convertToCustomAspects(aspectDefinitions, false);
        return CollectionWithPagingInfo.asPaged(paging, customAspects, false, aspectDefinitions.size());
    }

    @Override
    public CustomAspect createCustomAspect(String modelName, CustomAspect aspect) {
        this.validateCurrentUser();
        ModelDetails existingModelDetails = new ModelDetails(this, this.getCustomModelImpl(modelName));
        this.validateTypeAspectParent(aspect, existingModelDetails.getModel());
        existingModelDetails.getAspects().add(aspect);
        this.updateModel(existingModelDetails, "cmm.rest_api.aspect_create_failure");
        return aspect;
    }

    @Override
    public CustomAspect updateCustomAspect(String modelName, CustomAspect aspect, Parameters parameters) {
        return this.updateTypeAspect(modelName, aspect, parameters);
    }

    @Override
    public void deleteCustomAspect(String modelName, String aspectName) {
        this.validateCurrentUser();
        if (aspectName == null) {
            throw new InvalidArgumentException(ASPECT_NAME_NULL_ERR);
        }
        ModelDetails existingModelDetails = new ModelDetails(this, this.getCustomModelImpl(modelName));
        if (existingModelDetails.isActive()) {
            throw new ConstraintViolatedException("cmm.rest_api.aspect_cannot_delete");
        }
        Map<String, AbstractCommonDetails> allAspects = CustomModelsImpl.transformToMap(existingModelDetails.getAspects(), CustomModelsImpl.toNameFunction());
        CustomAspect aspectToBeDeleted = (CustomAspect)allAspects.get(aspectName);
        if (aspectToBeDeleted == null) {
            throw new EntityNotFoundException(aspectName);
        }
        this.validateTypeAspectDelete(allAspects.values(), aspectToBeDeleted.getPrefixedName());
        allAspects.remove(aspectName);
        existingModelDetails.setAspects(new ArrayList<AbstractCommonDetails>(allAspects.values()));
        this.updateModel(existingModelDetails, "cmm.rest_api.aspect_delete_failure");
    }

    @Override
    public CollectionWithPagingInfo<CustomModelConstraint> getCustomModelConstraints(String modelName, Parameters parameters) {
        CustomModelDefinition modelDef = this.getCustomModelImpl(modelName);
        Collection constraintDefinitions = modelDef.getModelDefinedConstraints();
        Paging paging = Paging.DEFAULT;
        List<CustomModelConstraint> customModelConstraints = this.convertToCustomModelConstraints(constraintDefinitions);
        return CollectionWithPagingInfo.asPaged(paging, customModelConstraints, false, constraintDefinitions.size());
    }

    @Override
    public CustomModelConstraint getCustomModelConstraint(String modelName, String constraintName, Parameters parameters) {
        if (constraintName == null) {
            throw new InvalidArgumentException(CONSTRAINT_NAME_NULL_ERR);
        }
        CustomModelDefinition modelDef = this.getCustomModelImpl(modelName);
        QName constraintQname = QName.createQName((String)modelDef.getName().getNamespaceURI(), (String)constraintName);
        ConstraintDefinition constraintDef = this.customModelService.getCustomConstraint(constraintQname);
        if (constraintDef == null) {
            throw new EntityNotFoundException(constraintName);
        }
        return new CustomModelConstraint(constraintDef, (MessageLookup)this.dictionaryService);
    }

    @Override
    public CustomModelConstraint createCustomModelConstraint(String modelName, CustomModelConstraint constraint) {
        this.validateCurrentUser();
        ModelDetails existingModelDetails = new ModelDetails(this, this.getCustomModelImpl(modelName));
        existingModelDetails.getModelDefinedConstraints().add(constraint);
        this.updateModel(existingModelDetails, "cmm.rest_api.constraint_create_failure");
        return constraint;
    }

    @Override
    public CustomModelDownload createDownload(String modelName, Parameters parameters) {
        this.validateCurrentUser();
        if (modelName == null) {
            throw new InvalidArgumentException(MODEL_NAME_NULL_ERR);
        }
        String propName = parameters.getParameter(PARAM_WITH_EXT_MODULE);
        boolean withForm = Boolean.valueOf(propName);
        try {
            NodeRef nodeRef = this.customModelService.createDownloadNode(modelName, withForm, modelName + ".zip");
            return new CustomModelDownload(nodeRef);
        }
        catch (Exception ex) {
            String errorMsg = "cmm.rest_api.model_download_failure";
            if (ex.getMessage() != null) {
                errorMsg = ex.getMessage();
            }
            throw new ApiException(errorMsg, ex);
        }
    }

    private CustomType convertToCustomType(TypeDefinition typeDefinition, boolean includeInheritedProps) {
        List<CustomModelProperty> properties = this.convertToCustomModelProperty((ClassDefinition)typeDefinition, includeInheritedProps);
        return new CustomType(typeDefinition, (MessageLookup)this.dictionaryService, properties);
    }

    private List<CustomType> convertToCustomTypes(Collection<TypeDefinition> typeDefinitions, boolean includeInheritedProps) {
        ArrayList<CustomType> customTypes = new ArrayList<CustomType>(typeDefinitions.size());
        for (TypeDefinition td : typeDefinitions) {
            customTypes.add(this.convertToCustomType(td, includeInheritedProps));
        }
        return customTypes;
    }

    private CustomAspect convertToCustomAspect(AspectDefinition aspectDefinition, boolean includeInheritedProps) {
        List<CustomModelProperty> properties = this.convertToCustomModelProperty((ClassDefinition)aspectDefinition, includeInheritedProps);
        return new CustomAspect(aspectDefinition, (MessageLookup)this.dictionaryService, properties);
    }

    private List<CustomAspect> convertToCustomAspects(Collection<AspectDefinition> aspectDefinitions, boolean includeInheritedProps) {
        ArrayList<CustomAspect> customAspects = new ArrayList<CustomAspect>(aspectDefinitions.size());
        for (AspectDefinition ad : aspectDefinitions) {
            customAspects.add(this.convertToCustomAspect(ad, includeInheritedProps));
        }
        return customAspects;
    }

    private List<CustomModelProperty> convertToCustomModelProperty(ClassDefinition classDefinition, boolean includeInherited) {
        Collection ownProperties = null;
        ClassDefinition parentDef = classDefinition.getParentClassDefinition();
        ownProperties = !includeInherited && parentDef != null ? CustomModelsImpl.removeRightEntries(classDefinition.getProperties(), parentDef.getProperties()).values() : classDefinition.getProperties().values();
        ArrayList<CustomModelProperty> customProperties = new ArrayList<CustomModelProperty>(ownProperties.size());
        for (PropertyDefinition propDef : ownProperties) {
            customProperties.add(new CustomModelProperty(propDef, (MessageLookup)this.dictionaryService));
        }
        return customProperties;
    }

    private List<CustomModelConstraint> convertToCustomModelConstraints(Collection<ConstraintDefinition> constraintDefinitions) {
        ArrayList<CustomModelConstraint> constraints = new ArrayList<CustomModelConstraint>(constraintDefinitions.size());
        for (ConstraintDefinition definition : constraintDefinitions) {
            constraints.add(new CustomModelConstraint(definition, (MessageLookup)this.dictionaryService));
        }
        return constraints;
    }

    private M2Model convertToM2Model(ModelDetails modelDetails) {
        return this.convertToM2Model(modelDetails.getModel(), modelDetails.getTypes(), modelDetails.getAspects(), modelDetails.getModelDefinedConstraints());
    }

    private M2Model convertToM2Model(CustomModel customModel, Collection<CustomType> types, Collection<CustomAspect> aspects, Collection<CustomModelConstraint> constraints) {
        this.validateBasicModelInput(customModel);
        LinkedHashSet<Pair<String, String>> namespacesToImport = new LinkedHashSet<Pair<String, String>>();
        String namespacePrefix = customModel.getNamespacePrefix();
        String namespaceURI = customModel.getNamespaceUri();
        String name = this.constructName(customModel.getName(), namespacePrefix);
        M2Model model = M2Model.createModel((String)name);
        model.createNamespace(namespaceURI, namespacePrefix);
        model.setDescription(customModel.getDescription());
        String author = customModel.getAuthor();
        if (author == null) {
            author = this.getCurrentUserFullName();
        }
        model.setAuthor(author);
        if (types != null) {
            for (CustomType customType : types) {
                this.validateName(customType.getName(), TYPE_NAME_NULL_ERR);
                M2Type m2Type = model.createType(this.constructName(customType.getName(), namespacePrefix));
                m2Type.setDescription(customType.getDescription());
                m2Type.setTitle(customType.getTitle());
                this.setParentName((M2Class)m2Type, customType.getParentName(), namespacesToImport, namespacePrefix);
                this.setM2Properties((M2Class)m2Type, customType.getProperties(), namespacePrefix, namespacesToImport);
            }
        }
        if (aspects != null) {
            for (CustomAspect customAspect : aspects) {
                this.validateName(customAspect.getName(), ASPECT_NAME_NULL_ERR);
                M2Aspect m2Aspect = model.createAspect(this.constructName(customAspect.getName(), namespacePrefix));
                m2Aspect.setDescription(customAspect.getDescription());
                m2Aspect.setTitle(customAspect.getTitle());
                this.setParentName((M2Class)m2Aspect, customAspect.getParentName(), namespacesToImport, namespacePrefix);
                this.setM2Properties((M2Class)m2Aspect, customAspect.getProperties(), namespacePrefix, namespacesToImport);
            }
        }
        if (constraints != null) {
            for (CustomModelConstraint customModelConstraint : constraints) {
                this.validateName(customModelConstraint.getName(), CONSTRAINT_NAME_NULL_ERR);
                String constraintName = this.constructName(customModelConstraint.getName(), namespacePrefix);
                M2Constraint m2Constraint = model.createConstraint(constraintName, customModelConstraint.getType());
                this.setConstraintOtherData(customModelConstraint, m2Constraint, null);
            }
        }
        for (Pair pair : namespacesToImport) {
            if (namespaceURI.equals(pair.getFirst())) continue;
            model.createImport((String)pair.getFirst(), (String)pair.getSecond());
        }
        return model;
    }

    private void setConstraintOtherData(CustomModelConstraint constraint, M2Constraint m2Constraint, String propDataType) {
        if (m2Constraint.getType() == null) {
            throw new InvalidArgumentException("cmm.rest_api.constraint_type_null");
        }
        ConstraintValidator constraintValidator = ConstraintValidator.findByType(m2Constraint.getType());
        if (propDataType != null) {
            constraintValidator.validateUsage(this.prefixedStringToQname(propDataType));
        }
        m2Constraint.setTitle(constraint.getTitle());
        m2Constraint.setDescription(constraint.getDescription());
        for (CustomModelNamedValue parameter : constraint.getParameters()) {
            this.validateName(parameter.getName(), "cmm.rest_api.constraint_parameter_name_null");
            if (parameter.getListValue() != null) {
                if (propDataType != null && "allowedValues".equals(parameter.getName())) {
                    this.validateListConstraint(parameter.getListValue(), propDataType);
                }
                m2Constraint.createParameter(parameter.getName(), parameter.getListValue());
                continue;
            }
            constraintValidator.validate(parameter.getName(), parameter.getSimpleValue());
            m2Constraint.createParameter(parameter.getName(), parameter.getSimpleValue());
        }
    }

    private void validateListConstraint(List<String> listValue, String propDataType) {
        for (String value : listValue) {
            try {
                this.valueDataTypeValidator.validateValue(propDataType, value);
            }
            catch (Exception ex) {
                throw new InvalidArgumentException(ex.getMessage());
            }
        }
    }

    private void setM2Properties(M2Class m2Class, List<CustomModelProperty> properties, String namespacePrefix, Set<Pair<String, String>> namespacesToImport) {
        if (properties != null) {
            for (CustomModelProperty prop : properties) {
                this.validateName(prop.getName(), "cmm.rest_api.property_name_null");
                M2Property m2Property = m2Class.createProperty(this.constructName(prop.getName(), namespacePrefix));
                m2Property.setTitle(prop.getTitle());
                m2Property.setDescription(prop.getDescription());
                m2Property.setMandatory(prop.isMandatory());
                m2Property.setMandatoryEnforced(prop.isMandatoryEnforced());
                m2Property.setMultiValued(prop.isMultiValued());
                String dataType = prop.getDataType();
                if (StringUtils.isBlank((CharSequence)dataType)) {
                    dataType = DEFAULT_DATA_TYPE;
                } else if (!dataType.contains(":")) {
                    throw new InvalidArgumentException("cmm.rest_api.property_datatype_invalid", new Object[]{dataType});
                }
                namespacesToImport.add(this.resolveToUriAndPrefix(dataType));
                try {
                    this.valueDataTypeValidator.validateValue(dataType, prop.getDefaultValue());
                }
                catch (Exception ex) {
                    throw new InvalidArgumentException(ex.getMessage());
                }
                m2Property.setType(dataType);
                m2Property.setDefaultValue(prop.getDefaultValue());
                m2Property.setIndexed(prop.isIndexed());
                if (!BOOLEAN_DATA_TYPE.equals(dataType)) {
                    if (Facetable.TRUE == prop.getFacetable()) {
                        m2Property.setFacetable(true);
                    } else if (Facetable.FALSE == prop.getFacetable()) {
                        m2Property.setFacetable(false);
                    }
                }
                m2Property.setIndexTokenisationMode(prop.getIndexTokenisationMode());
                List<String> constraintRefs = prop.getConstraintRefs();
                List<CustomModelConstraint> constraints = prop.getConstraints();
                if (constraintRefs.size() > 0) {
                    for (String ref : constraintRefs) {
                        Pair<String, String> prefixLocalName = this.splitPrefixedQName(ref);
                        if (!namespacePrefix.equals(prefixLocalName.getFirst())) {
                            throw new ConstraintViolatedException(I18NUtil.getMessage((String)"cmm.rest_api.constraint_ref_not_defined", (Object[])new Object[]{ref}));
                        }
                        m2Property.addConstraintRef(ref);
                    }
                }
                if (constraints.size() <= 0) continue;
                for (CustomModelConstraint modelConstraint : constraints) {
                    String constraintName = null;
                    if (modelConstraint.getName() != null) {
                        this.validateName(modelConstraint.getName(), CONSTRAINT_NAME_NULL_ERR);
                        constraintName = this.constructName(modelConstraint.getName(), namespacePrefix);
                    }
                    M2Constraint m2Constraint = m2Property.addConstraint(constraintName, modelConstraint.getType());
                    this.setConstraintOtherData(modelConstraint, m2Constraint, dataType);
                }
            }
        }
    }

    private void validateBasicModelInput(CustomModel customModel) {
        this.validateName(customModel.getName(), MODEL_NAME_NULL_ERR);
        this.validateName(customModel.getNamespacePrefix(), "cmm.rest_api.model_namespace_prefix_null");
        if (customModel.getNamespaceUri() == null) {
            throw new InvalidArgumentException("cmm.rest_api.model_namespace_uri_null");
        }
        Matcher matcher = URI_PATTERN.matcher(customModel.getNamespaceUri());
        if (!matcher.find()) {
            throw new InvalidArgumentException("cmm.rest_api.model_namespace_uri_invalid");
        }
    }

    private void validateName(String name, String errMsgId) {
        if (name == null) {
            if (errMsgId == null) {
                errMsgId = InvalidArgumentException.DEFAULT_MESSAGE_ID;
            }
            throw new InvalidArgumentException(errMsgId);
        }
        Matcher matcher = NAME_PATTERN.matcher(name);
        if (!matcher.find()) {
            throw new InvalidArgumentException("cmm.rest_api.input_validation_err", new Object[]{name});
        }
    }

    private void validateCurrentUser() {
        String currentUser = AuthenticationUtil.getFullyAuthenticatedUser();
        if (!this.customModelService.isModelAdmin(currentUser)) {
            throw new PermissionDeniedException();
        }
    }

    protected String getCurrentUserFullName() {
        String userName = AuthenticationUtil.getFullyAuthenticatedUser();
        NodeRef personRef = this.personService.getPerson(userName, false);
        String firstName = (String)((Object)this.nodeService.getProperty(personRef, ContentModel.PROP_FIRSTNAME));
        String lastName = (String)((Object)this.nodeService.getProperty(personRef, ContentModel.PROP_LASTNAME));
        String fullName = (String)(firstName != null ? firstName + " " : "") + (lastName != null ? lastName : "");
        return ((String)(StringUtils.isBlank((CharSequence)fullName) ? userName : fullName)).trim();
    }

    private String constructName(String name, String prefix) {
        return new StringBuilder(100).append(prefix).append(':').append(name).toString();
    }

    protected Pair<String, String> resolveToUriAndPrefix(String parentName) {
        QName qName = this.prefixedStringToQname(parentName);
        Collection prefixes = this.namespaceService.getPrefixes(qName.getNamespaceURI());
        if (prefixes.size() == 0) {
            throw new InvalidArgumentException("cmm.rest_api.prefix_not_registered", new Object[]{qName.getNamespaceURI()});
        }
        String prefix = (String)prefixes.iterator().next();
        return new Pair((Object)qName.getNamespaceURI(), (Object)prefix);
    }

    private QName prefixedStringToQname(String prefixedQName) {
        try {
            return QName.createQName((String)prefixedQName, (NamespacePrefixResolver)this.namespaceService);
        }
        catch (Exception ex) {
            String msg = ex.getMessage();
            if (msg == null) {
                msg = "";
            }
            throw new InvalidArgumentException("cmm.rest_api.prefixed_qname_invalid", new Object[]{prefixedQName, msg});
        }
    }

    private void setParentName(M2Class m2Class, String parentPrefixedName, Set<Pair<String, String>> namespacesToImport, String modelNamespacePrefix) {
        if (StringUtils.isBlank((CharSequence)parentPrefixedName)) {
            return;
        }
        Pair<String, String> prefixLocaNamePair = this.splitPrefixedQName(parentPrefixedName);
        if (!modelNamespacePrefix.equals(prefixLocaNamePair.getFirst())) {
            Pair<String, String> uriPrefixPair = this.resolveToUriAndPrefix(parentPrefixedName);
            namespacesToImport.add(uriPrefixPair);
        }
        m2Class.setParentName(parentPrefixedName);
    }

    private void validateTypeAspectParent(AbstractCustomClass typeAspect, CustomModel existingModel) {
        String parentPrefixedName = typeAspect.getParentName();
        if (StringUtils.isBlank((CharSequence)parentPrefixedName)) {
            return;
        }
        Pair<String, String> prefixLocaNamePair = this.splitPrefixedQName(parentPrefixedName);
        String parentPrefix = (String)prefixLocaNamePair.getFirst();
        String parentLocalName = (String)prefixLocaNamePair.getSecond();
        this.validateName(parentPrefix, null);
        this.validateName(parentLocalName, null);
        boolean isAspect = typeAspect instanceof CustomAspect;
        AspectDefinition classDefinition = null;
        QName qname = null;
        if (existingModel.getNamespacePrefix().equals(parentPrefix)) {
            qname = QName.createQName((String)existingModel.getNamespaceUri(), (String)parentLocalName);
            classDefinition = isAspect ? this.customModelService.getCustomAspect(qname) : this.customModelService.getCustomType(qname);
        } else {
            Pair<String, String> uriPrefixPair = this.resolveToUriAndPrefix(parentPrefixedName);
            qname = QName.createQName((String)((String)uriPrefixPair.getFirst()), (String)parentLocalName);
            Object object = classDefinition = isAspect ? this.dictionaryService.getAspect(qname) : this.dictionaryService.getType(qname);
        }
        if (classDefinition == null) {
            String msgId = isAspect ? "cmm.rest_api.aspect_parent_not_exist" : "cmm.rest_api.type_parent_not_exist";
            throw new ConstraintViolatedException(I18NUtil.getMessage((String)msgId, (Object[])new Object[]{parentPrefixedName}));
        }
        this.checkCircularDependency(classDefinition.getModel(), existingModel, parentPrefixedName);
    }

    private void checkCircularDependency(ModelDefinition modelDefinition, CustomModel existingModel, String parentPrefixedName) {
        for (NamespaceDefinition importedNamespace : modelDefinition.getImportedNamespaces()) {
            ModelDefinition md = null;
            md = this.customModelService.getCustomModelByUri(importedNamespace.getUri());
            if (md == null) continue;
            if (existingModel.getNamespaceUri().equals(importedNamespace.getUri())) {
                String msg = I18NUtil.getMessage((String)"cmm.rest_api.circular_dependency_err", (Object[])new Object[]{parentPrefixedName, existingModel.getName()});
                throw new ConstraintViolatedException(msg);
            }
            this.checkCircularDependency(md, existingModel, parentPrefixedName);
        }
    }

    private Pair<String, String> splitPrefixedQName(String prefixedQName) {
        String[] prefixLocalName = QName.splitPrefixedQName((String)prefixedQName);
        if ("".equals(prefixLocalName[0])) {
            throw new InvalidArgumentException("cmm.rest_api.prefixed_qname_invalid_format", new Object[]{prefixedQName});
        }
        return new Pair((Object)prefixLocalName[0], (Object)prefixLocalName[1]);
    }

    private CustomModelDefinition updateModel(ModelDetails modelDetails, String errorMsg) {
        M2Model m2Model = this.convertToM2Model(modelDetails);
        try {
            CustomModelDefinition modelDef = this.customModelService.updateCustomModel(modelDetails.getModel().getName(), m2Model, modelDetails.isActive());
            return modelDef;
        }
        catch (CustomModelException.CustomModelConstraintException mce) {
            throw new ConstraintViolatedException(mce.getMessage());
        }
        catch (CustomModelException.InvalidCustomModelException iex) {
            throw new InvalidArgumentException(iex.getMessage());
        }
        catch (Exception ex) {
            if (ex.getMessage() != null) {
                errorMsg = ex.getMessage();
            }
            throw new ApiException(errorMsg, ex);
        }
    }

    private void mergeProperties(AbstractCustomClass existingDetails, AbstractCustomClass newDetails, Parameters parameters, boolean isModelActive) {
        this.validateList(newDetails.getProperties(), "cmm.rest_api.properties_empty_null");
        Map<String, AbstractCommonDetails> existingProperties = CustomModelsImpl.transformToMap(existingDetails.getProperties(), CustomModelsImpl.toNameFunction());
        Map<String, AbstractCommonDetails> newProperties = CustomModelsImpl.transformToMap(newDetails.getProperties(), CustomModelsImpl.toNameFunction());
        String propName = parameters.getParameter(PARAM_UPDATE_PROP);
        if (propName == null) {
            for (String name : newProperties.keySet()) {
                if (!existingProperties.containsKey(name)) continue;
                throw new ConstraintViolatedException(I18NUtil.getMessage((String)"cmm.rest_api.property_create_name_already_in_use", (Object[])new Object[]{name}));
            }
        } else {
            CustomModelProperty existingProp = (CustomModelProperty)existingProperties.get(propName);
            if (existingProp == null) {
                throw new EntityNotFoundException(propName);
            }
            CustomModelProperty modifiedProp = (CustomModelProperty)newProperties.get(propName);
            if (modifiedProp == null) {
                throw new InvalidArgumentException("cmm.rest_api.property_update_prop_not_found", new Object[]{propName});
            }
            existingProp.setTitle(modifiedProp.getTitle());
            existingProp.setDescription(modifiedProp.getDescription());
            existingProp.setDefaultValue(modifiedProp.getDefaultValue());
            existingProp.setConstraintRefs(modifiedProp.getConstraintRefs());
            existingProp.setConstraints(modifiedProp.getConstraints());
            if (isModelActive) {
                this.validateActivePropertyUpdate(existingProp, modifiedProp);
            }
            existingProp.setDataType(modifiedProp.getDataType());
            existingProp.setMandatory(modifiedProp.isMandatory());
            existingProp.setMandatoryEnforced(modifiedProp.isMandatoryEnforced());
            existingProp.setMultiValued(modifiedProp.isMultiValued());
        }
        existingProperties.putAll(newProperties);
        existingDetails.setProperties(new ArrayList<AbstractCommonDetails>(existingProperties.values()));
    }

    private void validateActivePropertyUpdate(CustomModelProperty existingProp, CustomModelProperty newProp) {
        if (!StringUtils.equals((CharSequence)existingProp.getDataType(), (CharSequence)newProp.getDataType())) {
            throw new ConstraintViolatedException("cmm.rest_api.property_change_datatype_err");
        }
        if (existingProp.isMandatory() != newProp.isMandatory()) {
            throw new ConstraintViolatedException("cmm.rest_api.property_change_mandatory_opt_err");
        }
        if (existingProp.isMandatoryEnforced() != newProp.isMandatoryEnforced()) {
            throw new ConstraintViolatedException("cmm.rest_api.property_change_mandatory_enforced_opt_err");
        }
        if (existingProp.isMultiValued() != newProp.isMultiValued()) {
            throw new ConstraintViolatedException("cmm.rest_api.property_change_multi_valued_opt_err");
        }
    }

    private void deleteProperty(AbstractCustomClass existingClassModel, String propertyName) {
        Map<String, AbstractCommonDetails> existingProperties = CustomModelsImpl.transformToMap(existingClassModel.getProperties(), CustomModelsImpl.toNameFunction());
        if (!existingProperties.containsKey(propertyName)) {
            throw new EntityNotFoundException(propertyName);
        }
        existingProperties.remove(propertyName);
        existingClassModel.setProperties(new ArrayList<AbstractCommonDetails>(existingProperties.values()));
    }

    private void validateList(List<?> list, String errorMsg) {
        if (CollectionUtils.isEmpty(list)) {
            throw new InvalidArgumentException(errorMsg);
        }
    }

    private static <K, V> Map<K, V> transformToMap(Collection<V> collection, Function<? super V, K> function) {
        HashMap<Object, V> map = new HashMap<Object, V>(collection.size());
        for (V item : collection) {
            map.put(function.apply(item), item);
        }
        return map;
    }

    private static <K, V> Map<K, V> removeRightEntries(Map<K, V> leftMap, Map<K, V> rightMap) {
        HashMap<K, V> result = new HashMap<K, V>(leftMap);
        for (K key : rightMap.keySet()) {
            result.remove(key);
        }
        return result;
    }

    private void validateTypeAspectDelete(Collection<? extends AbstractCustomClass> list, String classPrefixedName) {
        for (AbstractCustomClass abstractCustomClass : list) {
            if (!classPrefixedName.equals(abstractCustomClass.getParentName())) continue;
            throw new ConstraintViolatedException(I18NUtil.getMessage((String)"cmm.rest_api.aspect_type_cannot_delete", (Object[])new Object[]{classPrefixedName, abstractCustomClass.getPrefixedName()}));
        }
    }

    private boolean hasSelectProperty(Parameters parameters, String param) {
        return parameters.getSelectedProperties().contains(param);
    }

    private static Function<AbstractCommonDetails, String> toNameFunction() {
        return new Function<AbstractCommonDetails, String>(){

            public String apply(AbstractCommonDetails details) {
                return details.getName();
            }
        };
    }

    private <T extends AbstractCommonDetails> T getObjectByName(Collection<T> collection, String name) {
        for (AbstractCommonDetails details : collection) {
            if (!details.getName().equals(name)) continue;
            return (T)details;
        }
        return null;
    }

    @Override
    public CustomModel createCustomModel(M2Model m2Model) {
        this.validateCurrentUser();
        this.validateImportedM2Model(m2Model);
        CompiledModel compiledModel = null;
        try {
            compiledModel = this.customModelService.compileModel(m2Model);
        }
        catch (CustomModelException.CustomModelConstraintException mce) {
            throw new ConstraintViolatedException(mce.getMessage());
        }
        catch (CustomModelException.InvalidCustomModelException iex) {
            throw new InvalidArgumentException(iex.getMessage());
        }
        ModelDefinition modelDefinition = compiledModel.getModelDefinition();
        CustomModel customModel = new CustomModel();
        customModel.setName(modelDefinition.getName().getLocalName());
        customModel.setAuthor(modelDefinition.getAuthor());
        customModel.setDescription(modelDefinition.getDescription((MessageLookup)this.dictionaryService));
        customModel.setStatus(CustomModel.ModelStatus.DRAFT);
        NamespaceDefinition nsd = (NamespaceDefinition)modelDefinition.getNamespaces().iterator().next();
        customModel.setNamespaceUri(nsd.getUri());
        customModel.setNamespacePrefix(nsd.getPrefix());
        List<CustomType> customTypes = this.convertToCustomTypes(compiledModel.getTypes(), false);
        List<CustomAspect> customAspects = this.convertToCustomAspects(compiledModel.getAspects(), false);
        List constraintDefinitions = CustomModelDefinitionImpl.removeInlineConstraints((CompiledModel)compiledModel);
        List<CustomModelConstraint> customModelConstraints = this.convertToCustomModelConstraints(constraintDefinitions);
        customModel.setTypes(customTypes);
        customModel.setAspects(customAspects);
        customModel.setConstraints(customModelConstraints);
        return this.createCustomModelImpl(customModel, false);
    }

    private void validateImportedM2Model(M2Model m2Model) {
        List namespaces = m2Model.getNamespaces();
        if (namespaces.size() > 1) {
            throw new ConstraintViolatedException(I18NUtil.getMessage((String)"cmm.rest_api.model.import_namespace_multiple_found", (Object[])new Object[]{namespaces.size()}));
        }
        if (namespaces.isEmpty()) {
            throw new ConstraintViolatedException("cmm.rest_api.model.import_namespace_undefined");
        }
        this.checkUnsupportedModelElements(m2Model.getTypes());
        this.checkUnsupportedModelElements(m2Model.getAspects());
    }

    private void checkUnsupportedModelElements(Collection<? extends M2Class> m2Classes) {
        for (M2Class m2Class : m2Classes) {
            if (m2Class.getAssociations().size() > 0) {
                throw new ConstraintViolatedException("cmm.rest_api.model.import_associations_unsupported");
            }
            if (m2Class.getPropertyOverrides().size() > 0) {
                throw new ConstraintViolatedException("cmm.rest_api.model.import_overrides_unsupported");
            }
            if (m2Class.getMandatoryAspects().size() > 0) {
                throw new ConstraintViolatedException("cmm.rest_api.model.import_mandatory_aspects_unsupported");
            }
            if (m2Class.getArchive() != null) {
                throw new ConstraintViolatedException("cmm.rest_api.model.import_archive_unsupported");
            }
            if (m2Class.getIncludedInSuperTypeQuery() == null) continue;
            throw new ConstraintViolatedException("cmm.rest_api.model.import_includedInSuperTQ_unsupported");
        }
    }

    public class ModelDetails {
        private CustomModel model;
        private boolean active;
        private List<CustomType> types;
        private List<CustomAspect> aspects;
        private List<CustomModelConstraint> modelDefinedConstraints;

        public ModelDetails(CustomModelsImpl this$0, CustomModelDefinition modelDefinition) {
            this.model = new CustomModel(modelDefinition);
            this.active = modelDefinition.isActive();
            this.types = this$0.convertToCustomTypes(modelDefinition.getTypeDefinitions(), false);
            this.aspects = this$0.convertToCustomAspects(modelDefinition.getAspectDefinitions(), false);
            this.modelDefinedConstraints = this$0.convertToCustomModelConstraints(modelDefinition.getModelDefinedConstraints());
        }

        public CustomModel getModel() {
            return this.model;
        }

        public void setModel(CustomModel model) {
            this.model = model;
        }

        public List<CustomType> getTypes() {
            return this.types;
        }

        public void setTypes(List<CustomType> types) {
            this.types = types;
        }

        public List<CustomAspect> getAspects() {
            return this.aspects;
        }

        public void setAspects(List<CustomAspect> aspects) {
            this.aspects = aspects;
        }

        public List<CustomModelConstraint> getModelDefinedConstraints() {
            return this.modelDefinedConstraints;
        }

        public void setModelDefinedConstraints(List<CustomModelConstraint> modelDefinedConstraints) {
            this.modelDefinedConstraints = modelDefinedConstraints;
        }

        public boolean isActive() {
            return this.active;
        }
    }

    public static enum ConstraintValidator {
        REGEX{

            @Override
            public void validate(String parameterName, String value) {
                if ("expression".equals(parameterName)) {
                    try {
                        Pattern.compile(value);
                    }
                    catch (Exception ex) {
                        throw new InvalidArgumentException("cmm.rest_api.regex_constraint_invalid_expression", new Object[]{value});
                    }
                }
            }
        }
        ,
        MINMAX{

            @Override
            public void validate(String parameterName, String value) {
                double parsedValue;
                try {
                    parsedValue = Double.parseDouble(value);
                }
                catch (Exception ex) {
                    throw new InvalidArgumentException("cmm.rest_api.minmax_constraint_invalid_parameter", new Object[]{value, parameterName});
                }
                if ("maxValue".equalsIgnoreCase(parameterName) && parsedValue < Double.MIN_VALUE) {
                    throw new InvalidArgumentException("cmm.rest_api.minmax_constraint_invalid_max_value");
                }
            }

            @Override
            public void validateUsage(QName propDataType) {
                if (!(propDataType == null || DataTypeDefinition.INT.equals((Object)propDataType) || DataTypeDefinition.LONG.equals((Object)propDataType) || DataTypeDefinition.FLOAT.equals((Object)propDataType) || DataTypeDefinition.DOUBLE.equals((Object)propDataType))) {
                    throw new InvalidArgumentException("cmm.rest_api.minmax_constraint_invalid_use");
                }
            }
        }
        ,
        LENGTH{

            @Override
            public void validate(String parameterName, String value) {
                try {
                    Integer.parseInt(value);
                }
                catch (Exception ex) {
                    throw new InvalidArgumentException("cmm.rest_api.length_constraint_invalid_parameter", new Object[]{value, parameterName});
                }
            }

            @Override
            public void validateUsage(QName propDataType) {
                if (!(propDataType == null || DataTypeDefinition.TEXT.equals((Object)propDataType) || DataTypeDefinition.MLTEXT.equals((Object)propDataType) || DataTypeDefinition.CONTENT.equals((Object)propDataType))) {
                    throw new InvalidArgumentException("cmm.rest_api.length_constraint_invalid_use");
                }
            }
        }
        ,
        DUMMY_CONSTRAINT{

            @Override
            public void validate(String parameterName, String value) {
            }
        };


        public abstract void validate(String var1, String var2);

        public void validateUsage(QName propDataType) {
        }

        public static ConstraintValidator findByType(String constraintType) {
            for (ConstraintValidator c : ConstraintValidator.values()) {
                if (!c.name().equals(constraintType)) continue;
                return c;
            }
            return DUMMY_CONSTRAINT;
        }
    }
}

