/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.framework;

import org.alfresco.rest.framework.core.exceptions.InvalidArgumentException;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Api
implements Comparable<Api> {
    private static Log logger = LogFactory.getLog(Api.class);
    private final String name;
    private final SCOPE scope;
    private final int version;
    public static final Api ALFRESCO_PUBLIC = new Api("alfresco", SCOPE.PUBLIC, 1);

    private Api(String name, SCOPE scope, int version) {
        this.name = name;
        this.scope = scope;
        this.version = version;
    }

    public String getName() {
        return this.name;
    }

    public SCOPE getScope() {
        return this.scope;
    }

    public int getVersion() {
        return this.version;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.scope == null ? 0 : this.scope.hashCode());
        result = 31 * result + this.version;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Api other = (Api)obj;
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        if (this.scope != other.scope) {
            return false;
        }
        return this.version == other.version;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("Api [name=");
        builder.append(this.name);
        builder.append(", scope=");
        builder.append((Object)this.scope);
        builder.append(", version=");
        builder.append(this.version);
        builder.append("]");
        return builder.toString();
    }

    public static Api valueOf(String apiName, String apiScope, String apiVersion) throws InvalidArgumentException {
        SCOPE scope = null;
        int version = 1;
        try {
            if (!StringUtils.isAllLowerCase((CharSequence)apiName)) {
                throw new InvalidArgumentException("Api name must be lowercase");
            }
            scope = SCOPE.valueOf(apiScope.toUpperCase());
            version = Integer.parseInt(apiVersion);
            if (version < 1) {
                throw new InvalidArgumentException("Version must be a positive integer.");
            }
        }
        catch (Exception error) {
            if (error instanceof InvalidArgumentException) {
                throw (InvalidArgumentException)((Object)error);
            }
            logger.debug((Object)("Invalid API definition: " + apiName + " " + apiScope + " " + apiVersion));
            throw new InvalidArgumentException("Invalid API definition:" + error.getMessage());
        }
        Api anApi = new Api(apiName, scope, version);
        return ALFRESCO_PUBLIC.equals(anApi) ? ALFRESCO_PUBLIC : anApi;
    }

    @Override
    public int compareTo(Api other) {
        int compare = this.scope.compareTo(other.scope);
        if (compare != 0) {
            return compare;
        }
        compare = this.name.compareTo(other.name);
        if (compare != 0) {
            return compare;
        }
        if (this.version < other.version) {
            return -1;
        }
        if (this.version > other.version) {
            return 1;
        }
        return 0;
    }

    public static enum SCOPE {
        PRIVATE,
        PUBLIC;

    }
}

