/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.framework.jacksonextensions;

import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.module.SimpleModule;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.InitializingBean;

public class RestJsonModule
extends SimpleModule
implements InitializingBean {
    private static Log logger = LogFactory.getLog(RestJsonModule.class);
    private static final String NAME = "AlfrescoRestJsonModule";
    private List<JsonSerializer> jsonSerializers;
    private Map<String, JsonDeserializer> jsonDeserializers;

    public RestJsonModule() {
        super(NAME, new Version(1, 0, 0, null));
    }

    public void setupModule(Module.SetupContext context) {
        super.setupModule(context);
    }

    public void afterPropertiesSet() throws Exception {
        if (this.jsonSerializers != null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Setting up Json Module serializers");
            }
            for (JsonSerializer jsonSerializer : this.jsonSerializers) {
                this.addSerializer(jsonSerializer);
            }
        }
        if (this.jsonDeserializers != null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Setting up Json Module deserializers");
            }
            for (Map.Entry entry : this.jsonDeserializers.entrySet()) {
                Class<?> theDeserializer = Class.forName((String)entry.getKey());
                this.addDeserializer(theDeserializer, (JsonDeserializer)entry.getValue());
            }
        }
    }

    public void setJsonSerializers(List<JsonSerializer> jsonSerializers) {
        this.jsonSerializers = jsonSerializers;
    }

    public void setJsonDeserializers(Map<String, JsonDeserializer> jsonDeserializers) {
        this.jsonDeserializers = jsonDeserializers;
    }
}

