/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.framework.tools;

import java.util.Map;
import org.alfresco.metrics.rest.RestMetricsReporter;
import org.alfresco.repo.search.QueryParserException;
import org.alfresco.rest.framework.Api;
import org.alfresco.rest.framework.core.exceptions.DefaultExceptionResolver;
import org.alfresco.rest.framework.core.exceptions.ErrorResponse;
import org.alfresco.rest.framework.core.exceptions.ExceptionResolver;
import org.alfresco.rest.framework.jacksonextensions.JacksonHelper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.extensions.webscripts.WebScriptException;

public class ApiAssistant {
    private static Log logger = LogFactory.getLog(ApiAssistant.class);
    private ExceptionResolver<Exception> defaultResolver = new DefaultExceptionResolver();
    private ExceptionResolver<WebScriptException> webScriptExceptionResolver;
    private ExceptionResolver<QueryParserException> queryParserExceptionResolver;
    private ExceptionResolver<Exception> resolver;
    private JacksonHelper jsonHelper;
    private RestMetricsReporter restMetricsReporter;

    public static Api determineApi(Map<String, String> templateVars) {
        String apiScope = templateVars.get("apiScope");
        String apiVersion = templateVars.get("apiVersion");
        String apiName = templateVars.get("apiName");
        return Api.valueOf(apiName, apiScope, apiVersion);
    }

    public ErrorResponse resolveException(Exception ex) {
        ErrorResponse error = null;
        error = ex instanceof WebScriptException ? this.webScriptExceptionResolver.resolveException((WebScriptException)((Object)ex)) : (ex instanceof QueryParserException ? this.queryParserExceptionResolver.resolveException((QueryParserException)ex) : this.resolver.resolveException(ex));
        if (error == null) {
            error = this.defaultResolver.resolveException(ex);
        }
        return error;
    }

    public JacksonHelper getJsonHelper() {
        return this.jsonHelper;
    }

    public void setDefaultResolver(ExceptionResolver<Exception> defaultResolver) {
        this.defaultResolver = defaultResolver;
    }

    public void setWebScriptExceptionResolver(ExceptionResolver<WebScriptException> webScriptExceptionResolver) {
        this.webScriptExceptionResolver = webScriptExceptionResolver;
    }

    public void setQueryParserExceptionResolver(ExceptionResolver<QueryParserException> queryParserExceptionResolver) {
        this.queryParserExceptionResolver = queryParserExceptionResolver;
    }

    public void setResolver(ExceptionResolver<Exception> resolver) {
        this.resolver = resolver;
    }

    public void setJsonHelper(JacksonHelper jsonHelper) {
        this.jsonHelper = jsonHelper;
    }

    public RestMetricsReporter getRestMetricsReporter() {
        return this.restMetricsReporter;
    }

    public void setRestMetricsReporter(RestMetricsReporter restMetricsReporterImpl) {
        this.restMetricsReporter = restMetricsReporterImpl;
    }
}

