/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.api.impl.validator.actions;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.alfresco.rest.api.Actions;
import org.alfresco.rest.api.impl.validator.actions.ActionParameterDefinitionValidator;
import org.alfresco.rest.api.model.ActionDefinition;
import org.alfresco.rest.api.model.rules.Action;
import org.alfresco.rest.framework.core.exceptions.InvalidArgumentException;
import org.alfresco.rest.framework.core.exceptions.NotFoundException;
import org.alfresco.service.Experimental;
import org.alfresco.service.cmr.dictionary.DataTypeDefinition;
import org.alfresco.service.namespace.QName;
import org.assertj.core.api.Assertions;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.BDDMockito;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.junit.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
@Experimental
public class ActionParameterDefinitionValidatorTest {
    private static final String MANDATORY_PARAM_KEY = "paramKey";
    private static final String NON_MANDATORY_PARAM_KEY = "nonMandatoryParamKey";
    @Mock
    private Actions actionsMock;
    @InjectMocks
    private ActionParameterDefinitionValidator objectUnderTest;

    @Test
    public void testSimpleValidationPasses() {
        Action action = new Action();
        String actionDefinitionId = "properActionDefinition";
        action.setActionDefinitionId("properActionDefinition");
        action.setParams(Map.of(MANDATORY_PARAM_KEY, "paramValue"));
        List<ActionDefinition.ParameterDefinition> parameterDefinitions = List.of(this.createParameterDefinition(MANDATORY_PARAM_KEY, DataTypeDefinition.TEXT, true, null));
        ActionDefinition actionDefinition = this.createActionDefinition("properActionDefinition", parameterDefinitions);
        BDDMockito.given((Object)this.actionsMock.getRuleActionDefinitionById("properActionDefinition")).willReturn((Object)actionDefinition);
        this.objectUnderTest.validate(action);
        ((Actions)BDDMockito.then((Object)this.actionsMock).should()).getRuleActionDefinitionById("properActionDefinition");
        BDDMockito.then((Object)this.actionsMock).shouldHaveNoMoreInteractions();
    }

    @Test
    public void testValidationPassesWhenNoParametersNeeded() {
        Action action = new Action();
        String actionDefinitionId = "properActionDefinition";
        action.setActionDefinitionId("properActionDefinition");
        ActionDefinition actionDefinition = this.createActionDefinition("properActionDefinition", null);
        BDDMockito.given((Object)this.actionsMock.getRuleActionDefinitionById("properActionDefinition")).willReturn((Object)actionDefinition);
        this.objectUnderTest.validate(action);
        ((Actions)BDDMockito.then((Object)this.actionsMock).should()).getRuleActionDefinitionById("properActionDefinition");
        BDDMockito.then((Object)this.actionsMock).shouldHaveNoMoreInteractions();
    }

    @Test
    public void testValidationPassesWhenNoMandatoryParametersNeeded() {
        Action action = new Action();
        String actionDefinitionId = "properActionDefinition";
        action.setActionDefinitionId("properActionDefinition");
        ActionDefinition actionDefinition = this.createActionDefinition("properActionDefinition", List.of(this.createParameterDefinition(NON_MANDATORY_PARAM_KEY, DataTypeDefinition.TEXT, false, null)));
        BDDMockito.given((Object)this.actionsMock.getRuleActionDefinitionById("properActionDefinition")).willReturn((Object)actionDefinition);
        this.objectUnderTest.validate(action);
        ((Actions)BDDMockito.then((Object)this.actionsMock).should()).getRuleActionDefinitionById("properActionDefinition");
        BDDMockito.then((Object)this.actionsMock).shouldHaveNoMoreInteractions();
    }

    @Test
    public void testValidationPassesWhenOptionalParametersNotProvided() {
        Action action = new Action();
        String actionDefinitionId = "properActionDefinition";
        action.setActionDefinitionId("properActionDefinition");
        action.setParams(Map.of(MANDATORY_PARAM_KEY, "paramValue"));
        List<ActionDefinition.ParameterDefinition> parameterDefinitions = List.of(this.createParameterDefinition(MANDATORY_PARAM_KEY, DataTypeDefinition.TEXT, true, null), this.createParameterDefinition(NON_MANDATORY_PARAM_KEY, DataTypeDefinition.BOOLEAN, false, null));
        ActionDefinition actionDefinition = this.createActionDefinition("properActionDefinition", parameterDefinitions);
        BDDMockito.given((Object)this.actionsMock.getRuleActionDefinitionById("properActionDefinition")).willReturn((Object)actionDefinition);
        this.objectUnderTest.validate(action);
        ((Actions)BDDMockito.then((Object)this.actionsMock).should()).getRuleActionDefinitionById("properActionDefinition");
        BDDMockito.then((Object)this.actionsMock).shouldHaveNoMoreInteractions();
    }

    @Test
    public void testValidationFailsWhenTooManyParameters() {
        Action action = new Action();
        String actionDefinitionId = "properActionDefinition";
        action.setActionDefinitionId("properActionDefinition");
        action.setParams(Map.of(MANDATORY_PARAM_KEY, "paramValue", NON_MANDATORY_PARAM_KEY, false));
        List<ActionDefinition.ParameterDefinition> parameterDefinitions = List.of(this.createParameterDefinition(MANDATORY_PARAM_KEY, DataTypeDefinition.TEXT, true, null));
        ActionDefinition actionDefinition = this.createActionDefinition("properActionDefinition", parameterDefinitions);
        BDDMockito.given((Object)this.actionsMock.getRuleActionDefinitionById("properActionDefinition")).willReturn((Object)actionDefinition);
        Assertions.assertThatExceptionOfType(InvalidArgumentException.class).isThrownBy(() -> this.objectUnderTest.validate(action)).withMessageContaining(String.format("Action of definition id: %s must not contain parameter of name: %s", "properActionDefinition", NON_MANDATORY_PARAM_KEY));
        ((Actions)BDDMockito.then((Object)this.actionsMock).should()).getRuleActionDefinitionById("properActionDefinition");
        BDDMockito.then((Object)this.actionsMock).shouldHaveNoMoreInteractions();
    }

    @Test
    public void testValidationFailsWhenMissingParameters() {
        Action action = new Action();
        String actionDefinitionId = "properActionDefinition";
        action.setActionDefinitionId("properActionDefinition");
        List<ActionDefinition.ParameterDefinition> parameterDefinitions = List.of(this.createParameterDefinition(MANDATORY_PARAM_KEY, DataTypeDefinition.TEXT, true, null));
        ActionDefinition actionDefinition = this.createActionDefinition("properActionDefinition", parameterDefinitions);
        BDDMockito.given((Object)this.actionsMock.getRuleActionDefinitionById("properActionDefinition")).willReturn((Object)actionDefinition);
        Assertions.assertThatExceptionOfType(InvalidArgumentException.class).isThrownBy(() -> this.objectUnderTest.validate(action)).withMessageContaining(String.format("Action parameters should not be null or empty for this action. See Action Definition for action of: %s", "properActionDefinition"));
        ((Actions)BDDMockito.then((Object)this.actionsMock).should()).getRuleActionDefinitionById("properActionDefinition");
        BDDMockito.then((Object)this.actionsMock).shouldHaveNoMoreInteractions();
    }

    @Test
    public void testValidationFailsWhenMissingParameterValue() {
        Action action = new Action();
        String actionDefinitionId = "properActionDefinition";
        action.setActionDefinitionId("properActionDefinition");
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put(MANDATORY_PARAM_KEY, null);
        action.setParams(params);
        List<ActionDefinition.ParameterDefinition> parameterDefinitions = List.of(this.createParameterDefinition(MANDATORY_PARAM_KEY, DataTypeDefinition.TEXT, true, null));
        ActionDefinition actionDefinition = this.createActionDefinition("properActionDefinition", parameterDefinitions);
        BDDMockito.given((Object)this.actionsMock.getRuleActionDefinitionById("properActionDefinition")).willReturn((Object)actionDefinition);
        Assertions.assertThatExceptionOfType(InvalidArgumentException.class).isThrownBy(() -> this.objectUnderTest.validate(action)).withMessageContaining(String.format("Missing action's mandatory parameter: %s", MANDATORY_PARAM_KEY));
        ((Actions)BDDMockito.then((Object)this.actionsMock).should()).getRuleActionDefinitionById("properActionDefinition");
        BDDMockito.then((Object)this.actionsMock).shouldHaveNoMoreInteractions();
    }

    @Test
    public void testValidationFailsWhenMandatoryParameterIsMissing() {
        Action action = new Action();
        String actionDefinitionId = "properActionDefinition";
        action.setActionDefinitionId("properActionDefinition");
        action.setParams(Map.of(NON_MANDATORY_PARAM_KEY, true));
        List<ActionDefinition.ParameterDefinition> parameterDefinitions = List.of(this.createParameterDefinition(MANDATORY_PARAM_KEY, DataTypeDefinition.TEXT, true, null), this.createParameterDefinition(NON_MANDATORY_PARAM_KEY, DataTypeDefinition.BOOLEAN, false, null));
        ActionDefinition actionDefinition = this.createActionDefinition("properActionDefinition", parameterDefinitions);
        BDDMockito.given((Object)this.actionsMock.getRuleActionDefinitionById("properActionDefinition")).willReturn((Object)actionDefinition);
        Assertions.assertThatExceptionOfType(InvalidArgumentException.class).isThrownBy(() -> this.objectUnderTest.validate(action)).withMessageContaining(String.format("Missing action's mandatory parameter: %s", MANDATORY_PARAM_KEY));
        ((Actions)BDDMockito.then((Object)this.actionsMock).should()).getRuleActionDefinitionById("properActionDefinition");
        BDDMockito.then((Object)this.actionsMock).shouldHaveNoMoreInteractions();
    }

    @Test
    public void testValidationFailsWhenActionWithNullActionDefinition() {
        Action action = new Action();
        action.setActionDefinitionId(null);
        action.setParams(Map.of(MANDATORY_PARAM_KEY, "paramValue"));
        Assertions.assertThatExceptionOfType(InvalidArgumentException.class).isThrownBy(() -> this.objectUnderTest.validate(action)).withMessageContaining("Empty/null rule action definition id");
        BDDMockito.then((Object)this.actionsMock).shouldHaveNoInteractions();
    }

    @Test
    public void testValidationFailsWhenNotApplicableActionDefinition() {
        Action action = new Action();
        String actionDefinitionId = "notApplicableActionDefinition";
        action.setActionDefinitionId("notApplicableActionDefinition");
        action.setParams(Map.of(MANDATORY_PARAM_KEY, "paramValue"));
        BDDMockito.given((Object)this.actionsMock.getRuleActionDefinitionById("notApplicableActionDefinition")).willThrow(NotFoundException.class);
        Assertions.assertThatExceptionOfType(InvalidArgumentException.class).isThrownBy(() -> this.objectUnderTest.validate(action)).withMessageContaining(String.format("Invalid rule action definition requested %s", "notApplicableActionDefinition"));
        ((Actions)BDDMockito.then((Object)this.actionsMock).should()).getRuleActionDefinitionById("notApplicableActionDefinition");
        BDDMockito.then((Object)this.actionsMock).shouldHaveNoMoreInteractions();
    }

    @Test
    public void testHasProperPriority() {
        int expectedPriority = Integer.MIN_VALUE;
        int actualPriority = this.objectUnderTest.getPriority();
        Assert.assertEquals((long)Integer.MIN_VALUE, (long)actualPriority);
    }

    private ActionDefinition createActionDefinition(String actionDefinitionId, List<ActionDefinition.ParameterDefinition> parameterDefinitions) {
        return new ActionDefinition(actionDefinitionId, actionDefinitionId, "title", "description", Collections.emptyList(), false, false, parameterDefinitions);
    }

    private ActionDefinition.ParameterDefinition createParameterDefinition(String name, QName qName, boolean mandatory, String constraint) {
        return new ActionDefinition.ParameterDefinition(name, qName.toPrefixString(), false, mandatory, "label", constraint);
    }
}

